library(glmmADMB)

N <- read.csv("N.csv",colClasses=c(rep("factor",3),rep("numeric",2)))

library(lme4)
m3 <- glmer(amonio~tratamiento+micrositio+(1|repeticion),
            family=Gamma(link="log"),data=na.omit(N))

g3 <- glmmadmb(amonio~tratamiento+micrositio+(1|repeticion),
           data=na.omit(N),family="gamma")

coef(g3)
fixef(m3)
VarCorr(g3)
VarCorr(m3)

g4 <- glmmadmb(amonio~tratamiento+micrositio+(1|repeticion),
           data=na.omit(N),family="gamma",link="inverse")


try(m4 <- glmer(amonio~tratamiento+micrositio+(1|repeticion),
            family=Gamma,data=na.omit(N)))
##error, mu[i] must be positive

detach("package:lme4")
library(lme4a)
m3A <- glmer(amonio~tratamiento+micrositio+(1|repeticion),
            family=Gamma(link="log"),data=na.omit(N))
## CRASH!
if (FALSE) {
  m4A <- glmer(amonio~tratamiento+micrositio+(1|repeticion),
            family=Gamma,data=na.omit(N))
}

fixef(m3A)

library(MASS)
m3B <- glmmPQL(amonio~tratamiento+micrositio,
               random=~1|repeticion,family=Gamma,
               data=na.omit(N))

m4B <- glmmPQL(amonio~tratamiento+micrositio,
               random=~1|repeticion,family=Gamma(link="log"),
               data=na.omit(N))

cfun <- function(x) {
  if (inherits(x,"glmmadmb")) coef(x) else fixef(x)
}
mlist <- list(admb.log=g3,lme4.log=m3,lme4a.log=m3A,
      glmmPQL.log=m3B,admb.inv=g4,glmmPQL.inv=m4B)

cbind(t(sapply(mlist,cfun)),logLik=sapply(mlist,logLik))

      

