###################################################
### chunk number 1: 
###################################################
library(MASS)
library(ellipse)
library(cpcbp)


###################################################
### chunk number 2: 
###################################################
set.seed(1001)
X1 = simdata(offset=6)
T1 = sim.theor(offset=6)
op = par(pty="s")
plot_dat.theor(X1,vars=1:2,xlim=c(-12,12),
              ylim=c(-12,12),theor=T1)
par(op)


###################################################
### chunk number 3: 
###################################################
X2 = simdata(offset=15,offset2=10,vars=c(20,20,20))
T2 = sim.theor(offset=15,offset2=10,vars=c(20,20,20))
op = par(pty="s")
plot_dat.theor(X2,vars=1:2,xlim=c(-12,35),
              ylim=c(-12,35),theor=T2)
par(op)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## X2.bpm = bp.means(X2); X2.bpm
## tvals.m=sim.theor(offset=0,offset2=10,vars=c(20,20,20))$mean
## tvals.diff = tvals.m[2,]-tvals.m[1,]


###################################################
### chunk number 5:  eval=FALSE
###################################################
## p2e = 2*pt(abs(X2.bpm$meandiffs-tvals.diff)/X2.bpm$sd.corr,nrow(X2)-2,
##   lower.tail=FALSE); p2e


###################################################
### chunk number 6:  eval=FALSE
###################################################
## p2z = 2*pt((abs(X2.bpm$meandiffs))/X2.bpm$sd.corr,nrow(X2)-2,
##   lower.tail=FALSE); p2z


###################################################
### chunk number 7:  eval=FALSE
###################################################
## b2 = bp.anova(X2)
## p1b2 = sapply(b2,function(x)x[1,"Pr(>F)"]); p1b2


###################################################
### chunk number 8:  eval=FALSE
###################################################
## X1.bpm = bp.means(X1); X1.bpm
## tvals.m=sim.theor(offset=0,offset2=0)$mean
## tvals.diff = tvals.m[2,]-tvals.m[1,]
## p1z = 2*pt((abs(X1.bpm$meandiffs))/X1.bpm$sd.corr,nrow(X1)-2,
##   lower.tail=FALSE)
## b1 = bp.anova(X1)
## p1b1 = sapply(b1,function(x)x[1,"Pr(>F)"])
## rbind(p1z,p1b1)


###################################################
### chunk number 9:  eval=FALSE
###################################################
## testcover = function(n=400,offset=15,offset2=10,vars=c(20,20,20),cor=0.8,rpt=50) {
##   tvals.m=sim.theor(offset=0,offset2=offset2,vars=vars,cor=cor)$mean
##   tvals.diff = tvals.m[2,]-tvals.m[1,]
##   pvals = t(sapply(1:n,
##     function(x) {
##       if (rpt >0 && x %% rpt==0) cat(x,"\n")
##       x1t<-simdata(offset=offset,offset2=offset2,vars=vars,cor=cor)
##       x1t.bp = bp.means(x1t)
##       2*pt(abs(x1t.bp$meandiffs-tvals.diff)/x1t.bp$sd.corr,nrow(x1t)-2,
##            lower.tail=FALSE)
##     }))
##   c(apply(pvals,2,coverfun),coverfun(pvals))
## }


###################################################
### chunk number 10:  eval=FALSE
###################################################
## testcov = TRUE
## if (testcov) testcover()


