/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class Evaluator {
    public Vector expressions;
    public Vector variable_names;
    public Vector initial_variable_values;
    public int independent_variables_count;
    public double[] variable_values;
    public double[] last_valid_variable_values;
    public int max_expression_list_size;
    public double[] evaluation_stack;
    public static final int max_arguments_count = 3;
    public double seconds_since_1970 = (double)System.currentTimeMillis() / 1000.0;

    public Evaluator() {
        this.clearAllVariables();
    }

    public void clearAllVariables() {
        this.expressions = null;
        this.variable_names = null;
        this.initial_variable_values = null;
        this.independent_variables_count = 0;
        this.variable_values = null;
        this.last_valid_variable_values = null;
        this.max_expression_list_size = 0;
        this.evaluation_stack = null;
    }

    public boolean addIndependentVariable(String string, double d) {
        if (this.variable_names == null) {
            this.variable_names = new Vector();
        }
        if (this.initial_variable_values == null) {
            this.initial_variable_values = new Vector();
        }
        if (this.independent_variables_count < this.variable_names.size()) {
            return false;
        }
        if (this.getVariableIndex(string) >= 0) {
            return false;
        }
        this.variable_names.addElement(string);
        this.initial_variable_values.addElement(new Double(d));
        this.independent_variables_count = this.variable_names.size();
        return true;
    }

    public boolean addDependentVariable(String string, double d, int n) {
        int n2;
        if (this.variable_names == null) {
            this.variable_names = new Vector();
        }
        if (this.initial_variable_values == null) {
            this.initial_variable_values = new Vector();
        }
        if ((n2 = this.getVariableIndex(string)) >= 0) {
            if (!this.isVariableIndependent(n2)) {
                return false;
            }
            if (n < 0) {
                return false;
            }
        }
        if (n2 < 0) {
            this.variable_names.addElement(string);
            this.initial_variable_values.addElement(new Double(d));
            n2 = this.variable_names.size() - 1;
        }
        if (n >= 0) {
            this.getExpression(n).setVariable(n2);
        }
        return true;
    }

    public void prepareVariables() {
        this.variable_values = new double[this.variable_names.size()];
        this.last_valid_variable_values = new double[this.variable_names.size()];
        this.setInitialVariableValues();
        this.confirmVariableValues();
    }

    public void setInitialVariableValues() {
        int n = 0;
        while (n < this.initial_variable_values.size()) {
            this.variable_values[n] = (Double)this.initial_variable_values.elementAt(n);
            ++n;
        }
    }

    public void resetVariableValues() {
        int n = 0;
        while (n < this.variable_names.size()) {
            this.variable_values[n] = this.last_valid_variable_values[n];
            ++n;
        }
    }

    public void confirmVariableValues() {
        int n = 0;
        while (n < this.variable_names.size()) {
            this.last_valid_variable_values[n] = this.variable_values[n];
            ++n;
        }
    }

    public void setVariableValue(int n, double d) {
        if (this.variable_values != null) {
            this.variable_values[n] = d;
        } else {
            this.initial_variable_values.setElementAt(new Double(d), n);
        }
    }

    public double getVariableValue(int n) {
        if (this.variable_values != null) {
            return this.variable_values[n];
        }
        return (Double)this.initial_variable_values.elementAt(n);
    }

    public int getVariableIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.variable_names.size()) {
            if (string.equals((String)this.variable_names.elementAt(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public boolean isVariableIndependent(int n) {
        return n >= 0 && n < this.independent_variables_count;
    }

    public int addExpression(Expression expression) {
        if (this.expressions == null) {
            this.expressions = new Vector();
        }
        this.expressions.addElement(expression);
        if (expression.list_size > this.max_expression_list_size) {
            this.max_expression_list_size = expression.list_size;
            this.evaluation_stack = new double[this.max_expression_list_size + 3];
        }
        return this.expressions.size() - 1;
    }

    public Expression getExpression(int n) {
        return (Expression)this.expressions.elementAt(n);
    }

    public double getExpressionValue(int n) {
        return ((Expression)this.expressions.elementAt((int)n)).current_value;
    }

    public void setExpressionCoordinate(int n, Graphics3D graphics3D, int n2, int n3) {
        this.getExpression(n).setCoordinate(graphics3D, n2, n3);
    }

    public boolean evaluate() {
        boolean bl = true;
        if (this.expressions == null) {
            this.expressions = new Vector();
        }
        this.confirmVariableValues();
        int n = 0;
        while (n < this.expressions.size()) {
            Expression expression = (Expression)this.expressions.elementAt(n);
            expression.confirmValue();
            if (!expression.evaluate()) {
                int n2 = 0;
                while (n2 <= n) {
                    expression = (Expression)this.expressions.elementAt(n2);
                    expression.resetValue();
                    ++n2;
                }
                this.resetVariableValues();
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }
}

