/*
 * Decompiled with CFR 0.152.
 */
class Expression {
    public Evaluator evaluator;
    public double current_value = 0.0;
    public double last_valid_value = 0.0;
    public Graphics3D graphics;
    public int point_index;
    public int coordinate_index;
    public int variable_index;
    public int list_size;
    public int[] tokens_list;
    public double[] values_list;
    public boolean is_atomic_independent_variable;
    public int independent_variable_index;

    public Expression(Evaluator evaluator, int n, int[] nArray, double[] dArray) {
        this.evaluator = evaluator;
        this.graphics = null;
        this.point_index = -1;
        this.coordinate_index = -1;
        this.variable_index = -1;
        this.list_size = n;
        this.tokens_list = nArray;
        this.values_list = dArray;
        if (this.list_size == 2 && this.tokens_list[0] == 21 && this.evaluator.isVariableIndependent((int)this.values_list[0])) {
            this.is_atomic_independent_variable = true;
            this.independent_variable_index = (int)this.values_list[0];
        } else {
            this.is_atomic_independent_variable = false;
            this.independent_variable_index = -1;
        }
    }

    public void setCoordinate(Graphics3D graphics3D, int n, int n2) {
        this.graphics = graphics3D;
        this.point_index = n;
        this.coordinate_index = n2;
        this.variable_index = -1;
    }

    public void setVariable(int n) {
        this.graphics = null;
        this.point_index = -1;
        this.coordinate_index = -1;
        this.variable_index = n;
    }

    public boolean setValue() {
        if (this.variable_index >= 0) {
            this.evaluator.setVariableValue(this.variable_index, this.current_value);
            return true;
        }
        if (this.graphics != null && this.point_index >= 0 && this.coordinate_index >= 0) {
            return this.graphics.setCoordinateValue(this.point_index, this.coordinate_index, this.current_value);
        }
        return true;
    }

    public void setIndependentVariable(double d) {
        if (this.is_atomic_independent_variable) {
            this.current_value = d;
            this.evaluator.setVariableValue(this.independent_variable_index, this.current_value);
        }
    }

    public double getCurrentValue() {
        return this.current_value;
    }

    public boolean isAtomicIndependentVariable() {
        return this.is_atomic_independent_variable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean evaluate() {
        int n = 3;
        int n2 = 0;
        if (this.evaluator == null) {
            return false;
        }
        double[] dArray = this.evaluator.evaluation_stack;
        if (dArray == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.list_size) {
            block57: {
                int n4 = this.tokens_list[n3];
                if (n4 == 24) break;
                try {
                    switch (n4) {
                        case 22: {
                            dArray[n++] = this.values_list[n3];
                            break;
                        }
                        case 28: {
                            double d2 = dArray[--n];
                            dArray[n++] = -d2;
                            break;
                        }
                        case 21: {
                            dArray[n++] = this.evaluator.getVariableValue((int)this.values_list[n3]);
                            break;
                        }
                        case 7: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = d2 + d;
                            break;
                        }
                        case 8: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = d2 - d;
                            break;
                        }
                        case 9: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = d2 * d;
                            break;
                        }
                        case 10: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            if (d == 0.0) {
                                return false;
                            }
                            dArray[n++] = d2 / d;
                            break;
                        }
                        case 11: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = Math.pow(d2, d);
                            break;
                        }
                        case 30: {
                            n = this.evaluate_function(dArray, n, n3);
                            if (n < 0) {
                                return false;
                            }
                            break;
                        }
                        case 34: {
                            double d2 = dArray[--n];
                            if (d2 == 1.0) {
                                dArray[n++] = 0.0;
                            } else {
                                if (d2 != 0.0) return false;
                                dArray[n++] = 1.0;
                            }
                            break;
                        }
                        case 32: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            if (d2 == 1.0) {
                                dArray[n++] = d;
                            } else if (d == 1.0) {
                                dArray[n++] = d2;
                            } else if (d2 == 0.0) {
                                dArray[n++] = 0.0;
                            } else {
                                if (d != 0.0) return false;
                                dArray[n++] = 0.0;
                            }
                            break;
                        }
                        case 33: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            if (d2 == 0.0) {
                                dArray[n++] = d;
                            } else if (d == 0.0) {
                                dArray[n++] = d2;
                            } else if (d2 == 1.0) {
                                dArray[n++] = 1.0;
                            } else {
                                if (d != 1.0) return false;
                                dArray[n++] = 1.0;
                            }
                            break;
                        }
                        case 12: {
                            double d2 = dArray[--n];
                            dArray[n++] = this.gamma(d2 + 1.0);
                            break;
                        }
                        case 13: {
                            double d2 = dArray[--n];
                            if (d2 <= -2.0) {
                                return false;
                            }
                            dArray[n++] = this.factorial2(d2);
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            dArray[n++] = (double)n4 + 0.5;
                            break;
                        }
                        case 31: {
                            double d;
                            double d2;
                            n2 = (int)this.values_list[n3];
                            if (n < 2 * n2 + 1) {
                                return false;
                            }
                            double d3 = 1.0;
                            int n5 = 0;
                            while (n5 < n2) {
                                int n6 = (int)dArray[n - n2 + n5];
                                d2 = dArray[n - n2 - n5 - 2];
                                d = dArray[n - n2 - n5 - 1];
                                switch (n6) {
                                    case 14: {
                                        if (d2 == d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    case 15: {
                                        if (d2 != d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    case 16: {
                                        if (d2 < d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    case 18: {
                                        if (d2 <= d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    case 17: {
                                        if (d2 > d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    case 19: {
                                        if (d2 >= d) break;
                                        d3 = 0.0;
                                        break;
                                    }
                                    default: {
                                        return false;
                                    }
                                }
                                if (d3 < 0.5) break;
                                ++n5;
                            }
                            n = n - 2 * n2 - 1;
                            dArray[n++] = d3;
                            break;
                        }
                        case 35: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = d;
                            break;
                        }
                        case 36: {
                            double d = dArray[--n];
                            double d2 = dArray[--n];
                            dArray[n++] = d;
                            this.evaluator.setVariableValue((int)this.values_list[n3], d);
                            break;
                        }
                        default: {
                            return false;
                        }
                        case 27: {
                            if (n > 3) break block57;
                        }
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    return false;
                }
                if (n > 3) break block57;
                return false;
            }
            ++n3;
        }
        if (n != 4) {
            return false;
        }
        this.current_value = dArray[--n];
        if (!Double.isNaN(this.current_value) && !Double.isInfinite(this.current_value)) return this.setValue();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int evaluate_function(double[] dArray, int n, int n2) {
        int n3 = (int)this.values_list[n2] / 1024;
        int n4 = (int)this.values_list[n2] & 0x3FF;
        if (n < n3) {
            return -1;
        }
        switch (n4) {
            case 1: {
                double d = 0.0;
                int n5 = 0;
                while (n5 < n3) {
                    d += dArray[--n];
                    ++n5;
                }
                dArray[n++] = d;
                return n;
            }
            case 2: {
                if (n3 != 2) {
                    return -1;
                }
                double d = dArray[--n];
                double d2 = dArray[--n];
                dArray[n++] = d2 - d;
                return n;
            }
            case 3: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = -d;
                return n;
            }
            case 4: {
                double d = 1.0;
                int n6 = 0;
                while (n6 < n3) {
                    d *= dArray[--n];
                    ++n6;
                }
                dArray[n++] = d;
                return n;
            }
            case 5: {
                if (n3 != 2) {
                    return -1;
                }
                double d = dArray[--n];
                double d3 = dArray[--n];
                if (d == 0.0) {
                    return -1;
                }
                dArray[n++] = d3 / d;
                return n;
            }
            case 6: {
                double d = 1.0;
                int n7 = 0;
                while (n7 < n3) {
                    d = Math.pow(dArray[--n], d);
                    ++n7;
                }
                dArray[n++] = d;
                return n;
            }
            case 7: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.abs(d);
                return n;
            }
            case 8: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                double d4 = (d = dArray[--n]) > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : 0.0);
                dArray[n++] = d4;
                return n;
            }
            case 9: {
                double d;
                double d5;
                if (n3 != 1) {
                    return -1;
                }
                if ((d5 = Math.floor((d = dArray[--n]) + 0.5)) == d + 0.5 && (d5 > 0.0 && (1 & (int)d5) == 1 || d5 < 0.0 && (1 & (int)(-d5)) == 1)) {
                    d5 -= 1.0;
                }
                dArray[n++] = d5;
                return n;
            }
            case 10: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                double d6 = (d = dArray[--n]) >= 0.0 ? Math.floor(d) : Math.ceil(d);
                dArray[n++] = d6;
                return n;
            }
            case 11: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                double d7 = (d = dArray[--n]) >= 0.0 ? d - Math.floor(d) : d - Math.ceil(d);
                dArray[n++] = d7;
                return n;
            }
            case 12: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.floor(d);
                return n;
            }
            case 13: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.ceil(d);
                return n;
            }
            case 14: {
                double d;
                double d8;
                if (n3 == 1) {
                    d8 = 1.0E-10;
                    d = dArray[--n];
                } else {
                    if (n3 != 2) return -1;
                    d8 = dArray[--n];
                    d = dArray[--n];
                    if (d8 < 0.0) {
                        return -1;
                    }
                }
                double d9 = Math.abs(d) < d8 ? 0.0 : d;
                dArray[n++] = d9;
                return n;
            }
            case 15: {
                double d = Double.MIN_VALUE;
                int n8 = 0;
                while (n8 < n3) {
                    if (dArray[--n] > d) {
                        d = dArray[n];
                    }
                    ++n8;
                }
                dArray[n++] = d;
                return n;
            }
            case 16: {
                double d = Double.MAX_VALUE;
                int n9 = 0;
                while (n9 < n3) {
                    if (dArray[--n] < d) {
                        d = dArray[n];
                    }
                    ++n9;
                }
                dArray[n++] = d;
                return n;
            }
            case 17: 
            case 19: {
                if (n3 == 1) return n;
                return -1;
            }
            case 18: {
                if (n3 != 1) {
                    return -1;
                }
                dArray[n - 1] = 0.0;
                return n;
            }
            case 20: {
                double d;
                double d10;
                if (n3 != 1) {
                    return -1;
                }
                if ((d10 = dArray[--n]) > 0.0) {
                    d = 0.0;
                } else {
                    if (!(d10 < 0.0)) return -1;
                    d = Math.PI;
                }
                dArray[n++] = d;
                return n;
            }
            case 21: {
                if (n3 != 2) {
                    return -1;
                }
                double d = dArray[--n];
                double d11 = dArray[--n];
                if (d == 0.0) {
                    return -1;
                }
                dArray[n++] = d11 - d * Math.floor(d11 / d);
                return n;
            }
            case 22: {
                if (n3 != 2) {
                    return -1;
                }
                double d = dArray[--n];
                double d12 = dArray[--n];
                if (d == 0.0) {
                    return -1;
                }
                dArray[n++] = Math.floor(d12 / d);
                return n;
            }
            case 23: {
                if (n3 != 0) {
                    return -1;
                }
                double d = Math.random();
                dArray[n++] = d;
                return n;
            }
            case 24: {
                if (n3 > 1) {
                    return -1;
                }
                if (n3 != 1) return n;
                double d = dArray[--n];
                return n;
            }
            case 25: {
                double d;
                if (n3 == 2) {
                    double d13 = dArray[--n];
                    double d14 = dArray[--n];
                    if (d13 <= 0.0 || d14 < 0.0 || d14 == 1.0) {
                        return -1;
                    }
                    if (d14 == 0.0) {
                        dArray[n++] = 0.0;
                    }
                    double d15 = Math.log(d13) / Math.log(d14);
                    dArray[n++] = d15;
                    return n;
                }
                if (n3 != 1) return -1;
                if ((d = dArray[--n]) <= 0.0) {
                    return -1;
                }
                dArray[n++] = Math.log(d);
                return n;
            }
            case 26: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.exp(d);
                return n;
            }
            case 27: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) < 0.0) {
                    return -1;
                }
                dArray[n++] = Math.sqrt(d);
                return n;
            }
            case 28: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.sin(d);
                return n;
            }
            case 29: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.cos(d);
                return n;
            }
            case 30: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.tan(d);
                return n;
            }
            case 31: {
                double d;
                double d16;
                if (n3 != 1) {
                    return -1;
                }
                if ((d16 = Math.sin(d = dArray[--n])) == 0.0) {
                    return -1;
                }
                dArray[n++] = 1.0 / d16;
                return n;
            }
            case 32: {
                double d;
                double d17;
                if (n3 != 1) {
                    return -1;
                }
                if ((d17 = Math.cos(d = dArray[--n])) == 0.0) {
                    return -1;
                }
                dArray[n++] = 1.0 / d17;
                return n;
            }
            case 33: {
                double d;
                double d18;
                if (n3 != 1) {
                    return -1;
                }
                if ((d18 = Math.tan(d = dArray[--n])) == 0.0) {
                    return -1;
                }
                dArray[n++] = 1.0 / d18;
                return n;
            }
            case 34: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) > 1.0 || d < -1.0) {
                    return -1;
                }
                dArray[n++] = Math.asin(d);
                return n;
            }
            case 35: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) > 1.0 || d < -1.0) {
                    return -1;
                }
                dArray[n++] = Math.acos(d);
                return n;
            }
            case 36: {
                if (n3 == 1) {
                    double d = dArray[--n];
                    dArray[n++] = Math.atan(d);
                    return n;
                }
                if (n3 != 2) return -1;
                double d = dArray[--n];
                double d19 = dArray[--n];
                dArray[n++] = Math.atan2(d, d19);
                return n;
            }
            case 37: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 0.0) {
                    return -1;
                }
                double d20 = 1.0 / d;
                if (d20 > 1.0 || d20 < -1.0) {
                    return -1;
                }
                dArray[n++] = Math.asin(d20);
                return n;
            }
            case 38: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 0.0) {
                    return -1;
                }
                double d21 = 1.0 / d;
                if (d21 > 1.0 || d21 < -1.0) {
                    return -1;
                }
                dArray[n++] = Math.acos(d21);
                return n;
            }
            case 39: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 0.0) {
                    return -1;
                }
                double d22 = 1.0 / d;
                dArray[n++] = Math.atan(d22);
                return n;
            }
            case 40: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = (Math.exp(d) - Math.exp(-d)) / 2.0;
                return n;
            }
            case 41: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = (Math.exp(d) + Math.exp(-d)) / 2.0;
                return n;
            }
            case 42: {
                double d;
                double d23;
                if (n3 != 1) {
                    return -1;
                }
                if ((d23 = Math.exp(d = dArray[--n]) + Math.exp(-d)) == 0.0) {
                    return -1;
                }
                dArray[n++] = (Math.exp(d) - Math.exp(-d)) / d23;
                return n;
            }
            case 43: {
                double d;
                double d24;
                if (n3 != 1) {
                    return -1;
                }
                if ((d24 = Math.exp(d = dArray[--n]) - Math.exp(-d)) == 0.0) {
                    return -1;
                }
                dArray[n++] = 1.0 / d24;
                return n;
            }
            case 44: {
                double d;
                double d25;
                if (n3 != 1) {
                    return -1;
                }
                if ((d25 = Math.exp(d = dArray[--n]) + Math.exp(-d)) == 0.0) {
                    return -1;
                }
                dArray[n++] = 1.0 / d25;
                return n;
            }
            case 45: {
                double d;
                double d26;
                if (n3 != 1) {
                    return -1;
                }
                if ((d26 = Math.exp(d = dArray[--n]) - Math.exp(-d)) == 0.0) {
                    return -1;
                }
                dArray[n++] = (Math.exp(d) + Math.exp(-d)) / d26;
                return n;
            }
            case 46: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = Math.log(d + Math.sqrt(1.0 + d * d));
                return n;
            }
            case 47: {
                double d;
                double d27;
                if (n3 != 1) {
                    return -1;
                }
                if ((d27 = (d = dArray[--n]) * d - 1.0) < 0.0) {
                    return -1;
                }
                dArray[n++] = Math.log(d + Math.sqrt(d27));
                return n;
            }
            case 48: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if (1.0 - (d = dArray[--n]) <= 0.0 || d <= -1.0) {
                    return -1;
                }
                double d28 = (1.0 + d) / (1.0 - d);
                if (d28 <= 0.0) {
                    return -1;
                }
                dArray[n++] = Math.log(Math.sqrt(d28));
                return n;
            }
            case 49: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 0.0) {
                    return -1;
                }
                double d29 = d < 0.0 ? Math.log((1.0 - Math.sqrt(1.0 + d * d)) / d) : Math.log((1.0 + Math.sqrt(1.0 + d * d)) / d);
                dArray[n++] = d29;
                return n;
            }
            case 50: {
                double d;
                double d30;
                if (n3 != 1) {
                    return -1;
                }
                if ((d30 = 1.0 - (d = dArray[--n]) * d) < 0.0 || d <= 0.0) {
                    return -1;
                }
                dArray[n++] = Math.log((1.0 + Math.sqrt(d30)) / d);
                return n;
            }
            case 51: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if (1.0 - (d = dArray[--n]) == 0.0) {
                    return -1;
                }
                double d31 = (-1.0 - d) / (1.0 - d);
                if (d31 <= 0.0) {
                    return -1;
                }
                dArray[n++] = Math.log(Math.sqrt(d31));
                return n;
            }
            case 52: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) <= -1.0) {
                    return -1;
                }
                dArray[n++] = this.gamma(d + 1.0);
                return n;
            }
            case 53: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = this.factorial2(d);
                return n;
            }
            case 54: {
                double d;
                if (n3 != 2) {
                    return -1;
                }
                double d32 = dArray[--n];
                if ((d = dArray[--n]) <= -1.0 || d32 <= -1.0 || d - d32 <= -1.0) {
                    return -1;
                }
                dArray[n++] = Math.exp(this.logGamma(d + 1.0) - this.logGamma(d32 + 1.0) - this.logGamma(d - d32 + 1.0));
                return n;
            }
            case 55: {
                if (n3 < 0) {
                    return -1;
                }
                double d = 0.0;
                double d33 = 0.0;
                int n10 = 0;
                while (n10 < n3) {
                    double d34;
                    if ((d34 = dArray[--n]) <= -1.0) {
                        return -1;
                    }
                    d33 += d34;
                    d += this.logGamma(d34 + 1.0);
                    ++n10;
                }
                if (d <= -1.0) {
                    return -1;
                }
                dArray[n++] = Math.exp(this.logGamma(d33 + 1.0) - d);
                return n;
            }
            case 56: {
                double d;
                double d35;
                if (n3 != 2) {
                    return -1;
                }
                --n;
                if ((d35 = dArray[--n]) + (d = dArray[n]) <= -1.0 || d <= -1.0) {
                    return -1;
                }
                dArray[n++] = Math.exp(this.logGamma(d35 + d + 1.0) - this.logGamma(d + 1.0));
                return n;
            }
            case 57: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = this.gamma(d);
                return n;
            }
            case 58: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = this.logGamma(d);
                return n;
            }
            case 112: {
                double d;
                double d36;
                double d37;
                if (n3 != 2) {
                    return -1;
                }
                --n;
                if ((d37 = this.gamma((d36 = dArray[--n]) + (d = dArray[n]))) == 0.0) {
                    return -1;
                }
                dArray[n++] = this.gamma(d36) * this.gamma(d) / d37;
                return n;
            }
            case 59: {
                if (n3 != 3) {
                    return -1;
                }
                double d = dArray[--n];
                double d38 = dArray[--n];
                double d39 = dArray[--n];
                if (d == 0.0 || d38 < 0.0) {
                    return -1;
                }
                d39 = Math.pow(d39, d38);
                dArray[n++] = d39 - d * Math.floor(d39 / d);
                return n;
            }
            case 60: {
                if (n3 == 2) {
                    double d = dArray[--n];
                    double d40 = dArray[--n];
                    dArray[n++] = this.erf(d) - this.erf(d40);
                    return n;
                }
                if (n3 != 1) return -1;
                double d = dArray[--n];
                dArray[n++] = this.erf(d);
                return n;
            }
            case 61: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = 1.0 - this.erf(d);
                return n;
            }
            case 62: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = this.erfi(d);
                return n;
            }
            case 63: {
                double d;
                double d41;
                if (n3 == 1) {
                    d41 = 1.0E-4;
                    d = dArray[--n];
                } else {
                    if (n3 != 2) return -1;
                    d41 = dArray[--n];
                    d = dArray[--n];
                    if (d41 < 0.0) {
                        return -1;
                    }
                }
                d = dArray[--n];
                double d42 = Math.floor(d * 12600.0 + 0.5);
                if (Math.abs(d42 - d) < d41 * 10.0) {
                    d42 = d;
                }
                dArray[n++] = d42;
                return n;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                if (n < n3) {
                    return -1;
                }
                double d = 1.0;
                int n11 = 0;
                while (n11 < n3 - 1) {
                    double d43 = dArray[n - n11 - 2];
                    double d44 = dArray[n - n11 - 1];
                    switch (n4) {
                        case 64: {
                            if (d43 == d44) break;
                            d = 0.0;
                            break;
                        }
                        case 65: {
                            if (d43 != d44) break;
                            d = 0.0;
                            break;
                        }
                        case 66: {
                            if (d43 < d44) break;
                            d = 0.0;
                            break;
                        }
                        case 68: {
                            if (d43 <= d44) break;
                            d = 0.0;
                            break;
                        }
                        case 67: {
                            if (d43 > d44) break;
                            d = 0.0;
                            break;
                        }
                        case 69: {
                            if (d43 >= d44) break;
                            d = 0.0;
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    if (d < 0.5) break;
                    ++n11;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 70: 
            case 71: 
            case 80: {
                if (n3 != 1) {
                    return -1;
                }
                double d = dArray[--n];
                dArray[n++] = 1.0;
                return n;
            }
            case 72: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == Math.floor(d + 0.5)) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 73: {
                double d;
                double d45;
                if (n3 != 1) {
                    return -1;
                }
                if ((d45 = Math.floor((d = dArray[--n]) + 0.5)) != d || d45 != Math.floor(d45 / 2.0 + 0.5)) {
                    dArray[n++] = 0.0;
                    return n;
                }
                dArray[n++] = 1.0;
                return n;
            }
            case 74: {
                double d;
                double d46;
                if (n3 != 1) {
                    return -1;
                }
                if ((d46 = Math.floor((d = dArray[--n]) + 0.5)) != d || d46 == Math.floor(d46 / 2.0 + 0.5)) {
                    dArray[n++] = 0.0;
                    return n;
                }
                dArray[n++] = 1.0;
                return n;
            }
            case 75: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) > 0.0) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 76: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) < 0.0) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 77: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) <= 0.0) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 78: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) >= 0.0) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 79: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 1.0) {
                    dArray[n++] = 1.0;
                    return n;
                }
                dArray[n++] = 0.0;
                return n;
            }
            case 81: {
                double d;
                if (n3 != 1) {
                    return -1;
                }
                if ((d = dArray[--n]) == 1.0) {
                    dArray[n++] = 0.0;
                    return n;
                }
                if (d != 0.0) return -1;
                dArray[n++] = 1.0;
                return n;
            }
            case 85: {
                double d;
                if (n3 != 2) {
                    return -1;
                }
                double d47 = dArray[--n];
                if ((d = dArray[--n]) == 1.0) {
                    dArray[n++] = d47;
                    return n;
                }
                if (d != 0.0) return -1;
                dArray[n++] = 1.0;
                return n;
            }
            case 82: 
            case 83: 
            case 84: {
                if (n < n3) {
                    return -1;
                }
                double d = n4 == 82 ? 1.0 : 0.0;
                int n12 = 0;
                while (n12 < n3) {
                    double d48 = dArray[n - n12 - 1];
                    switch (n4) {
                        case 82: {
                            if (d48 == 0.0) {
                                d = 0.0;
                                break;
                            }
                            if (d48 == 1.0) break;
                            return -1;
                        }
                        case 83: {
                            if (d48 == 1.0) {
                                d = 1.0;
                                break;
                            }
                            if (d48 == 0.0) break;
                            return -1;
                        }
                        case 84: {
                            if (d48 == 1.0) {
                                d = 1.0 - d;
                                break;
                            }
                            if (d48 == 0.0) break;
                            return -1;
                        }
                        default: {
                            return -1;
                        }
                    }
                    ++n12;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 86: {
                double d;
                if (n3 < 2 || n3 > 4) {
                    return -1;
                }
                double d49 = dArray[n - n3];
                if (d49 == 1.0) {
                    d = dArray[n - n3 + 1];
                } else if (d49 == 0.0) {
                    if (n3 <= 2) return -1;
                    d = dArray[n - n3 + 2];
                } else {
                    if (n3 <= 3) return -1;
                    d = dArray[n - n3 + 3];
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 87: {
                if ((n3 & 1) == 1) {
                    return -1;
                }
                double d = 0.0;
                int n13 = 0;
                while (n13 < n3) {
                    double d50 = dArray[n - n3 + 1];
                    double d51 = dArray[n - n3];
                    if (d51 == 1.0) {
                        d = d50;
                        break;
                    }
                    if (d51 != 0.0) {
                        return -1;
                    }
                    n13 += 2;
                }
                if (n13 >= n3) {
                    return -1;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 88: {
                if ((n3 & 1) == 0) {
                    return -1;
                }
                double d = dArray[n - n3];
                int n14 = 0;
                while (n14 < n3) {
                    double d52 = dArray[n - n3 + 2];
                    double d53 = dArray[n - n3 + 1];
                    if (d == d53) {
                        d = d52;
                        break;
                    }
                    n14 += 2;
                }
                if (n14 >= n3) {
                    return -1;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                if (n3 == 1) return n;
                return -1;
            }
            case 95: 
            case 96: 
            case 97: 
            case 99: {
                double d;
                if (n3 == 1) {
                    d = dArray[--n];
                } else {
                    if (n3 != 2) return -1;
                    double d54 = dArray[--n];
                    d = dArray[--n];
                }
                dArray[n++] = d;
                return n;
            }
            case 106: 
            case 107: {
                if (n3 != 0) {
                    return -1;
                }
                double d = (double)System.currentTimeMillis() / 1000.0;
                dArray[n++] = d - this.evaluator.seconds_since_1970;
                return n;
            }
            case 108: {
                if (n3 != 0) {
                    return -1;
                }
                dArray[n++] = -2.085978496E9 + (double)System.currentTimeMillis() / 1000.0;
                return n;
            }
            case 109: {
                if (n < n3) {
                    return -1;
                }
                double d = 1.0;
                int n15 = 0;
                while (n15 < n3) {
                    double d55 = dArray[n - n15 - 1];
                    if (d55 != 0.0) {
                        d = 0.0;
                        break;
                    }
                    ++n15;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 110: {
                if (n < n3) {
                    return -1;
                }
                double d = 1.0;
                double d56 = dArray[n - 1];
                int n16 = 0;
                while (n16 < n3) {
                    double d57 = dArray[n - n16 - 1];
                    if (d57 != d56) {
                        d = 0.0;
                        break;
                    }
                    ++n16;
                }
                if (n3 == 1 && d56 != 0.0) {
                    d = 0.0;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 111: {
                if (n < n3) {
                    return -1;
                }
                double d = 1.0;
                int n17 = 0;
                while (n17 < n3) {
                    double d58 = dArray[n - n17 - 1];
                    if (d58 < 0.0) {
                        d = 0.0;
                        break;
                    }
                    ++n17;
                }
                n -= n3;
                dArray[n++] = d;
                return n;
            }
            case 113: {
                if (n3 != 2) {
                    return -1;
                }
                double d = dArray[--n];
                double d59 = dArray[--n];
                dArray[n++] = d;
                this.evaluator.setVariableValue((int)d59, d);
                return n;
            }
            default: {
                return -1;
            }
        }
    }

    public void resetValue() {
        this.current_value = this.last_valid_value;
        this.setValue();
    }

    public void confirmValue() {
        this.last_valid_value = this.current_value;
    }

    public double erf(double d) {
        double d2 = d * d;
        if (d2 < 0.417316) {
            return d * (1.1283791670955126 + d2 * (-0.37612638903183754 + d2 * (0.11283791670955126 + d2 * (-0.026866170645131252 + d2 * (0.005223977625442188 + d2 * (-8.548327023450853E-4 + d2 * 1.2055332981789664E-4))))));
        }
        return (d > 0.0 ? 1.0 : -1.0) - 0.5641895835477563 / d * Math.exp(-d2) * (1.0 + 1.0 / (-0.9995450369403409 + d * (-1.775762362302549 + d * (-1.131190748119284 + d * (-0.2693430703319502 + d * (0.04984841389825107 + d * (-0.003959278415228862 + d * -9.749847083947127E-5)))))));
    }

    public double erfi(double d) {
        double d2 = d * d;
        if (d2 < 3.7558439999999997) {
            return d * (1.1283791670955126 + d2 * (0.37612638903183754 + d2 * (0.11283791670955126 + d2 * (0.026866170645131252 + d2 * (0.005223977625442188 + d2 * (8.548327023450853E-4 + d2 * (1.2055332981789664E-4 + d2 * (1.492565035840625E-5 + d2 * 1.6462114365889248E-6))))))));
        }
        return (d > 0.0 ? 1.0 : -1.0) + 0.5641895835477563 / d * Math.exp(d2) * (1.0 + 0.5 / d2);
    }

    public double gamma(double d) {
        if (d < 0.999999) {
            double d2 = Math.sin(Math.PI * (1.0 - d));
            if (d2 == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.PI * (1.0 - d) / this.gamma(2.0 - d) / d2;
        }
        double d3 = d - 0.5 + 0.5772156649015329;
        double d4 = -0.033065598370407914 + d * (7.675315151147096 + d * (0.17079593808620658 + d * (-0.053762067160213846 + d * (0.010456709616406415 + d * (-0.0012260922213384849 + d * (7.933850210667055E-5 + d * -2.1735396138730348E-6))))));
        if (d4 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(d3, d - 0.5) * Math.exp(-d3) * 2.5066282746310007 * (1.0 + 1.0 / d4);
    }

    public double logGamma(double d) {
        if (d < 0.999999) {
            double d2 = Math.sin(Math.PI * (1.0 - d));
            if (d2 <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.log(Math.PI * (1.0 - d) / d2) - this.logGamma(2.0 - d);
        }
        double d3 = d - 0.5 + 0.5772156649015329;
        double d4 = -0.033065598370407914 + d * (7.675315151147096 + d * (0.17079593808620658 + d * (-0.053762067160213846 + d * (0.010456709616406415 + d * (-0.0012260922213384849 + d * (7.933850210667055E-5 + d * -2.1735396138730348E-6))))));
        if (d4 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (d - 0.5) * Math.log(d3) - d3 + 0.9189385332046728 + Math.log(1.0 + 1.0 / d4);
    }

    double factorial2(double d) {
        return Math.pow(2.0, d / 2.0) * Math.pow(0.6366197723675814, 0.25 * (1.0 - Math.cos(Math.PI * d)) * this.gamma(1.0 + d / 2.0));
    }
}

