/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

class Graphics3D {
    public Color point_edge_color;
    public int full_pixel_width;
    public int full_pixel_height;
    public int pixel_width;
    public int pixel_height;
    public boolean is_stereo;
    public double stereo_distance;
    public double stereo_offset;
    public double pixel_stereo_offset;
    public double length_view_point;
    public double initial_length_view_point;
    public double magnification;
    public double initial_magnification;
    public double width;
    public double height;
    public double eye_distance;
    public Quaternion rotation;
    public Quaternion initial_rotation;
    public double[] original_sizes;
    public double[] original_center;
    public double[] scalings;
    public double[] scaled_scalings;
    public int old_pixel_width;
    public int old_pixel_height;
    public double old_width;
    public double old_height;
    public boolean old_is_stereo;
    public double old_stereo_distance;
    public double old_eye_distance;
    public Quaternion old_rotation;
    public Color option_AmbientLight;
    public boolean[] option_Axes = new boolean[3];
    public Primitive3D[] option_AxesStyle = new Primitive3D[3];
    public Primitive3D[] option_AxesLabel = new Primitive3D[3];
    public Primitive3D option_PlotLabel = null;
    public int[] option_AxesEdge = new int[]{-1, -1, -1};
    public Vector[] option_Ticks;
    public double[] ticks_max_in_length = new double[3];
    public double[] ticks_max_out_length = new double[3];
    public Color option_Background;
    public boolean option_Boxed = true;
    public double[] option_BoxRatios;
    public Primitive3D option_BoxStyle;
    public Color option_DefaultColor;
    public boolean option_Lighting = true;
    public Vector option_LightSources_vectors;
    public Vector option_LightSources_colors;
    public double[][] option_PlotRange;
    public double[] option_ViewPoint = new double[]{1.3, -2.4, 2.0};
    public double[] option_ViewVertical;
    public String option_TextStyle_font_url;
    public String option_TextStyle_font_family;
    public int option_TextStyle_font_weight;
    public int option_TextStyle_font_slant;
    public int option_TextStyle_font_size;
    public Color option_TextStyle_font_color;
    public Color option_TextStyle_font_background;
    int max_count_points;
    int count_points;
    float[] xs;
    float[] ys;
    float[] zs;
    int[] point_flags;
    public int[] left_pixel_xs;
    public int[] right_pixel_xs;
    public int[] pixel_ys;
    float[] point_scale;
    int[] temp_xs;
    int[] temp_ys;
    int[] temp_line_xs;
    int[] temp_line_ys;
    int visible_faces;
    boolean show_faces;
    int count_primitives;
    int min_primitive_index;
    int max_primitive_index;
    Vector primitives;
    int max_primitive_count_points;
    double[] max_original_coordinates;
    double[] min_original_coordinates;
    int count_ordered_primitives;
    int[] order;
    float[] rotated_center_zs;

    public void setGlobalParameters(int n, int n2, Color color, Color color2) {
        this.point_edge_color = color2;
        if (this.option_Background == null) {
            this.option_Background = color;
        }
        this.full_pixel_width = n;
        this.full_pixel_height = n2;
    }

    public Graphics3D() {
        double[] dArray = new double[3];
        dArray[2] = 1.0;
        this.option_ViewVertical = dArray;
        this.option_TextStyle_font_weight = -1;
        this.option_TextStyle_font_slant = -1;
        this.option_TextStyle_font_size = -1;
        this.point_edge_color = null;
        this.option_Background = null;
        this.full_pixel_width = 0;
        this.full_pixel_height = 0;
        this.pixel_width = 0;
        this.pixel_height = 0;
        this.is_stereo = false;
        this.stereo_distance = 0.0;
        this.primitives = new Vector();
        this.count_primitives = 0;
        this.min_primitive_index = 0;
        this.max_primitive_index = 0;
        this.visible_faces = 3;
        this.show_faces = true;
        this.rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.width = 1000.0;
        this.height = 1000.0;
        this.eye_distance = 8000.0;
        this.length_view_point = 3.38378;
        this.initial_length_view_point = 3.38378;
        this.magnification = 1.0;
        this.initial_magnification = 1.0;
        this.original_sizes = new double[3];
        this.original_center = new double[3];
        this.scalings = new double[3];
        this.scaled_scalings = new double[3];
        this.old_rotation = new Quaternion(0.0, 0.0, 0.0, 0.0);
        double[][] dArrayArray = new double[4][];
        double[] dArray2 = new double[3];
        dArray2[0] = 0.707107;
        dArray2[2] = 0.707107;
        dArrayArray[0] = dArray2;
        dArrayArray[1] = new double[]{0.57735, 0.57735, 0.57735};
        double[] dArray3 = new double[3];
        dArray3[1] = 0.707107;
        dArray3[2] = 0.707107;
        dArrayArray[2] = dArray3;
        dArrayArray[3] = new double[]{-0.408248, -0.408248, -0.816497};
        double[][] dArrayArray2 = dArrayArray;
        this.option_LightSources_vectors = new Vector();
        this.option_LightSources_vectors.addElement(dArrayArray2[0]);
        this.option_LightSources_vectors.addElement(dArrayArray2[1]);
        this.option_LightSources_vectors.addElement(dArrayArray2[2]);
        this.option_LightSources_vectors.addElement(dArrayArray2[3]);
        this.option_LightSources_colors = new Vector();
        this.option_LightSources_colors.addElement(new Color(1.0f, 0.0f, 0.0f));
        this.option_LightSources_colors.addElement(new Color(0.0f, 1.0f, 0.0f));
        this.option_LightSources_colors.addElement(new Color(0.0f, 0.0f, 1.0f));
        this.option_LightSources_colors.addElement(new Color(1.0f, 1.0f, 1.0f));
    }

    public Quaternion getQuaternion() {
        return this.rotation;
    }

    public void setQuaternion(Quaternion quaternion) {
        this.rotation = quaternion;
    }

    public void multiplyQuaternion(Quaternion quaternion) {
        this.rotation = quaternion.product(this.rotation);
        this.rotation.normalize();
    }

    public void projectPoints(boolean bl) {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        if (!bl && this.old_rotation.equals(this.rotation) && this.old_eye_distance == this.eye_distance && this.old_pixel_width == this.pixel_width && this.old_pixel_height == this.pixel_height && this.old_width == this.width && this.old_height == this.height && this.old_is_stereo == this.is_stereo && this.old_stereo_distance == this.stereo_distance) {
            return;
        }
        this.old_rotation.s = this.rotation.s;
        this.old_rotation.x = this.rotation.x;
        this.old_rotation.y = this.rotation.y;
        this.old_rotation.z = this.rotation.z;
        this.old_eye_distance = this.eye_distance;
        this.old_pixel_width = this.pixel_width;
        this.old_pixel_height = this.pixel_height;
        this.old_width = this.width;
        this.old_height = this.height;
        this.old_is_stereo = this.is_stereo;
        this.old_stereo_distance = this.stereo_distance;
        double d = this.rotation.s * this.rotation.x;
        double d2 = this.rotation.s * this.rotation.y;
        double d3 = this.rotation.s * this.rotation.z;
        double d4 = this.rotation.x * this.rotation.x;
        double d5 = this.rotation.x * this.rotation.y;
        double d6 = this.rotation.x * this.rotation.z;
        double d7 = this.rotation.y * this.rotation.y;
        double d8 = this.rotation.y * this.rotation.z;
        double d9 = this.rotation.z * this.rotation.z;
        double d10 = 2 * this.pixel_height;
        double d11 = 2.0 * this.height / this.eye_distance;
        float f5 = (float)(d10 * (0.5 - d7 - d9));
        float f6 = (float)(d10 * (d5 - d3));
        float f7 = (float)(d10 * (d6 + d2));
        float f8 = (float)(d10 * (d5 + d3));
        float f9 = (float)(d10 * (0.5 - d4 - d9));
        float f10 = (float)(d10 * (d8 - d));
        float f11 = (float)(d11 * (d6 - d2));
        float f12 = (float)(d11 * (d8 + d));
        float f13 = (float)(d11 * (0.5 - d4 - d7));
        float f14 = (float)(this.eye_distance * d11 / 2.0);
        float f15 = (float)this.pixel_width / 2.0f;
        float f16 = (float)this.pixel_height / 2.0f;
        if (!this.is_stereo) {
            this.pixel_stereo_offset = 0.0;
            n = 0;
            while (n < this.count_points) {
                f4 = f5 * this.xs[n] + f6 * this.ys[n] + f7 * this.zs[n];
                f3 = f8 * this.xs[n] + f9 * this.ys[n] + f10 * this.zs[n];
                f2 = f11 * this.xs[n] + f12 * this.ys[n] + f13 * this.zs[n];
                f = f14 - f2;
                if ((double)f <= 0.0) {
                    this.point_scale[n] = 0.0f;
                } else {
                    this.left_pixel_xs[n] = (int)(f15 + f4 / f);
                    this.pixel_ys[n] = (int)(f16 - f3 / f);
                    this.point_scale[n] = f;
                }
                ++n;
            }
        } else {
            float f17 = (float)(this.stereo_offset * d10);
            this.pixel_stereo_offset = f17 / f14;
            float f18 = f15 - (float)this.pixel_stereo_offset;
            float f19 = f15 + (float)this.pixel_stereo_offset;
            n = 0;
            while (n < this.count_points) {
                f4 = f5 * this.xs[n] + f6 * this.ys[n] + f7 * this.zs[n];
                f3 = f8 * this.xs[n] + f9 * this.ys[n] + f10 * this.zs[n];
                f2 = f11 * this.xs[n] + f12 * this.ys[n] + f13 * this.zs[n];
                f = f14 - f2;
                if ((double)f <= 0.0) {
                    this.point_scale[n] = 0.0f;
                } else {
                    this.left_pixel_xs[n] = (int)(f18 + (f4 + f17) / f);
                    this.right_pixel_xs[n] = (int)(f19 + (f4 - f17) / f);
                    this.pixel_ys[n] = (int)(f16 - f3 / f);
                    this.point_scale[n] = f;
                }
                ++n;
            }
        }
        if (this.count_points == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.count_primitives) {
            float f20;
            Primitive3D primitive3D = (Primitive3D)this.primitives.elementAt(n2);
            int n3 = primitive3D.count_points;
            if (n3 >= 3) {
                if (n3 == 3) {
                    f20 = this.point_scale[primitive3D.first_point] + this.point_scale[primitive3D.second_point] + this.point_scale[primitive3D.fourth_point];
                    this.rotated_center_zs[n2] = f20 + f20;
                } else {
                    f20 = this.point_scale[primitive3D.first_point] + this.point_scale[primitive3D.third_point];
                    this.rotated_center_zs[n2] = f20 + f20 + this.point_scale[primitive3D.second_point] + this.point_scale[primitive3D.fourth_point];
                }
            } else if (n3 == 2) {
                f20 = this.point_scale[primitive3D.first_point] + this.point_scale[primitive3D.third_point];
                this.rotated_center_zs[n2] = f20 + f20 + f20;
            } else {
                this.rotated_center_zs[n2] = n3 == 1 ? 6.0f * this.point_scale[primitive3D.points[0]] : 1.0f;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.count_ordered_primitives) {
            n2 = this.order[n4];
            float f21 = this.rotated_center_zs[n2];
            int n5 = n4 - 1;
            while (n5 >= 0 && this.rotated_center_zs[this.order[n5]] < f21) {
                this.order[n5 + 1] = this.order[n5];
                --n5;
            }
            this.order[n5 + 1] = n2;
            ++n4;
        }
    }

    public void addPrimitive(Primitive3D primitive3D) {
        if (primitive3D == null || primitive3D.count_points <= 0 && primitive3D.text == null || this.count_primitives != this.primitives.size()) {
            return;
        }
        this.primitives.addElement(primitive3D);
        if (primitive3D.count_points > this.max_primitive_count_points) {
            this.max_primitive_count_points = primitive3D.count_points;
        }
        this.max_count_points += primitive3D.count_points;
        ++this.count_primitives;
        this.max_primitive_index = this.count_primitives - 1;
    }

    public boolean xor(boolean bl, boolean bl2) {
        return bl && !bl2 || !bl && bl2;
    }

    public void preparePrimitives(Graphics graphics, Evaluator evaluator) {
        int n;
        double d;
        double d2;
        Object object;
        int n2;
        int n3;
        int n4;
        double d3;
        int n5;
        int n6;
        Primitive3D primitive3D;
        int n7 = 0;
        while (n7 < this.count_primitives) {
            primitive3D = (Primitive3D)this.primitives.elementAt(n7);
            n6 = 0;
            while (n6 < primitive3D.count_points) {
                double[] dArray = primitive3D.original_points[n6];
                if (dArray != null) {
                    double d4;
                    if (this.max_original_coordinates != null) {
                        n5 = 0;
                        while (n5 < 3) {
                            d4 = dArray[n5];
                            if (d4 > this.max_original_coordinates[n5]) {
                                this.max_original_coordinates[n5] = d4;
                            }
                            if (d4 < this.min_original_coordinates[n5]) {
                                this.min_original_coordinates[n5] = d4;
                            }
                            ++n5;
                        }
                    } else {
                        this.max_original_coordinates = new double[3];
                        this.min_original_coordinates = new double[3];
                        n5 = 0;
                        while (n5 < 3) {
                            this.max_original_coordinates[n5] = d4 = dArray[n5];
                            this.min_original_coordinates[n5] = d4;
                            ++n5;
                        }
                    }
                }
                ++n6;
            }
            ++n7;
        }
        if (this.max_original_coordinates == null) {
            this.max_original_coordinates = new double[3];
            this.min_original_coordinates = new double[3];
            n5 = 0;
            while (n5 < 3) {
                this.max_original_coordinates[n5] = 0.0;
                this.min_original_coordinates[n5] = 0.0;
                ++n5;
            }
        }
        if (this.option_Background == null) {
            this.option_Background = Color.white;
        }
        if (this.option_DefaultColor == null) {
            this.option_DefaultColor = new Color(this.option_Background.getRed() >= 128 ? 0 : 255, this.option_Background.getGreen() >= 128 ? 0 : 255, this.option_Background.getBlue() >= 128 ? 0 : 255);
        }
        if (this.option_AmbientLight == null) {
            this.option_AmbientLight = Color.black;
        }
        n5 = 0;
        while (n5 < 3) {
            if (this.option_PlotRange != null && this.option_PlotRange[n5][0] != Double.NEGATIVE_INFINITY && this.option_PlotRange[n5][1] != Double.POSITIVE_INFINITY) {
                if (this.option_PlotRange[n5][1] < this.option_PlotRange[n5][0]) {
                    double d5 = this.option_PlotRange[n5][0];
                    this.option_PlotRange[n5][0] = this.option_PlotRange[n5][1];
                    this.option_PlotRange[n5][1] = d5;
                }
                this.original_sizes[n5] = this.option_PlotRange[n5][1] - this.option_PlotRange[n5][0];
                this.original_center[n5] = (this.option_PlotRange[n5][1] + this.option_PlotRange[n5][0]) * 0.5;
            } else {
                this.original_sizes[n5] = this.max_original_coordinates[n5] - this.min_original_coordinates[n5];
                this.original_sizes[n5] = this.max_original_coordinates[n5] == this.min_original_coordinates[n5] ? 2.1 : this.original_sizes[n5] * 1.05;
                this.original_center[n5] = (this.max_original_coordinates[n5] + this.min_original_coordinates[n5]) * 0.5;
            }
            ++n5;
        }
        if (this.option_BoxRatios == null) {
            this.option_BoxRatios = new double[3];
            n5 = 0;
            while (n5 < 3) {
                this.option_BoxRatios[n5] = this.original_sizes[n5];
                ++n5;
            }
        }
        if (this.option_BoxRatios[1] > (d3 = this.option_BoxRatios[0])) {
            d3 = this.option_BoxRatios[1];
        }
        if (this.option_BoxRatios[2] > d3) {
            d3 = this.option_BoxRatios[2];
        }
        n5 = 0;
        while (n5 < 3) {
            this.option_BoxRatios[n5] = this.option_BoxRatios[n5] / d3;
            this.scalings[n5] = this.option_BoxRatios[n5] / this.original_sizes[n5];
            this.scaled_scalings[n5] = this.option_BoxRatios[n5];
            ++n5;
        }
        double d6 = Math.sqrt(this.option_BoxRatios[0] * this.option_BoxRatios[0] + this.option_BoxRatios[1] * this.option_BoxRatios[1] + this.option_BoxRatios[2] * this.option_BoxRatios[2]);
        if (this.option_Ticks == null) {
            this.option_Ticks = new Vector[3];
            int n8 = 0;
            while (n8 < 3) {
                this.option_Ticks[n8] = new Vector();
                ++n8;
            }
        }
        if (this.option_Boxed) {
            if (this.option_BoxStyle == null) {
                this.option_BoxStyle = new Primitive3D();
            }
            if (this.option_BoxStyle.standard_color == null) {
                this.option_BoxStyle.standard_color = this.option_DefaultColor;
            }
        }
        double[][] dArrayArray = new double[][]{null, null};
        boolean bl = false;
        boolean bl2 = false;
        n5 = 0;
        while (n5 < 3) {
            boolean bl3 = false;
            n4 = 0;
            while (n4 < 4) {
                n3 = 0;
                n2 = n4;
                if (n5 == 1) {
                    if (n2 == 1) {
                        n2 = 2;
                    } else if (n2 == 2) {
                        n2 = 1;
                    }
                }
                if (this.option_Axes[n5] && !bl3) {
                    if (this.option_AxesEdge[n5] >= 0) {
                        if (n2 == this.option_AxesEdge[n5]) {
                            n3 = 1;
                        }
                    } else if (this.option_AxesEdge[n5] == -1) {
                        if (n4 == 3) {
                            n3 = 1;
                        } else if (this.xor((n4 & 1) == 1, this.option_ViewPoint[(n5 + 1) % 3] >= 0.0) && this.xor((n4 & 2) == 2, this.option_ViewPoint[(n5 + 2) % 3] <= 0.0) && Math.abs(this.option_ViewPoint[(n5 + 1) % 3]) <= Math.abs(this.option_ViewPoint[(n5 + 2) % 3])) {
                            n3 = 1;
                        } else if (this.xor((n4 & 1) == 1, this.option_ViewPoint[(n5 + 1) % 3] <= 0.0) && this.xor((n4 & 2) == 2, this.option_ViewPoint[(n5 + 2) % 3] >= 0.0) && Math.abs(this.option_ViewPoint[(n5 + 1) % 3]) >= Math.abs(this.option_ViewPoint[(n5 + 2) % 3])) {
                            n3 = 1;
                        }
                    }
                }
                if (n3 != 0 || this.option_Boxed) {
                    object = new double[2][3];
                    if (n3 != 0) {
                        double d7;
                        bl3 = true;
                        if (this.option_Ticks != null && this.option_Ticks[n5] != null) {
                            double d8;
                            double d9;
                            bl2 = true;
                            if (this.option_Ticks[n5].isEmpty()) {
                                try {
                                    this.ticks_max_in_length[n5] = 0.01;
                                    this.ticks_max_out_length[n5] = 0.0;
                                    double[] dArray = new double[]{0.25, 0.2, 0.1, 0.05, 0.025, 0.02, 0.01};
                                    d7 = Math.pow(10.0, Math.ceil(Math.log(this.original_sizes[n5]) / Math.log(10.0)));
                                    int n9 = 1;
                                    while (n9 < 7 && this.original_sizes[n5] / d7 / dArray[n9] <= 5.0) {
                                        ++n9;
                                    }
                                    d2 = dArray[--n9] * d7;
                                    int n10 = 0;
                                    while (n10 < 1) {
                                        ++n10;
                                    }
                                    d9 = this.original_center[n5] - this.original_sizes[n5] / 2.0;
                                    d = this.original_center[n5] + this.original_sizes[n5] / 2.0;
                                    d8 = Math.ceil(d9 / d2) * d2;
                                    int n11 = 0;
                                    while (n11 < 10 && d8 <= d) {
                                        if (Math.abs(d8) < Math.abs(d2 / 100.0)) {
                                            d8 = 0.0;
                                        }
                                        Primitive3D primitive3D2 = new Primitive3D();
                                        primitive3D2.front_specular_exponent = 0.01;
                                        primitive3D2.back_specular_exponent = 0.0;
                                        primitive3D2.original_point_size = d8;
                                        primitive3D2.text = Float.toString((float)d8);
                                        this.option_Ticks[n5].addElement(primitive3D2);
                                        d8 += d2;
                                        ++n11;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            }
                            n = 0;
                            while (n < this.option_Ticks[n5].size()) {
                                try {
                                    Primitive3D primitive3D3 = new Primitive3D((Primitive3D)this.option_Ticks[n5].elementAt(n));
                                    Primitive3D primitive3D4 = (Primitive3D)this.option_Ticks[n5].elementAt(n);
                                    double d10 = primitive3D4.original_point_size;
                                    double d11 = primitive3D4.front_specular_exponent;
                                    d9 = primitive3D4.back_specular_exponent;
                                    primitive3D4.text = null;
                                    primitive3D4.count_points = 2;
                                    primitive3D4.original_points = new double[2][3];
                                    primitive3D4.original_points[0][n5] = d10;
                                    primitive3D4.original_points[1][n5] = d10;
                                    primitive3D4.original_scaled_offsets = new double[2][3];
                                    primitive3D4.original_scaled_offsets[0][n5] = 0.0;
                                    primitive3D4.original_scaled_offsets[1][n5] = 0.0;
                                    primitive3D3.count_points = 1;
                                    primitive3D3.original_points = new double[1][3];
                                    primitive3D3.original_points[0][n5] = d10;
                                    primitive3D3.original_scaled_offsets = new double[1][3];
                                    primitive3D3.original_scaled_offsets[0][n5] = 0.0;
                                    primitive3D3.original_point_size = 0.0;
                                    primitive3D3.original_thickness = 0.0;
                                    int n12 = 1;
                                    while (n12 < 3) {
                                        double d12;
                                        int n13 = (n5 + n12) % 3;
                                        d8 = 1.0;
                                        if ((n4 & n12) == 0) {
                                            d8 = -1.0;
                                        }
                                        primitive3D4.original_points[0][n13] = d12 = this.original_center[n13] - this.original_sizes[n13] / 2.0;
                                        primitive3D4.original_points[1][n13] = d12;
                                        primitive3D4.original_scaled_offsets[0][n13] = (d8 + 1.0) / 2.0 - d8 * d11 * d6 / 1.4142136 / this.option_BoxRatios[n13];
                                        primitive3D4.original_scaled_offsets[1][n13] = (d8 + 1.0) / 2.0 + d8 * d9 * d6 / 1.4142136 / this.option_BoxRatios[n13];
                                        int n14 = 0;
                                        while (n14 < 1) {
                                            ++n14;
                                        }
                                        primitive3D3.original_points[0][n13] = d12;
                                        primitive3D3.original_scaled_offsets[0][n13] = (d8 + 1.0) / 2.0 + d8 * (0.05 + this.ticks_max_in_length[n5] + this.ticks_max_out_length[n5]) * d6 / 1.4142136 / this.option_BoxRatios[n13];
                                        ++n12;
                                    }
                                    this.addPrimitive(primitive3D4);
                                    this.addPrimitive(primitive3D3);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                ++n;
                            }
                        }
                        if (this.option_AxesLabel[n5] != null) {
                            bl = true;
                            primitive3D = this.option_AxesLabel[n5];
                            primitive3D.count_points = 1;
                            primitive3D.original_point_size = 0.0;
                            primitive3D.original_thickness = 0.0;
                            primitive3D.original_points = dArrayArray;
                            primitive3D.original_scaled_offsets = new double[1][3];
                            primitive3D.original_scaled_offsets[0][n5] = 0.5;
                            n = 1;
                            while (n < 3) {
                                d7 = 1.0;
                                if ((n4 & n) == 0) {
                                    d7 = -1.0;
                                }
                                int n15 = (n5 + n) % 3;
                                primitive3D.original_scaled_offsets[0][n15] = (d7 + 1.0) / 2.0 + d7 * (0.15 + this.ticks_max_in_length[n5] + this.ticks_max_out_length[n5]) * d6 / 1.4142136 / this.option_BoxRatios[n15];
                                ++n;
                            }
                            this.addPrimitive(primitive3D);
                        }
                        primitive3D = this.option_AxesStyle[n5] != null ? new Primitive3D(this.option_AxesStyle[n5]) : new Primitive3D();
                        if (primitive3D.standard_color == null) {
                            primitive3D.standard_color = this.option_DefaultColor;
                        }
                    } else {
                        primitive3D = new Primitive3D(this.option_BoxStyle);
                    }
                    primitive3D.is_filled = false;
                    primitive3D.count_points = 2;
                    primitive3D.original_points = dArrayArray;
                    primitive3D.original_scaled_offsets = object;
                    primitive3D.original_scaled_offsets[0][n5] = 0.0;
                    primitive3D.original_scaled_offsets[0][(n5 + 1) % 3] = n4 & 1;
                    primitive3D.original_scaled_offsets[0][(n5 + 2) % 3] = (n4 & 2) / 2;
                    primitive3D.original_scaled_offsets[1][n5] = 1.0;
                    primitive3D.original_scaled_offsets[1][(n5 + 1) % 3] = n4 & 1;
                    primitive3D.original_scaled_offsets[1][(n5 + 2) % 3] = (n4 & 2) / 2;
                    this.addPrimitive(primitive3D);
                }
                ++n4;
            }
            ++n5;
        }
        if (this.option_PlotLabel != null) {
            primitive3D = this.option_PlotLabel;
            primitive3D.count_points = 0;
            primitive3D.original_point_size = 0.0;
            primitive3D.original_thickness = 1.0;
            primitive3D.original_points = null;
            primitive3D.original_scaled_offsets = null;
            this.addPrimitive(primitive3D);
        }
        float[] fArray = new float[3];
        this.xs = new float[this.max_count_points];
        this.ys = new float[this.max_count_points];
        this.zs = new float[this.max_count_points];
        this.point_flags = new int[this.max_count_points];
        this.count_points = 0;
        n7 = 0;
        while (n7 < this.count_primitives) {
            int n16;
            primitive3D = (Primitive3D)this.primitives.elementAt(n7);
            if (primitive3D.points == null && primitive3D.count_points > 0) {
                primitive3D.points = new int[primitive3D.count_points + 1];
            }
            n4 = -1;
            n2 = 0;
            n6 = 0;
            int n17 = 0;
            while (n17 < primitive3D.count_points) {
                if (primitive3D.original_points[n17] != null) {
                    n5 = 0;
                    while (n5 < 3) {
                        fArray[n5] = (float)(this.scalings[n5] * (primitive3D.original_points[n17][n5] - this.original_center[n5]) + this.scaled_scalings[n5] * primitive3D.original_scaled_offsets[n17][n5]);
                        ++n5;
                    }
                    n2 = evaluator != null && primitive3D.original_expressions != null && (primitive3D.original_expressions[n17][0] >= 0 || primitive3D.original_expressions[n17][1] >= 0 || primitive3D.original_expressions[n17][2] >= 0) ? 1 : 0;
                } else {
                    n5 = 0;
                    while (n5 < 3) {
                        fArray[n5] = (float)(this.scaled_scalings[n5] * (primitive3D.original_scaled_offsets[n17][n5] - 0.5));
                        ++n5;
                    }
                    n2 = 0;
                }
                if (n2 != 0) {
                    n3 = this.count_points;
                    this.point_flags[n3] = this.point_flags[n3] | 2;
                    n5 = 0;
                    while (n5 < 3) {
                        n16 = primitive3D.original_expressions[n17][n5];
                        if (n16 >= 0) {
                            evaluator.setExpressionCoordinate(n16, this, n3, n5);
                        }
                        ++n5;
                    }
                } else {
                    n3 = 0;
                }
                while (n3 < this.count_points && ((this.point_flags[n3] & 2) == 2 || fArray[0] != this.xs[n3] || fArray[1] != this.ys[n3] || fArray[2] != this.zs[n3])) {
                    ++n3;
                }
                if (primitive3D.is_filled) {
                    this.point_flags[n3] = this.point_flags[n3] | 1;
                }
                if (n3 >= this.count_points) {
                    this.xs[n3] = fArray[0];
                    this.ys[n3] = fArray[1];
                    this.zs[n3] = fArray[2];
                    this.count_points = n3 + 1;
                }
                if (n4 != n3) {
                    primitive3D.points[n6] = n3;
                    if (primitive3D.edge_flags != null) {
                        primitive3D.edge_flags[n6] = primitive3D.edge_flags[n17];
                    }
                    n4 = n3;
                    ++n6;
                }
                ++n17;
            }
            if (primitive3D.is_filled && n6 >= 4 && primitive3D.points[0] == primitive3D.points[n6 - 1]) {
                --n6;
            }
            if (primitive3D.count_points == 2) {
                if (n6 == 1) {
                    primitive3D.points[1] = primitive3D.points[0];
                }
            } else if (primitive3D.count_points >= 3) {
                if (n6 == 1) {
                    primitive3D.points[1] = primitive3D.points[0];
                    n6 = 2;
                }
                if (n6 == 2) {
                    primitive3D.points[2] = primitive3D.points[1];
                    n6 = 3;
                }
                primitive3D.count_points = n6;
            }
            if (primitive3D.text != null) {
                primitive3D.point_diameter = -1;
            } else {
                if (primitive3D.count_points == 1 && n2 != 0) {
                    n5 = 0;
                    while (n5 < 3) {
                        n16 = primitive3D.original_expressions[0][n5];
                        if (n16 >= 0 && evaluator.getExpression(n16).isAtomicIndependentVariable()) {
                            primitive3D.font_url = Primitive3D.text_dragable_point;
                        }
                        ++n5;
                    }
                }
                primitive3D.point_diameter = !primitive3D.is_filled && primitive3D.count_points == 1 ? (primitive3D.is_absolute_point_size ? (int)primitive3D.original_point_size : (int)(primitive3D.original_point_size * (double)this.full_pixel_height * d6)) : (primitive3D.is_filled ? (primitive3D.is_absolute_edge_thickness ? (int)primitive3D.original_edge_thickness : (int)(primitive3D.original_edge_thickness * (double)this.full_pixel_height * d6)) : (primitive3D.is_absolute_thickness ? (int)primitive3D.original_thickness : (int)(primitive3D.original_thickness * (double)this.full_pixel_height * d6)));
                if (primitive3D.point_diameter < 0) {
                    primitive3D.point_diameter = 0;
                }
                if (primitive3D.count_points == 1) {
                    primitive3D.first_point = primitive3D.points[0];
                    primitive3D.second_point = primitive3D.points[0];
                    primitive3D.third_point = primitive3D.points[0];
                    primitive3D.fourth_point = primitive3D.points[0];
                } else if (primitive3D.count_points == 2) {
                    primitive3D.first_point = primitive3D.points[0];
                    primitive3D.second_point = primitive3D.points[0];
                    primitive3D.third_point = primitive3D.points[1];
                    primitive3D.fourth_point = primitive3D.points[1];
                } else if (primitive3D.count_points == 3) {
                    primitive3D.first_point = primitive3D.points[0];
                    primitive3D.second_point = primitive3D.points[1];
                    primitive3D.third_point = primitive3D.points[1];
                    primitive3D.fourth_point = primitive3D.points[2];
                } else if (primitive3D.count_points == 4) {
                    n = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < 4) {
                        n19 = this.getPointDistance(primitive3D, n20);
                        if (n20 == 0 || n18 > n19) {
                            n = n20;
                            n18 = n19;
                        }
                        ++n20;
                    }
                    if (n == 1 || n == 2) {
                        primitive3D.first_point = primitive3D.points[0];
                        primitive3D.second_point = primitive3D.points[1];
                        primitive3D.third_point = primitive3D.points[2];
                        primitive3D.fourth_point = primitive3D.points[3];
                    } else {
                        primitive3D.first_point = primitive3D.points[2];
                        primitive3D.second_point = primitive3D.points[3];
                        primitive3D.third_point = primitive3D.points[0];
                        primitive3D.fourth_point = primitive3D.points[1];
                    }
                } else if (primitive3D.count_points > 4) {
                    n = 0;
                    int n21 = 0;
                    while (n21 < primitive3D.count_points) {
                        n += this.getPointDistance(primitive3D, n21);
                        ++n21;
                    }
                    double d13 = (double)n / 3.0;
                    int n22 = 1;
                    double d14 = d13;
                    int n23 = 0;
                    n = 0;
                    primitive3D.first_point = primitive3D.points[0];
                    int n24 = 0;
                    while (n22 < 3 && n24 < primitive3D.count_points) {
                        int n25 = n;
                        if ((double)(n += this.getPointDistance(primitive3D, n24)) > d14) {
                            n6 = (double)n - d14 < d14 - (double)n25 ? (n24 + 1) % primitive3D.count_points : n24;
                            if (n22 == 1) {
                                primitive3D.second_point = primitive3D.points[n6];
                                n23 = n6;
                            } else if (n22 == 2) {
                                primitive3D.third_point = primitive3D.points[(n23 + n6) / 2];
                                primitive3D.fourth_point = primitive3D.points[n6];
                            }
                            ++n22;
                            d14 += d13;
                        }
                        ++n24;
                    }
                }
            }
            primitive3D.original_points = null;
            primitive3D.original_scaled_offsets = null;
            if (primitive3D.font_url != Primitive3D.text_dragable_point) {
                primitive3D.original_expressions = null;
            }
            ++n7;
        }
        if (this.option_ViewPoint != null && this.option_ViewVertical != null) {
            this.set_rotation_from_view_parameters(this.option_ViewPoint, this.option_ViewVertical);
            if (bl || bl2) {
                this.setPerspective(this.length_view_point, 0.66, this.is_stereo, this.stereo_distance);
            } else {
                this.setPerspective(this.length_view_point, 1.0, this.is_stereo, this.stereo_distance);
            }
        } else if (bl || bl2) {
            this.setPerspective(3.38378, 0.66, this.is_stereo, this.stereo_distance);
        } else {
            this.setPerspective(3.38378, 1.0, this.is_stereo, this.stereo_distance);
        }
        this.initial_magnification = this.magnification;
        n7 = 0;
        while (n7 < this.count_primitives) {
            primitive3D = (Primitive3D)this.primitives.elementAt(n7);
            if (primitive3D.standard_color == null) {
                primitive3D.standard_color = this.option_DefaultColor;
            }
            if (primitive3D.text != null) {
                if (primitive3D.front_face_color == null) {
                    primitive3D.front_face_color = this.option_TextStyle_font_color != null ? this.option_TextStyle_font_color : primitive3D.standard_color;
                }
                if (primitive3D.back_face_color == null && this.option_TextStyle_font_background != null) {
                    primitive3D.back_face_color = this.option_TextStyle_font_background;
                }
                primitive3D.front_color = primitive3D.front_face_color;
                primitive3D.back_color = primitive3D.back_face_color;
            } else {
                if (primitive3D.edge_color == null) {
                    primitive3D.edge_color = this.option_DefaultColor;
                }
                if (primitive3D.front_face_color == null) {
                    primitive3D.front_face_color = this.option_DefaultColor;
                }
                if (primitive3D.back_face_color == null && primitive3D.text == null) {
                    primitive3D.back_face_color = this.option_DefaultColor;
                }
                if (!this.option_Lighting) {
                    primitive3D.front_color = primitive3D.front_face_color;
                    primitive3D.back_color = primitive3D.back_face_color;
                }
            }
            if (primitive3D.is_filled && this.option_Lighting && primitive3D.count_points > 2) {
                double[] dArray = new double[3];
                int[][] nArrayArray = new int[][]{{primitive3D.front_diffuse_color.getRed() * this.option_AmbientLight.getRed() / 255, primitive3D.front_diffuse_color.getGreen() * this.option_AmbientLight.getGreen() / 255, primitive3D.front_diffuse_color.getBlue() * this.option_AmbientLight.getBlue() / 255}, {primitive3D.back_diffuse_color.getRed() * this.option_AmbientLight.getRed() / 255, primitive3D.back_diffuse_color.getGreen() * this.option_AmbientLight.getGreen() / 255, primitive3D.back_diffuse_color.getBlue() * this.option_AmbientLight.getBlue() / 255}};
                float f = this.xs[primitive3D.second_point] - this.xs[primitive3D.first_point];
                float f2 = this.ys[primitive3D.second_point] - this.ys[primitive3D.first_point];
                float f3 = this.zs[primitive3D.second_point] - this.zs[primitive3D.first_point];
                float f4 = this.xs[primitive3D.fourth_point] - this.xs[primitive3D.second_point];
                float f5 = this.ys[primitive3D.fourth_point] - this.ys[primitive3D.second_point];
                float f6 = this.zs[primitive3D.fourth_point] - this.zs[primitive3D.second_point];
                dArray[0] = f2 * f6 - f3 * f5;
                dArray[1] = f3 * f4 - f * f6;
                dArray[2] = f * f5 - f2 * f4;
                d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
                dArray[0] = dArray[0] / d2;
                dArray[1] = dArray[1] / d2;
                dArray[2] = dArray[2] / d2;
                dArray = this.rotation.rotated(dArray);
                int n26 = 0;
                while (n26 < this.option_LightSources_vectors.size()) {
                    Color color;
                    int n27;
                    double[] dArray2 = (double[])this.option_LightSources_vectors.elementAt(n26);
                    Color color2 = (Color)this.option_LightSources_colors.elementAt(n26);
                    d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
                    if (d > 0.0) {
                        n27 = 0;
                        color = primitive3D.front_diffuse_color;
                    } else {
                        d = -d;
                        n27 = 1;
                        color = primitive3D.back_diffuse_color;
                    }
                    if (color != null) {
                        nArrayArray[n27][0] = nArrayArray[n27][0] + (int)((double)(color.getRed() * color2.getRed()) * (d /= 255.0));
                        nArrayArray[n27][1] = nArrayArray[n27][1] + (int)((double)(color.getGreen() * color2.getGreen()) * d);
                        nArrayArray[n27][2] = nArrayArray[n27][2] + (int)((double)(color.getBlue() * color2.getBlue()) * d);
                    }
                    Color color3 = null;
                    double d15 = 1.0;
                    d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
                    if (dArray[2] >= 0.0) {
                        if (d > 0.0) {
                            n27 = 0;
                            color3 = primitive3D.front_specular_color;
                            d15 = primitive3D.front_specular_exponent;
                        }
                    } else if (d < 0.0) {
                        n27 = 1;
                        color3 = primitive3D.back_specular_color;
                        d15 = primitive3D.back_specular_exponent;
                    }
                    if (color3 != null) {
                        double[] dArray3 = new double[]{2.0 * dArray[0] * dArray[2], 2.0 * dArray[1] * dArray[2], 2.0 * dArray[2] * dArray[2] - 1.0};
                        d = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[1] + dArray3[2] * dArray2[2];
                        if ((d += 1.0) < 0.0) {
                            d = 0.0;
                        }
                        d = Math.pow(Math.abs(d / 2.0), d15);
                        nArrayArray[n27][0] = nArrayArray[n27][0] + (int)((double)(color3.getRed() * color2.getRed()) * (d /= 255.0));
                        nArrayArray[n27][1] = nArrayArray[n27][1] + (int)((double)(color3.getGreen() * color2.getGreen()) * d);
                        nArrayArray[n27][2] = nArrayArray[n27][2] + (int)((double)(color3.getBlue() * color2.getBlue()) * d);
                    }
                    ++n26;
                }
                int n28 = 0;
                while (n28 < 3) {
                    int n29 = 0;
                    while (n29 < 2) {
                        if (nArrayArray[n29][n28] < 0) {
                            nArrayArray[n29][n28] = 0;
                        }
                        if (nArrayArray[n29][n28] > 255) {
                            nArrayArray[n29][n28] = 255;
                        }
                        ++n29;
                    }
                    ++n28;
                }
                primitive3D.front_color = new Color(nArrayArray[0][0], nArrayArray[0][1], nArrayArray[0][2]);
                primitive3D.back_color = new Color(nArrayArray[1][0], nArrayArray[1][1], nArrayArray[1][2]);
            }
            ++n7;
        }
        this.order = new int[this.count_primitives];
        int n30 = 0;
        n7 = 0;
        while (n7 < this.count_primitives) {
            boolean bl4 = false;
            primitive3D = (Primitive3D)this.primitives.elementAt(n7);
            if (!primitive3D.is_filled && primitive3D.count_points > 1) {
                boolean bl5 = true;
                n6 = 0;
                while (n6 < primitive3D.count_points && bl5) {
                    if ((this.point_flags[primitive3D.points[n6]] & 1) == 0) {
                        bl5 = false;
                    }
                    ++n6;
                }
                if (bl5) {
                    object = null;
                    int n31 = 0;
                    while (n31 < this.count_primitives) {
                        boolean bl6 = true;
                        object = (Primitive3D)this.primitives.elementAt(n31);
                        if (((Primitive3D)object).is_filled) {
                            n6 = 0;
                            while (n6 < primitive3D.count_points && bl6) {
                                boolean bl7 = false;
                                int n32 = 0;
                                while (n32 < ((Primitive3D)object).count_points && !bl7) {
                                    if (primitive3D.points[n6] == ((Primitive3D)object).points[n32]) {
                                        bl7 = true;
                                    }
                                    ++n32;
                                }
                                if (!bl7) {
                                    bl6 = false;
                                }
                                ++n6;
                            }
                            if (bl6) {
                                ((Primitive3D)object).addEdge(primitive3D);
                                bl4 = true;
                            }
                        }
                        ++n31;
                    }
                }
            }
            if (!bl4) {
                this.order[n30] = n7;
                ++n30;
            }
            ++n7;
        }
        this.count_ordered_primitives = n30;
        this.left_pixel_xs = new int[this.count_points];
        this.right_pixel_xs = new int[this.count_points];
        this.pixel_ys = new int[this.count_points];
        this.point_scale = new float[this.count_points];
        this.temp_xs = new int[this.max_primitive_count_points + 1];
        this.temp_ys = new int[this.max_primitive_count_points + 1];
        this.temp_line_xs = new int[6];
        this.temp_line_ys = new int[6];
        this.rotated_center_zs = new float[this.count_primitives];
        if (this.option_TextStyle_font_family == null) {
            this.option_TextStyle_font_family = "Courier";
        }
        if (this.option_TextStyle_font_weight == -1) {
            this.option_TextStyle_font_weight = 0;
        }
        if (this.option_TextStyle_font_slant == -1) {
            this.option_TextStyle_font_slant = 0;
        }
        if (this.option_TextStyle_font_size == -1) {
            this.option_TextStyle_font_size = 10;
        }
        n7 = 0;
        while (n7 < this.count_primitives) {
            primitive3D = (Primitive3D)this.primitives.elementAt(n7);
            if (primitive3D.text != null) {
                if (primitive3D.font_url == null) {
                    primitive3D.font_url = this.option_TextStyle_font_url;
                }
                if (primitive3D.font == null) {
                    primitive3D.font = this.option_TextStyle_font_family;
                }
                if (primitive3D.font_size == -1) {
                    primitive3D.font_size = this.option_TextStyle_font_size;
                }
                if (primitive3D.font_weight == -1) {
                    primitive3D.font_weight = this.option_TextStyle_font_weight;
                }
                if (primitive3D.font_slant == -1) {
                    primitive3D.font_slant = this.option_TextStyle_font_slant;
                }
                primitive3D.font = new Font((String)primitive3D.font, primitive3D.font_weight | primitive3D.font_slant, primitive3D.font_size);
                graphics.setFont((Font)primitive3D.font);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                primitive3D.font_size = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
                primitive3D.font_weight = fontMetrics.stringWidth(primitive3D.text);
                primitive3D.font_slant = -((int)((double)primitive3D.font_weight * (primitive3D.original_point_size + 1.0) / 2.0));
                primitive3D.font_y_offset = (int)((double)primitive3D.font_size * (primitive3D.original_thickness + 1.0) / 2.0) - fontMetrics.getMaxDescent();
                primitive3D.first_point = primitive3D.font_slant - 2;
                primitive3D.second_point = primitive3D.font_y_offset - fontMetrics.getMaxAscent() - 2;
                primitive3D.third_point = primitive3D.font_weight + 4;
                primitive3D.fourth_point = primitive3D.font_size + 4;
            }
            ++n7;
        }
    }

    public boolean setCoordinateValue(int n, int n2, double d) {
        float f = (float)(this.scalings[n2] * (d - this.original_center[n2]));
        if (n2 == 0) {
            this.xs[n] = f;
        } else if (n2 == 1) {
            this.ys[n] = f;
        } else if (n2 == 2) {
            this.zs[n] = f;
        }
        return true;
    }

    public void set_rotation_from_view_parameters(double[] dArray, double[] dArray2) {
        double d;
        double[] dArray3 = null;
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        if (!(dArray != null && dArray.length >= 3 || (dArray = this.option_ViewPoint) != null && dArray.length >= 3)) {
            dArray = new double[]{1.3, -2.4, 2.0};
        }
        if (!(dArray2 != null && dArray2.length >= 3 || (dArray2 = this.option_ViewVertical) != null && dArray2.length >= 3)) {
            dArray2 = new double[]{0.0, 0.0, 1.0};
        }
        if (!(dArray3 != null && dArray3.length >= 3 || (dArray3 = this.option_BoxRatios) != null && dArray3.length >= 3)) {
            dArray3 = new double[]{1.0, 1.0, 1.0};
        }
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        dArray5[0] = dArray[0] / d2;
        dArray5[1] = dArray[1] / d2;
        dArray5[2] = dArray[2] / d2;
        dArray4[0] = dArray5[1];
        dArray4[1] = -dArray5[0];
        dArray4[2] = 0.0;
        double d3 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if ((d = Math.asin(d3)) < 1.0E-4) {
            this.rotation = dArray[2] > 0.0 ? new Quaternion(0.0, 1.0, 0.0, 0.0, false) : new Quaternion(Math.PI, 1.0, 0.0, 0.0, false);
        } else {
            if (dArray[2] < 0.0) {
                d = Math.PI - d;
            }
            this.rotation = new Quaternion(d, dArray4[0], dArray4[1], dArray4[2], true);
        }
        double[] dArray6 = new double[]{dArray2[0] * dArray3[0], dArray2[1] * dArray3[1], dArray2[2] * dArray3[2]};
        dArray6 = this.rotation.rotated(dArray6);
        d = Math.abs(dArray6[0]) < 1.0E-7 ? (dArray6[1] > 0.0 ? 0.0 : Math.PI) : Math.atan2(dArray6[0], dArray6[1]);
        this.rotation = new Quaternion(d, 0.0, 0.0, 1.0, false).product(this.rotation);
        this.initial_length_view_point = d2;
        this.initial_rotation = this.rotation;
    }

    public int getPointDistance(Primitive3D primitive3D, int n) {
        int n2 = primitive3D.points[n];
        int n3 = primitive3D.points[(n + 1) % primitive3D.count_points];
        return (int)(Math.abs(this.xs[n3] - this.xs[n2]) + Math.abs(this.ys[n3] - this.ys[n2]) + Math.abs(this.zs[n3] - this.zs[n2]));
    }

    public void setPerspective(double d, double d2, boolean bl, double d3) {
        this.length_view_point = d;
        this.magnification = d2;
        this.is_stereo = bl;
        this.stereo_distance = d3;
        if (!bl) {
            this.pixel_width = this.full_pixel_width;
            this.pixel_height = this.full_pixel_height;
        } else {
            this.pixel_width = (this.full_pixel_width + 1) / 2;
            this.pixel_height = this.full_pixel_height;
        }
        double d4 = 0.5 * Math.sqrt(this.option_BoxRatios[0] * this.option_BoxRatios[0] + this.option_BoxRatios[1] * this.option_BoxRatios[1] + this.option_BoxRatios[2] * this.option_BoxRatios[2]);
        if (d < 1.01 * d4) {
            this.length_view_point = d = 1.01 * d4;
        }
        this.eye_distance = d;
        this.height = this.width = 2.0 * Math.sqrt(d * d * d4 * d4 / (d * d - d4 * d4));
        if (this.pixel_width < this.pixel_height) {
            this.height = this.height * (double)this.pixel_height / (double)this.pixel_width;
        } else {
            this.width = this.width * (double)this.pixel_width / (double)this.pixel_height;
        }
        this.eye_distance /= d2;
        this.width /= d2;
        this.height /= d2;
        this.stereo_offset = d3 / 2.0 * d4 * 2.0;
    }

    public void setCutPrimitivesCount(int n, int n2, boolean bl) {
        this.min_primitive_index = 0;
        this.max_primitive_index = this.count_primitives - n - 1;
        this.visible_faces = n > 0 ? 3 : n2;
        this.show_faces = bl;
    }

    public void paint(Graphics graphics, Graphics graphics2, Image image) {
        if (!this.is_stereo) {
            this.paintPrimitives(graphics, this.left_pixel_xs);
        } else {
            this.paintPrimitives(graphics, this.left_pixel_xs);
            this.paintPrimitives(graphics2, this.right_pixel_xs);
            graphics.drawImage(image, this.pixel_width, 0, null);
        }
    }

    public void paintPrimitives(Graphics graphics, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.count_ordered_primitives) {
            int n3 = this.order[n2];
            if (this.min_primitive_index <= n3 && n3 <= this.max_primitive_index) {
                Primitive3D primitive3D;
                Primitive3D primitive3D2 = primitive3D = (Primitive3D)this.primitives.elementAt(n3);
                n = -1;
                while (primitive3D != null) {
                    int n4;
                    int n5;
                    int n6;
                    boolean bl = true;
                    int n7 = primitive3D.count_points;
                    if (primitive3D.text != null) {
                        if (primitive3D.count_points == 0) {
                            if (primitive3D.back_color != null) {
                                graphics.setColor(primitive3D.back_color);
                                graphics.fillRect(this.pixel_width / 2 + primitive3D.first_point, 2 + primitive3D.second_point, primitive3D.third_point, primitive3D.fourth_point);
                            }
                            graphics.setColor(primitive3D.front_color);
                            graphics.setFont((Font)primitive3D.font);
                            graphics.drawString(primitive3D.text, this.pixel_width / 2 + primitive3D.font_slant, 2 + primitive3D.font_y_offset);
                        } else {
                            n6 = primitive3D.points[0];
                            if (this.point_scale[n6] != 0.0f) {
                                if (primitive3D.back_color != null) {
                                    graphics.setColor(primitive3D.back_color);
                                    graphics.fillRect(nArray[n6] + primitive3D.first_point, this.pixel_ys[n6] + primitive3D.second_point, primitive3D.third_point, primitive3D.fourth_point);
                                }
                                graphics.setColor(primitive3D.front_color);
                                graphics.setFont((Font)primitive3D.font);
                                graphics.drawString(primitive3D.text, nArray[n6] + primitive3D.font_slant, this.pixel_ys[n6] + primitive3D.font_y_offset);
                            }
                        }
                    } else if (n7 == 1) {
                        n5 = primitive3D.points[0];
                        if (this.point_scale[n5] != 0.0f) {
                            graphics.setColor(primitive3D.standard_color);
                            n4 = primitive3D.is_absolute_point_size ? primitive3D.point_diameter : (int)((float)primitive3D.point_diameter / this.point_scale[n5]);
                            if (n4 > 1) {
                                int n8 = n4 / 2;
                                graphics.fillOval(nArray[n5] - n8, this.pixel_ys[n5] - n8, n4, n4);
                                if (this.point_edge_color != null) {
                                    graphics.setColor(this.point_edge_color);
                                    graphics.drawOval(nArray[n5] - n8, this.pixel_ys[n5] - n8, n4, n4);
                                }
                            } else {
                                if (this.point_edge_color != null) {
                                    graphics.setColor(this.point_edge_color);
                                }
                                graphics.drawLine(nArray[n5], this.pixel_ys[n5], nArray[n5], this.pixel_ys[n5]);
                            }
                        }
                    } else if (n7 > 1) {
                        n6 = 0;
                        while (n6 < n7) {
                            n5 = primitive3D.points[n6];
                            if (this.point_scale[n5] == 0.0f) break;
                            this.temp_xs[n6] = nArray[n5];
                            this.temp_ys[n6] = this.pixel_ys[n5];
                            ++n6;
                        }
                        if (n6 >= n7) {
                            int n9;
                            boolean bl2 = true;
                            if (primitive3D.is_filled && n7 > 2) {
                                n9 = (nArray[primitive3D.second_point] - nArray[primitive3D.first_point]) * (this.pixel_ys[primitive3D.fourth_point] - this.pixel_ys[primitive3D.second_point]) - (nArray[primitive3D.fourth_point] - nArray[primitive3D.second_point]) * (this.pixel_ys[primitive3D.second_point] - this.pixel_ys[primitive3D.first_point]);
                                if (n9 == 0) {
                                    n9 = primitive3D.last_z_coordinate;
                                } else {
                                    primitive3D.last_z_coordinate = n9;
                                }
                                if (n9 <= 0) {
                                    if ((this.visible_faces & 1) == 1) {
                                        graphics.setColor(primitive3D.front_color);
                                    } else {
                                        bl = false;
                                    }
                                } else if (n9 > 0) {
                                    if ((this.visible_faces & 2) == 2) {
                                        graphics.setColor(primitive3D.back_color);
                                    } else {
                                        bl = false;
                                    }
                                }
                                if (bl) {
                                    if (this.show_faces) {
                                        graphics.fillPolygon(this.temp_xs, this.temp_ys, n7);
                                    }
                                    if (primitive3D.is_outlined) {
                                        this.temp_xs[n7] = this.temp_xs[0];
                                        this.temp_ys[n7] = this.temp_ys[0];
                                        primitive3D.points[n7] = primitive3D.points[0];
                                        ++n7;
                                        graphics.setColor(primitive3D.edge_color);
                                        bl2 = primitive3D.is_absolute_edge_thickness;
                                    }
                                }
                            } else if (!primitive3D.is_filled) {
                                graphics.setColor(primitive3D.standard_color);
                                bl2 = primitive3D.is_absolute_thickness;
                            }
                            if (!primitive3D.is_filled || bl && primitive3D.is_outlined && n7 > 3) {
                                int n10;
                                int n11;
                                int n12;
                                if (bl2 && primitive3D.point_diameter < 2) {
                                    if (primitive3D.edge_flags == null && (primitive3D.is_filled || n7 <= 2)) {
                                        graphics.drawPolygon(this.temp_xs, this.temp_ys, n7);
                                    } else {
                                        n9 = this.temp_xs[0];
                                        n12 = this.temp_ys[0];
                                        if (primitive3D.edge_flags == null) {
                                            n6 = 1;
                                            while (n6 < n7) {
                                                n11 = this.temp_xs[n6];
                                                n10 = this.temp_ys[n6];
                                                graphics.drawLine(n9, n12, n11, n10);
                                                n9 = n11;
                                                n12 = n10;
                                                ++n6;
                                            }
                                        } else {
                                            n6 = 1;
                                            while (n6 < n7) {
                                                n11 = this.temp_xs[n6];
                                                n10 = this.temp_ys[n6];
                                                if (primitive3D.edge_flags[n6 - 1]) {
                                                    graphics.drawLine(n9, n12, n11, n10);
                                                }
                                                n9 = n11;
                                                n12 = n10;
                                                ++n6;
                                            }
                                        }
                                    }
                                } else {
                                    n4 = primitive3D.point_diameter;
                                    n12 = !bl2 ? (int)((float)n4 / this.point_scale[primitive3D.points[0]]) : n4;
                                    n10 = --n12 / 2;
                                    int n13 = this.temp_xs[0] - n10;
                                    int n14 = this.temp_ys[0] - n10;
                                    n6 = 1;
                                    while (n6 < n7) {
                                        n9 = 0;
                                        n11 = !bl2 ? (int)((float)n4 / this.point_scale[primitive3D.points[n6]]) : n4;
                                        int n15 = --n11 / 2;
                                        int n16 = this.temp_xs[n6] - n15;
                                        int n17 = this.temp_ys[n6] - n15;
                                        if (primitive3D.edge_flags == null || primitive3D.edge_flags[n6 - 1]) {
                                            graphics.drawLine(n13, n14, n16, n17);
                                            if (n12 > 0 || n11 > 0) {
                                                if (n12 <= 0) {
                                                    this.temp_line_xs[0] = n13;
                                                    this.temp_line_ys[0] = n14;
                                                    n9 = 1;
                                                }
                                                if (n14 < n17) {
                                                    if (n13 < n16) {
                                                        if (n12 > 0) {
                                                            this.temp_line_xs[0] = n13;
                                                            this.temp_line_ys[0] = n14 + n12;
                                                            this.temp_line_xs[1] = n13;
                                                            this.temp_line_ys[1] = n14;
                                                            this.temp_line_xs[2] = n13 + n12;
                                                            this.temp_line_ys[2] = n14;
                                                            n9 = 3;
                                                        }
                                                        if (n11 > 0) {
                                                            this.temp_line_xs[n9] = n16 + n11;
                                                            this.temp_line_ys[n9] = n17;
                                                            this.temp_line_xs[n9 + 1] = n16 + n11;
                                                            this.temp_line_ys[n9 + 1] = n17 + n11;
                                                            this.temp_line_xs[n9 + 2] = n16;
                                                            this.temp_line_ys[n9 + 2] = n17 + n11;
                                                            n9 += 3;
                                                        }
                                                    } else {
                                                        if (n12 > 0) {
                                                            this.temp_line_xs[0] = n13;
                                                            this.temp_line_ys[0] = n14;
                                                            this.temp_line_xs[1] = n13 + n12;
                                                            this.temp_line_ys[1] = n14;
                                                            this.temp_line_xs[2] = n13 + n12;
                                                            this.temp_line_ys[2] = n14 + n12;
                                                            n9 = 3;
                                                        }
                                                        if (n11 > 0) {
                                                            this.temp_line_xs[n9] = n16 + n11;
                                                            this.temp_line_ys[n9] = n17 + n11;
                                                            this.temp_line_xs[n9 + 1] = n16;
                                                            this.temp_line_ys[n9 + 1] = n17 + n11;
                                                            this.temp_line_xs[n9 + 2] = n16;
                                                            this.temp_line_ys[n9 + 2] = n17;
                                                            n9 += 3;
                                                        }
                                                    }
                                                } else if (n13 > n16) {
                                                    if (n12 > 0) {
                                                        this.temp_line_xs[0] = n13 + n12;
                                                        this.temp_line_ys[0] = n14;
                                                        this.temp_line_xs[1] = n13 + n12;
                                                        this.temp_line_ys[1] = n14 + n12;
                                                        this.temp_line_xs[2] = n13;
                                                        this.temp_line_ys[2] = n14 + n12;
                                                        n9 = 3;
                                                    }
                                                    if (n11 > 0) {
                                                        this.temp_line_xs[n9] = n16;
                                                        this.temp_line_ys[n9] = n17 + n11;
                                                        this.temp_line_xs[n9 + 1] = n16;
                                                        this.temp_line_ys[n9 + 1] = n17;
                                                        this.temp_line_xs[n9 + 2] = n16 + n11;
                                                        this.temp_line_ys[n9 + 2] = n17;
                                                        n9 += 3;
                                                    }
                                                } else {
                                                    if (n12 > 0) {
                                                        this.temp_line_xs[0] = n13 + n12;
                                                        this.temp_line_ys[0] = n14 + n12;
                                                        this.temp_line_xs[1] = n13;
                                                        this.temp_line_ys[1] = n14 + n12;
                                                        this.temp_line_xs[2] = n13;
                                                        this.temp_line_ys[2] = n14;
                                                        n9 = 3;
                                                    }
                                                    if (n11 > 0) {
                                                        this.temp_line_xs[n9] = n16;
                                                        this.temp_line_ys[n9] = n17;
                                                        this.temp_line_xs[n9 + 1] = n16 + n11;
                                                        this.temp_line_ys[n9 + 1] = n17;
                                                        this.temp_line_xs[n9 + 2] = n16 + n11;
                                                        this.temp_line_ys[n9 + 2] = n17 + n11;
                                                        n9 += 3;
                                                    }
                                                }
                                                if (n11 <= 0) {
                                                    this.temp_line_xs[n9] = n16;
                                                    this.temp_line_ys[n9] = n17;
                                                    ++n9;
                                                }
                                                graphics.fillPolygon(this.temp_line_xs, this.temp_line_ys, n9);
                                            }
                                        }
                                        n12 = n11;
                                        n10 = n15;
                                        n13 = n16;
                                        n14 = n17;
                                        ++n6;
                                    }
                                }
                            }
                        }
                    }
                    primitive3D = !bl || !primitive3D2.is_filled || primitive3D2.edge_primitives == null || primitive3D2.edge_primitives.size() <= n + 1 ? null : (Primitive3D)primitive3D2.edge_primitives.elementAt(++n);
                }
            }
            ++n2;
        }
    }
}

