/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Live
extends Applet
implements Runnable {
    Evaluator evaluator;
    Graphics3D ps3D;
    Graphics3D painted_ps3D;
    Vector frames;
    int frames_count = 0;
    int current_frame_index;
    double animation_display_time = 0.05;
    int animation_direction = 1;
    double animate_min = 0.0;
    double animate_max = 0.0;
    double animate_step = 1.0;
    int animate_variable_index = -1;
    double animate_variable_value = 0.0;
    double valid_animate_variable_value = 0.0;
    boolean is_new_animate_frame = true;
    long painted_time;
    boolean is_animating = true;
    boolean is_spinning = false;
    double spin_x = 0.0;
    double spin_y = 0.0;
    Thread painter = null;
    Image image_buffer;
    Graphics graphics_buffer;
    Image second_image_buffer;
    Graphics second_graphics_buffer;
    Image preload_bg_image;
    Image bg_image;
    Image bg_rotated_image;
    Image bg_right_image;
    Image bg_rotated_right_image;
    int bg_width;
    int bg_height;
    boolean bg_is_fixed;
    boolean bg_is_cylindrical;
    boolean bg_is_spherical;
    Color background_color;
    Color foreground_color;
    Color point_edge_color;
    boolean is_put_on_screen = true;
    int min_height_width = 100;
    Primitive3D active_primitive = null;
    Primitive3D dragged_point = null;
    int text_x = 10;
    int text_y = 0;
    int applet_width;
    int applet_height;
    boolean is_dragging;
    boolean is_dragging_point;
    int visible_faces;
    boolean show_faces;
    int mouse_drag_action;
    AudioClip audio_enter;
    AudioClip audio_loop_enter;
    AudioClip audio_first_frame;
    static String empty_string = "";
    static String enter_plain_string = "LiveGraphics3D 1.00";
    static String enter_drag_string = "LiveGraphics3D 1.00: Please drag to rotate.";
    static String enter_drag_animated_string = "LiveGraphics3D 1.00: Drag to rotate; double click to stop/restart.";
    static String enter_animated_string = "LiveGraphics3D 1.00: Please double click to stop/restart.";
    static String enter_init_string = "Initializing LiveGraphics3D 1.00. Please wait.";
    static String syntax_error_string = "LiveGraphics3D applet stopped because of a syntax error.";
    static String url_error_string = "Malformed URL: ";
    static String target_string = "target=";
    int down_mouse_x;
    int down_mouse_y;
    double down_mouse_point_x;
    double down_mouse_point_y;
    double down_mouse_point_z;
    long down_time;
    double last_x;
    double last_y;
    long last_drag_time;
    double llast_x;
    double llast_y;
    long llast_drag_time;
    boolean is_control_down;
    boolean is_meta_down;
    boolean is_shift_down;
    boolean is_mouse_here;
    double length_view_point_factor;
    double magnification_factor;
    int cut_primitives_count;
    Quaternion rotation;
    int bg_x_offset;
    int bg_y_offset;
    boolean is_stereo;
    double stereo_distance;
    double preceding_length_view_point_factor;
    double preceding_magnification_factor;
    int preceding_cut_primitives_count;
    Quaternion preceding_rotation;
    int preceding_bg_x_offset;
    int preceding_bg_y_offset;
    double preceding_stereo_distance;
    int preceding_frame_index;
    Quaternion home_rotation;
    int home_bg_x_offset;
    int home_bg_y_offset;
    double home_magnification_factor;
    boolean home_is_stereo;
    double home_stereo_distance;
    int home_cut_primitives_count;
    boolean is_new_dragging;
    boolean is_home_event;
    boolean initialized;
    boolean is_stopped;
    static String double_chars = ".+-0123456789eE";

    public void init() {
        this.is_stopped = false;
    }

    public void initialize() {
        if (!this.initialized) {
            int n;
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            String string2;
            String string3;
            String string4;
            String string5;
            Object object6;
            block95: {
                Object object7;
                System.out.println("LiveGraphics3D 1.00 by Martin_Kraus_Germany@yahoo.com");
                this.text_y = 0;
                InputStream inputStream = this.getClass().getResourceAsStream("liveinit.gif");
                Image image = null;
                if (inputStream != null) {
                    object7 = Toolkit.getDefaultToolkit();
                    try {
                        int n3 = 4000;
                        object6 = new byte[n3];
                        inputStream.read((byte[])object6, 0, n3);
                        image = ((Toolkit)object7).createImage((byte[])object6);
                        object6 = null;
                    }
                    catch (IOException iOException) {}
                    if (image != null) {
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(image, 0);
                        try {
                            mediaTracker.waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                        mediaTracker = null;
                    }
                }
                if ((object7 = this.getParameter("BGCOLOR")) != null) {
                    if (((String)(object7 = ((String)object7).trim())).charAt(0) == '#') {
                        object7 = ((String)object7).substring(1);
                    }
                    this.background_color = new Color(Integer.parseInt((String)object7, 16));
                    this.foreground_color = this.background_color.getRed() + this.background_color.getBlue() + this.background_color.getGreen() > 384 ? Color.black : Color.white;
                } else {
                    this.background_color = Color.white;
                    this.foreground_color = Color.black;
                }
                this.set_applet_size();
                this.image_buffer = this.createImage(this.applet_width, this.applet_height);
                this.graphics_buffer = this.image_buffer.getGraphics();
                this.graphics_buffer.setFont(new Font("Dialog", 0, 10));
                if (image == null) {
                    this.graphics_buffer.setColor(this.background_color);
                    this.graphics_buffer.fillRect(0, 0, this.applet_width, this.applet_height);
                    this.print_message(this.graphics_buffer, "LiveGraphics3D 1.00", false);
                    this.print_message(this.graphics_buffer, "Initializing. Please wait.", false);
                } else {
                    this.graphics_buffer.setColor(Color.white);
                    this.graphics_buffer.fillRect(0, 0, this.applet_width, this.applet_height);
                    this.graphics_buffer.drawImage(image, (this.applet_width - image.getWidth(null)) / 2, (this.applet_height - image.getHeight(null)) / 2, null);
                    image = null;
                }
                this.is_put_on_screen = false;
                this.repaint();
                String string6 = this.getParameter("PRELOAD_BACKGROUND");
                if (string6 != null) {
                    try {
                        this.preload_bg_image = this.getImage(new URL(this.getDocumentBase(), string6));
                        if (this.preload_bg_image == null) break block95;
                        object6 = new MediaTracker(this);
                        ((MediaTracker)object6).addImage(this.preload_bg_image, 0);
                        try {
                            ((MediaTracker)object6).waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                        object6 = null;
                        this.graphics_buffer.drawImage(this.preload_bg_image, 0, 0, this.applet_width, this.applet_height, null);
                        this.repaint();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            if ((object6 = (Object)this.getParameter("AUDIO_ENTER")) != null) {
                this.audio_enter = this.getAudioClip(this.getDocumentBase(), (String)object6);
            }
            if ((string5 = this.getParameter("AUDIO_LOOP_ENTER")) != null) {
                this.audio_loop_enter = this.getAudioClip(this.getDocumentBase(), string5);
            }
            if ((string4 = this.getParameter("AUDIO_FIRST_FRAME")) != null) {
                this.audio_first_frame = this.getAudioClip(this.getDocumentBase(), string4);
            }
            if ((string3 = this.getParameter("POINT_EDGE_COLOR")) != null) {
                if ((string3 = string3.trim()).charAt(0) == '#') {
                    string3 = string3.substring(1);
                }
                this.point_edge_color = new Color(Integer.parseInt(string3, 16));
            } else {
                this.point_edge_color = null;
            }
            double d = 0.0;
            double d2 = 0.0;
            String string7 = this.getParameter("INITIAL_ROTATION");
            if (string7 != null && !Character.isDigit(string7.charAt(0)) && string7.charAt(0) != '-') {
                string2 = this.getDocumentBase().getRef();
                string7 = string7.concat("=");
                string7 = string2 == null || (n2 = string2.indexOf(string7)) < 0 ? null : string2.substring(n2 + string7.length());
            }
            if (string7 != null) {
                n2 = string7.indexOf(",");
                d = n2 < 0 ? this.get_double_value(string7) : this.get_double_value(string7.substring(0, n2));
                if (n2 > 0) {
                    d2 = this.get_double_value(string7.substring(n2 + 1));
                }
            }
            string2 = this.getParameter("SPIN_X");
            this.spin_x = 0.0;
            if (string2 != null) {
                this.spin_x = this.get_double_value(string2);
            }
            String string8 = this.getParameter("SPIN_Y");
            this.spin_y = 0.0;
            if (string8 != null) {
                this.spin_y = this.get_double_value(string8);
            }
            if (this.spin_x != 0.0 || this.spin_y != 0.0) {
                this.is_spinning = true;
            }
            String string9 = this.getParameter("VISIBLE_FACES");
            this.visible_faces = 3;
            if (string9 != null) {
                if (string9.equalsIgnoreCase("FRONT")) {
                    this.visible_faces = 1;
                } else if (string9.equalsIgnoreCase("BACK")) {
                    this.visible_faces = 2;
                }
            }
            String string10 = this.getParameter("MOUSE_DRAG_ACTION");
            this.mouse_drag_action = 1;
            if (string10 != null && string10.equalsIgnoreCase("NONE")) {
                this.mouse_drag_action = 0;
            }
            String string11 = this.getParameter("INDEPENDENT_VARIABLES");
            this.evaluator = null;
            if (string11 != null) {
                this.evaluator = new Evaluator();
                object5 = new Parser(string11, this.evaluator);
                if (!((Parser)object5).scan_independent_variables()) {
                    this.print_message(this.graphics_buffer, "LiveGraphics3D error in INDEPENDENT_VARIABLES.");
                    this.print_syntax_error(this.graphics_buffer, (Parser)object5);
                    this.evaluator = null;
                    this.repaint();
                }
                object5 = null;
            }
            if ((object5 = this.getParameter("DEPENDENT_VARIABLES")) != null) {
                if (this.evaluator == null) {
                    this.evaluator = new Evaluator();
                }
                if (!((Parser)(object4 = new Parser((String)object5, this.evaluator))).scan_dependent_variables()) {
                    this.print_message(this.graphics_buffer, "LiveGraphics3D error in DEPENDENT_VARIABLES.");
                    this.print_syntax_error(this.graphics_buffer, (Parser)object4);
                    this.evaluator = null;
                    this.repaint();
                } else {
                    this.evaluator.prepareVariables();
                    if (!this.evaluator.evaluate()) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D evaluation error in DEPENDENT_VARIABLES.");
                        this.print_syntax_error(this.graphics_buffer, (Parser)object4);
                        this.evaluator = null;
                        this.repaint();
                    }
                }
                object4 = null;
            } else if (this.evaluator != null) {
                this.evaluator.prepareVariables();
            }
            object4 = this.getParameter("INPUT");
            if (object4 == null) {
                object3 = this.getParameter("INPUT_ARCHIVE");
                string = this.getParameter("INPUT_FILE");
                if (string != null) {
                    try {
                        object2 = null;
                        if (object3 != null) {
                            try {
                                ZipInputStream zipInputStream = new ZipInputStream(new URL(this.getDocumentBase(), (String)object3).openStream());
                                object = null;
                                object = zipInputStream.getNextEntry();
                                while (object != null && !string.equals(((ZipEntry)object).getName())) {
                                    object = zipInputStream.getNextEntry();
                                }
                                if (object != null) {
                                    object2 = zipInputStream;
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        if (object2 == null) {
                            object2 = new URL(this.getDocumentBase(), string).openStream();
                        }
                        int n4 = 20000;
                        object = new byte[n4];
                        n = n4;
                        StringBuffer stringBuffer = new StringBuffer();
                        while (n > -1) {
                            n = ((InputStream)object2).read((byte[])object, 0, n4);
                            if (n <= -1) continue;
                            stringBuffer.append(new String((byte[])object, 0, 0, n));
                        }
                        object = null;
                        object4 = stringBuffer.toString();
                        stringBuffer = null;
                    }
                    catch (IOException iOException) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D error:");
                        this.print_message(this.graphics_buffer, "Can't read " + string);
                    }
                }
            }
            object3 = new Parser((String)object4, this.evaluator);
            if (((Parser)object3).text != null && ((Parser)object3).scan_animation() && ((Parser)object3).scanned_frames != null && ((Parser)object3).scanned_frames.size() > 0) {
                String string12;
                this.frames = ((Parser)object3).scanned_frames;
                this.animation_display_time = ((Parser)object3).scanned_AnimationDisplayTime;
                this.animation_direction = ((Parser)object3).scanned_AnimationDirection;
                this.valid_animate_variable_value = this.animate_variable_value = (this.animate_min = ((Parser)object3).scanned_Animate_min);
                this.is_new_animate_frame = true;
                this.animate_max = ((Parser)object3).scanned_Animate_max;
                this.animate_step = ((Parser)object3).scanned_Animate_step;
                this.animate_variable_index = ((Parser)object3).scanned_Animate_variable;
                if (this.frames.size() > 1 || this.animate_variable_index < 0 || this.evaluator == null) {
                    this.frames_count = this.frames.size();
                    this.animate_variable_index = -1;
                } else {
                    this.frames_count = (int)Math.floor(1.000000000001 + (this.animate_max - this.animate_min) / this.animate_step);
                    if (this.frames_count < 1) {
                        this.frames_count = 1;
                    }
                }
                if (this.frames_count <= 1) {
                    this.is_animating = false;
                }
                if (this.evaluator != null && this.animate_variable_index >= 0) {
                    this.valid_animate_variable_value = this.evaluator.getVariableValue(this.animate_variable_index);
                }
                object3 = null;
                string = this.getParameter("BACKGROUND");
                this.bg_is_fixed = false;
                this.bg_is_cylindrical = false;
                this.bg_is_spherical = false;
                if (string != null) {
                    this.bg_is_fixed = true;
                } else {
                    string = this.getParameter("CYLINDRICAL_BACKGROUND");
                    if (string != null) {
                        this.bg_is_cylindrical = true;
                    } else {
                        string = this.getParameter("SPHERICAL_BACKGROUND");
                        if (string != null) {
                            this.bg_is_spherical = true;
                        }
                    }
                }
                this.bg_image = null;
                this.bg_right_image = null;
                object2 = null;
                if (string != null) {
                    object2 = new MediaTracker(this);
                    try {
                        this.bg_image = this.getImage(new URL(this.getDocumentBase(), string));
                        if (this.bg_image != null) {
                            ((MediaTracker)object2).addImage(this.bg_image, 0);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.print_message(this.graphics_buffer, "LiveGraphics3D error:");
                        this.print_message(this.graphics_buffer, "bad URL " + string);
                        this.bg_image = null;
                        object2 = null;
                        this.bg_is_fixed = false;
                        this.bg_is_cylindrical = false;
                        this.bg_is_spherical = false;
                    }
                }
                if (this.bg_image != null && (string = this.getParameter("RIGHT_BACKGROUND")) != null) {
                    try {
                        this.bg_right_image = this.getImage(new URL(this.getDocumentBase(), string));
                        if (this.bg_right_image != null) {
                            ((MediaTracker)object2).addImage(this.bg_right_image, 0);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                if ((string12 = this.getParameter("MAGNIFICATION")) != null) {
                    this.magnification_factor = Math.abs(this.get_double_value(string12));
                    if (this.magnification_factor == 0.0) {
                        this.magnification_factor = 1.0;
                    }
                } else {
                    this.magnification_factor = 1.0;
                }
                this.preceding_magnification_factor = this.magnification_factor;
                object = this.getParameter("STEREO_DISTANCE");
                if (object != null) {
                    this.is_stereo = true;
                    this.stereo_distance = this.get_double_value((String)object);
                } else {
                    this.stereo_distance = 0.05;
                    this.is_stereo = false;
                }
                this.preceding_stereo_distance = this.stereo_distance;
                n = 0;
                while (n < this.frames.size()) {
                    this.ps3D = (Graphics3D)this.frames.elementAt(n);
                    this.ps3D.setGlobalParameters(this.applet_width, this.applet_height, this.background_color, this.point_edge_color);
                    this.ps3D.preparePrimitives(this.graphics_buffer, this.evaluator);
                    ++n;
                }
                this.current_frame_index = 0;
                if (this.bg_image != null) {
                    if (object2 != null) {
                        try {
                            ((MediaTracker)object2).waitForAll();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.bg_width = this.bg_image.getWidth(null);
                    this.bg_height = this.bg_image.getHeight(null);
                    if (this.bg_width < this.applet_width || this.bg_height < this.applet_height) {
                        this.bg_is_fixed = true;
                        this.bg_is_cylindrical = false;
                        this.bg_is_spherical = false;
                    }
                    this.bg_x_offset = 0;
                    this.bg_y_offset = 0;
                    if (this.bg_is_spherical) {
                        this.bg_x_offset = (int)(-d * (double)this.bg_width / 2.0 / 180.0);
                        this.bg_y_offset = (int)(-d2 * (double)this.bg_height / 180.0);
                        this.bg_rotated_image = this.createRotatedImage(this.bg_image);
                        if (this.bg_right_image != null) {
                            this.bg_rotated_right_image = this.createRotatedImage(this.bg_right_image);
                        }
                    } else if (this.bg_is_cylindrical) {
                        this.bg_x_offset = (int)(-d * (double)this.bg_width / 2.0 / 180.0);
                        this.bg_y_offset = (int)(-d2 * (double)this.bg_width / 2.0 / 180.0);
                    }
                    if (this.bg_is_cylindrical || this.bg_is_spherical) {
                        this.rotation = this.adjust_bg_offsets();
                    }
                    if (this.bg_right_image == null) {
                        this.bg_right_image = this.bg_image;
                        this.bg_rotated_right_image = this.bg_rotated_image;
                    }
                }
                object2 = null;
                if (!this.bg_is_cylindrical && !this.bg_is_spherical) {
                    this.rotation = new Quaternion(d2 * Math.PI / 180.0, 1.0, 0.0, 0.0, false);
                    this.rotation.multiply(new Quaternion(d * Math.PI / 180.0, 0.0, 1.0, 0.0, false));
                }
                this.preceding_rotation = this.rotation;
                this.ps3D = (Graphics3D)this.frames.elementAt(this.current_frame_index);
                this.ps3D.setPerspective(this.ps3D.initial_length_view_point, this.ps3D.initial_magnification * this.magnification_factor, this.is_stereo, this.stereo_distance);
                this.ps3D.setCutPrimitivesCount(this.cut_primitives_count, this.visible_faces, this.show_faces);
                this.ps3D.setQuaternion(this.rotation.product(this.ps3D.initial_rotation));
                this.ps3D.projectPoints(false);
                this.home_rotation = this.rotation;
                this.home_bg_x_offset = this.bg_x_offset;
                this.home_bg_y_offset = this.bg_y_offset;
                this.home_magnification_factor = this.magnification_factor;
                this.home_is_stereo = this.is_stereo;
                this.home_stereo_distance = this.stereo_distance;
                this.home_cut_primitives_count = this.cut_primitives_count;
                this.is_put_on_screen = false;
                this.paintGraphics3D();
            } else {
                if (((Parser)object3).text == null) {
                    this.print_message(this.graphics_buffer, "LiveGraphics3D error: applet parameter");
                    this.print_message(this.graphics_buffer, "\"INPUT\" or \"INPUT_FILE\" missing.");
                } else {
                    this.print_syntax_error(this.graphics_buffer, (Parser)object3);
                }
                this.ps3D = null;
            }
            object3 = null;
            this.preload_bg_image = null;
            System.gc();
        }
        if (this.ps3D == null) {
            this.print_message(this.graphics_buffer, "LiveGraphics3D aborted.", false);
            this.repaint();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public double getVersionNumber() {
        return 0.6;
    }

    public boolean setGraphics3D(String string) {
        Parser parser = new Parser(string, this.evaluator);
        this.initialized = false;
        this.text_y = 0;
        if (parser.text != null && parser.scan_animation() && parser.scanned_frames != null && parser.scanned_frames.size() > 0) {
            this.frames = parser.scanned_frames;
            this.animation_display_time = parser.scanned_AnimationDisplayTime;
            this.animation_direction = parser.scanned_AnimationDirection;
            this.valid_animate_variable_value = this.animate_variable_value = (this.animate_min = parser.scanned_Animate_min);
            this.is_new_animate_frame = true;
            this.animate_max = parser.scanned_Animate_max;
            this.animate_step = parser.scanned_Animate_step;
            this.animate_variable_index = parser.scanned_Animate_variable;
            if (this.frames.size() > 1 || this.animate_variable_index < 0 || this.evaluator == null) {
                this.frames_count = this.frames.size();
                this.animate_variable_index = -1;
            } else {
                this.frames_count = (int)Math.floor(1.000000000001 + (this.animate_max - this.animate_min) / this.animate_step);
                if (this.frames_count < 1) {
                    this.frames_count = 1;
                }
            }
            if (this.frames_count <= 1) {
                this.is_animating = false;
            }
            if (this.evaluator != null && this.animate_variable_index >= 0) {
                this.valid_animate_variable_value = this.evaluator.getVariableValue(this.animate_variable_index);
            }
            parser = null;
            int n = 0;
            while (n < this.frames.size()) {
                this.ps3D = (Graphics3D)this.frames.elementAt(n);
                this.ps3D.setGlobalParameters(this.applet_width, this.applet_height, this.background_color, this.point_edge_color);
                this.ps3D.preparePrimitives(this.graphics_buffer, this.evaluator);
                ++n;
            }
            this.current_frame_index = 0;
            this.ps3D = (Graphics3D)this.frames.elementAt(this.current_frame_index);
            this.ps3D.setPerspective(this.ps3D.initial_length_view_point, this.ps3D.initial_magnification * this.magnification_factor, this.is_stereo, this.stereo_distance);
            this.ps3D.setCutPrimitivesCount(this.cut_primitives_count, this.visible_faces, this.show_faces);
            this.ps3D.setQuaternion(this.rotation.product(this.ps3D.initial_rotation));
            this.ps3D.projectPoints(false);
            this.is_put_on_screen = false;
            this.paintGraphics3D();
            System.gc();
            this.initialized = true;
            return true;
        }
        if (parser.text == null) {
            this.print_message(this.graphics_buffer, "LiveGraphics3D error: not enough memory");
        } else {
            this.print_syntax_error(this.graphics_buffer, parser);
        }
        this.ps3D = null;
        parser = null;
        this.preload_bg_image = null;
        System.gc();
        this.is_put_on_screen = false;
        this.repaint();
        this.initialized = true;
        return false;
    }

    public boolean setMagnification(double d) {
        if (d > 0.0) {
            this.magnification_factor = d;
            this.is_new_dragging = true;
            return true;
        }
        return false;
    }

    public double getMagnification() {
        return this.magnification_factor;
    }

    public boolean setStereoDistance(double d) {
        this.is_stereo = d != 0.0;
        this.stereo_distance = d;
        this.is_new_dragging = true;
        return true;
    }

    public double getStereoDistance() {
        if (this.is_stereo) {
            return this.stereo_distance;
        }
        return 0.0;
    }

    public boolean setStrippedPrimitives(int n) {
        this.cut_primitives_count = n;
        this.is_new_dragging = true;
        return true;
    }

    public int getStrippedPrimitives() {
        return this.cut_primitives_count;
    }

    public boolean setSpin(double d, double d2) {
        this.spin_x = d;
        this.spin_y = d2;
        this.is_spinning = this.spin_x != 0.0 || this.spin_y != 0.0;
        this.is_new_dragging = true;
        return true;
    }

    public double getSpinX() {
        return this.spin_x;
    }

    public double getSpinY() {
        return this.spin_y;
    }

    public boolean setViewPointAndViewVertical(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.ps3D == null) {
            return false;
        }
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{d4, d5, d6};
        this.ps3D.set_rotation_from_view_parameters(dArray, dArray2);
        this.rotation = new Quaternion(0.0, 1.0, 0.0, 0.0, false);
        this.is_new_dragging = true;
        return true;
    }

    public double getViewPointX() {
        double[] dArray = new double[3];
        dArray[2] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return 1.3;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[0] * this.painted_ps3D.length_view_point;
    }

    public double getViewPointY() {
        double[] dArray = new double[3];
        dArray[2] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return -2.4;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[1] * this.painted_ps3D.length_view_point;
    }

    public double getViewPointZ() {
        double[] dArray = new double[3];
        dArray[2] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return 2.0;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[2] * this.painted_ps3D.length_view_point;
    }

    public double getViewVerticalX() {
        double[] dArray = new double[3];
        dArray[1] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return 0.0;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[0] / this.painted_ps3D.option_BoxRatios[0];
    }

    public double getViewVerticalY() {
        double[] dArray = new double[3];
        dArray[1] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return 0.0;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[1] / this.painted_ps3D.option_BoxRatios[1];
    }

    public double getViewVerticalZ() {
        double[] dArray = new double[3];
        dArray[1] = 1.0;
        double[] dArray2 = dArray;
        if (this.painted_ps3D == null) {
            return 1.0;
        }
        double[] dArray3 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
        return dArray3[2] / this.painted_ps3D.option_BoxRatios[2];
    }

    void setFrameInternal(int n) {
        if (n < 0 || n >= this.frames_count) {
            return;
        }
        if (this.frames.size() > 1) {
            this.ps3D = (Graphics3D)this.frames.elementAt(n);
        } else {
            this.ps3D = (Graphics3D)this.frames.elementAt(0);
            if (this.animate_variable_index > -1) {
                this.animate_variable_value = this.animate_min + (double)n * this.animate_step;
                this.is_new_animate_frame = true;
                if (this.evaluator != null) {
                    this.evaluator.setVariableValue(this.animate_variable_index, this.animate_variable_value);
                }
            }
        }
    }

    public boolean setFrame(int n) {
        if (n < 0 || n >= this.frames_count) {
            return false;
        }
        this.current_frame_index = n;
        this.setFrameInternal(this.current_frame_index);
        this.is_new_dragging = true;
        return true;
    }

    public int getFrame() {
        return this.current_frame_index;
    }

    public double get_double_value(String string) {
        double d;
        int n = 0;
        while (n < string.length() && double_chars.indexOf(string.charAt(n)) < 0) {
            ++n;
        }
        if (n >= string.length()) {
            return 0.0;
        }
        int n2 = n;
        while (n < string.length() && double_chars.indexOf(string.charAt(n)) >= 0) {
            ++n;
        }
        int n3 = n;
        try {
            d = Double.valueOf(string.substring(n2, n3));
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    public Image createRotatedImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Image image2 = this.createImage(n + 1, n2 + 1);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        int n3 = 0;
        while (n3 < n2 / 2) {
            graphics.copyArea(0, n3, n, 1, 0, n2 - n3 - n3);
            graphics.copyArea(0, n2 - 1 - n3, n, 1, 0, n3 - (n2 - 1 - n3));
            ++n3;
        }
        graphics.copyArea(0, n2 - (n2 / 2 - 1), n, n2 / 2, 0, -1);
        int n4 = 0;
        while (n4 < n / 2) {
            graphics.copyArea(n4, 0, 1, n2, n - n4 - n4, 0);
            graphics.copyArea(n - 1 - n4, 0, 1, n2, n4 - (n - 1 - n4), 0);
            ++n4;
        }
        graphics.copyArea(n - (n / 2 - 1), 0, n / 2, n2, -1, 0);
        graphics = null;
        return image2;
    }

    public void start() {
        this.is_stopped = false;
        this.set_applet_size();
        this.is_control_down = false;
        this.is_meta_down = false;
        this.is_shift_down = false;
        this.is_new_dragging = false;
        this.is_put_on_screen = true;
        this.is_dragging = false;
        this.is_dragging_point = false;
        if (!this.initialized) {
            this.is_animating = true;
        }
        this.down_time = System.currentTimeMillis() - 10000L;
        this.painter = new Thread(this);
        this.painter.start();
    }

    public void set_applet_size() {
        this.applet_width = this.size().width;
        this.applet_height = this.size().height;
        this.min_height_width = this.applet_height < this.applet_width ? this.applet_height : this.applet_width;
    }

    public void print_message(Graphics graphics, String string) {
        this.print_message(graphics, string, true);
    }

    public void print_message(Graphics graphics, String string, boolean bl) {
        if (bl) {
            System.out.println(string);
        }
        if (this.text_y == 0) {
            this.graphics_buffer.setColor(Color.white);
            this.graphics_buffer.fillRect(0, 0, this.applet_width, this.applet_height);
        }
        this.text_y = this.text_y + graphics.getFontMetrics().getAscent() + 2;
        graphics.setColor(this.foreground_color);
        graphics.drawString(string, this.text_x, this.text_y);
    }

    public void print_syntax_error(Graphics graphics, Parser parser) {
        if (parser.text_index + 1 >= parser.text.length()) {
            parser.text_index = parser.text.length() - 1;
        }
        if (parser.text_index > 30) {
            this.print_message(graphics, "LiveGraphics3D syntax error:");
            this.print_message(graphics, "..." + parser.text.substring(parser.text_index - 30, parser.text_index + 1));
        } else {
            this.print_message(graphics, "LiveGraphics3D syntax error:");
            this.print_message(graphics, parser.text.substring(0, parser.text_index + 1));
        }
    }

    public void stop() {
        this.is_stopped = true;
    }

    public void free_resources() {
        this.ps3D = null;
        this.painted_ps3D = null;
        if (this.frames != null) {
            this.frames.removeAllElements();
            this.frames = null;
        }
        this.image_buffer = null;
        this.second_image_buffer = null;
        this.preload_bg_image = null;
        this.bg_image = null;
        this.bg_rotated_image = null;
        this.bg_right_image = null;
        this.bg_rotated_right_image = null;
        if (this.graphics_buffer != null) {
            this.graphics_buffer.dispose();
            this.graphics_buffer = null;
        }
        if (this.second_graphics_buffer != null) {
            this.second_graphics_buffer.dispose();
            this.second_graphics_buffer = null;
        }
        this.audio_enter = null;
        this.audio_loop_enter = null;
        this.audio_first_frame = null;
        System.gc();
    }

    public void destroy() {
        this.is_stopped = true;
    }

    public void finalize() {
        this.free_resources();
    }

    public void run() {
        this.is_stopped = false;
        this.initialize();
        while (!this.is_stopped) {
            int n;
            if (this.ps3D == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.is_new_dragging) {
                this.is_new_dragging = false;
                if (!this.is_dragging_point) {
                    if (this.is_control_down) {
                        this.length_view_point_factor = this.preceding_length_view_point_factor * Math.pow(4.0, ((double)this.down_mouse_y - this.last_y) / (double)this.min_height_width);
                        this.stereo_distance = this.preceding_stereo_distance + 0.25 * (this.last_x - (double)this.down_mouse_x) / (double)this.applet_width;
                    } else if (this.is_shift_down) {
                        this.magnification_factor = this.preceding_magnification_factor / Math.pow(4.0, ((double)this.down_mouse_y - this.last_y) / (double)this.min_height_width);
                        if (!this.bg_is_cylindrical && !this.bg_is_spherical) {
                            this.rotation = new Quaternion(4.71238898038469 * ((double)this.down_mouse_x - this.last_x) / (double)this.min_height_width, 0.0, 0.0, 1.0, false).product(this.preceding_rotation);
                        }
                    } else if (this.is_meta_down) {
                        this.cut_primitives_count = this.preceding_cut_primitives_count - (this.down_mouse_y - (int)this.last_y) / 8;
                        if (this.cut_primitives_count < 0) {
                            this.cut_primitives_count = 0;
                        }
                        n = ((int)this.last_x - this.down_mouse_x) / 8;
                        if (this.animation_direction == -1) {
                            n = -n;
                        }
                        this.current_frame_index = this.preceding_frame_index + n;
                        int n2 = this.frames_count;
                        if (this.animation_direction == 0) {
                            n2 = 2 * this.frames_count - 2;
                        }
                        this.current_frame_index = this.current_frame_index >= 0 ? (this.current_frame_index %= n2) : (n2 - -this.current_frame_index % n2) % n2;
                        if (this.animation_direction == 0) {
                            if (this.current_frame_index < this.frames_count) {
                                this.setFrameInternal(this.current_frame_index);
                            } else {
                                this.setFrameInternal(2 * this.frames_count - this.current_frame_index - 2);
                            }
                        } else {
                            this.setFrameInternal(this.current_frame_index);
                        }
                    } else if (this.is_dragging || this.is_spinning) {
                        if (this.bg_is_cylindrical || this.bg_is_spherical) {
                            this.bg_x_offset = this.preceding_bg_x_offset - ((int)this.last_x - this.down_mouse_x);
                            this.bg_y_offset = this.preceding_bg_y_offset - ((int)this.last_y - this.down_mouse_y);
                            this.rotation = this.adjust_bg_offsets();
                        } else {
                            double d = this.last_y - (double)this.down_mouse_y;
                            double d2 = this.last_x - (double)this.down_mouse_x;
                            double d3 = Math.sqrt(d * d + d2 * d2);
                            this.rotation = d3 > 1.0 ? new Quaternion(4.71238898038469 * d3 / (double)this.min_height_width, d /= d3, d2 /= d3, 0.0, false).product(this.preceding_rotation) : this.preceding_rotation;
                        }
                    }
                }
                this.ps3D.setPerspective(this.ps3D.initial_length_view_point * this.length_view_point_factor, this.ps3D.initial_magnification * this.magnification_factor, this.is_stereo, this.stereo_distance);
                this.ps3D.setCutPrimitivesCount(this.cut_primitives_count, this.visible_faces, this.show_faces);
                this.ps3D.setQuaternion(this.rotation.product(this.ps3D.initial_rotation));
                if (!this.is_dragging_point) {
                    if (!this.is_new_animate_frame || this.evaluator == null || this.animate_variable_index < 0) {
                        if (this.is_home_event) {
                            this.ps3D.projectPoints(true);
                        } else {
                            this.ps3D.projectPoints(false);
                        }
                    } else {
                        if (!this.evaluator.evaluate()) {
                            this.animate_variable_value = this.valid_animate_variable_value;
                            this.evaluator.setVariableValue(this.animate_variable_index, this.animate_variable_value);
                        } else {
                            this.valid_animate_variable_value = this.animate_variable_value;
                        }
                        this.ps3D.projectPoints(true);
                    }
                } else if (this.evaluator != null && this.dragged_point != null) {
                    int n3 = this.dragged_point.points[0];
                    double d = this.ps3D.point_scale[n3];
                    if (d <= 0.0) {
                        this.ps3D.projectPoints(false);
                    } else {
                        double d4;
                        Object object;
                        int n4;
                        double[] dArray = new double[3];
                        double[] dArray2 = new double[3];
                        double d5 = 0.0;
                        double d6 = 0.0;
                        double d7 = 0.0;
                        int n5 = 0;
                        int n6 = 0;
                        double[] dArray3 = new double[3];
                        Expression[] expressionArray = new Expression[]{null, null, null};
                        double[] dArray4 = new double[3];
                        double d8 = this.ps3D.pixel_height;
                        int n7 = 0;
                        double[] dArray5 = new double[]{1.0, 1.0, 1.0};
                        int n8 = 0;
                        while (n8 < 3) {
                            n4 = this.dragged_point.original_expressions[0][n8];
                            if (n4 >= 0 && ((Expression)(object = this.evaluator.getExpression(n4))).isAtomicIndependentVariable()) {
                                expressionArray[n8] = object;
                            }
                            ++n8;
                        }
                        n4 = 0;
                        while (n4 < 3) {
                            object = expressionArray[n4];
                            if (object != null) {
                                dArray4[n4] = ((Expression)object).getCurrentValue();
                                ++n7;
                            }
                            ++n4;
                        }
                        if (n7 < 3) {
                            double d9 = 0.0;
                            int n9 = 0;
                            dArray3[0] = 0.0;
                            dArray3[1] = 0.0;
                            dArray3[2] = 1.0;
                            object = this.ps3D.getQuaternion().conjugated().rotated(dArray3);
                            int n10 = 0;
                            while (n10 < 3) {
                                if (expressionArray[n10] != null) {
                                    dArray3[0] = 0.0;
                                    dArray3[1] = 0.0;
                                    dArray3[2] = 0.0;
                                    dArray3[n10] = 1.0;
                                    Object object2 = object[n10];
                                    dArray3[0] = dArray3[0] - object2 * object[0];
                                    dArray3[1] = dArray3[1] - object2 * object[1];
                                    dArray3[2] = dArray3[2] - object2 * object[2];
                                    d9 = dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2];
                                    if (n7 == 2) {
                                        if (n9 == 0) {
                                            d5 = d9;
                                            dArray[0] = dArray3[0];
                                            dArray[1] = dArray3[1];
                                            dArray[2] = dArray3[2];
                                            n5 = n10;
                                            n9 = 1;
                                        } else if (n9 == 1) {
                                            d6 = d9;
                                            dArray2[0] = dArray3[0];
                                            dArray2[1] = dArray3[1];
                                            dArray2[2] = dArray3[2];
                                            n6 = n10;
                                            d7 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
                                            n9 = 2;
                                        }
                                        d9 = 1.0;
                                    }
                                    if (d9 < 0.1) {
                                        d9 = 0.1;
                                    }
                                    dArray5[n10] = 1.0 / d9;
                                }
                                ++n10;
                            }
                        }
                        dArray3[0] = d * (this.last_x - (double)this.down_mouse_x) / d8;
                        dArray3[1] = d * ((double)this.down_mouse_y - this.last_y) / d8;
                        dArray3[2] = 0.0;
                        double[] dArray6 = this.ps3D.getQuaternion().conjugated().rotated(dArray3);
                        if (n7 == 2 && (d4 = d5 * d6 - d7 * d7) > 0.0) {
                            double d10 = dArray6[0] * dArray[0] + dArray6[1] * dArray[1] + dArray6[2] * dArray[2];
                            double d11 = dArray6[0] * dArray2[0] + dArray6[1] * dArray2[1] + dArray6[2] * dArray2[2];
                            dArray6[0] = 0.0;
                            dArray6[1] = 0.0;
                            dArray6[2] = 0.0;
                            dArray6[n5] = (d10 * d6 - d11 * d7) / d4;
                            dArray6[n6] = (d11 * d5 - d10 * d7) / d4;
                        }
                        dArray3[0] = dArray6[0] * dArray5[0] + this.down_mouse_point_x;
                        dArray3[1] = dArray6[1] * dArray5[1] + this.down_mouse_point_y;
                        dArray3[2] = dArray6[2] * dArray5[2] + this.down_mouse_point_z;
                        int n11 = 0;
                        while (n11 < 3) {
                            Expression expression = expressionArray[n11];
                            if (expression != null) {
                                expression.setIndependentVariable(dArray3[n11] / this.ps3D.scalings[n11] + this.ps3D.original_center[n11]);
                            }
                            ++n11;
                        }
                        if (!this.evaluator.evaluate()) {
                            int n12 = 0;
                            while (n12 < 3) {
                                Expression expression = expressionArray[n12];
                                if (expression != null) {
                                    expression.setIndependentVariable(dArray4[n12]);
                                }
                                ++n12;
                            }
                        }
                        this.ps3D.projectPoints(true);
                    }
                }
                this.is_home_event = false;
                if (!this.is_put_on_screen) {
                    while (!this.is_put_on_screen) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.is_put_on_screen = false;
                this.paintGraphics3D();
                if (this.audio_first_frame != null && this.current_frame_index == 0 && this.is_animating && this.frames_count > 1 && (this.is_dragging || this.is_mouse_here)) {
                    this.audio_first_frame.play();
                }
            } else {
                try {
                    if (this.is_animating && this.frames_count > 1 && (this.is_dragging || this.is_mouse_here) && !this.is_meta_down || this.is_spinning && this.is_mouse_here) {
                        Thread.sleep(5L);
                    } else {
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            int n13 = n = System.currentTimeMillis() - this.painted_time < (long)(1000.0 * this.animation_display_time) ? 0 : 1;
            if (this.is_spinning && this.is_mouse_here && n != 0) {
                this.is_new_dragging = true;
                this.painted_time = System.currentTimeMillis();
                this.last_x += this.spin_x;
                this.last_y += this.spin_y;
            }
            if (!this.is_animating || this.frames_count <= 1 || !this.is_dragging && !this.is_mouse_here || this.is_meta_down || n == 0) continue;
            this.is_new_dragging = true;
            this.painted_time = System.currentTimeMillis();
            if (this.animation_direction == 1) {
                ++this.current_frame_index;
                if (this.current_frame_index >= this.frames_count) {
                    this.current_frame_index = 0;
                }
                this.setFrameInternal(this.current_frame_index);
                continue;
            }
            if (this.animation_direction == -1) {
                --this.current_frame_index;
                if (this.current_frame_index < 0) {
                    this.current_frame_index = this.frames_count - 1;
                }
                this.setFrameInternal(this.current_frame_index);
                continue;
            }
            if (this.animation_direction != 0) continue;
            ++this.current_frame_index;
            if (this.current_frame_index >= 2 * this.frames_count - 2) {
                this.current_frame_index = 0;
            }
            if (this.current_frame_index < this.frames_count) {
                this.setFrameInternal(this.current_frame_index);
                continue;
            }
            this.setFrameInternal(2 * this.frames_count - this.current_frame_index - 2);
        }
    }

    Quaternion adjust_bg_offsets() {
        while (this.bg_x_offset > this.bg_width) {
            this.bg_x_offset -= this.bg_width;
        }
        while (this.bg_x_offset < 0) {
            this.bg_x_offset += this.bg_width;
        }
        double d = Math.PI * -2 * (double)this.bg_x_offset / (double)this.bg_width;
        double d2 = 0.0;
        if (this.bg_is_cylindrical) {
            int n = (this.bg_height - this.applet_height) / 2;
            if (this.bg_y_offset > n) {
                this.bg_y_offset = n;
            } else if (this.bg_y_offset < -n) {
                this.bg_y_offset = -n;
            }
            d2 = Math.PI * -2 * (double)this.bg_y_offset / (double)this.bg_width;
        } else if (this.bg_is_spherical) {
            while (this.bg_y_offset > this.bg_height + this.bg_height) {
                this.bg_y_offset = this.bg_y_offset - this.bg_height - this.bg_height;
            }
            while (this.bg_y_offset < 0) {
                this.bg_y_offset = this.bg_y_offset + this.bg_height + this.bg_height;
            }
            d2 = -Math.PI * (double)this.bg_y_offset / (double)this.bg_height;
        }
        this.rotation = new Quaternion(d2, 1.0, 0.0, 0.0, false);
        this.rotation.multiply(new Quaternion(d, 0.0, 1.0, 0.0, false));
        return this.rotation;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.is_mouse_here = true;
        this.requestFocus();
        if (this.audio_enter != null) {
            this.audio_enter.play();
        }
        if (this.audio_loop_enter != null) {
            this.audio_loop_enter.loop();
        }
        if (this.initialized) {
            if (this.ps3D == null) {
                this.getAppletContext().showStatus(syntax_error_string);
                return true;
            }
            if (!this.is_dragging_point && !this.is_dragging) {
                if (this.frames_count <= 1) {
                    if (this.mouse_drag_action == 0) {
                        this.getAppletContext().showStatus(enter_plain_string);
                    } else {
                        this.getAppletContext().showStatus(enter_drag_string);
                    }
                } else if (this.mouse_drag_action == 0) {
                    this.getAppletContext().showStatus(enter_animated_string);
                } else {
                    this.getAppletContext().showStatus(enter_drag_animated_string);
                }
            }
        } else {
            this.getAppletContext().showStatus(enter_init_string);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.is_mouse_here = false;
        if (this.audio_loop_enter != null) {
            this.audio_loop_enter.stop();
        }
        if (this.active_primitive != null) {
            this.drawTextRectangle(this.active_primitive);
            this.active_primitive = null;
            this.getAppletContext().showStatus(empty_string);
            if (!this.is_dragging && !this.is_new_dragging && this.is_put_on_screen) {
                this.is_put_on_screen = false;
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.is_mouse_here = true;
        if (!this.initialized || this.painted_ps3D == null || n < 0 || n > this.applet_width || n2 < 0 || n2 > this.applet_height || !this.is_put_on_screen || this.is_dragging_point) {
            return true;
        }
        this.mark_hyperlink(n, n2);
        return true;
    }

    public synchronized void mark_hyperlink(int n, int n2) {
        Object object;
        Primitive3D primitive3D = this.active_primitive;
        this.active_primitive = null;
        if (!this.is_animating && !this.is_spinning) {
            object = this.painted_ps3D.left_pixel_xs;
            int[] nArray = this.painted_ps3D.pixel_ys;
            if (this.painted_ps3D.is_stereo && n > this.painted_ps3D.pixel_width) {
                object = this.painted_ps3D.right_pixel_xs;
                n -= this.painted_ps3D.pixel_width;
            }
            int n3 = this.painted_ps3D.count_ordered_primitives - 1;
            while (n3 >= 0) {
                int n4 = this.painted_ps3D.order[n3];
                if (this.painted_ps3D.min_primitive_index <= n4 && n4 <= this.painted_ps3D.max_primitive_index) {
                    Primitive3D primitive3D2 = (Primitive3D)this.painted_ps3D.primitives.elementAt(n4);
                    if (primitive3D2.font_url != null) {
                        int n5;
                        if (primitive3D2.font_url == Primitive3D.text_dragable_point) {
                            int n6 = primitive3D2.points[0];
                            if (this.painted_ps3D.point_scale[n6] > 0.0f && object[n6] - (n5 = primitive3D2.is_absolute_point_size ? primitive3D2.point_diameter / 2 + 4 : (int)((float)primitive3D2.point_diameter / this.painted_ps3D.point_scale[n6] / 2.0f + 4.0f)) <= n && nArray[n6] - n5 <= n2 && object[n6] + n5 >= n && nArray[n6] + n5 >= n2) {
                                this.active_primitive = primitive3D2;
                                break;
                            }
                        } else if (primitive3D2.count_points == 0) {
                            if (this.painted_ps3D.pixel_width / 2 + primitive3D2.first_point <= n && 2 + primitive3D2.second_point <= n2 && this.painted_ps3D.pixel_width / 2 + primitive3D2.first_point + primitive3D2.third_point >= n && 2 + primitive3D2.second_point + primitive3D2.fourth_point >= n2) {
                                this.active_primitive = primitive3D2;
                                break;
                            }
                        } else {
                            n5 = primitive3D2.points[0];
                            if (this.painted_ps3D.point_scale[n5] > 0.0f && object[n5] + primitive3D2.first_point <= n && nArray[n5] + primitive3D2.second_point <= n2 && object[n5] + primitive3D2.first_point + primitive3D2.third_point >= n && nArray[n5] + primitive3D2.second_point + primitive3D2.fourth_point >= n2) {
                                this.active_primitive = primitive3D2;
                                break;
                            }
                        }
                    }
                }
                --n3;
            }
        }
        if (primitive3D != this.active_primitive && (primitive3D != null || this.active_primitive != null)) {
            if (!this.is_put_on_screen) {
                this.active_primitive = null;
            } else {
                if (primitive3D != null) {
                    this.drawTextRectangle(primitive3D);
                    if (this.active_primitive == null) {
                        this.getAppletContext().showStatus(empty_string);
                    }
                }
                if (this.active_primitive != null) {
                    object = this.active_primitive.font_url;
                    int n7 = ((String)object).indexOf(target_string);
                    if (n7 > 0) {
                        object = ((String)object).substring(0, n7 - 1);
                    }
                    this.drawTextRectangle(this.active_primitive);
                    this.getAppletContext().showStatus((String)object);
                }
                this.is_put_on_screen = false;
                this.repaint();
            }
        }
    }

    public synchronized void drawTextRectangle(Primitive3D primitive3D) {
        if (primitive3D.font_url == Primitive3D.text_dragable_point) {
            int n = primitive3D.points[0];
            if (this.painted_ps3D.point_scale[n] > 0.0f) {
                int n2 = primitive3D.is_absolute_point_size ? primitive3D.point_diameter / 2 + 4 : (int)((float)primitive3D.point_diameter / this.painted_ps3D.point_scale[n] / 2.0f + 4.0f);
                this.graphics_buffer.setColor(Color.white);
                this.graphics_buffer.setXORMode(Color.black);
                this.graphics_buffer.drawRect(this.painted_ps3D.left_pixel_xs[n] - n2, this.painted_ps3D.pixel_ys[n] - n2, 2 * n2 - 1, 2 * n2 - 1);
                if (this.painted_ps3D.is_stereo) {
                    this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width + this.painted_ps3D.right_pixel_xs[n] - n2, this.painted_ps3D.pixel_ys[n] - n2, 2 * n2 - 1, 2 * n2 - 1);
                }
                this.graphics_buffer.setPaintMode();
            }
        } else if (primitive3D.count_points == 0) {
            this.graphics_buffer.setColor(Color.white);
            this.graphics_buffer.setXORMode(Color.black);
            this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width / 2 + primitive3D.first_point, 2 + primitive3D.second_point, primitive3D.third_point - 1, primitive3D.fourth_point - 1);
            if (this.painted_ps3D.is_stereo) {
                this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width + this.painted_ps3D.pixel_width / 2 + primitive3D.first_point, 2 + primitive3D.second_point, primitive3D.third_point - 1, primitive3D.fourth_point - 1);
            }
            this.graphics_buffer.setPaintMode();
        } else {
            int n = primitive3D.points[0];
            if (this.painted_ps3D.point_scale[n] > 0.0f) {
                this.graphics_buffer.setColor(Color.white);
                this.graphics_buffer.setXORMode(Color.black);
                this.graphics_buffer.drawRect(this.painted_ps3D.left_pixel_xs[n] + primitive3D.first_point, this.painted_ps3D.pixel_ys[n] + primitive3D.second_point, primitive3D.third_point - 1, primitive3D.fourth_point - 1);
                if (this.painted_ps3D.is_stereo) {
                    this.graphics_buffer.drawRect(this.painted_ps3D.pixel_width + this.painted_ps3D.right_pixel_xs[n] + primitive3D.first_point, this.painted_ps3D.pixel_ys[n] + primitive3D.second_point, primitive3D.third_point - 1, primitive3D.fourth_point - 1);
                }
                this.graphics_buffer.setPaintMode();
            }
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.is_mouse_here = true;
        if (this.painted_ps3D == null) {
            return true;
        }
        if (this.active_primitive != null && this.active_primitive.text != null) {
            URL uRL;
            String string = this.active_primitive.font_url;
            String string2 = null;
            int n3 = string.indexOf(target_string);
            if (n3 > 0) {
                string2 = string.substring(n3 + target_string.length());
                string = string.substring(0, n3 - 1);
            }
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.getAppletContext().showStatus(String.valueOf(url_error_string) + malformedURLException.getMessage());
                uRL = null;
            }
            if (uRL != null) {
                if (string2 == null) {
                    this.getAppletContext().showDocument(uRL);
                } else {
                    this.getAppletContext().showDocument(uRL, string2);
                }
            }
        } else {
            long l = System.currentTimeMillis();
            if (this.active_primitive != null && this.active_primitive.count_points == 1) {
                this.down_time = l;
                this.is_animating = false;
                this.is_dragging = false;
                this.is_dragging_point = true;
                this.dragged_point = this.active_primitive;
                this.down_mouse_point_x = this.painted_ps3D.xs[this.active_primitive.points[0]];
                this.down_mouse_point_y = this.painted_ps3D.ys[this.active_primitive.points[0]];
                this.down_mouse_point_z = this.painted_ps3D.zs[this.active_primitive.points[0]];
            } else {
                if (l > this.down_time && l - this.down_time < 500L) {
                    if (this.is_animating || this.frames_count > 1) {
                        this.is_animating ^= true;
                    }
                    this.down_time = l - 1000L;
                } else {
                    this.down_time = l;
                }
                this.is_dragging = true;
                this.is_dragging_point = false;
            }
            this.preceding_rotation = this.rotation;
            this.preceding_length_view_point_factor = this.length_view_point_factor;
            this.preceding_magnification_factor = this.magnification_factor;
            this.preceding_cut_primitives_count = this.cut_primitives_count;
            this.preceding_bg_x_offset = this.bg_x_offset;
            this.preceding_bg_y_offset = this.bg_y_offset;
            this.preceding_stereo_distance = this.stereo_distance;
            this.preceding_frame_index = this.current_frame_index;
            this.down_mouse_x = n;
            this.down_mouse_y = n2;
            this.last_x = this.down_mouse_x;
            this.last_y = this.down_mouse_y;
            this.last_drag_time = l;
            this.is_spinning = false;
            this.spin_x = 0.0;
            this.spin_y = 0.0;
            this.is_shift_down = false;
            this.is_control_down = false;
            this.is_meta_down = false;
            if (event.shiftDown()) {
                this.is_shift_down = true;
            } else if (event.controlDown()) {
                this.is_control_down = true;
            } else if (event.metaDown()) {
                this.is_meta_down = true;
            }
        }
        if (this.is_dragging_point) {
            this.drawTextRectangle(this.active_primitive);
            this.active_primitive = null;
            this.getAppletContext().showStatus(empty_string);
            if (this.is_put_on_screen) {
                this.is_put_on_screen = false;
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (!(this.is_shift_down || this.is_meta_down || this.is_control_down || !this.is_mouse_here || this.llast_drag_time == 0L || this.is_dragging_point)) {
            this.calculateSpin(event, n, n2);
        } else {
            this.is_spinning = false;
            this.spin_x = 0.0;
            this.spin_y = 0.0;
        }
        this.llast_drag_time = 0L;
        this.is_dragging = false;
        this.is_dragging_point = false;
        this.is_shift_down = false;
        this.is_meta_down = false;
        this.is_control_down = false;
        if (!(this.initialized && this.painted_ps3D != null && this.is_mouse_here && n >= 0 && n <= this.applet_width && n2 >= 0 && n2 <= this.applet_height && this.is_put_on_screen)) {
            return true;
        }
        this.mark_hyperlink(n, n2);
        return true;
    }

    void calculateSpin(Event event, int n, int n2) {
        double d = this.last_x;
        double d2 = this.last_y;
        long l = this.last_drag_time;
        double d3 = this.llast_x;
        double d4 = this.llast_y;
        long l2 = this.llast_drag_time;
        long l3 = System.currentTimeMillis();
        if (n == (int)this.last_x && n2 == (int)this.last_y && (l3 - l > 500L || l3 >= l + (l - l2) + (l - l2))) {
            this.spin_x = 0.0;
            this.spin_y = 0.0;
        } else {
            if (l3 > l) {
                d = n;
                d2 = n2;
                l = l3;
            }
            if (l <= l2) {
                this.spin_x = 0.0;
                this.spin_y = 0.0;
            } else {
                double d5 = this.animation_display_time;
                if (d5 < 0.005) {
                    d5 = 0.005;
                }
                double d6 = 1000.0 * d5 / (double)(l - l2);
                this.spin_x = d6 * (d - d3);
                this.spin_y = d6 * (d2 - d4);
                double d7 = Math.sqrt(this.spin_x * this.spin_x + this.spin_y * this.spin_y);
                if (d7 > (double)this.min_height_width / 8.0) {
                    this.spin_x = this.spin_x / d7 * (double)this.min_height_width / 8.0;
                    this.spin_y = this.spin_y / d7 * (double)this.min_height_width / 8.0;
                }
            }
        }
        if (Math.abs(this.spin_x) > 0.1 || Math.abs(this.spin_y) > 0.1) {
            this.is_spinning = true;
        } else {
            this.is_spinning = false;
            this.spin_x = 0.0;
            this.spin_y = 0.0;
        }
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.ps3D == null || this.active_primitive != null && this.active_primitive.text != null || !this.is_dragging && !this.is_dragging_point || this.mouse_drag_action == 0 && !this.is_dragging_point && !this.is_shift_down && !this.is_control_down && !this.is_meta_down) {
            return true;
        }
        if (!(!this.is_dragging_point && this.preceding_rotation == null || n == (int)this.last_x && n2 == (int)this.last_y)) {
            long l;
            this.is_new_dragging = true;
            if (this.is_dragging && (this.is_shift_down || this.is_control_down || this.is_meta_down)) {
                if (Math.abs((int)this.last_x - n) > Math.abs((int)this.last_y - n2)) {
                    this.down_mouse_y = this.down_mouse_y + n2 - (int)this.last_y;
                } else {
                    this.down_mouse_x = this.down_mouse_x + n - (int)this.last_x;
                }
            }
            if (this.last_drag_time != (l = System.currentTimeMillis())) {
                this.llast_x = this.last_x;
                this.llast_y = this.last_y;
                this.llast_drag_time = this.last_drag_time;
            }
            this.last_x = n;
            this.last_y = n2;
            this.last_drag_time = l;
            this.spin_x = 0.0;
            this.spin_y = 0.0;
            this.is_spinning = false;
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (this.painted_ps3D == null) {
            return true;
        }
        if (n == 102) {
            this.show_faces ^= true;
            this.is_new_dragging = true;
        }
        if (n == 111) {
            double[] dArray = new double[3];
            dArray[2] = 1.0;
            double[] dArray2 = dArray;
            double[] dArray3 = new double[3];
            dArray3[1] = 1.0;
            double[] dArray4 = dArray3;
            dArray2 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray2);
            dArray4 = this.painted_ps3D.getQuaternion().conjugated().rotated(dArray4);
            String string = "LiveGraphics3D parameters:\n   <PARAM NAME=MAGNIFICATION VALUE=" + this.magnification_factor + ">\n";
            if (this.is_stereo) {
                string = String.valueOf(string) + "   <PARAM NAME=STEREO_DISTANCE VALUE=" + this.stereo_distance + ">\n";
            }
            if (this.spin_x != 0.0) {
                string = String.valueOf(string) + "   <PARAM NAME=SPIN_X VALUE=" + this.spin_x + ">\n";
            }
            if (this.spin_y != 0.0) {
                string = String.valueOf(string) + "   <PARAM NAME=SPIN_Y VALUE=" + this.spin_y + ">\n";
            }
            if (this.evaluator != null && this.evaluator.isVariableIndependent(0)) {
                string = String.valueOf(string) + "   <PARAM NAME=INDEPENDENT_VARIABLES VALUE=\"{\n";
                int n2 = 0;
                while (this.evaluator.isVariableIndependent(n2)) {
                    string = String.valueOf(string) + "       " + (String)this.evaluator.variable_names.elementAt(n2) + "->" + this.evaluator.getVariableValue(n2);
                    string = this.evaluator.isVariableIndependent(n2 + 1) ? String.valueOf(string) + ",\n" : String.valueOf(string) + "}\">\n";
                    ++n2;
                }
            }
            string = String.valueOf(string) + "Graphics3D options:\n   ViewPoint->{" + dArray2[0] * this.painted_ps3D.length_view_point + ", " + dArray2[1] * this.painted_ps3D.length_view_point + ", " + dArray2[2] * this.painted_ps3D.length_view_point + "},\n   ViewVertical->{" + dArray4[0] / this.painted_ps3D.option_BoxRatios[0] + ", " + dArray4[1] / this.painted_ps3D.option_BoxRatios[1] + ", " + dArray4[2] / this.painted_ps3D.option_BoxRatios[2] + "}";
            System.out.println(string);
        } else if (n == 115) {
            if (!this.is_stereo) {
                this.is_stereo = true;
            } else if (this.stereo_distance > 0.0) {
                this.stereo_distance = -this.stereo_distance;
                if (this.stereo_distance > 0.0) {
                    this.stereo_distance = -0.05;
                }
            } else {
                this.stereo_distance = -this.stereo_distance;
                this.is_stereo = false;
            }
            this.is_new_dragging = true;
        } else if (n == 1000) {
            this.rotation = this.home_rotation;
            this.bg_x_offset = this.home_bg_x_offset;
            this.bg_y_offset = this.home_bg_y_offset;
            this.magnification_factor = this.home_magnification_factor;
            this.is_stereo = this.home_is_stereo;
            this.stereo_distance = this.home_stereo_distance;
            this.cut_primitives_count = this.home_cut_primitives_count;
            this.spin_x = 0.0;
            this.spin_y = 0.0;
            this.is_spinning = false;
            this.show_faces = true;
            if (this.evaluator != null) {
                this.evaluator.setInitialVariableValues();
            }
            this.setFrame(0);
            if (this.evaluator != null) {
                this.evaluator.evaluate();
            }
            this.is_home_event = true;
            this.is_new_dragging = true;
        }
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.image_buffer != null) {
            graphics.drawImage(this.image_buffer, 0, 0, this);
            this.is_put_on_screen = true;
        }
    }

    public void paintGraphics3D() {
        this.active_primitive = null;
        if (this.ps3D.is_stereo && this.second_graphics_buffer == null) {
            this.second_image_buffer = this.createImage((this.applet_width + 1) / 2, this.applet_height);
            this.second_graphics_buffer = this.second_image_buffer.getGraphics();
        }
        if (this.bg_image == null) {
            this.graphics_buffer.setColor(this.ps3D.option_Background);
            this.graphics_buffer.fillRect(0, 0, this.ps3D.pixel_width, this.ps3D.pixel_height);
            if (this.ps3D.is_stereo) {
                this.second_graphics_buffer.setColor(this.ps3D.option_Background);
                this.second_graphics_buffer.fillRect(0, 0, this.ps3D.pixel_width, this.ps3D.pixel_height);
            }
        } else {
            Image image = this.bg_image;
            Image image2 = this.bg_rotated_image;
            Image image3 = this.bg_right_image;
            Image image4 = this.bg_rotated_right_image;
            if (this.ps3D.is_stereo && this.ps3D.stereo_distance < 0.0) {
                image = this.bg_right_image;
                image2 = this.bg_rotated_right_image;
                image3 = this.bg_image;
                image4 = this.bg_rotated_image;
            }
            if (this.bg_is_spherical) {
                int n;
                int n2;
                int n3 = (this.bg_width / 2 + this.bg_width - this.bg_x_offset) % this.bg_width;
                int n4 = ((this.ps3D.pixel_height - this.bg_height) / 2 + this.bg_height + this.bg_y_offset) % (this.bg_height + this.bg_height) - this.bg_height;
                int n5 = 0;
                if (n4 > 0) {
                    n2 = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + n3 - (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (n2 < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(image2, n2, n4 - this.bg_height, null);
                        n2 += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        n = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + n3 + (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                        while (n < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(image4, n, n4 - this.bg_height, null);
                            n += this.bg_width;
                        }
                    }
                }
                n2 = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset - (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                while (n2 < this.ps3D.pixel_width) {
                    this.graphics_buffer.drawImage(image, n2, n4, null);
                    n2 += this.bg_width;
                }
                if (this.ps3D.is_stereo) {
                    n = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset + (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (n < this.ps3D.pixel_width) {
                        this.second_graphics_buffer.drawImage(image3, n, n4, null);
                        n += this.bg_width;
                    }
                }
                if (n4 + this.bg_height < this.ps3D.pixel_height) {
                    n = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + n3 - (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                    while (n < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(image2, n, n4 + this.bg_height, null);
                        n += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        int n6 = n5 = ((this.ps3D.pixel_width + this.bg_width) / 2 + n3 + (int)this.ps3D.pixel_stereo_offset) % this.bg_width - this.bg_width;
                        while (n6 < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(image4, n6, n4 + this.bg_height, null);
                            n6 += this.bg_width;
                        }
                    }
                }
            } else {
                int n;
                int n7 = (int)this.ps3D.pixel_stereo_offset;
                if (this.bg_is_fixed) {
                    n7 = 0;
                }
                int n8 = n = ((this.ps3D.pixel_height + this.bg_height) / 2 + this.bg_y_offset) % this.bg_height - this.bg_height;
                while (n8 < this.ps3D.pixel_height) {
                    int n9;
                    int n10 = n9 = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset - n7) % this.bg_width - this.bg_width;
                    while (n10 < this.ps3D.pixel_width) {
                        this.graphics_buffer.drawImage(image, n10, n8, null);
                        n10 += this.bg_width;
                    }
                    if (this.ps3D.is_stereo) {
                        int n11 = n9 = ((this.ps3D.pixel_width + this.bg_width) / 2 + this.bg_x_offset + n7) % this.bg_width - this.bg_width;
                        while (n11 < this.ps3D.pixel_width) {
                            this.second_graphics_buffer.drawImage(image3, n11, n8, null);
                            n11 += this.bg_width;
                        }
                    }
                    n8 += this.bg_height;
                }
            }
        }
        this.ps3D.paint(this.graphics_buffer, this.second_graphics_buffer, this.second_image_buffer);
        this.painted_ps3D = this.ps3D;
        this.repaint();
    }

    public Live() {
        this.applet_width = this.size().width;
        this.applet_height = this.size().height;
        this.is_dragging = false;
        this.is_dragging_point = false;
        this.show_faces = true;
        this.mouse_drag_action = 1;
        this.audio_enter = null;
        this.audio_loop_enter = null;
        this.audio_first_frame = null;
        this.down_mouse_x = 50;
        this.down_mouse_y = 50;
        this.down_mouse_point_x = 0.0;
        this.down_mouse_point_y = 0.0;
        this.down_mouse_point_z = 0.0;
        this.down_time = 0L;
        this.last_x = 50.0;
        this.last_y = 50.0;
        this.last_drag_time = 0L;
        this.llast_x = 50.0;
        this.llast_y = 50.0;
        this.llast_drag_time = 0L;
        this.is_control_down = false;
        this.is_meta_down = false;
        this.is_shift_down = false;
        this.is_mouse_here = false;
        this.length_view_point_factor = 1.0;
        this.magnification_factor = 1.0;
        this.cut_primitives_count = 0;
        this.rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.bg_x_offset = 0;
        this.bg_y_offset = 0;
        this.stereo_distance = 0.05;
        this.preceding_length_view_point_factor = 1.0;
        this.preceding_magnification_factor = 1.0;
        this.preceding_cut_primitives_count = 0;
        this.preceding_rotation = this.rotation;
        this.preceding_bg_x_offset = 0;
        this.preceding_bg_y_offset = 0;
        this.preceding_stereo_distance = 0.05;
        this.preceding_frame_index = 0;
        this.home_rotation = this.rotation;
        this.home_bg_x_offset = this.bg_x_offset;
        this.home_bg_y_offset = this.bg_y_offset;
        this.home_magnification_factor = this.magnification_factor;
        this.home_is_stereo = this.is_stereo;
        this.home_stereo_distance = this.stereo_distance;
        this.home_cut_primitives_count = this.cut_primitives_count;
        this.is_new_dragging = false;
        this.is_home_event = false;
        this.initialized = false;
        this.is_stopped = false;
    }
}

