/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Stack;
import java.util.Vector;

class Parser {
    public String text;
    public int text_index;
    char current_char;
    int last_text_index;
    char last_char;
    public Evaluator evaluator;
    static String single_quote_chars = "'\u00b4`'";
    static String breaking_chars = " \r\n\t\\";
    static String white_characters = " \t\r\n\f";
    static String comment_end = "*)";
    static String[] standard_parts = new String[]{"Capital", "Script", "Gothic", "Not", "DoubleStruck", "Doubled", "Double", "Filled", "Left", "Right", ""};
    static String[] standard_short_parts = new String[]{"c", "s", "g", "n", "t", "v", "w", "f", "l", "r"};
    static String coded_char_names = "0AA225AB257AC259AD228AE230AG224AH226Ak63272Ale8501AliasD63332AliasI63336Alig63328Alp945Alt63441Andy63273And8743Angl8736Angs8491AR229As8944AT227AutoL62376AutoO62382AutoP62372AutoR62377AutoS62381Ba8726Bec8757Beta946Bet8502Br774Bu8226CAc263Cap8994cAA193cAB256cAC258cAD196cAE198cAG192cAH194cAl913cAR197cAT195cB914cCA262cCC199cCH268cCh935cDe916cDif63307cDig988cEA201cEB274cEC276cED203cEG200cEH202cEp917cEta919cEth208cG915cIA205cIC300cID207cIG204cIH206cIo921cKa922cKo990cLa923cLS321cM924cNT209cNu925cOA211cODoubleA336cODoubleD214cOG210cOH212cOme937cOmi927cOS216cOT213cPh934cPi928cPs936cR929cSa992cSH352cSi931cSt986cTa932cThe920cTho222cUA218cUDoubleA368cUDoubleD220cUG217cUH219cUp933cX926cY221cZ918CC231Ced807CenterD183CenterE8943Cent162CH269Ch967CircleD8857CircleM8854CircleP8853CircleT8855Cloc8754CloseCurlyD8221CloseCurlyQ8217Clov8984Clu9827Col8758Com63338Cong8801Conti62385Conto8750Contr63331Copr8720Copy169Cou8755Cr62624CupC8781Cup8995CurlyCapitalU978CurlyE603CurlyK1008CurlyPh981CurlyPi982CurlyR1009CurlyT977Curr164Dag8224Dal8504Das8211Deg176Dele63440Delt948Del8711Des8945Diame62468Diamond62753DiamondS9826Dif63308Dig63249Div247DotE8784DotlessI305DotlessJ63232Dott63313wC8751wDa8225vG63306wDot776wDow8659vP63305wlA8656wlr8660wlT62467wLongLeftA62720wLongLeftR62722wLongRightA62721wP8243wrA8658wrT8872tA63206tB63207tC63208tcA63396tcB63397tcC63398tcD63399tcE63400tcF63401tcG63402tcH63403tcI63404tcJ63405tcK63406tcL63407tcM63408tcN63409tcO63410tcP63411tcQ63412tcR63413tcS63414tcT63415tcU63416tcV63417tcW63418tcX63419tcY63420tcZ63421tD63209tE63210tF63211tG63212tH63213tI63214tJ63215tK63216tL63217tM63218tN63219tO63220tP63221tQ63222tR63223tS63224tT63225tU63226tV63227tW63228tX63229tY63230tZ63231wUpA8657wUpD8661wV8741DownArrowB62724DownArrowU62726DownArrow8595DownB785DownE161DownLeftR62731DownLeftT62734DownLeftVectorB62732DownLeftVector8637DownQ191DownRightT62735DownRightVectorB62733DownRightVector8641DownTeeA8615DownTee8868EA233EB275EC277ED235EG232EH234Ele8712Ell8230EmptyC9675EmptyDi9671EmptyDo9661EmptyR9647EmptySe8709EmptySmallC9702EmptySmallS62759EmptySq9635EmptyU9651EmptyV62768En63444Ep949EqualT8770Equal62513Equi8652Er63335Es63337Eta951Eth240Exi8707Exp63309Fe63274Fi63233fC9679fDi9670fDo9660fR9646fSmallC63312fSmallS62760fS9634fU9650fV62761Fin962Fiv9733Fla9837FlL63234Flo402Fo8704Fr63265Ga947Gi8503gA63180gB63181gC63182gcA63370gcB63371gcC63372gcD63373gcE63374gcF63375gcG63376gcH63377gcI63378gcJ63379gcK63380gcL63381gcM63382gcN63383gcO63384gcP63385gcQ63386gcR63387gcS63388gcT63389gcU63390gcV63391gcW63392gcX63393gcY63394gcZ63395gD63183gE63184gF63185gG63186gH63187gI63188gJ63189gK63190gL63191gM63192gN63193gO63194gP63195gQ63196gR63197gS63198gT63199gU63200gV63201gW63202gX63203gY63204gZ63205GrayC63315GrayS63314GreaterEqualL8923GreaterEqual8805GreaterF8807GreaterG8811GreaterL8823GreaterS62502GreaterT8819Hac780Hap9786HB8463He9825Ho62977HumpD8782HumpE8783Hy173IA237IC301ID239IG236IH238ImaginaryI63310ImaginaryJ63311Imp62755Ind62371Inf8734Integ8747Inter8898InvisibleC63333InvisiblePo62388InvisiblePr62387InvisibleS62304Io953Ka954Ker63318Key63443Ko63250La955lAn9001lArrowB8676lArrowR8646lArrow8592lB62979lC8968lwBracketi62981lwBracket12314lDownT62745lDownVectorB62743lDownVector8643lF8970lG171lM63339lrA8596lrV62725lS63329lTeeA8612lTeeV62729lTee8867lTriangleB62480lTriangleE8884lTriangle8882lUpD62741lUpT62744lUpVectorB62742lUpVector8639lVectorB62727lVector8636LessEqualG8922LessEqual8804LessF8806LessG8822LessL8810LessS62496LessT8818Li63267LongD8212LongLeftA62748LongLeftR62750LongR62749LowerL8601LowerR8600LS322Ma63319Mea8737Med62308Mh8487Mic181Min8723Mo63446Mu956Na9838NegativeM62339NegativeThic62340NegativeThin62338NegativeV62336NestedG62501NestedL62497Neu63266NoB62370Non160nCo8802nCu8813nw8742nEl8713nEqualT62464nEqual8800nEx8708nGreaterE8817nGreaterF8809nGreaterG62503nGreaterL8825nGreaterS62505nGreaterT8821nGreater8815nHumpD62466nHumpE62465nlTriangleB62482nlTriangleE8940nlTriangle8938nLessE8816nLessF8808nLessG8824nLessL62498nLessS62500nLessT8820nLess8814nNestedG62504nNestedL62499nPrecedesE8928nPrecedesS62507nPrecedesT8936nPrecedes8832nRe8716nrTriangleB62483nrTriangleE8941nrTriangle8939nSquareSubsetE8930nSquareSubset62510nSquareSupersetE8931nSquareSuperset62511nSubsetE8840nSubset8836nSucceedsE8929nSucceedsS62509nSucceedsT8937nSucceeds8833nSupersetE8841nSuperset8837nTildeE8772nTildeF8775nTildeT8777nTilde8769nV8740NT241Nul62368Num63268Nu957OA243ODoubleA337ODoubleD246OG242OH244Ome969Omi959OpenCurlyD8220OpenCurlyQ8216Opt63442Or8744OS248OT245OverBrace62994OverBrack62996OverP62992Para182Part8706Ph966Pi960Pla9633Plu177PrecedesE8828PrecedesS62506PrecedesT8830Precedes8826Pri8242Prod8719Proportiona8733Proportion8759Ps968Reg174ReturnI8629ReturnK63334ReverseD8245ReverseEl8715ReverseEq8651ReverseP8244ReverseU62747Rh961rAngleB9002rAngle8735rArrowB8677rArrowL8644rArrow8594rB62980rC8969rwBracketi62982rwBracket12315rDownT62740rDownVectorB62738rDownVector8642rF8971rG187rM63340rS63330rTeeA8614rTeeV62730rTee8866rTriangleB62481rTriangleE8885rTriangle8883rUpD62736rUpT62739rUpVectorB62737rUpVector8638rVectorB62728rVector8640RoundI62756RoundS62386RuleD62751Rule62754Sad9785Sam63251sA63154sB63155sC63156scA63344scB63345scC63346scD63347scE63348scF63349scG63350scH63351scI63352scJ63353scK63354scL63355scM63356scN63357scO63358scP63359scQ63360scR63361scS63362scT63363scU63364scV63365scW63366scX63367scY63368scZ63369sDotlessI63280sDotlessJ63281sD63157sE63158sF63159sG63160sH63161sI63162sJ63163sK63164sL63165sM63166sN63167sO63168sP63169sQ63170sR63171sS63172sT63173sU63174sV63175sW63176sX63177sY63178sZ63179Sec167Sel9632SH353Sha9839Shi63445ShortD62763ShortL62758ShortR62757ShortU62762Sig963Six63317Sk8259Sm8728SpaceI9251SpaceK63423Spa9824Sp8738Sqr8730SquareI8851SquareSubsetE8849SquareSubset8847SquareSupersetE8850SquareSuperset8848SquareU8852Square62752Sta8902Ste163Sti63248SubsetE8838Subset8834SucceedsE8829SucceedsS62508SucceedsT8831Succeeds8827Such8717Sum8721SupersetE8839Superset8835SZ223Tab63422Tau964Ther8756Thet952Thick62309Thin62307Tho254TildeE8771TildeF8773TildeT8776Tilde8764Tim215Tra63270Tri8411UA250UDoubleA369UDoubleD252UG249UH251UnderBrace62995UnderBrack62997UnderP62993UnionP8846Union8899Unk65533UpArrowB62723UpArrowD8645UpArrow8593UpD8597UpE62746UpperL8598UpperR8599Ups965UpTeeA8613UpTee8869Vee8897VerticalB8739VerticalE8942VerticalL62978VerticalS62514VerticalT8768Very62305Vi63271War63269Wat63316Wed8896Wei8472Wo63264Xi958YA253YD255Ye165Ze950   ";
    double scanned_real;
    boolean is_scanned_real;
    public static final int TOKEN_COMMA = 0;
    public static final int TOKEN_LEFT_PARENTHESIS = 1;
    public static final int TOKEN_RIGHT_PARENTHESIS = 2;
    public static final int TOKEN_LEFT_BRACKET = 3;
    public static final int TOKEN_RIGHT_BRACKET = 4;
    public static final int TOKEN_LEFT_BRACE = 5;
    public static final int TOKEN_RIGHT_BRACE = 6;
    public static final int TOKEN_PLUS = 7;
    public static final int TOKEN_MINUS = 8;
    public static final int TOKEN_TIMES = 9;
    public static final int TOKEN_DIVIDE = 10;
    public static final int TOKEN_POWER = 11;
    public static final int TOKEN_FACTORIAL = 12;
    public static final int TOKEN_FACTORIAL2 = 13;
    public static final int TOKEN_EQUAL = 14;
    public static final int TOKEN_UNEQUAL = 15;
    public static final int TOKEN_LESS = 16;
    public static final int TOKEN_GREATER = 17;
    public static final int TOKEN_LESSEQUAL = 18;
    public static final int TOKEN_GREATEREQUAL = 19;
    public static final int TOKEN_RIGHT_ARROW = 20;
    public static final int TOKEN_IDENTIFIER = 21;
    public static final int TOKEN_NUMBER = 22;
    public static final int TOKEN_STRING = 23;
    public static final int TOKEN_TERMINATE = 24;
    public static final int TOKEN_NONE = 25;
    public static final int TOKEN_VOID = 26;
    public static final int TOKEN_UNARY_PLUS = 27;
    public static final int TOKEN_UNARY_MINUS = 28;
    public static final int TOKEN_INVALID_IDENTIFIER = 29;
    public static final int TOKEN_FUNCTION_IDENTIFIER = 30;
    public static final int TOKEN_INEQUALITY = 31;
    public static final int TOKEN_AND = 32;
    public static final int TOKEN_OR = 33;
    public static final int TOKEN_NOT = 34;
    public static final int TOKEN_SEMICOLON = 35;
    public static final int TOKEN_SET = 36;
    static String structure_characters = ",()[]{}";
    static String number_start = "+-.0123456789";
    static String digit_characters = "0123456789";
    static String octal_digits = "01234567";
    static String hexadecimal_digits = "0123456789abcdefABCDEF";
    int scanned_token_type;
    double scanned_number;
    String scanned_identifier;
    String scanned_string;
    int scanned_function_identifier;
    static int max_length_identifier = 100;
    char[] scanned_identifier_chars = new char[max_length_identifier];
    boolean scanned_left_bracket;
    boolean is_scanning_expression = false;
    boolean is_scanning_after_operand = false;
    public static int CONSTRUCT_NONE = 0;
    public static int CONSTRUCT_FUNCTION = 1;
    public static int CONSTRUCT_SYMBOL = 2;
    public static int CONSTRUCT_LIST = 3;
    public static int CONSTRUCT_RULE = 4;
    public static int CONSTRUCT_UNIDENTIFIED = 5;
    static String name_ShowAnimation = "ShowAnimation";
    static String name_Animate = "Animate";
    static String name_AnimationDisplayTime = "AnimationDisplayTime";
    static String name_AnimationDirection = "AnimationDirection";
    static String name_Forward = "Forward";
    static String name_Backward = "Backward";
    static String name_ForwardBackward = "ForwardBackward";
    static String name_Graphics3D = "Graphics3D";
    static String name_Scaled = "Scaled";
    static String name_Cuboid = "Cuboid";
    static String name_Line = "Line";
    static String name_Point = "Point";
    static String name_Polygon = "Polygon";
    static String name_Text = "Text";
    static String name_StyleForm = "StyleForm";
    static String name_Questionmark = "?";
    static String name_TextStyle = "TextStyle";
    static String name_FontWeight = "FontWeight";
    static String name_Bold = "Bold";
    static String name_FontSize = "FontSize";
    static String name_FontSlant = "FontSlant";
    static String name_Italic = "Italic";
    static String name_FontFamily = "FontFamily";
    static String name_FontColor = "FontColor";
    static String name_URL = "URL";
    static String name_AbsolutePointSize = "AbsolutePointSize";
    static String name_AbsoluteThickness = "AbsoluteThickness";
    static String name_CMYKColor = "CMYKColor";
    static String name_EdgeForm = "EdgeForm";
    static String name_FaceForm = "FaceForm";
    static String name_GrayLevel = "GrayLevel";
    static String name_Hue = "Hue";
    static String name_PointSize = "PointSize";
    static String name_RGBColor = "RGBColor";
    static String name_SurfaceColor = "SurfaceColor";
    static String name_Thickness = "Thickness";
    static String name_AmbientLight = "AmbientLight";
    static String name_Axes = "Axes";
    static String name_AxesLabel = "AxesLabel";
    static String name_AxesEdge = "AxesEdge";
    static String name_AxesStyle = "AxesStyle";
    static String name_PlotLabel = "PlotLabel";
    static String name_Background = "Background";
    static String name_Boxed = "Boxed";
    static String name_BoxRatios = "BoxRatios";
    static String name_BoxStyle = "BoxStyle";
    static String name_DefaultColor = "DefaultColor";
    static String name_Lighting = "Lighting";
    static String name_LightSources = "LightSources";
    static String name_PlotRange = "PlotRange";
    static String name_Ticks = "Ticks";
    static String name_ViewPoint = "ViewPoint";
    static String name_ViewVertical = "ViewVertical";
    static String name_True = "True";
    static String name_False = "False";
    static String name_Automatic = "Automatic";
    static String name_All = "All";
    static String name_None = "None";
    static String name_Catalan = "Catalan";
    static String name_Degree = "Degree";
    static String name_E = "E";
    static String name_EulerGamma = "EulerGamma";
    static String name_Glaisher = "Glaisher";
    static String name_GoldenRatio = "GoldenRatio";
    static String name_Khinchin = "Khinchin";
    static String name_Pi = "Pi";
    static String name_I = "I";
    static String name_Infinity = "Infinity";
    static String name_Indeterminate = "Indeterminate";
    static String name_ComplexInfinity = "ComplexInfinity";
    static final int FUNCTION_N = 0;
    static final int FUNCTION_PLUS = 1;
    static final int FUNCTION_SUBTRACT = 2;
    static final int FUNCTION_MINUS = 3;
    static final int FUNCTION_TIMES = 4;
    static final int FUNCTION_DIVIDE = 5;
    static final int FUNCTION_POWER = 6;
    static final int FUNCTION_ABS = 7;
    static final int FUNCTION_SIGN = 8;
    static final int FUNCTION_ROUND = 9;
    static final int FUNCTION_INTEGERPART = 10;
    static final int FUNCTION_FRACTIONALPART = 11;
    static final int FUNCTION_FLOOR = 12;
    static final int FUNCTION_CEILING = 13;
    static final int FUNCTION_CHOP = 14;
    static final int FUNCTION_MAX = 15;
    static final int FUNCTION_MIN = 16;
    static final int FUNCTION_RE = 17;
    static final int FUNCTION_IM = 18;
    static final int FUNCTION_CONJUGATE = 19;
    static final int FUNCTION_ARG = 20;
    static final int FUNCTION_MOD = 21;
    static final int FUNCTION_QUOTIENT = 22;
    static final int FUNCTION_RANDOM = 23;
    static final int FUNCTION_SEEDRANDOM = 24;
    static final int FUNCTION_LOG = 25;
    static final int FUNCTION_EXP = 26;
    static final int FUNCTION_SQRT = 27;
    static final int FUNCTION_SIN = 28;
    static final int FUNCTION_COS = 29;
    static final int FUNCTION_TAN = 30;
    static final int FUNCTION_CSC = 31;
    static final int FUNCTION_SEC = 32;
    static final int FUNCTION_COT = 33;
    static final int FUNCTION_ARCSIN = 34;
    static final int FUNCTION_ARCCOS = 35;
    static final int FUNCTION_ARCTAN = 36;
    static final int FUNCTION_ARCCSC = 37;
    static final int FUNCTION_ARCSEC = 38;
    static final int FUNCTION_ARCCOT = 39;
    static final int FUNCTION_SINH = 40;
    static final int FUNCTION_COSH = 41;
    static final int FUNCTION_TANH = 42;
    static final int FUNCTION_CSCH = 43;
    static final int FUNCTION_SECH = 44;
    static final int FUNCTION_COTH = 45;
    static final int FUNCTION_ARCSINH = 46;
    static final int FUNCTION_ARCCOSH = 47;
    static final int FUNCTION_ARCTANH = 48;
    static final int FUNCTION_ARCCSCH = 49;
    static final int FUNCTION_ARCSECH = 50;
    static final int FUNCTION_ARCCOTH = 51;
    static final int FUNCTION_FACTORIAL = 52;
    static final int FUNCTION_FACTORIAL2 = 53;
    static final int FUNCTION_BINOMIAL = 54;
    static final int FUNCTION_MULTINOMIAL = 55;
    static final int FUNCTION_POCHHAMMER = 56;
    static final int FUNCTION_GAMMA = 57;
    static final int FUNCTION_LOGGAMMA = 58;
    static final int FUNCTION_POWERMOD = 59;
    static final int FUNCTION_ERF = 60;
    static final int FUNCTION_ERFC = 61;
    static final int FUNCTION_ERFI = 62;
    static final int FUNCTION_RATIONALIZE = 63;
    static final int FUNCTION_EQUAL = 64;
    static final int FUNCTION_UNEQUAL = 65;
    static final int FUNCTION_LESS = 66;
    static final int FUNCTION_GREATER = 67;
    static final int FUNCTION_LESSEQUAL = 68;
    static final int FUNCTION_GREATEREQUAL = 69;
    static final int FUNCTION_NUMBERQ = 70;
    static final int FUNCTION_NUMERICQ = 71;
    static final int FUNCTION_INTEGERQ = 72;
    static final int FUNCTION_EVENQ = 73;
    static final int FUNCTION_ODDQ = 74;
    static final int FUNCTION_POSITIVE = 75;
    static final int FUNCTION_NEGATIVE = 76;
    static final int FUNCTION_NONPOSITIVE = 77;
    static final int FUNCTION_NONNEGATIVE = 78;
    static final int FUNCTION_TRUEQ = 79;
    static final int FUNCTION_VALUEQ = 80;
    static final int FUNCTION_NOT = 81;
    static final int FUNCTION_AND = 82;
    static final int FUNCTION_OR = 83;
    static final int FUNCTION_XOR = 84;
    static final int FUNCTION_IMPLIES = 85;
    static final int FUNCTION_IF = 86;
    static final int FUNCTION_WHICH = 87;
    static final int FUNCTION_SWITCH = 88;
    static final int FUNCTION_IDENTITY = 89;
    static final int FUNCTION_EVALUATE = 90;
    static final int FUNCTION_HOLD = 91;
    static final int FUNCTION_HOLDCOMPLETE = 92;
    static final int FUNCTION_HOLDFORM = 93;
    static final int FUNCTION_RELEASEHOLD = 94;
    static final int FUNCTION_NUMBERFORM = 95;
    static final int FUNCTION_SCIENTIFICFORM = 96;
    static final int FUNCTION_ENGINEERINGFORM = 97;
    static final int FUNCTION_ACCOUNTINGFORM = 98;
    static final int FUNCTION_PADDEDFORM = 99;
    static final int FUNCTION_STANDARDFORM = 100;
    static final int FUNCTION_TRADITIONALFORM = 101;
    static final int FUNCTION_INPUTFORM = 102;
    static final int FUNCTION_OUTPUTFORM = 103;
    static final int FUNCTION_DISPLAYFORM = 104;
    static final int FUNCTION_FULLFORM = 105;
    static final int FUNCTION_SESSIONTIME = 106;
    static final int FUNCTION_TIMEUSED = 107;
    static final int FUNCTION_ABSOLUTETIME = 108;
    static final int FUNCTION_DISCRETEDELTA = 109;
    static final int FUNCTION_KRONECKERDELTA = 110;
    static final int FUNCTION_UNITSTEP = 111;
    static final int FUNCTION_BETA = 112;
    static final int FUNCTION_SET = 113;
    static final int FUNCTIONS_COUNT = 114;
    static String[] function_names = new String[]{"N", "Plus", "Subtract", "Minus", "Times", "Divide", "Power", "Abs", "Sign", "Round", "IntegerPart", "FractionalPart", "Floor", "Ceiling", "Chop", "Max", "Min", "Re", "Im", "Conjugate", "Arg", "Mod", "Quotient", "Random", "SeedRandom", "Log", "Exp", "Sqrt", "Sin", "Cos", "Tan", "Csc", "Sec", "Cot", "ArcSin", "ArcCos", "ArcTan", "ArcCsc", "ArcSec", "ArcCot", "Sinh", "Cosh", "Tanh", "Csch", "Sech", "Coth", "ArcSinh", "ArcCosh", "ArcTanh", "ArcCsch", "ArcSech", "ArcCoth", "Factorial", "Factorial2", "Binomial", "Multinomial", "Pochhammer", "Gamma", "LogGamma", "PowerMod", "Erf", "Erfc", "Erfi", "Rationalize", "Equal", "Unequal", "Less", "Greater", "LessEqual", "GreaterEqual", "NumberQ", "NumericQ", "IntegerQ", "EvenQ", "OddQ", "Positive", "Negative", "NonPositive", "NonNegative", "TrueQ", "ValueQ", "Not", "And", "Or", "Xor", "Implies", "If", "Which", "Switch", "Identity", "Evaluate", "Hold", "HoldComplete", "HoldForm", "ReleaseHold", "NumberForm", "ScientificForm", "EngineeringForm", "AccountingForm", "PaddedForm", "StandardForm", "TraditionalForm", "InputForm", "OutputForm", "DisplayForm", "FullForm", "SessionTime", "TimeUsed", "AbsoluteTime", "DiscreteDelta", "KroneckerDelta", "UnitStep", "Beta", "Set"};
    boolean scanning_EdgeForm;
    boolean scanning_FaceForm;
    boolean scanning_FaceForm_back;
    boolean scanning_SurfaceColor;
    boolean scanning_SurfaceColor_specular;
    boolean scanning_AxesStyles;
    double scanned_AnimationDisplayTime = 0.05;
    int scanned_AnimationDirection = 1;
    double scanned_Animate_min = 0.0;
    double scanned_Animate_max = 0.0;
    double scanned_Animate_step = 1.0;
    int scanned_Animate_variable = -1;
    Vector scanned_frames;
    boolean scanning_animation_option = false;
    Graphics3D graphics;
    boolean is_scanned_AmbientLight;
    boolean is_scanned_Axes;
    boolean is_scanned_AxesLabel;
    boolean is_scanned_AxesStyle;
    boolean is_scanned_AxesEdge;
    boolean is_scanned_Ticks;
    boolean is_scanned_PlotLabel;
    boolean is_scanned_Background;
    boolean is_scanned_DefaultColor;
    boolean is_scanned_BoxStyle;
    boolean is_scanned_Boxed;
    boolean is_scanned_Lighting;
    boolean is_scanned_BoxRatios;
    boolean is_scanned_PlotRange;
    boolean is_scanned_LightSources;
    boolean is_scanned_ViewPoint;
    boolean is_scanned_ViewVertical;
    boolean is_scanned_TextStyle;
    boolean scanned_nothing;
    boolean scanned_unidentified;
    int recursion_depth = 0;
    Primitive3D[] scanned_AxesStyles = new Primitive3D[]{null, null, null};
    static int max_count_scanned_numbers = 4;
    double[] scanned_numbers = new double[max_count_scanned_numbers];
    int count_scanned_numbers;
    int count_scanned_points;
    double[][] scanned_points;
    double[][] scanned_scaled_offsets;
    int[][] scanned_expressions;
    Vector points_scanned;
    Vector scaled_offsets_scanned;
    Vector expressions_scanned;
    Color scanned_color;
    String scanned_font_url;
    String scanned_font_family;
    int scanned_font_weight;
    int scanned_font_slant;
    int scanned_font_size;
    Color scanned_font_color;
    Color scanned_font_background;
    int scanned_expression;
    boolean is_scanned_expression_numeric;
    static int[] arguments_counts = new int[1000];

    public Parser(String string, Evaluator evaluator) {
        this.evaluator = evaluator;
        this.set_text(string);
    }

    public void set_text(String string) {
        this.text = string;
        this.text_index = -1;
        this.current_char = '\u0000';
        this.last_text_index = -1;
        this.last_char = '\u0000';
        this.is_scanning_expression = false;
        this.is_scanning_after_operand = false;
    }

    Color copied_color(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    /*
     * Unable to fully structure code
     */
    char next_char() {
        var1_1 = false;
        this.last_char = this.current_char;
        this.last_text_index = this.text_index++;
        if (this.text_index >= 0 && this.text_index < this.text.length()) ** GOTO lbl91
        this.current_char = (char)12;
        return this.current_char;
lbl-1000:
        // 1 sources

        {
            this.current_char = this.text.charAt(this.text_index);
            if (this.current_char == '\\' && this.text_index + 1 < this.text.length()) {
                ++this.text_index;
                this.current_char = this.text.charAt(this.text_index);
                if (this.current_char == '[') {
                    var2_2 = ++this.text_index;
                    while (this.text_index < this.text.length() && (Character.isLetterOrDigit(this.text.charAt(this.text_index)) || Parser.breaking_chars.indexOf(this.text.charAt(this.text_index)) >= 0)) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length() || this.text.charAt(this.text_index) != ']') {
                        this.text_index = this.last_text_index + 1;
                        this.current_char = (char)92;
                        var1_1 = true;
                        continue;
                    }
                    var3_3 = this.text.substring(var2_2, this.text_index);
                    var4_4 = -1;
                    var6_6 = 0;
                    block2: while (var4_4 != var3_3.length()) {
                        var4_4 = var3_3.length();
                        var7_7 = 0;
                        while ((var5_5 = Parser.standard_parts[var7_7].length()) > 0) {
                            if (var3_3.regionMatches(var6_6, Parser.standard_parts[var7_7], 0, var5_5)) {
                                var3_3 = String.valueOf(var3_3.substring(0, var6_6)) + Parser.standard_short_parts[var7_7] + var3_3.substring(var6_6 + var5_5);
                                ++var6_6;
                                continue block2;
                            }
                            ++var7_7;
                        }
                    }
                    var7_7 = -1;
                    if (var3_3.equals("n")) {
                        var7_7 = 172;
                    } else if (var3_3.length() >= 2) {
                        var6_6 = 0;
                        var8_8 = var3_3.substring(0, 2);
                        while (var6_6 >= 0) {
                            if ((var6_6 = Parser.coded_char_names.indexOf((String)var8_8, var6_6 + 1)) < 0 || !Character.isDigit(Parser.coded_char_names.charAt(var6_6 - 1))) continue;
                            var9_9 = var6_6 + 2;
                            while (!Character.isDigit(Parser.coded_char_names.charAt(var9_9))) {
                                ++var9_9;
                            }
                            var10_10 = var9_9 + 1;
                            while (Character.isDigit(Parser.coded_char_names.charAt(var10_10))) {
                                ++var10_10;
                            }
                            if (!var3_3.regionMatches(0, Parser.coded_char_names, var6_6, var9_9 - var6_6)) continue;
                            var6_6 = -1;
                            var7_7 = Integer.parseInt(Parser.coded_char_names.substring(var9_9, var10_10));
                        }
                    }
                    if (var7_7 >= 0) {
                        var8_8 = new byte[]{(byte)(var7_7 % 256)};
                        this.current_char = new String((byte[])var8_8, var7_7 / 256).charAt(0);
                    } else {
                        this.current_char = (char)191;
                    }
                    var1_1 = true;
                    continue;
                }
                if (Parser.white_characters.indexOf(this.current_char) >= 0) {
                    ++this.text_index;
                    while (this.text_index < this.text.length() && Parser.white_characters.indexOf(this.text.charAt(this.text_index)) >= 0) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length()) {
                        this.text_index = this.text.length() - 1;
                        this.current_char = (char)32;
                        var1_1 = true;
                        continue;
                    }
                    var1_1 = false;
                    continue;
                }
                this.current_char = (char)92;
                --this.text_index;
                var1_1 = true;
                continue;
            }
            if (Parser.single_quote_chars.indexOf(this.current_char) >= 0 && this.text_index + 1 < this.text.length() && Parser.single_quote_chars.indexOf(this.text.charAt(this.text_index + 1)) >= 0) {
                this.current_char = (char)34;
                ++this.text_index;
                var1_1 = true;
                continue;
            }
            if (this.current_char == '(' && this.text_index + 1 < this.text.length() && this.text.charAt(this.text_index + 1) == '*') {
                this.text_index = this.text.indexOf(Parser.comment_end, this.text_index + 1);
                this.text_index = this.text_index == -1 ? this.text.length() - 1 : ++this.text_index;
                this.current_char = (char)32;
                var1_1 = true;
                continue;
            }
            var1_1 = true;
lbl91:
            // 9 sources

            ** while (!var1_1)
        }
lbl92:
        // 1 sources

        return this.current_char;
    }

    void unget_char() {
        this.current_char = this.last_char;
        this.text_index = this.last_text_index;
    }

    char first_non_white_char() {
        while (this.text_index < this.text.length() && white_characters.indexOf(this.current_char) >= 0) {
            this.next_char();
        }
        return this.current_char;
    }

    void scan_real() {
        int n = 1;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        this.is_scanned_real = false;
        if (this.current_char == '-') {
            n = -1;
            this.next_char();
        } else if (this.current_char == '+') {
            this.next_char();
        }
        int n3 = digit_characters.indexOf(this.current_char);
        if (n3 >= 0) {
            this.is_scanned_real = true;
        }
        while (n3 >= 0) {
            d = 10.0 * d + (double)n3;
            n3 = digit_characters.indexOf(this.next_char());
        }
        if (this.current_char == '.') {
            n3 = digit_characters.indexOf(this.next_char());
            if (n3 >= 0) {
                this.is_scanned_real = true;
            }
            while (n3 >= 0) {
                d2 = 10.0 * d2 + (double)n3;
                ++n2;
                n3 = digit_characters.indexOf(this.next_char());
            }
        }
        if (this.is_scanned_real) {
            this.scanned_real = n2 == 0 ? (double)n * d : (double)n * (d + Math.pow(0.1, n2) * d2);
        }
    }

    void scan_token() {
        if (this.text_index < 0) {
            this.text_index = -1;
            this.next_char();
        }
        this.first_non_white_char();
        while (this.text_index < this.text.length()) {
            if (this.is_scanning_expression && this.current_char == '-') {
                if (this.next_char() == '>') {
                    this.scanned_token_type = 20;
                    this.is_scanning_after_operand = false;
                    this.next_char();
                    return;
                }
                if (this.is_scanning_after_operand) {
                    this.scanned_token_type = 8;
                    this.is_scanning_after_operand = false;
                } else {
                    this.scanned_token_type = 28;
                }
                return;
            }
            if (this.is_scanning_expression && this.current_char == '+') {
                if (this.is_scanning_after_operand) {
                    this.scanned_token_type = 7;
                    this.is_scanning_after_operand = false;
                } else {
                    this.scanned_token_type = 27;
                }
                this.next_char();
                return;
            }
            if (number_start.indexOf(this.current_char) >= 0) {
                if (this.is_scanning_expression && this.is_scanning_after_operand) {
                    this.scanned_token_type = 9;
                    this.is_scanning_after_operand = false;
                    return;
                }
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 1.0;
                boolean bl = false;
                if (this.current_char == '-') {
                    d3 = -1.0;
                    this.next_char();
                    if (this.current_char == '>') {
                        this.scanned_token_type = 20;
                        this.next_char();
                        return;
                    }
                    if (this.current_char == '(') {
                        bl = true;
                        this.next_char();
                    }
                }
                this.scan_real();
                if (this.is_scanned_real) {
                    d = this.scanned_real;
                    if (this.current_char == '`') {
                        this.next_char();
                        if (this.current_char == '`') {
                            this.next_char();
                        }
                        this.scan_real();
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (this.current_char == '*' || this.current_char == 'e' || this.current_char == 'E') {
                        bl2 = true;
                        if (this.current_char == 'e' || this.current_char == 'E') {
                            bl3 = true;
                        } else if (this.next_char() == '1') {
                            if (this.next_char() == '0' && this.next_char() == '^') {
                                bl3 = true;
                            }
                        } else if (this.current_char == '^') {
                            bl3 = true;
                        } else {
                            this.unget_char();
                            bl2 = false;
                        }
                        if (bl3) {
                            this.next_char();
                            this.scan_real();
                            if (this.is_scanned_real) {
                                d2 = this.scanned_real;
                            } else {
                                bl3 = false;
                            }
                        }
                    }
                    if (!bl || this.current_char == ')') {
                        if (bl) {
                            this.next_char();
                        }
                        if (bl3 || !bl2) {
                            this.scanned_number = d3 * d * Math.pow(10.0, d2);
                            this.scanned_token_type = 22;
                            if (this.is_scanning_expression) {
                                this.is_scanning_after_operand = true;
                            }
                            return;
                        }
                    }
                }
            } else {
                if (Character.isLetterOrDigit(this.current_char) || this.current_char == '$') {
                    if (this.is_scanning_expression && this.is_scanning_after_operand) {
                        this.scanned_token_type = 9;
                        this.is_scanning_after_operand = false;
                        return;
                    }
                    this.scanned_identifier_chars[0] = this.current_char;
                    int n = 1;
                    while (Character.isLetterOrDigit(this.next_char()) || this.current_char == '$') {
                        if (n >= max_length_identifier) continue;
                        this.scanned_identifier_chars[n] = this.current_char;
                        ++n;
                    }
                    this.scanned_identifier = new String(this.scanned_identifier_chars, 0, n);
                    if (this.is_scanning_expression) {
                        this.is_scanning_after_operand = true;
                    }
                    this.scanned_left_bracket = this.first_non_white_char() == '[';
                    this.scanned_token_type = 21;
                    return;
                }
                if (structure_characters.indexOf(this.current_char) >= 0) {
                    this.scanned_token_type = structure_characters.indexOf(this.current_char);
                    if (this.is_scanning_expression) {
                        if (this.scanned_token_type == 1 && this.is_scanning_after_operand) {
                            this.scanned_token_type = 9;
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        this.is_scanning_after_operand = this.scanned_token_type == 2 || this.scanned_token_type == 4 || this.scanned_token_type == 6;
                    }
                    this.next_char();
                    return;
                }
                if (this.current_char == ':') {
                    if (this.next_char() == '>') {
                        this.scanned_token_type = 20;
                        this.next_char();
                        if (this.is_scanning_expression) {
                            this.is_scanning_after_operand = false;
                        }
                        return;
                    }
                } else if (this.current_char == '\"') {
                    StringBuffer stringBuffer = new StringBuffer(60);
                    this.next_char();
                    while (this.text_index < this.text.length() && this.current_char != '\"') {
                        if (this.current_char == '\\') {
                            this.next_char();
                            if (this.current_char == 'n') {
                                stringBuffer.append('\n');
                            } else if (this.current_char == 'b') {
                                stringBuffer.append('\b');
                            } else if (this.current_char == 't') {
                                stringBuffer.append('\t');
                            } else if (this.current_char == 'r') {
                                stringBuffer.append('\r');
                            } else if (this.current_char == 'f') {
                                stringBuffer.append('\f');
                            } else if (single_quote_chars.indexOf(this.current_char) >= 0 || this.current_char == '\"' || this.current_char == '\\') {
                                stringBuffer.append(this.current_char);
                                this.current_char = (char)92;
                            } else if (octal_digits.indexOf(this.current_char) >= 0 || this.current_char == '.' || this.current_char == ':') {
                                int n = 3;
                                int n2 = 0;
                                if (this.current_char == '.') {
                                    n = 2;
                                    this.next_char();
                                }
                                if (this.current_char == ':') {
                                    n = 4;
                                    this.next_char();
                                }
                                int n3 = 0;
                                while (n3 < n) {
                                    int n4 = hexadecimal_digits.indexOf(this.current_char);
                                    if (n4 < 0) break;
                                    if (n4 >= 16) {
                                        n4 -= 6;
                                    }
                                    n2 = n == 3 ? n2 * 8 + n4 : n2 * 16 + n4;
                                    if (n3 + 1 < n) {
                                        this.next_char();
                                    }
                                    ++n3;
                                }
                                byte[] byArray = new byte[]{(byte)(n2 % 256)};
                                stringBuffer.append(new String(byArray, n2 / 256));
                                if (n3 < n) {
                                    stringBuffer.append(this.current_char);
                                }
                            } else {
                                stringBuffer.append('\\');
                                stringBuffer.append(this.current_char);
                            }
                        } else if (this.current_char != '\n' && this.current_char != '\r' && this.current_char != '\t' && this.current_char != '\f') {
                            stringBuffer.append(this.current_char);
                        }
                        this.next_char();
                    }
                    if (this.text_index < this.text.length()) {
                        this.scanned_token_type = 23;
                        this.scanned_string = new String(stringBuffer);
                        if (this.is_scanning_expression) {
                            this.is_scanning_after_operand = true;
                        }
                        this.next_char();
                        return;
                    }
                } else if (this.is_scanning_expression) {
                    if (this.current_char == '*') {
                        this.scanned_token_type = 9;
                        this.is_scanning_after_operand = false;
                        this.next_char();
                        return;
                    }
                    if (this.current_char == '/') {
                        this.scanned_token_type = 10;
                        this.is_scanning_after_operand = false;
                        this.next_char();
                        return;
                    }
                    if (this.current_char == '^') {
                        this.scanned_token_type = 11;
                        this.is_scanning_after_operand = false;
                        this.next_char();
                        return;
                    }
                    if (this.current_char == '!') {
                        if (!this.is_scanning_after_operand) {
                            this.scanned_token_type = 34;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        this.next_char();
                        if (this.current_char == '=') {
                            this.scanned_token_type = 15;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if (this.current_char == '!') {
                            this.scanned_token_type = 13;
                            this.is_scanning_after_operand = true;
                            this.next_char();
                            return;
                        }
                        this.scanned_token_type = 12;
                        this.is_scanning_after_operand = true;
                        return;
                    }
                    if (this.current_char == '=') {
                        if (this.next_char() == '=') {
                            this.scanned_token_type = 14;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        this.scanned_token_type = 36;
                        this.is_scanning_after_operand = false;
                        return;
                    }
                    if (this.current_char == '<') {
                        if (this.next_char() == '=') {
                            this.scanned_token_type = 18;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        this.scanned_token_type = 16;
                        this.is_scanning_after_operand = false;
                        return;
                    }
                    if (this.current_char == '>') {
                        if (this.next_char() == '=') {
                            this.scanned_token_type = 19;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        this.scanned_token_type = 17;
                        this.is_scanning_after_operand = false;
                        return;
                    }
                    if (this.current_char == '&') {
                        if (this.next_char() == '&') {
                            this.scanned_token_type = 32;
                            this.next_char();
                            this.is_scanning_after_operand = false;
                            return;
                        }
                    } else if (this.current_char == '|') {
                        if (this.next_char() == '|') {
                            this.scanned_token_type = 33;
                            this.next_char();
                            this.is_scanning_after_operand = false;
                            return;
                        }
                    } else if (this.current_char == ';') {
                        this.scanned_token_type = 35;
                        this.next_char();
                        this.is_scanning_after_operand = false;
                        return;
                    }
                }
            }
            this.scan_salt();
        }
        this.scanned_token_type = this.is_scanning_expression ? 24 : 25;
    }

    void scan_salt() {
        int n = 0;
        while (this.text_index < this.text.length()) {
            if (this.current_char == '\"') {
                this.next_char();
                while (this.text_index < this.text.length() && this.current_char != '\"') {
                    if (this.current_char == '\\') {
                        this.next_char();
                    }
                    this.next_char();
                }
            } else if (structure_characters.indexOf(this.current_char) >= 0) {
                if (this.current_char == '(' || this.current_char == '{' || this.current_char == '[') {
                    ++n;
                } else if (this.current_char == ')' || this.current_char == '}' || this.current_char == ']' ? --n < 0 : this.current_char == ',' && n == 0) break;
            }
            this.next_char();
        }
    }

    void scan_right_bracket() {
        this.scan_salt();
        while (this.text_index < this.text.length() && this.current_char == ',') {
            this.next_char();
            this.scan_salt();
        }
        this.scan_token();
        if (this.scanned_token_type != 4 && this.scanned_token_type != 2 && this.scanned_token_type != 6) {
            this.scanned_token_type = 25;
        }
    }

    public boolean scan_animation() {
        this.text_index = -1;
        this.scanned_AnimationDisplayTime = 0.05;
        this.scanned_AnimationDirection = 1;
        this.scanned_Animate_min = 0.0;
        this.scanned_Animate_max = 0.0;
        this.scanned_Animate_step = 1.0;
        this.scanned_Animate_variable = -1;
        this.scanned_frames = new Vector();
        this.scanning_animation_option = false;
        this.scan_token();
        if (this.scanned_token_type != 21) {
            return false;
        }
        if (this.scanned_identifier.equals(name_Graphics3D)) {
            if (!this.scan_Graphics3D()) {
                return false;
            }
            this.scanned_frames.addElement(this.graphics);
        } else if (this.scanned_identifier.equals(name_ShowAnimation)) {
            this.scan_token();
            if (this.scanned_token_type != 3) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type == 21 && this.scanned_identifier.equals(name_Graphics3D)) {
                if (!this.scan_Graphics3D()) {
                    return false;
                }
                this.scanned_frames.addElement(this.graphics);
            } else if (this.scanned_token_type == 5) {
                this.scanned_token_type = 0;
                while (this.scanned_token_type == 0) {
                    this.scan_token();
                    if (!this.scan_Graphics3D()) {
                        return false;
                    }
                    this.scanned_frames.addElement(this.graphics);
                    this.scan_token();
                }
                if (this.scanned_token_type != 6) {
                    return false;
                }
            } else {
                return false;
            }
            this.scan_token();
            this.scanning_animation_option = true;
            this.init_scan_Graphics3D();
            while (this.scanned_token_type == 0) {
                if (!this.scan_option()) {
                    return false;
                }
                this.scan_token();
            }
            if (this.scanned_token_type != 4) {
                return false;
            }
            this.distribute_options(this.scanned_frames);
        } else if (this.scanned_identifier.equals(name_Animate)) {
            this.scan_token();
            if (this.scanned_token_type != 3) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 21 || !this.scanned_identifier.equals(name_Graphics3D)) {
                return false;
            }
            if (!this.scan_Graphics3D()) {
                return false;
            }
            this.scanned_frames.addElement(this.graphics);
            this.scan_token();
            if (this.scanned_token_type != 0) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 5) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 21) {
                return false;
            }
            this.scanned_Animate_variable = this.evaluator.getVariableIndex(this.scanned_identifier);
            if (this.scanned_Animate_variable < 0) {
                return false;
            }
            if (!this.evaluator.isVariableIndependent(this.scanned_Animate_variable)) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 0) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 22) {
                return false;
            }
            this.scanned_Animate_min = this.scanned_number;
            this.scan_token();
            if (this.scanned_token_type != 0) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 22) {
                return false;
            }
            this.scanned_Animate_max = this.scanned_number;
            this.scan_token();
            if (this.scanned_token_type == 0) {
                this.scan_token();
                if (this.scanned_token_type != 22) {
                    return false;
                }
                this.scanned_Animate_step = this.scanned_number;
                this.scan_token();
            } else {
                this.scanned_Animate_step = 1.0;
            }
            if (this.scanned_token_type != 6) {
                return false;
            }
            this.scan_token();
            this.scanning_animation_option = true;
            this.init_scan_Graphics3D();
            while (this.scanned_token_type == 0) {
                if (!this.scan_option()) {
                    return false;
                }
                this.scan_token();
            }
            if (this.scanned_token_type != 4) {
                return false;
            }
            this.distribute_options(this.scanned_frames);
        } else {
            return false;
        }
        return true;
    }

    public void init_scan_Graphics3D() {
        this.graphics = new Graphics3D();
        this.scanning_EdgeForm = false;
        this.scanning_FaceForm = false;
        this.scanning_SurfaceColor = false;
        this.is_scanned_AmbientLight = false;
        this.is_scanned_Axes = false;
        this.is_scanned_AxesLabel = false;
        this.is_scanned_AxesStyle = false;
        this.is_scanned_AxesEdge = false;
        this.is_scanned_Ticks = false;
        this.is_scanned_PlotLabel = false;
        this.is_scanned_Background = false;
        this.is_scanned_DefaultColor = false;
        this.is_scanned_BoxStyle = false;
        this.is_scanned_Boxed = false;
        this.is_scanned_Lighting = false;
        this.is_scanned_BoxRatios = false;
        this.is_scanned_PlotRange = false;
        this.is_scanned_LightSources = false;
        this.is_scanned_ViewPoint = false;
        this.is_scanned_ViewVertical = false;
        this.is_scanned_TextStyle = false;
    }

    public void distribute_options(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Graphics3D graphics3D = (Graphics3D)vector.elementAt(n);
            if (this.is_scanned_AmbientLight) {
                graphics3D.option_AmbientLight = this.graphics.option_AmbientLight;
            }
            if (this.is_scanned_Axes) {
                graphics3D.option_Axes = this.graphics.option_Axes;
            }
            if (this.is_scanned_AxesLabel) {
                graphics3D.option_AxesLabel = this.graphics.option_AxesLabel;
            }
            if (this.is_scanned_AxesStyle) {
                graphics3D.option_AxesStyle = this.graphics.option_AxesStyle;
            }
            if (this.is_scanned_AxesEdge) {
                graphics3D.option_AxesEdge = this.graphics.option_AxesEdge;
            }
            if (this.is_scanned_Ticks) {
                graphics3D.option_Ticks = this.graphics.option_Ticks;
            }
            if (this.is_scanned_PlotLabel) {
                graphics3D.option_PlotLabel = this.graphics.option_PlotLabel;
            }
            if (this.is_scanned_Background) {
                graphics3D.option_Background = this.graphics.option_Background;
            }
            if (this.is_scanned_DefaultColor) {
                graphics3D.option_DefaultColor = this.graphics.option_DefaultColor;
            }
            if (this.is_scanned_BoxStyle) {
                graphics3D.option_BoxStyle = this.graphics.option_BoxStyle;
            }
            if (this.is_scanned_Boxed) {
                graphics3D.option_Boxed = this.graphics.option_Boxed;
            }
            if (this.is_scanned_Lighting) {
                graphics3D.option_Lighting = this.graphics.option_Lighting;
            }
            if (this.is_scanned_BoxRatios) {
                graphics3D.option_BoxRatios = this.graphics.option_BoxRatios;
            }
            if (this.is_scanned_PlotRange) {
                graphics3D.option_PlotRange = this.graphics.option_PlotRange;
            }
            if (this.is_scanned_LightSources) {
                graphics3D.option_LightSources_vectors = this.graphics.option_LightSources_vectors;
                graphics3D.option_LightSources_colors = this.graphics.option_LightSources_colors;
            }
            if (this.is_scanned_ViewPoint) {
                graphics3D.option_ViewPoint = this.graphics.option_ViewPoint;
            }
            if (this.is_scanned_ViewVertical) {
                graphics3D.option_ViewVertical = this.graphics.option_ViewVertical;
            }
            if (this.is_scanned_TextStyle) {
                graphics3D.option_TextStyle_font_url = this.graphics.option_TextStyle_font_url;
                graphics3D.option_TextStyle_font_family = this.graphics.option_TextStyle_font_family;
                graphics3D.option_TextStyle_font_weight = this.graphics.option_TextStyle_font_weight;
                graphics3D.option_TextStyle_font_slant = this.graphics.option_TextStyle_font_slant;
                graphics3D.option_TextStyle_font_size = this.graphics.option_TextStyle_font_size;
                graphics3D.option_TextStyle_font_color = this.graphics.option_TextStyle_font_color;
                graphics3D.option_TextStyle_font_background = this.graphics.option_TextStyle_font_background;
            }
            ++n;
        }
    }

    public boolean scan_Graphics3D() {
        this.init_scan_Graphics3D();
        Primitive3D primitive3D = new Primitive3D();
        if (this.scanned_token_type != 21 || !this.scanned_identifier.equals(name_Graphics3D)) {
            return false;
        }
        this.scan_token();
        if (this.scanned_token_type != 3) {
            return false;
        }
        if (!this.scan_primitive(primitive3D)) {
            return false;
        }
        this.scan_token();
        while (this.scanned_token_type == 0) {
            if (!this.scan_option()) {
                return false;
            }
            this.scan_token();
        }
        return this.scanned_token_type == 4;
    }

    boolean scan_primitive(Primitive3D primitive3D) {
        this.scanned_nothing = false;
        this.scanned_unidentified = false;
        this.scan_token();
        if (this.scanned_token_type == 5) {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm || this.scanning_AxesStyles && this.recursion_depth == 1) {
                primitive3D = new Primitive3D(primitive3D);
            }
            ++this.recursion_depth;
            while (this.scan_primitive(primitive3D)) {
                this.scan_token();
                if (this.scanned_token_type != 0) break;
            }
            --this.recursion_depth;
            if (this.scanned_token_type != 6) {
                return false;
            }
            if (this.scanning_AxesStyles && this.recursion_depth == 1) {
                this.scanned_AxesStyles[0] = this.scanned_AxesStyles[1];
                this.scanned_AxesStyles[1] = this.scanned_AxesStyles[2];
                this.scanned_AxesStyles[2] = primitive3D;
            }
            return true;
        }
        if (this.scanned_token_type != 21) {
            this.scanned_nothing = true;
            return false;
        }
        if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_EdgeForm)) {
            this.scan_token();
            if (this.scanned_token_type != 3) {
                return false;
            }
            this.scanning_EdgeForm = true;
            primitive3D.is_outlined = false;
            if (this.scan_primitive(primitive3D)) {
                this.scanning_EdgeForm = false;
                this.scan_token();
                return this.scanned_token_type == 4;
            }
            if (this.scanned_nothing && this.scanned_token_type == 4) {
                this.scanning_EdgeForm = false;
                return true;
            }
        } else {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_FaceForm)) {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                this.scanning_FaceForm = true;
                this.scanning_FaceForm_back = false;
                if (!this.scan_primitive(primitive3D)) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type == 0) {
                    this.scanning_FaceForm_back = true;
                    if (!this.scan_primitive(primitive3D)) {
                        this.scanning_FaceForm = false;
                        this.scanning_FaceForm_back = false;
                        return false;
                    }
                    this.scanning_FaceForm_back = false;
                    this.scan_token();
                }
                this.scanning_FaceForm = false;
                return this.scanned_token_type == 4;
            }
            if (!this.scanning_EdgeForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_SurfaceColor)) {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                this.scanning_SurfaceColor = true;
                this.scanning_SurfaceColor_specular = false;
                if (!this.scan_primitive(primitive3D)) {
                    this.scanning_SurfaceColor = false;
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type == 0) {
                    this.scanning_SurfaceColor_specular = true;
                    if (!this.scan_primitive(primitive3D)) {
                        this.scanning_SurfaceColor = false;
                        this.scanning_SurfaceColor_specular = false;
                        return false;
                    }
                    this.scanning_SurfaceColor = false;
                    this.scanning_SurfaceColor_specular = false;
                    this.scan_token();
                    if (this.scanned_token_type == 0) {
                        this.scan_token();
                        if (this.scanned_token_type != 22) {
                            return false;
                        }
                        if (!this.scanning_FaceForm_back) {
                            primitive3D.front_specular_exponent = this.scanned_number;
                        }
                        primitive3D.back_specular_exponent = this.scanned_number;
                        this.scan_token();
                    }
                }
                this.scanning_SurfaceColor = false;
                return this.scanned_token_type == 4;
            }
        }
        if (!this.scan_color()) {
            return false;
        }
        if (this.scanned_color != null) {
            if (this.scanning_SurfaceColor && !this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    primitive3D.front_diffuse_color = this.scanned_color;
                }
                primitive3D.back_diffuse_color = this.scanned_color;
            } else if (this.scanning_SurfaceColor && this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    primitive3D.front_specular_color = this.scanned_color;
                }
                primitive3D.back_specular_color = this.scanned_color;
            } else if (this.scanning_FaceForm) {
                if (!this.scanning_FaceForm_back) {
                    primitive3D.front_face_color = this.scanned_color;
                }
                primitive3D.back_face_color = this.scanned_color;
            } else if (this.scanning_EdgeForm) {
                primitive3D.edge_color = this.scanned_color;
                primitive3D.is_outlined = true;
            } else {
                primitive3D.standard_color = this.scanned_color;
                primitive3D.front_face_color = this.scanned_color;
                primitive3D.back_face_color = this.scanned_color;
            }
            return true;
        }
        if (!(this.scanning_SurfaceColor || this.scanning_EdgeForm || this.scanning_FaceForm)) {
            if (this.scanned_identifier.equals(name_PointSize)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                primitive3D.original_point_size = this.scanned_numbers[0];
                primitive3D.is_absolute_point_size = false;
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsolutePointSize)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                primitive3D.original_point_size = this.scanned_numbers[0];
                primitive3D.is_absolute_point_size = true;
                return true;
            }
        }
        if (!this.scanning_SurfaceColor && !this.scanning_FaceForm) {
            if (this.scanned_identifier.equals(name_Thickness)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    primitive3D.is_outlined = true;
                    primitive3D.original_edge_thickness = this.scanned_numbers[0];
                    primitive3D.is_absolute_edge_thickness = false;
                } else {
                    primitive3D.original_thickness = this.scanned_numbers[0];
                    primitive3D.is_absolute_thickness = false;
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsoluteThickness)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    primitive3D.is_outlined = true;
                    primitive3D.original_edge_thickness = this.scanned_numbers[0];
                    primitive3D.is_absolute_edge_thickness = true;
                } else {
                    primitive3D.original_thickness = this.scanned_numbers[0];
                    primitive3D.is_absolute_thickness = true;
                }
                return true;
            }
        }
        if (!(this.scanning_EdgeForm || this.scanning_FaceForm || this.scanning_SurfaceColor)) {
            if (this.scanned_identifier.equals(name_Point)) {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 4) {
                    return false;
                }
                Primitive3D primitive3D2 = new Primitive3D(primitive3D);
                primitive3D2.count_points = 1;
                primitive3D2.original_points = this.scanned_points;
                primitive3D2.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive3D2.original_expressions = this.scanned_expressions;
                primitive3D2.is_filled = false;
                primitive3D2.is_outlined = false;
                this.graphics.addPrimitive(primitive3D2);
                return true;
            }
            if (this.scanned_identifier.equals(name_Line)) {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 4) {
                    return false;
                }
                Primitive3D primitive3D3 = new Primitive3D(primitive3D);
                primitive3D3.count_points = this.count_scanned_points;
                primitive3D3.original_points = this.scanned_points;
                primitive3D3.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive3D3.original_expressions = this.scanned_expressions;
                primitive3D3.is_filled = false;
                primitive3D3.is_outlined = false;
                this.graphics.addPrimitive(primitive3D3);
                return true;
            }
            if (this.scanned_identifier.equals(name_Polygon)) {
                boolean[] blArray = null;
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type == 0) {
                    this.scan_salt();
                    this.scan_token();
                    if (this.scanned_token_type == 0) {
                        this.scan_token();
                        if (this.scanned_token_type != 5) {
                            this.scan_salt();
                            this.scan_token();
                        } else {
                            blArray = new boolean[this.count_scanned_points];
                            int n = 0;
                            while (this.scanned_token_type != 6) {
                                this.scan_token();
                                if (this.scanned_token_type != 21) {
                                    this.scan_salt();
                                    this.scan_token();
                                }
                                if (this.scanned_identifier.equals(name_True)) {
                                    if (n < this.count_scanned_points) {
                                        blArray[n] = true;
                                    }
                                    this.scan_token();
                                } else if (this.scanned_identifier.equals(name_False)) {
                                    if (n < this.count_scanned_points) {
                                        blArray[n] = false;
                                    }
                                    this.scan_token();
                                } else {
                                    this.scan_salt();
                                    this.scan_token();
                                }
                                if (this.scanned_token_type != 0 && this.scanned_token_type != 6) {
                                    return false;
                                }
                                ++n;
                            }
                            if (n != this.count_scanned_points) {
                                blArray = null;
                            }
                            this.scan_token();
                        }
                    }
                }
                if (this.scanned_token_type != 4) {
                    return false;
                }
                Primitive3D primitive3D4 = new Primitive3D(primitive3D);
                primitive3D4.count_points = this.count_scanned_points;
                primitive3D4.original_points = this.scanned_points;
                primitive3D4.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive3D4.original_expressions = this.scanned_expressions;
                primitive3D4.edge_flags = blArray;
                primitive3D4.is_filled = true;
                this.graphics.addPrimitive(primitive3D4);
                return true;
            }
            if (this.scanned_identifier.equals(name_Cuboid)) {
                double[] dArray;
                double[] dArray2;
                int[][] nArrayArray = new int[6][];
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 3;
                nArray[3] = 2;
                nArrayArray[0] = nArray;
                int[] nArray2 = new int[4];
                nArray2[1] = 4;
                nArray2[2] = 5;
                nArray2[3] = 1;
                nArrayArray[1] = nArray2;
                int[] nArray3 = new int[4];
                nArray3[1] = 2;
                nArray3[2] = 6;
                nArray3[3] = 4;
                nArrayArray[2] = nArray3;
                nArrayArray[3] = new int[]{7, 6, 4, 5};
                nArrayArray[4] = new int[]{7, 3, 2, 6};
                nArrayArray[5] = new int[]{7, 5, 1, 3};
                int[][] nArrayArray2 = nArrayArray;
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                double[] dArray3 = this.scanned_points[0];
                double[] dArray4 = this.scanned_scaled_offsets[0];
                if (this.scanned_expressions != null && (this.scanned_expressions[0][0] >= 0 || this.scanned_expressions[0][1] >= 0 || this.scanned_expressions[0][2] >= 0)) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type == 4) {
                    if (dArray3 != null) {
                        dArray2 = new double[]{dArray3[0] + 1.0, dArray3[1] + 1.0, dArray3[2] + 1.0};
                        dArray = dArray4;
                    } else {
                        dArray2 = null;
                        dArray = null;
                    }
                } else if (this.scanned_token_type == 0) {
                    if (!this.scan_points() || this.count_scanned_points != 1) {
                        return false;
                    }
                    if (this.scanned_expressions != null && (this.scanned_expressions[0][0] >= 0 || this.scanned_expressions[0][1] >= 0 || this.scanned_expressions[0][2] >= 0)) {
                        return false;
                    }
                    this.scan_token();
                    if (this.scanned_token_type != 4) {
                        return false;
                    }
                    dArray2 = this.scanned_points[0];
                    dArray = this.scanned_scaled_offsets[0];
                } else {
                    return false;
                }
                if (dArray3 != null && dArray2 != null || dArray3 == null && dArray2 == null && dArray != null) {
                    int n = 0;
                    while (n < 6) {
                        Primitive3D primitive3D5 = new Primitive3D(primitive3D);
                        primitive3D5.count_points = 4;
                        primitive3D5.original_points = new double[4][3];
                        primitive3D5.original_scaled_offsets = new double[4][3];
                        primitive3D5.is_filled = true;
                        int n2 = 0;
                        while (n2 < 4) {
                            int n3 = 0;
                            while (n3 < 3) {
                                if ((nArrayArray2[n][n2] & 1 << n3) != 0) {
                                    if (dArray2 != null) {
                                        primitive3D5.original_points[n2][n3] = dArray2[n3];
                                    } else {
                                        primitive3D5.original_points[n2] = null;
                                    }
                                    primitive3D5.original_scaled_offsets[n2][n3] = dArray[n3];
                                } else {
                                    if (dArray3 != null) {
                                        primitive3D5.original_points[n2][n3] = dArray3[n3];
                                    } else {
                                        primitive3D5.original_points[n2] = null;
                                    }
                                    primitive3D5.original_scaled_offsets[n2][n3] = dArray4[n3];
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                        this.graphics.addPrimitive(primitive3D5);
                        ++n;
                    }
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_Text)) {
                Primitive3D primitive3D6 = new Primitive3D(primitive3D);
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                this.scan_token();
                if (!this.scan_text(primitive3D6, true)) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 0) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                primitive3D6.count_points = 1;
                primitive3D6.original_points = this.scanned_points;
                primitive3D6.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive3D6.original_expressions = this.scanned_expressions;
                this.scan_token();
                double d = 0.0;
                double d2 = 0.0;
                if (this.scanned_token_type == 0) {
                    if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 2) {
                        return false;
                    }
                    d = this.scanned_numbers[0];
                    d2 = this.scanned_numbers[1];
                    this.scan_right_bracket();
                }
                if (this.scanned_token_type != 4) {
                    return false;
                }
                primitive3D6.original_point_size = d;
                primitive3D6.original_thickness = d2;
                this.graphics.addPrimitive(primitive3D6);
                return true;
            }
        }
        this.scan_salt();
        if (this.current_char == ',' || this.current_char == '}' || this.current_char == ']') {
            this.scanned_unidentified = true;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean scan_numbers(boolean var1_1, boolean var2_2) {
        var3_3 = 0;
        this.scan_token();
        if ((var2_2 || this.scanned_token_type == 3) && (!var2_2 || this.scanned_token_type == 5)) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            this.scan_token();
            if (this.scanned_token_type != 22) break;
            this.scanned_numbers[var3_3] = this.scanned_number;
            if (var1_1) {
                if (this.scanned_number > 0.9999) {
                    this.scanned_numbers[var3_3] = 0.9999;
                } else if (this.scanned_number < 1.0E-4) {
                    this.scanned_numbers[var3_3] = 1.0E-4;
                }
            }
            ++var3_3;
            this.scan_token();
            if (this.scanned_token_type != 0) break;
lbl17:
            // 2 sources

            ** while (var3_3 < Parser.max_count_scanned_numbers)
        }
lbl18:
        // 3 sources

        this.count_scanned_numbers = var3_3;
        if ((!var2_2 && this.scanned_token_type != 4 || var2_2 && this.scanned_token_type != 6) && var3_3 >= Parser.max_count_scanned_numbers) {
            this.scan_right_bracket();
        }
        return (var2_2 != false || this.scanned_token_type == 4) && (var2_2 == false || this.scanned_token_type == 6);
    }

    boolean scan_points() {
        boolean bl = false;
        int n = 0;
        this.scanned_points = null;
        this.scanned_scaled_offsets = null;
        this.scanned_expressions = null;
        this.points_scanned = new Vector(2);
        this.scaled_offsets_scanned = new Vector(2);
        if (this.evaluator != null) {
            this.is_scanning_expression = true;
            this.is_scanning_after_operand = false;
            this.expressions_scanned = new Vector(2);
        }
        while (n == 0 || bl && this.scanned_token_type == 0) {
            int n2;
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            int[] nArray = new int[]{-1, -1, -1};
            this.scan_token();
            if (this.scanned_token_type == 5) {
                this.scan_token();
                if (n == 0 && this.scanned_token_type == 5) {
                    bl = true;
                    this.scan_token();
                }
            }
            if (this.scanned_token_type == 21 && this.scanned_identifier.equals(name_Scaled)) {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                dArray2[0] = this.scanned_numbers[0];
                dArray2[1] = this.scanned_numbers[1];
                dArray2[2] = this.scanned_numbers[2];
                this.scan_token();
                if (this.scanned_token_type == 0) {
                    if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    dArray[0] = this.scanned_numbers[0];
                    dArray[1] = this.scanned_numbers[1];
                    dArray[2] = this.scanned_numbers[2];
                    this.scan_token();
                    if (this.scanned_token_type != 4) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    this.points_scanned.addElement(dArray);
                    this.scaled_offsets_scanned.addElement(dArray2);
                } else {
                    if (this.scanned_token_type != 4) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    this.points_scanned.addElement(dArray);
                    this.scaled_offsets_scanned.addElement(dArray2);
                }
            } else if (this.evaluator != null) {
                n2 = 0;
                while (n2 < 3) {
                    if (!this.scan_expression(true)) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.expressions_scanned = null;
                        return false;
                    }
                    this.is_scanning_expression = true;
                    this.is_scanning_after_operand = false;
                    if (!this.is_scanned_expression_numeric) {
                        nArray[n2] = this.scanned_expression;
                    }
                    dArray[n2] = this.scanned_number;
                    if (this.scanned_token_type != 0) break;
                    this.scan_token();
                    ++n2;
                }
                if (n2 < 2 || this.scanned_token_type != 6) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.expressions_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                this.points_scanned.addElement(dArray);
                this.scaled_offsets_scanned.addElement(dArray2);
                this.expressions_scanned.addElement(nArray);
            } else if (this.scanned_token_type == 22) {
                n2 = 0;
                while (n2 < 3 && this.scanned_token_type == 22) {
                    dArray[n2] = this.scanned_number;
                    this.scan_token();
                    if (this.scanned_token_type != 0) break;
                    this.scan_token();
                    ++n2;
                }
                if (n2 < 2 || this.scanned_token_type != 6) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                this.points_scanned.addElement(dArray);
                this.scaled_offsets_scanned.addElement(dArray2);
            } else {
                this.points_scanned = null;
                this.scaled_offsets_scanned = null;
                this.is_scanning_expression = false;
                return false;
            }
            if (bl) {
                this.scan_token();
            }
            ++n;
        }
        if (this.scanned_token_type != 6 && this.scanned_token_type != 4) {
            this.points_scanned = null;
            this.scaled_offsets_scanned = null;
            this.is_scanning_expression = false;
            return false;
        }
        this.count_scanned_points = n;
        this.scanned_points = new double[this.count_scanned_points][3];
        this.scanned_scaled_offsets = new double[this.count_scanned_points][3];
        if (this.evaluator != null) {
            this.scanned_expressions = new int[this.count_scanned_points][3];
        }
        n = 0;
        while (n < this.count_scanned_points) {
            this.scanned_points[n] = (double[])this.points_scanned.elementAt(n);
            this.scanned_scaled_offsets[n] = (double[])this.scaled_offsets_scanned.elementAt(n);
            if (this.evaluator != null) {
                this.scanned_expressions[n] = (int[])this.expressions_scanned.elementAt(n);
            }
            ++n;
        }
        this.points_scanned = null;
        this.scaled_offsets_scanned = null;
        this.expressions_scanned = null;
        this.is_scanning_expression = false;
        return true;
    }

    boolean scan_color() {
        this.scanned_color = null;
        if (this.scanned_identifier.equals(name_RGBColor)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_Hue)) {
            if (!this.scan_numbers(false, false)) {
                return false;
            }
            if (this.count_scanned_numbers == 1) {
                this.scanned_numbers[1] = 1.0;
                this.count_scanned_numbers = 2;
            }
            if (this.count_scanned_numbers == 2) {
                this.scanned_numbers[2] = 1.0;
                this.count_scanned_numbers = 3;
            }
            if (this.count_scanned_numbers != 3) {
                return false;
            }
            this.scanned_numbers[0] = this.scanned_numbers[0] - Math.floor(this.scanned_numbers[0]);
            int n = 0;
            while (n < 3) {
                if (this.scanned_numbers[n] > 0.9999) {
                    this.scanned_numbers[n] = 0.9999;
                }
                if (this.scanned_numbers[n] < 1.0E-4) {
                    this.scanned_numbers[n] = 1.0E-4;
                }
                ++n;
            }
            this.scanned_color = Color.getHSBColor((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_GrayLevel)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 1) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[0], (float)this.scanned_numbers[0]);
        } else if (this.scanned_identifier.equals(name_CMYKColor)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 4) {
                return false;
            }
            this.scanned_color = new Color((float)Math.max(0.0, 1.0 - this.scanned_numbers[0] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[1] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[2] - this.scanned_numbers[3]));
        }
        return true;
    }

    public boolean scan_text(Primitive3D primitive3D, boolean bl) {
        primitive3D.text = name_Questionmark;
        primitive3D.front_face_color = null;
        primitive3D.back_face_color = null;
        primitive3D.is_filled = false;
        if (this.scanned_token_type == 22) {
            primitive3D.text = String.valueOf(this.scanned_number);
        } else if (this.scanned_token_type == 23) {
            primitive3D.text = this.scanned_string;
        } else if (this.scanned_token_type == 21) {
            if (!this.scanned_identifier.equals(name_StyleForm)) {
                primitive3D.text = this.scanned_identifier;
            } else {
                this.scan_token();
                if (this.scanned_token_type != 3) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type == 22) {
                    primitive3D.text = String.valueOf(this.scanned_number);
                } else if (this.scanned_token_type == 23) {
                    primitive3D.text = this.scanned_string;
                } else if (this.scanned_token_type == 21) {
                    primitive3D.text = this.scanned_identifier;
                }
                this.scan_salt();
                this.scan_token();
                if (this.scanned_token_type == 4) {
                    primitive3D.font_url = null;
                    primitive3D.font = null;
                    primitive3D.font_weight = -1;
                    primitive3D.font_slant = -1;
                    primitive3D.font_size = -1;
                    primitive3D.front_face_color = null;
                    primitive3D.back_face_color = null;
                } else {
                    if (this.scanned_token_type != 0) {
                        return false;
                    }
                    if (!this.scan_font_options() || this.scanned_token_type != 4) {
                        return false;
                    }
                    primitive3D.font_url = this.scanned_font_url;
                    primitive3D.font = this.scanned_font_family;
                    primitive3D.font_weight = this.scanned_font_weight;
                    primitive3D.font_slant = this.scanned_font_slant;
                    primitive3D.font_size = this.scanned_font_size;
                    primitive3D.front_face_color = this.scanned_font_color;
                    primitive3D.back_face_color = this.scanned_font_background;
                }
            }
        }
        if (bl) {
            this.scan_salt();
        }
        return true;
    }

    boolean scan_font_options() {
        this.scanned_font_url = null;
        this.scanned_font_family = null;
        this.scanned_font_weight = -1;
        this.scanned_font_slant = -1;
        this.scanned_font_size = -1;
        this.scanned_font_color = null;
        this.scanned_font_background = null;
        this.scan_token();
        while (this.scanned_token_type == 21) {
            if (this.scanned_identifier.equals(name_URL)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 23) {
                    return false;
                }
                this.scanned_font_url = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontFamily)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 23) {
                    return false;
                }
                this.scanned_font_family = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontWeight)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 23) {
                    return false;
                }
                this.scanned_font_weight = this.scanned_string.equals(name_Bold) ? 1 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSlant)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 23) {
                    return false;
                }
                this.scanned_font_slant = this.scanned_string.equals(name_Italic) ? 2 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSize)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 22) {
                    return false;
                }
                this.scanned_font_size = (int)this.scanned_number;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontColor)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 21) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_color = this.scanned_color;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_Background)) {
                this.scan_token();
                if (this.scanned_token_type != 20) {
                    return false;
                }
                this.scan_token();
                if (this.scanned_token_type != 21) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_background = this.scanned_color;
                this.scan_token();
            } else {
                this.scan_salt();
                this.scan_token();
            }
            if (this.scanned_token_type != 0) break;
            this.scan_token();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean scan_option() {
        block152: {
            block154: {
                block153: {
                    this.scanned_nothing = false;
                    this.scanning_FaceForm_back = false;
                    this.scan_token();
                    if (this.scanned_token_type == 5) {
                        while (this.scan_option()) {
                            this.scan_token();
                            if (this.scanned_token_type != 0) break;
                        }
                        return this.scanned_token_type == 6;
                    }
                    if (this.scanned_token_type != 21) {
                        this.scanned_nothing = true;
                        return false;
                    }
                    if (!this.is_scanned_AmbientLight && this.scanned_identifier.equals(Parser.name_AmbientLight)) {
                        this.is_scanned_AmbientLight = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        var1_1 = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(var1_1)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_AmbientLight = var1_1.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_Axes && this.scanned_identifier.equals(Parser.name_Axes)) {
                        this.is_scanned_Axes = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21) {
                            if (this.scanned_identifier.equals(Parser.name_True)) {
                                this.graphics.option_Axes[0] = true;
                                this.graphics.option_Axes[1] = true;
                                this.graphics.option_Axes[2] = true;
                            }
                            return true;
                        }
                        if (this.scanned_token_type == 5) {
                            var1_2 = 0;
                            this.scanned_token_type = 0;
                            while (var1_2 < 3 && this.scanned_token_type == 0) {
                                this.scan_token();
                                if (this.scanned_token_type != 21) continue;
                                if (this.scanned_identifier.equals(Parser.name_True)) {
                                    this.graphics.option_Axes[var1_2] = true;
                                }
                                ++var1_2;
                                this.scan_token();
                            }
                            if (this.scanned_token_type == 6) {
                                return true;
                            }
                        }
                        return false;
                    }
                    if (!this.is_scanned_AxesLabel && this.scanned_identifier.equals(Parser.name_AxesLabel)) {
                        this.is_scanned_AxesLabel = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        var1_3 = 2;
                        var2_14 = false;
                        if (this.scanned_token_type == 5) {
                            var1_3 = 0;
                            var2_14 = true;
                            this.scan_token();
                        } else if (this.scanned_token_type == 21 && this.scanned_identifier.equals(Parser.name_None)) {
                            return true;
                        }
                        do {
                            if (var1_3 > 0 && var2_14) {
                                this.scan_token();
                            }
                            if (var1_3 > 2) {
                                return false;
                            }
                            if (this.scanned_token_type != 21 || !this.scanned_identifier.equals(Parser.name_None)) {
                                this.graphics.option_AxesLabel[var1_3] = var3_20 = new Primitive3D();
                                if (!this.scan_text(var3_20, false)) {
                                    return false;
                                }
                            }
                            if (!var2_14) continue;
                            ++var1_3;
                            this.scan_token();
                        } while (var2_14 && this.scanned_token_type == 0);
                        return var2_14 == false || this.scanned_token_type == 6;
                    }
                    if (!this.is_scanned_AxesStyle && this.scanned_identifier.equals(Parser.name_AxesStyle)) {
                        this.is_scanned_AxesStyle = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        var1_4 = new Primitive3D();
                        this.scanning_EdgeForm = true;
                        this.scanning_AxesStyles = true;
                        this.scanned_AxesStyles[0] = null;
                        this.scanned_AxesStyles[1] = null;
                        this.scanned_AxesStyles[2] = null;
                        if (!this.scan_primitive(var1_4)) {
                            this.scanning_EdgeForm = false;
                            this.scanning_AxesStyles = false;
                            return false;
                        }
                        this.scanning_EdgeForm = false;
                        this.scanning_AxesStyles = false;
                        if (this.scanned_AxesStyles[2] == null) {
                            this.scanned_AxesStyles[0] = var1_4;
                            this.scanned_AxesStyles[1] = var1_4;
                            this.scanned_AxesStyles[2] = var1_4;
                        }
                        var2_15 = 0;
                        while (var2_15 < 3) {
                            var1_4 = this.scanned_AxesStyles[var2_15];
                            if (var1_4 != null) {
                                var1_4.original_thickness = var1_4.original_edge_thickness;
                                var1_4.is_absolute_thickness = var1_4.is_absolute_edge_thickness;
                                var1_4.standard_color = var1_4.edge_color;
                            }
                            this.graphics.option_AxesStyle[var2_15] = var1_4;
                            ++var2_15;
                        }
                        return true;
                    }
                    if (!this.is_scanned_AxesEdge && this.scanned_identifier.equals(Parser.name_AxesEdge)) {
                        this.is_scanned_AxesEdge = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21) {
                            if (!this.scanned_identifier.equals(Parser.name_Automatic)) {
                                this.graphics.option_AxesEdge[0] = -2;
                                this.graphics.option_AxesEdge[1] = -2;
                                this.graphics.option_AxesEdge[2] = -2;
                            }
                            return true;
                        }
                        if (this.scanned_token_type != 5) {
                            return false;
                        }
                        var1_5 = 0;
                        do {
                            this.scan_token();
                            if (this.scanned_token_type == 21) {
                                if (!this.scanned_identifier.equals(Parser.name_Automatic)) {
                                    this.graphics.option_AxesEdge[var1_5] = -2;
                                }
                            } else if (this.scanned_token_type == 5) {
                                this.scan_token();
                                if (this.scanned_token_type != 22) {
                                    return false;
                                }
                                var2_16 = 0;
                                if (this.scanned_number > 0.0) {
                                    var2_16 = 1;
                                }
                                this.scan_token();
                                if (this.scanned_token_type != 0) {
                                    return false;
                                }
                                this.scan_token();
                                if (this.scanned_token_type != 22) {
                                    return false;
                                }
                                if (this.scanned_number > 0.0) {
                                    var2_16 += 2;
                                }
                                this.scan_token();
                                if (this.scanned_token_type != 6) {
                                    return false;
                                }
                                this.graphics.option_AxesEdge[var1_5] = var2_16;
                            } else {
                                return false;
                            }
                            this.scan_token();
                        } while (++var1_5 < 3 && this.scanned_token_type == 0);
                        return this.scanned_token_type == 6;
                    }
                    if (!this.is_scanned_Ticks && this.scanned_identifier.equals(Parser.name_Ticks)) {
                        this.is_scanned_Ticks = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21) {
                            if (this.scanned_identifier.equals(Parser.name_None)) {
                                this.graphics.option_Ticks = new Vector[3];
                                return true;
                            }
                            if (this.scanned_identifier.equals(Parser.name_Automatic)) {
                                this.graphics.option_Ticks = new Vector[3];
                                var1_6 = 0;
                                while (var1_6 < 3) {
                                    this.graphics.option_Ticks[var1_6] = new Vector<E>();
                                    ++var1_6;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (this.scanned_token_type == 5) {
                            this.graphics.option_Ticks = new Vector[3];
                            var1_7 = 0;
                            while (var1_7 < 3) {
                                this.graphics.option_Ticks[var1_7] = null;
                                ++var1_7;
                            }
                            var2_17 = 0;
                            this.scanned_token_type = 0;
                            while (this.scanned_token_type == 0) {
                                this.scan_token();
                                if (this.scanned_token_type == 21) {
                                    if (this.scanned_identifier.equals(Parser.name_Automatic)) {
                                        this.graphics.option_Ticks[var2_17] = new Vector<E>();
                                    } else if (!this.scanned_identifier.equals(Parser.name_None)) {
                                        return false;
                                    }
                                } else {
                                    if (this.scanned_token_type != 5) {
                                        return false;
                                    }
                                    this.graphics.option_Ticks[var2_17] = new Vector<E>();
                                    this.scanned_token_type = 0;
                                    while (this.scanned_token_type == 0) {
                                        var3_21 = new Primitive3D();
                                        var3_21.front_specular_exponent = 0.01;
                                        var3_21.back_specular_exponent = 0.0;
                                        this.scan_token();
                                        if (this.scanned_token_type == 22) {
                                            var3_21.original_point_size = this.scanned_number;
                                            var3_21.text = Double.toString(this.scanned_number);
                                        } else if (this.scanned_token_type == 5) {
                                            this.scan_token();
                                            if (this.scanned_token_type != 22) {
                                                return false;
                                            }
                                            var4_23 = this.scanned_number;
                                            this.scan_token();
                                            if (this.scanned_token_type == 0) {
                                                this.scan_token();
                                                if (!this.scan_text(var3_21, false)) {
                                                    return false;
                                                }
                                                this.scan_token();
                                                if (this.scanned_token_type == 0) {
                                                    this.scan_token();
                                                    if (this.scanned_token_type == 22) {
                                                        var3_21.front_specular_exponent = this.scanned_number / 2.0;
                                                        var3_21.back_specular_exponent = this.scanned_number / 2.0;
                                                    } else if (this.scanned_token_type == 5) {
                                                        this.scan_token();
                                                        if (this.scanned_token_type != 22) {
                                                            return false;
                                                        }
                                                        var3_21.front_specular_exponent = this.scanned_number;
                                                        this.scan_token();
                                                        if (this.scanned_token_type != 0) {
                                                            return false;
                                                        }
                                                        this.scan_token();
                                                        if (this.scanned_token_type != 22) {
                                                            return false;
                                                        }
                                                        var3_21.back_specular_exponent = this.scanned_number;
                                                        this.scan_token();
                                                        if (this.scanned_token_type != 6) {
                                                            return false;
                                                        }
                                                    } else {
                                                        return false;
                                                    }
                                                    this.scan_token();
                                                    if (this.scanned_token_type == 0) {
                                                        this.scanning_EdgeForm = true;
                                                        if (!this.scan_primitive(var3_21)) {
                                                            this.scanning_EdgeForm = false;
                                                            return false;
                                                        }
                                                        var3_21.original_thickness = var3_21.original_edge_thickness;
                                                        var3_21.is_absolute_thickness = var3_21.is_absolute_edge_thickness;
                                                        var3_21.standard_color = var3_21.edge_color;
                                                        this.scanning_EdgeForm = false;
                                                        this.scan_token();
                                                    }
                                                }
                                            } else {
                                                var3_21.text = Double.toString(var4_23);
                                            }
                                            var3_21.original_point_size = var4_23;
                                            if (this.scanned_token_type != 6) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                        if (this.graphics.ticks_max_in_length[var2_17] < var3_21.front_specular_exponent) {
                                            this.graphics.ticks_max_in_length[var2_17] = var3_21.front_specular_exponent;
                                        }
                                        if (this.graphics.ticks_max_out_length[var2_17] < var3_21.back_specular_exponent) {
                                            this.graphics.ticks_max_out_length[var2_17] = var3_21.back_specular_exponent;
                                        }
                                        this.graphics.option_Ticks[var2_17].addElement(var3_21);
                                        this.scan_token();
                                    }
                                    if (this.scanned_token_type != 6) {
                                        return false;
                                    }
                                }
                                ++var2_17;
                                this.scan_token();
                            }
                            return this.scanned_token_type == 6;
                        }
                        return false;
                    }
                    if (!this.is_scanned_PlotLabel && this.scanned_identifier.equals(Parser.name_PlotLabel)) {
                        this.is_scanned_PlotLabel = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21 && this.scanned_identifier.equals(Parser.name_None)) {
                            return true;
                        }
                        this.graphics.option_PlotLabel = var1_8 = new Primitive3D();
                        return this.scan_text(var1_8, false) != false;
                    }
                    if (!this.is_scanned_Background && this.scanned_identifier.equals(Parser.name_Background)) {
                        this.is_scanned_Background = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        var1_9 = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(var1_9)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_Background = var1_9.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_DefaultColor && this.scanned_identifier.equals(Parser.name_DefaultColor)) {
                        this.is_scanned_DefaultColor = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        var1_10 = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(var1_10)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_DefaultColor = var1_10.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_BoxStyle && this.scanned_identifier.equals(Parser.name_BoxStyle)) {
                        this.is_scanned_BoxStyle = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        var1_11 = new Primitive3D();
                        this.scanning_EdgeForm = true;
                        if (!this.scan_primitive(var1_11)) {
                            this.scanning_EdgeForm = false;
                            return false;
                        }
                        var1_11.original_thickness = var1_11.original_edge_thickness;
                        var1_11.is_absolute_thickness = var1_11.is_absolute_edge_thickness;
                        var1_11.standard_color = var1_11.edge_color;
                        this.graphics.option_BoxStyle = var1_11;
                        this.scanning_EdgeForm = false;
                        return true;
                    }
                    if (!this.is_scanned_Boxed && this.scanned_identifier.equals(Parser.name_Boxed)) {
                        this.is_scanned_Boxed = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21) {
                            if (this.scanned_identifier.equals(Parser.name_False)) {
                                this.graphics.option_Boxed = false;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (!this.is_scanned_Lighting && this.scanned_identifier.equals(Parser.name_Lighting)) {
                        this.is_scanned_Lighting = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        this.scan_token();
                        if (this.scanned_token_type == 21) {
                            if (this.scanned_identifier.equals(Parser.name_False)) {
                                this.graphics.option_Lighting = false;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (!this.is_scanned_BoxRatios && this.scanned_identifier.equals(Parser.name_BoxRatios)) {
                        this.is_scanned_BoxRatios = true;
                        this.scan_token();
                        if (this.scanned_token_type != 20) {
                            return false;
                        }
                        if (this.scan_numbers(false, true) && this.count_scanned_numbers == 3) {
                            this.graphics.option_BoxRatios = new double[3];
                            this.graphics.option_BoxRatios[0] = this.scanned_numbers[0];
                            this.graphics.option_BoxRatios[1] = this.scanned_numbers[1];
                            this.graphics.option_BoxRatios[2] = this.scanned_numbers[2];
                            return true;
                        }
                        this.scan_salt();
                        return true;
                    }
                    if (this.is_scanned_PlotRange || !this.scanned_identifier.equals(Parser.name_PlotRange)) break block152;
                    this.is_scanned_PlotRange = true;
                    this.scan_token();
                    if (this.scanned_token_type != 20) {
                        return false;
                    }
                    this.scan_token();
                    if (this.scanned_token_type != 5) {
                        this.scan_salt();
                        return true;
                    }
                    var1_12 = new double[][]{{-Infinity, Infinity}, {-Infinity, Infinity}, {-Infinity, Infinity}};
                    var2_18 = 0;
                    var3_22 = false;
                    this.scan_token();
                    if (this.scanned_token_type != 22) break block153;
                    var2_18 = 2;
                    var3_22 = true;
                    ** GOTO lbl405
                }
                if (this.scanned_token_type != 5) break block154;
                this.scan_token();
                ** GOTO lbl405
            }
            if (this.scanned_token_type == 21) ** GOTO lbl405
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.scanned_token_type != 21) {
                    var4_24 = 0;
                    while (var4_24 < 2) {
                        if (this.scanned_token_type != 22) {
                            return false;
                        }
                        var1_12[var2_18][var4_24] = this.scanned_number;
                        this.scan_token();
                        if (var4_24 == 0) {
                            this.scan_token();
                        }
                        ++var4_24;
                    }
                    if (this.scanned_token_type != 6) {
                        return false;
                    }
                }
                if (!var3_22) {
                    this.scan_token();
                    if (var2_18 < 2) {
                        this.scan_token();
                        if (this.scanned_token_type == 5) {
                            this.scan_token();
                        }
                    }
                }
                ++var2_18;
lbl405:
                // 4 sources

                ** while (var2_18 < 3)
            }
lbl406:
            // 1 sources

            if (this.scanned_token_type != 6) {
                return false;
            }
            this.graphics.option_PlotRange = var1_12;
            return true;
        }
        if (!this.is_scanned_LightSources && this.scanned_identifier.equals(Parser.name_LightSources)) {
            this.is_scanned_LightSources = true;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 5) {
                this.scan_salt();
                return true;
            }
            this.graphics.option_LightSources_vectors = new Vector<E>();
            this.graphics.option_LightSources_colors = new Vector<E>();
            this.scanned_token_type = 0;
            while (this.scanned_token_type == 0) {
                var1_13 = new double[3];
                this.scan_token();
                if (this.scanned_token_type != 5) {
                    return false;
                }
                if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                    return false;
                }
                var2_19 = Math.sqrt(this.scanned_numbers[0] * this.scanned_numbers[0] + this.scanned_numbers[1] * this.scanned_numbers[1] + this.scanned_numbers[2] * this.scanned_numbers[2]);
                var1_13[0] = this.scanned_numbers[0] / var2_19;
                var1_13[1] = this.scanned_numbers[1] / var2_19;
                var1_13[2] = this.scanned_numbers[2] / var2_19;
                this.scan_token();
                if (this.scanned_token_type != 0) {
                    return false;
                }
                var4_25 = new Primitive3D();
                this.scanning_FaceForm = true;
                if (!this.scan_primitive(var4_25) || var4_25.front_face_color == null) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scanning_FaceForm = false;
                this.graphics.option_LightSources_vectors.addElement(var1_13);
                this.graphics.option_LightSources_colors.addElement(var4_25.front_face_color);
                this.scan_token();
                if (this.scanned_token_type != 6) {
                    return false;
                }
                this.scan_token();
            }
            return this.scanned_token_type == 6;
        }
        if (!this.is_scanned_ViewPoint && this.scanned_identifier.equals(Parser.name_ViewPoint)) {
            this.is_scanned_ViewPoint = true;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.graphics.option_ViewPoint = new double[3];
            this.graphics.option_ViewPoint[0] = this.scanned_numbers[0];
            this.graphics.option_ViewPoint[1] = this.scanned_numbers[1];
            this.graphics.option_ViewPoint[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_ViewVertical && this.scanned_identifier.equals(Parser.name_ViewVertical)) {
            this.is_scanned_ViewVertical = true;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.graphics.option_ViewVertical = new double[3];
            this.graphics.option_ViewVertical[0] = this.scanned_numbers[0];
            this.graphics.option_ViewVertical[1] = this.scanned_numbers[1];
            this.graphics.option_ViewVertical[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_TextStyle && this.scanned_identifier.equals(Parser.name_TextStyle)) {
            this.is_scanned_TextStyle = true;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type == 21) {
                return true;
            }
            if (this.scanned_token_type != 5) {
                return false;
            }
            if (!this.scan_font_options() || this.scanned_token_type != 6) {
                return false;
            }
            this.graphics.option_TextStyle_font_url = this.scanned_font_url;
            this.graphics.option_TextStyle_font_family = this.scanned_font_family;
            this.graphics.option_TextStyle_font_weight = this.scanned_font_weight;
            this.graphics.option_TextStyle_font_slant = this.scanned_font_slant;
            this.graphics.option_TextStyle_font_size = this.scanned_font_size;
            this.graphics.option_TextStyle_font_color = this.scanned_font_color;
            this.graphics.option_TextStyle_font_background = this.scanned_font_background;
            return true;
        }
        if (this.scanning_animation_option && this.scanned_identifier.equals(Parser.name_AnimationDisplayTime)) {
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 22) {
                return false;
            }
            this.scanned_AnimationDisplayTime = this.scanned_number;
            return true;
        }
        if (this.scanning_animation_option && this.scanned_identifier.equals(Parser.name_AnimationDirection)) {
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 21) {
                return false;
            }
            if (this.scanned_identifier.equals(Parser.name_Forward)) {
                this.scanned_AnimationDirection = 1;
            } else if (this.scanned_identifier.equals(Parser.name_Backward)) {
                this.scanned_AnimationDirection = -1;
            } else if (this.scanned_identifier.equals(Parser.name_ForwardBackward)) {
                this.scanned_AnimationDirection = 0;
            }
            return true;
        }
        this.scan_salt();
        return this.current_char == ',' || this.current_char == '}' || this.current_char == ']';
    }

    public boolean scan_independent_variables() {
        if (this.evaluator == null) {
            return false;
        }
        this.evaluator.clearAllVariables();
        this.text_index = -1;
        this.scan_token();
        if (this.scanned_token_type != 5) {
            return false;
        }
        this.scanned_token_type = 0;
        while (this.scanned_token_type == 0) {
            this.scan_token();
            if (this.scanned_token_type != 21) break;
            String string = this.scanned_identifier;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.scan_token();
            if (this.scanned_token_type != 22) {
                return false;
            }
            double d = this.scanned_number;
            if (!this.evaluator.addIndependentVariable(string, d)) {
                return false;
            }
            this.scan_token();
        }
        return this.scanned_token_type == 6;
    }

    public boolean scan_dependent_variables() {
        if (this.evaluator == null) {
            return false;
        }
        this.text_index = -1;
        this.scan_token();
        if (this.scanned_token_type != 5) {
            return false;
        }
        this.scanned_token_type = 0;
        while (this.scanned_token_type == 0) {
            this.scan_token();
            if (this.scanned_token_type != 21) break;
            String string = this.scanned_identifier;
            this.scan_token();
            if (this.scanned_token_type != 20) {
                return false;
            }
            this.is_scanning_expression = true;
            this.is_scanning_after_operand = false;
            this.scan_token();
            if (!this.scan_expression(false)) {
                return false;
            }
            if (!(this.is_scanned_expression_numeric ? !this.evaluator.addDependentVariable(string, this.scanned_number, -1) : !this.evaluator.addDependentVariable(string, 0.0, this.scanned_expression))) continue;
            return false;
        }
        return this.scanned_token_type == 6;
    }

    public int left_precedence(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 35: {
                return 3;
            }
            case 36: {
                return 5;
            }
            case 33: {
                return 8;
            }
            case 32: {
                return 10;
            }
            case 34: {
                return 12;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 14;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 18;
            }
            case 11: {
                return 18;
            }
            case 27: 
            case 28: {
                return 18;
            }
            case 12: 
            case 13: {
                return 20;
            }
            case 30: {
                return 22;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: {
                return 101;
            }
            case 21: 
            case 22: {
                return 101;
            }
            case 24: 
            case 26: {
                return 0;
            }
        }
        return -1;
    }

    public int right_precedence(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 35: {
                return 4;
            }
            case 36: {
                return 6;
            }
            case 33: {
                return 7;
            }
            case 32: {
                return 9;
            }
            case 34: {
                return 13;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 15;
            }
            case 7: {
                return 15;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 17;
            }
            case 10: {
                return 17;
            }
            case 11: {
                return 19;
            }
            case 27: 
            case 28: {
                return 19;
            }
            case 12: 
            case 13: {
                return 19;
            }
            case 30: {
                return 23;
            }
            case 1: 
            case 3: {
                return 100;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 21: 
            case 22: {
                return 100;
            }
            case 24: 
            case 26: {
                return 0;
            }
        }
        return -1;
    }

    public boolean scan_expression(boolean bl) {
        double d;
        Stack<ExpressionElement> stack = new Stack<ExpressionElement>();
        Vector<ExpressionElement> vector = new Vector<ExpressionElement>();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        Parser.arguments_counts[0] = 1;
        if (this.evaluator == null) {
            System.out.println("no evaluator in scan_expression!");
            return false;
        }
        this.is_scanning_expression = true;
        this.is_scanning_after_operand = false;
        this.scanned_expression = -1;
        this.is_scanned_expression_numeric = false;
        this.expression_token();
        int n3 = this.scanned_token_type;
        if (n3 == 21) {
            d = 0.5 + (double)this.evaluator.getVariableIndex(this.scanned_identifier);
            if (d < 0.0) {
                this.is_scanning_expression = false;
                return false;
            }
            this.is_scanning_after_operand = true;
        } else if (n3 == 30) {
            d = 0.5 + (double)this.scanned_function_identifier;
            if (d < 0.0) {
                this.is_scanning_expression = false;
                return false;
            }
            if (this.scanned_function_identifier == 113) {
                bl2 = true;
            }
        } else if (n3 == 22) {
            if (this.scanned_number >= 0.0) {
                d = this.scanned_number;
                this.is_scanning_after_operand = true;
            } else {
                System.out.println("LiveGraphics3D: Internal scanning error! (resuming)");
                stack.push(new ExpressionElement(28, 0.0, n));
                d = -this.scanned_number;
                this.is_scanning_after_operand = true;
            }
        } else {
            d = 0.0;
        }
        if (n3 == 1 || n3 == 3) {
            Parser.arguments_counts[++n] = 1;
        } else if (n3 == 2 || n3 == 4) {
            if (--n < 0) {
                this.is_scanning_expression = false;
                return false;
            }
        } else if (n3 == 0) {
            if (arguments_counts[n] == 0) {
                this.is_scanning_expression = false;
                return false;
            }
            Parser.arguments_counts[n] = arguments_counts[n] + 1;
        } else if (arguments_counts[n] == 0) {
            Parser.arguments_counts[n] = 1;
        }
        if (n == 0 && n3 == 0 || n3 == 6) {
            n3 = 24;
        }
        if (this.left_precedence(n3) < 0 || this.right_precedence(n3) < 0) {
            this.is_scanning_expression = false;
            return false;
        }
        while (true) {
            int n4;
            if ((n4 = !stack.empty() ? ((ExpressionElement)stack.peek()).token : 26) == 24 && n3 == 24) break;
            if (this.left_precedence(n4) <= this.right_precedence(n3)) {
                stack.push(new ExpressionElement(n3, d, n));
                if (n3 == 24) continue;
                this.scan_token();
                this.expression_token();
                if (this.scanned_token_type == 36 && n3 != 21) {
                    this.is_scanning_expression = false;
                    return false;
                }
                n3 = this.scanned_token_type;
                if (n3 == 21) {
                    d = 0.5 + (double)this.evaluator.getVariableIndex(this.scanned_identifier);
                    if (d < 0.0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    if (bl2) {
                        n3 = 22;
                    }
                } else if (n3 == 30) {
                    d = 0.5 + (double)this.scanned_function_identifier;
                    if (d < 0.0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    if (this.scanned_function_identifier == 113) {
                        bl2 = true;
                    }
                } else if (n3 == 22) {
                    d = this.scanned_number;
                } else if (n3 == 36) {
                    if (!this.evaluator.isVariableIndependent((int)d)) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                } else {
                    d = 0.0;
                }
                if (n3 == 1 || n3 == 3) {
                    Parser.arguments_counts[++n] = 0;
                } else if (n3 == 2 || n3 == 4) {
                    bl2 = false;
                    if (--n < 0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                } else if (n3 == 0) {
                    bl2 = false;
                    if (arguments_counts[n] == 0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    Parser.arguments_counts[n] = arguments_counts[n] + 1;
                } else if (arguments_counts[n] == 0) {
                    Parser.arguments_counts[n] = 1;
                }
                if (n == 0 && n3 == 0 || n3 == 6) {
                    n3 = 24;
                }
                if (this.left_precedence(n3) >= 0 && this.right_precedence(n3) >= 0) continue;
                this.is_scanning_expression = false;
                return false;
            }
            ExpressionElement expressionElement = null;
            do {
                expressionElement = (ExpressionElement)stack.pop();
                if (expressionElement.token == 30) {
                    expressionElement.value += (double)(1024 * arguments_counts[expressionElement.nesting + 1]);
                }
                if (expressionElement.token != 1 && expressionElement.token != 2 && expressionElement.token != 3 && expressionElement.token != 4 && expressionElement.token != 0) {
                    vector.addElement(expressionElement);
                }
                n4 = !stack.empty() ? ((ExpressionElement)stack.peek()).token : 26;
                if (expressionElement.token == 16 || expressionElement.token == 17 || expressionElement.token == 14 || expressionElement.token == 15 || expressionElement.token == 18 || expressionElement.token == 19) {
                    ++n2;
                    if (n4 == 16 || n4 == 17 || n4 == 14 || n4 == 15 || n4 == 18 || n4 == 19) continue;
                    vector.addElement(new ExpressionElement(31, n2, 0));
                    continue;
                }
                n2 = 0;
            } while (n4 != 26 && this.left_precedence(n4) >= this.right_precedence(expressionElement.token));
        }
        vector.addElement(new ExpressionElement(24, 0.0, n));
        if (vector.size() < 2) {
            this.is_scanning_expression = false;
            return false;
        }
        if (vector.size() == 2 && ((ExpressionElement)vector.elementAt((int)0)).token == 22) {
            this.scanned_number = ((ExpressionElement)vector.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else if (vector.size() == 3 && ((ExpressionElement)vector.elementAt((int)0)).token == 22 && ((ExpressionElement)vector.elementAt((int)1)).token == 28) {
            this.scanned_number = -((ExpressionElement)vector.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else if (vector.size() == 3 && ((ExpressionElement)vector.elementAt((int)0)).token == 22 && ((ExpressionElement)vector.elementAt((int)1)).token == 27) {
            this.scanned_number = ((ExpressionElement)vector.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else {
            int[] nArray = new int[vector.size()];
            double[] dArray = new double[vector.size()];
            int n5 = 0;
            while (n5 < vector.size()) {
                nArray[n5] = ((ExpressionElement)vector.elementAt((int)n5)).token;
                dArray[n5] = ((ExpressionElement)vector.elementAt((int)n5)).value;
                ++n5;
            }
            this.scanned_expression = this.evaluator.addExpression(new Expression(this.evaluator, vector.size(), nArray, dArray));
            if (bl) {
                if (!this.evaluator.getExpression(this.scanned_expression).evaluate()) {
                    this.is_scanning_expression = false;
                    return false;
                }
                this.scanned_number = this.evaluator.getExpression((int)this.scanned_expression).current_value;
            } else {
                this.scanned_number = 0.0;
            }
        }
        this.is_scanning_expression = false;
        return true;
    }

    public void expression_token() {
        if (this.scanned_token_type != 21) {
            return;
        }
        if (this.scanned_left_bracket) {
            this.scanned_token_type = 30;
            this.is_scanning_after_operand = false;
            this.scanned_function_identifier = -1;
            int n = 0;
            while (n < 114) {
                if (this.scanned_identifier.equals(function_names[n])) {
                    this.scanned_function_identifier = n;
                    break;
                }
                ++n;
            }
            return;
        }
        if (this.scanned_identifier.equals(name_E)) {
            this.scanned_number = Math.E;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Pi)) {
            this.scanned_number = Math.PI;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_GoldenRatio)) {
            this.scanned_number = 1.618033988749895;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_EulerGamma)) {
            this.scanned_number = 0.5772156649015329;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Degree)) {
            this.scanned_number = Math.PI / 180;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Catalan)) {
            this.scanned_number = 0.915965594177219;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Khinchin)) {
            this.scanned_number = 2.6854520010653062;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Glaisher)) {
            this.scanned_number = 1.2824271291006226;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_True)) {
            this.scanned_number = 1.0;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_False)) {
            this.scanned_number = 0.0;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_I) || this.scanned_identifier.equals(name_Infinity) || this.scanned_identifier.equals(name_Indeterminate) || this.scanned_identifier.equals(name_ComplexInfinity)) {
            this.scanned_number = Double.NaN;
            this.scanned_token_type = 22;
            return;
        }
    }
}

