/*
 * Decompiled with CFR 0.152.
 */
class Quaternion {
    public double s;
    public double x;
    public double y;
    public double z;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.s = d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Quaternion(double d, double d2, double d3, double d4, boolean bl) {
        if (bl) {
            double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            double d6 = Math.sin(d / 2.0) / d5;
            this.s = Math.cos(d / 2.0);
            this.x = d6 * d2;
            this.y = d6 * d3;
            this.z = d6 * d4;
        } else {
            double d7 = Math.sin(d / 2.0);
            this.s = Math.cos(d / 2.0);
            this.x = d7 * d2;
            this.y = d7 * d3;
            this.z = d7 * d4;
        }
    }

    public void add(Quaternion quaternion) {
        this.s += quaternion.s;
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
    }

    public Quaternion sum(Quaternion quaternion) {
        return new Quaternion(this.s + quaternion.s, this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z);
    }

    public void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Quaternion conjugated() {
        return new Quaternion(this.s, -this.x, -this.y, -this.z);
    }

    public void multiply(Quaternion quaternion) {
        double d = this.s * quaternion.s - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        double d2 = this.s * quaternion.x + this.x * quaternion.s + this.y * quaternion.z - this.z * quaternion.y;
        double d3 = this.s * quaternion.y - this.x * quaternion.z + this.y * quaternion.s + this.z * quaternion.x;
        double d4 = this.s * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.s;
        this.s = d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Quaternion product(Quaternion quaternion) {
        double d = this.s * quaternion.s - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        double d2 = this.s * quaternion.x + this.x * quaternion.s + this.y * quaternion.z - this.z * quaternion.y;
        double d3 = this.s * quaternion.y - this.x * quaternion.z + this.y * quaternion.s + this.z * quaternion.x;
        double d4 = this.s * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.s;
        return new Quaternion(d, d2, d3, d4);
    }

    public void normalize() {
        double d = Math.sqrt(this.s * this.s + this.x * this.x + this.y * this.y + this.z * this.z);
        this.s /= d;
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public Quaternion normalized() {
        double d = Math.sqrt(this.s * this.s + this.x * this.x + this.y * this.y + this.z * this.z);
        return new Quaternion(this.s / d, this.x / d, this.y / d, this.z / d);
    }

    public boolean equals(Quaternion quaternion) {
        return this.s == quaternion.s && this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z;
    }

    public double[] rotated(double[] dArray) {
        double d = this.s * this.x;
        double d2 = this.s * this.y;
        double d3 = this.s * this.z;
        double d4 = this.x * this.x;
        double d5 = this.x * this.y;
        double d6 = this.x * this.z;
        double d7 = this.y * this.y;
        double d8 = this.y * this.z;
        double d9 = this.z * this.z;
        double[][] dArrayArray = new double[][]{{2.0 * (0.5 - d7 - d9), 2.0 * (d5 - d3), 2.0 * (d6 + d2)}, {2.0 * (d5 + d3), 2.0 * (0.5 - d4 - d9), 2.0 * (d8 - d)}, {2.0 * (d6 - d2), 2.0 * (d8 + d), 2.0 * (0.5 - d4 - d7)}};
        double[] dArray2 = new double[3];
        int n = 0;
        while (n < 3) {
            dArray2[n] = dArrayArray[n][0] * dArray[0] + dArrayArray[n][1] * dArray[1] + dArrayArray[n][2] * dArray[2];
            ++n;
        }
        return dArray2;
    }
}

