mma.polygon <- function(pmat,file=cur.LG,digits=mma.digits,...) {
  cat("Polygon[{",append=TRUE,file=file,...)
  cat(paste(apply(pmat,1,function(z)do.call("mma.triplet",
                                            as.list(c(z,
#                                                      digits=eval(digits,parent.frame())
                                                      digits=digits
                                                      )))),
            collapse=","),
      file=file,append=TRUE)
  cat("}]",append=TRUE,file=file,...)
}

LGmobius <- function(n=100,r=2,w=1,fn="mobius") {
  LG.open(fn)
  invisible(sapply(0:(n-1),
                   function(i){f <- i/n;
                               f2 <- (i+1)/n;
                               mma.polygon(matrix(c(r*cos(2*pi*f),
                                                    r*sin(2*pi*f)+w/2*cos(pi*f),
                                        w/2*sin(pi*f),
                                        r*cos(2*pi*f2),
                                        r*sin(2*pi*f2)+w/2*cos(pi*f2),
                                        w/2* sin(pi*f),
                                        r*cos(2*pi*f2),
                                        r*sin(2*pi*f2)-w/2*cos(pi*f),
                                        -w/2*sin(pi*f),
                                        r*cos(2*pi*f),
                                        r*sin(2*pi*f)-w/2*cos(pi*f),
                                        -w/2*sin(pi*f)),
                                      byrow=TRUE,ncol=3));
                             mma.sep()}))
  LG.close()
}

## add text ?
## EdgeForm?
## scale rate of edge twist
