#source("dispcolor.R")
#testcol <- function(n1=20,n2=20,white=80,msd=1,plotit=TRUE) {
#  t.arr <- array(dim=c(n1,n2,3))
#  mrad <- n1/3
#  cctr <- c(n1/2,n2/2)
#  pctrs.x <- cctr[1]+mrad*cos(2*pi*(0:4)/5)
#  pctrs.y <- cctr[2]+mrad*sin(2*pi*(0:4)/5)
#  for (i1 in 1:n1)
#    for (i2 in 1:n2) {
#      t.arr[i1,i2,] <-  colfun(i1,i2,
#                               ctrs.x=pctrs.x,
#                               ctrs.y=pctrs.y,msd=msd,white=white,n1=n1,n2=n2)
#    }
#  if (plotit) {
#    imagenrgb(t.arr)
#    points(pctrs.x,pctrs.y,cex=2,pch=23,bg="white",col="white")
#    points(cctr[1],cctr[2],cex=2,pch=23,bg="blue")
#  }
#  invisible(t.arr)
#}

#t1 <- testcol()
#t1 <- testcol(msd=1)
#t1 <- testcol(msd=1,white=0)
#t1 <- testcol(msd=1,white=100)
#t1 <- testcol(msd=1,white=150)
#t1 <- testcol(msd=0.1)

#image(t1[,,1])
#image(t1[,,2])
#image(t1[,,3])
#
#imagenrgb(t1)
#points(pctrs.x,pctrs.y,cex=3,pch=23,bg="white",col="white")


## play with lighting, EdgeForm[], colors:
## Gaussian mixture distribution with periodic boundary conditions?
## color = red, green, blue, cyan, magenta
## centers = pentagon in unit square

LGtoruswrap <- function(x1,y1,x2,y2,n1,n2) {
  xdist <- pmin(abs(x1-x2),n1-abs(x1-x2))
  ydist <- pmin(abs(y1-y2),n2-abs(y1-y2))
  sqrt(xdist^2+ydist^2)
}

LGtoruscolfun <- function(pt.x,pt.y,ctrs.x,ctrs.y,msd=n1/5,
                   white=0,n1=20,n2=20) {
  wts <- dnorm(LGtoruswrap(ctrs.x,ctrs.y,pt.x,pt.y,n1,n2),mean=0,sd=msd)
  wts <- wts/sum(wts)
  cols <- col2rgb(c("red","green","blue","cyan","magenta"))
  pcol <- apply(t(cols)*wts,2,mean)
  pcol <- pmin(pcol+white,255)
  pcol
}


LGtorus <- function(fn="tor8",coltype="patch",mesh=FALSE,white=80,msd=0.4,
                     n1=20,n2=20,rad1=8,rad2=5) {
  tcoord <- function(ctr,ang1,ang2,rad1,rad2) {  ## torus coordinates -> (x,y,z)
    x <- ctr[1]+cos(ang1)*rad1
    y <- ctr[2]+sin(ang1)*rad1
    x <- x+cos(ang1)*cos(ang2)*rad2
    y <- y+sin(ang1)*cos(ang2)*rad2  ## fixed bug sin(ang2) -> cos(ang2)
    z <- ctr[3]+sin(ang2)*rad2
    c(x,y,z)
  }
  tc2 <- function(ctr,i1,n1,i2,n2,rad1,rad2) {
    tcoord(ctr,2*pi*i1/n1,2*pi*i2/n2,rad1,rad2)
  }
  LG.open(basename=fn,
          options=list(lighting=FALSE,boxrat=c(1,1,0.3),
            axes=FALSE,box=FALSE),
          check.file=FALSE)
  ctr <- c(0,0,0)
  mrad <- n1/2
  cctr <- c(n1/2,n2/2)
  pctrs.x <- cctr[1]+mrad*cos(2*pi*(0:4)/5)
  pctrs.y <- cctr[2]+mrad*sin(2*pi*(0:4)/5)
                                        #
  for (i1 in 1:n1) {
    for (i2 in 1:n2) {
      p1 <- tc2(ctr,i1-1,n1,i2-1,n2,rad1,rad2)
      p2 <- tc2(ctr,i1-1,n1,i2  ,n2,rad1,rad2)
      p3 <- tc2(ctr,i1  ,n1,i2  ,n2,rad1,rad2)
      p4 <- tc2(ctr,i1  ,n1,i2-1,n2,rad1,rad2)
      if (coltype=="patch") {
        if (i1/n1 <0.2)
          col <- "red"
        else if (i1/n1 <0.8)
          col <- "blue"
        else if (i2/n2 <1/3)
          col <- "cyan"
        else if (i2/n2 >2/3)
          col <- "magenta"
        else
          col <- "green"
        ## cols[((i1+i2) %% 10+1)*5]
      }
      else if (coltype=="spots") {
        col <- do.call("rgb",as.list(LGtoruscolfun(i1,i2,
                                            ctrs.x=pctrs.x,
                                            ctrs.y=pctrs.y,
                                            msd=msd,white=white,n1=n1,n2=n2)/255))
      }
      mma.color(col)
      mma.sep()
      if (mesh) {
        ## switch p3 and p4 to get "mesh" effect
        mma.polygon(rbind(p1,p2,p4,p3))
      } else {
        mma.polygon(rbind(p1,p2,p3,p4))
      }
      mma.sep()
    }
  }
  LG.close()
}

#do.torus(coltype="spots",white=120)


## OK, neither the colors nor the distribution are right -- but work
## on this later ...
