\name{LG.open}
\alias{LG.open}
\alias{LG.close}
\title{open and close LiveGraphics3D files}
\description{
  Opens and closes LiveGraphics3D files, which use a Java applet to
  allow the display of rotatable and "zoomable" graphics in a browser
  window.  LiveGraphics3D uses Mathematica graphics format to describe
  3D graphics objects (including points, lines, polygons, etc.).
}
\usage{
LG.open(basename="LG", type="html", display=FALSE, check.file=TRUE,options=NULL, fn)
LG.close(fn=cur.LG,type=cur.LG.type,options=cur.LG.options,display=cur.LG.display)
}
\arguments{
  \item{basename}{base filename (not including extension) of graphics
    output file}
  \item{type}{"mma" for a raw Mathematica file; "html" for an HTML file
    with header information for using LiveGraphics3D}
    \item{options}{any options for the display of the LiveGraphics3D
    object.  (At the moment these include lighting, box ratios, and axis
    labels; see \code{\link{mma.options}} for more details.)}
  \item{display}{attempt to display graphic in browser when closed?}
  \item{fn}{alternative to basename; complete file name for output}
  \item{check.file}{(logical) check before overwriting existing output files?}
}
\details{
  \code{LG.open} opens an appropriate file (doing some checking to see
  whether it exists already), puts in initialization/header information,
  and sets several global variables (\code{cur.LG},
  \code{cur.LG.type}, and \code{cur.LG.options}), which are used by
  subsequent LiveGraphics3D calls and by \code{LG.close}.
  \code{LG.close} adds a footer and (if \code{display==TRUE}) attempts to
  display the result in a browser window.  The Java library
  \code{live.jar} must exist in the working directory for this to
  succeed (see \code{\link{get.live.jar}}).  To serve these graphics on the web, put the HTML files
  generated, along with \code{live.jar}, in your web directory.
  \code{LG.html.head} and \code{LG.html.tail} are tacked onto the
  front and back of Mathematica code to make the output into a valid
  HTML file.
}
\value{
  Sets global variables (see above).
}
\references{To download the LiveGraphics3D library \code{live.jar}
  (written by Martin
  Kraus, free for non-commercial use, and licensable from Wolfram
  Research for commercial use), or for more information, see the
  URLs
  \url{http://wwwvis.informatik.uni-stuttgart.de/~kraus/LiveGraphics3D/download.html} and 
 \url{http://www.mathsource.com/Content/Enhancements/Interfacing/Web/0209-281}.}
\author{Ben Bolker}
\note{Very big graphics objects (such as the volcano example shown by
  \code{examples(persp)}) take some time to load and are too big to
  rotate, at least on my machine.  At the moment the \code{display}
  option is tied to the working directory.}
\seealso{Graphics primitives for LiveGraphics3D:
  \code{\link{mma.point}}, \code{\link{mma.line}}, etc.}
\examples{
\dontrun{  ## disable because of "display" issues
## Pick normally distributed random numbers for (x,y,z) coordinates
x <- rnorm(20)
y <- rnorm(20)
z <- rnorm(20)
labels <- LETTERS[1:20]
toff <- 0.1                    ## offset of text from point location
psize <- runif(20,0.001,0.1)   ## random point sizes, unif distrib. (0.001,0.1)
col <- round(runif(20,2,6))    ## random colors between 1 and 5
LG.open("3dpoints",options=list(lighting=FALSE),type="display")
mma.point(x,y,z,col=col,pointsize=psize)  ## points
mma.sep()
mma.text(x-toff,y-toff,z-toff,labels,col="black")  ## text
LG.close()

## Mimic persp() example, but reduce mesh size for performance reasons
x <- seq(-10, 10, length = 60)
y <- x
f <- function(x, y) {
    r <- sqrt(x^2 + y^2)
    10 * sin(r)/r
}
z <- outer(x, y, f)
z[is.na(z)] <- 1
LG.open("sinc",type="display")
mma.persp(x, y, z, thin=2)
LG.close()
}
}
\keyword{hplot}
\keyword{dynamic}

