\name{LG.plot.profiles}
\alias{LG.plot.profiles}
\title{Plot likelihood surface + profiles using Live3D}
\description{
  Given a two-parameter likelihood surface, profile information for both
  parameters, and a best-fit points, produces a plot showing all of this
  information
}
\usage{
LG.plot.profiles(basename, x, y, surf, best, prof1, prof2, xlab = "x", ylab = "y", zlab = "z", colors = heat.colors(100), thin = 1, profcol = c("red", "green"), ptcol = "blue",fn=cur.LG)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{basename}{base name (without extension) of output file}
  \item{x}{vector of x coordinates}
  \item{y}{vector of y coordinates}
  \item{surf}{numeric matrix containing likelihood surface}
  \item{best}{3-vector representing best-fit point}
  \item{prof1}{3-column matrix giving coordinates of the likelihood
    profile in the x direction}
  \item{prof2}{3-column matrix giving coordinates of the likelihood
    profile in the y direction}
  \item{xlab}{x label}
  \item{ylab}{y label}
  \item{zlab}{z label}
  \item{colors}{colors for likelihood surface as a function of elevation}
  \item{thin}{thinning factor for plotting the surface}
  \item{profcol}{color for profile lines}
  \item{ptcol}{color for best-fit point}
  \item{fn}{file name}
}
\value{
  Produces an HTML/Live3D output file
}
\author{Ben Bolker}
\keyword{hplot}
\keyword{dynamic}
