\name{LGtoruswrap}
\alias{LGtoruswrap}
\alias{LGtoruscolfun}
\title{Utility functions for LGtorus}
\description{
  Wraps coordinate distances around the torus and generates appropriate colors
  for an LG-drawn torus with different-colored spots on it (with
  Gaussian weighting/interpolation)
}
\usage{
LGtoruswrap(x1, y1, x2, y2, n1, n2)
LGtoruscolfun(pt.x,pt.y,ctrs.x,ctrs.y,msd=n1/5,
                   white=0,n1=20,n2=20)
}
\arguments{
  \item{x1}{x location(s) of point 1}
  \item{y1}{y location(s) of point 1}
  \item{x2}{x location(s) of point 2}
  \item{y2}{y location(s) of point 2}
  \item{n1}{max distance/number of segments in x direction}
  \item{n2}{max distance/number of segments in y direction}
  \item{pt.x}{x locations}
  \item{pt.y}{y locations}
  \item{ctrs.x}{x locations of centers}
  \item{ctrs.y}{y locations of centers}
  \item{msd}{standard deviation of normal distrib.}
  \item{white}{?}
}
\details{
  These are fairly special-purpose functions designed for a particular
  picture I was trying to draw, that showed the location of clusters on
  a torus; different clusters were colored differently, with
  interpolation between them
}
\value{
  LGtoruswrap returns a numeric vector of wrapped distances between the first
  and second points; LGtoruscolfun returns a vector of colors
  appropriate to the list of points
}
\author{Ben Bolker}
\keyword{hplot}
\keyword{color}
