\name{mma.brace}
\alias{mma.start}
\alias{mma.end}
\alias{mma.brace}
\alias{mma.sep}
\alias{mma.triplet}
\alias{mma.color}
\alias{mma.options}
\alias{mma.end}
\alias{mma.digits}
\title{Low-level graphics primitives for LiveGraphics3D}
\description{
  Generate low-level details of 3D graphics objects in Mathematica
  graphics format (and write them to the current LiveGraphics3D
  file).
}
\usage{
mma.start(file=cur.LG, ...)
mma.end(file=cur.LG, ...)
mma.brace(file=cur.LG, ...)
mma.sep(file=cur.LG, ...)
mma.color(col,file=cur.LG,digits=mma.digits)
mma.triplet(x,y,z,digits=mma.digits)
mma.digits
}
\arguments{
  \item{file}{output file.  \code{cur.LG} is the current default file
    name for LiveGraphics3D objects}
  \item{col}{a color specification, in any of the forms allowed by
    \code{\link{col2rgb}}}
  \item{x,y,z}{3D coordinates of a points (numeric objects or vectors)}
  \item{digits}{significant digits to output}
  \item{...}{further arguments to cat()}
}
\details{
  \describe{
  \item{\code{mma.start} and \code{mma.end}}{open and close a Mathematica
    graphics object; they are mostly unnecessary if you use
    \code{\link{LG.open}} and \code{\link{LG.close}} to make
    LiveGraphics3D files.}
  \item{\code{mma.brace} and \code{mma.sep}}{write
    braces and separators to a LG3D file; \code{mma.sep} is required
    between objects.}
  \item{\code{mma.color}}{writes a Mathematica color specification to the
    LG3D file.}
  \item{\code{mma.triplet}}{is a low-level function to translate a triple
    of points to Mathematica format, and write it to the file.}
  \item{\code{mma.edge}}{changes the color of subsequent edges in the
    output}
  \item{\code{mma.digits}}{is the default number of digits (precision)
    for output}
}
}
\value{
  These functions do not produce results, but write various output to
  the current LG3D file (\code{cur.LG}).
}
\author{Ben Bolker}
\seealso{\code{\link{LG.open}}, \code{\link{mma.point}},
         \code{\link{col2rgb}}}
\keyword{hplot}
\keyword{dynamic}
