\name{mma.persp}
\alias{mma.persp}
\title{Output a perspective plot to a LiveGraphics3D file}
\description{
  Generates a perspective plot of a surface in Mathematica graphics
  format and sends it (by default) to the current LiveGraphics3D output
  file.
}
\usage{
mma.persp(x, y, z, digits=mma.digits, color.type="NONE", colors=topo.colors(100), thin=1, file=cur.LG, border=par("fg"),...)
}
\arguments{
  \item{x,y}{locations of grid lines at which the values in `z' are
    measured.  These must be in ascending order.}
  \item{z}{a matrix containing the values to be plotted.}
  \item{digits}{number of significant digits to write to output
    (mma.digits is a default setting)}
  \item{color.type}{
    Type of surface coloring.
    \describe{
    \item{"NONE"}{no coloring (except that imposed by lighting)}
    \item{"Z"}{color according to z-coordinate}
   }
  }
  \item{colors}{Color vector to use for coloring the surface}
  \item{thin}{thinning factor for the surface and coordinate vectors}
  \item{file}{output file: default is the current LG3D output file}
  \item{border}{color for border of polygons}
  \item{...}{additional arguments to \code{\link{cat}}}
}
\value{
  No value; writes to the output file.
}
\author{Ben Bolker}
\note{Additional 3D graphics objects can be added to the plot using
  \code{\link{mma.point}} etc.
}
\seealso{\code{\link{mma.point}},\code{\link{LG.open}}}
\keyword{hplot}
\keyword{dynamic}
