\name{mma.point}
\alias{mma.point}
\alias{mma.line}
\alias{mma.text}
\title{Medium-level graphics primitives for LiveGraphics3D}
\description{
  Generate graphics objects in 3D coordinates -- points, lines, or text
  strings -- in Mathematica graphics format and write them to the
  current LiveGraphics3D file.
}
\usage{
mma.point(x, y, z, digits=mma.digits, col=par("fg"), pointsize=0.01, file=cur.LG,
...)
mma.text(x,y,z,text,digits=mma.digits,col=par("fg"),file=cur.LG,...)
mma.line(x,y,z,digits=mma.digits,col=par("fg"),lwd=par("lwd"),file=cur.LG,...)
}
\arguments{
  \item{x,y,z}{3D location coordinates (numeric objects or vectors)}
  \item{text}{Text string to plot}
  \item{digits}{number of significant digits to write to file}
  \item{file}{output file; default is the current LG3D file,
    \code{cur.LG}}
  \item{col}{color specification (anything appropriate for
    \code{\link{col2rgb}})}
  \item{pointsize}{point size (as a fraction of plot size)}
  \item{lwd}{line width}
  \item{...}{additional arguments to cat()}
}
\value{
  No value returned; these functions write output to the current LG3D
  graphics file by default.
}
\author{Ben Bolker}
\note{Different Mathematica graphics objects should probably be separated by
  \code{\link{mma.sep}} (q.v.).}
\seealso{\code{\link{LG.open}},\code{\link{mma.sep}}}
\keyword{hplot}
\keyword{dynamic}
