`mailmerge` <-
function(data,  ## data frame with names corresponding to fields
                      msgfile, ## message text
                      delim="##", ## begin/end delimiters
                      mail=FALSE, ## send mail?
                      ofile=TRUE, ## create output files?
                      id="email",     ## data field to use as id
                      email="email",  ## name of email address field in data
                      fake=FALSE,     ## simulate sending mail only
                      auth=FALSE,
                      passwd=NULL,
                      trace=0,    ## tracing: 1= print ids/data, 2=also SMTP verbose
                      ...) {      ## additional args
  if (auth) {
    if (is.null(passwd)) passwd <- getPassword()
  }
  delim <- strsplit(delim,"")[[1]]
  if (length(delim)==1) delim <- rep(delim,2)
  fieldnames <- colnames(data)
  nfields <- ncol(data)
  ## error checking ...
  msg <- readLines(msgfile)
  for (i in 1:nrow(data)) {
    if (trace>0) cat(data[i,id],"\n")
    curmsg <- msg
    for (j in 1:length(msg)) {
      for (k in 1:nfields) {
        curmsg[j] <- gsub(pattern=paste(delim[1],fieldnames[k],delim[2],sep=""),
                       replacement=data[i,k],
                          x=curmsg[j])
      }
    }
    if (ofile) {
      cat(curmsg,file=paste("mmerge",gsub(" ","_",data[i,id]),"txt",sep="."),sep="\n")
    }
    if (mail) {
      if (nchar(data[i,email])>0) {
        if (fake) {
          fake.send.mail(curmsg,to=data[i,email],verbose=(trace>1),auth=auth,passwd=passwd,...)
        } else {
          send.mail(text=curmsg,to=data[i,email],verbose=(trace>1),auth=auth,passwd=passwd,...)
        }
      }
    }
  }
}

