`send.mail` <-
function(text,
                      to,
                      from, ## ="bolker@zoo.ufl.edu",
                      hostname, ## ="bolker-lap.zoo.ufl.edu",
                      auth=FALSE,user=NULL,passwd=NULL,
                      server, ## "smtp.ufl.edu",
                      verbose=FALSE,
                      port=25) {
  if (auth) {
    if (!require(caTools)) stop("install caTools package for base64encode()")
    if (is.null(passwd)) passwd <- getPassword()
    if (is.null(user)) stop("must specify user for authentication")
  }
  m <- make.socket(server,port=port)
  ws <- if(!verbose) {
    function(s) { write.socket(m,s) }
  } else {
    function(s) {cat(">>",s,"\n"); write.socket(m,paste(s,"\n",sep="")) }
  }
  rs <- function() { if (verbose) print(read.socket(m))}
  rs()
  on.exit(close.socket(m))
  ws(paste("EHLO",hostname))
  rs()
  if (auth) {
    ws("AUTH LOGIN")
    rs()
    ws(caTools::base64encode(user))
    rs()
    ws(caTools::base64encode(passwd))
    rs()
  }
  ws(paste("MAIL From:<",from,">",sep=""))
  rs()
  ws(paste("RCPT To:<",to,">",sep=""))
  rs()
  ws("DATA")
  sapply(text,function(t)ws(t))
  ws(".")
  rs()
  ws("QUIT")
  rs()
}

