\name{mailmerge}
\alias{mailmerge}
\title{e-mail merge}
\description{
  send a series of e-mails with variables filled in from a data frame
}
\usage{
mailmerge(data, msgfile, delim = "##", mail = FALSE, ofile = TRUE, id = "email", email = "email", fake = FALSE, auth = FALSE, passwd = NULL, trace = 0, ...)
}
\arguments{
  \item{data}{data frame holding variables}
  \item{msgfile}{a text file holding the message}
  \item{delim}{(character) opening and/or closing delimiters for
    variable fields}
  \item{mail}{(logical) really send mail?}
  \item{ofile}{(logical) save output files for each message?}
  \item{id}{(character) name of data field to use as the name of output files}
  \item{email}{(character) name of e-mail field}
  \item{fake}{(logical) fake e-mail sending?}
  \item{auth}{(logical) authentication required?}
  \item{passwd}{(logical) password for authentication (if null, will be
    prompted for)}
  \item{trace}{(logical) print out details?}
  \item{\dots}{additional arguments to \code{\link{send.mail}}}
}
\details{
  Output files will be saved as mmerge.ID.txt, where ID is the value
  taken from the "id" field for each e-mail message
}
\value{
  None; e-mails will be sent and output files may be saved
}
\author{Ben Bolker}
\keyword{misc}
