\name{send.mail}
\alias{send.mail}
\title{send e-mail via R}
\description{
   Contacts an SMTP server and sends e-mail
}
\usage{
send.mail(text, to, from, hostname, auth = FALSE, user = NULL, passwd = NULL, server, verbose = FALSE, port = 25)
}
\arguments{
  \item{text}{a character vector containing lines of an e-mail message}
  \item{to}{(character) e-mail address of recipient}
  \item{from}{(character) e-mail address of sender}
  \item{hostname}{(character) name of sending host}
  \item{auth}{(logical) authorization required?}
  \item{user}{(character) username for authentication}
  \item{passwd}{(character) password for authentication}
  \item{server}{(character) name of SMTP server}
  \item{verbose}{(logical) print details?}
  \item{port}{(integer) port number for sending e-mail (defaults to 25,
    but 587 may be appropriate for protected servers)}
}
\details{
  Connects to the server, sends e-mail, and quits
}
\value{
  None
}
\author{Ben Bolker}
\examples{
\dontrun{
  sendmail(c("first line","second line","third line"),
   from="bolker@ufl.edu", to="somebody@somewhere.org")
}
}
\keyword{misc}

