## Define UI
## 
## it would be cute to have a slider bar with *two* sliders,
## one for each species, but not necessarily practical, and
## lots of work
shinyUI(pageWithSidebar(
    ## Application title
    headerPanel("competition models"),
    ## Sidebar with a slider input for number of observations
    sidebarPanel(
        radioButtons("whichPlot","Plot",
                     choices=c("phase plane"="pp",
                     "dynamics"="time")),
        sliderInput("r1", ## "r[[1]]", 
                    "growth rate of species 1 [1/time]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("r2", ## "r[[2]]", 
                    "growth rate of species 2 [1/time]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("K1",
                    "carrying capacity of species 1 [ind/dens]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("K2",
                    "carrying capacity of species 2 [ind/dens]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("a21",
                    "comp effect of species 2 on species 1",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("a12",
                    "comp effect of species 1 on species 2",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("N01",
                    "starting density of species 1 [ind/dens]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("N02",
                    "starting density of species 2 [ind/dens]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("t.max",
                    "Maximum time [time]",
                    min=2,
                    max=100,
                    value=20),
        sliderInput("t.steps",
                    "Number of time steps",
                    min=10,
                    max=200,
                    value=100),
        sliderInput("fSize","Relative font size",
                    min=0.5,max=3.5,value=1,step=0.1),
        textInput('filename', "Filename",value="modelplot"),
        actionButton("printButton","Print")
        ),
    ## Show a plot of the generated distribution
    mainPanel(
        plotOutput("plot")
    )))
