## Define UI
## 
shinyUI(pageWithSidebar(
    ## Application title
    headerPanel("predation models"),
    ## Sidebar with a slider input for number of observations
    sidebarPanel(
        radioButtons("whichPlot","Plot",
                     choices=c("phase plane"="pp",
                     "dynamics"="time")),
        checkboxInput(inputId = "resDD",
                      label = "density-dependence and/or satiation",
                      value = FALSE),
        sliderInput("r.V", ## "r[[1]]", 
                    "growth rate of resource [1/time]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("b",
                    "attack rate of predators",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("c",
                    "efficiency of predators",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("d.P",
                    "death rate of predators",
                    min = 0,
                    max = 10, 
                    value = 0.5,
                    step = 0.1),
        sliderInput("N01",
                    "starting resource density [ind/area]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        sliderInput("N02",
                    "starting exploiter density [ind/area]",
                    min = 0,
                    max = 10, 
                    value = 1,
                    step = 0.1),
        conditionalPanel(condition="'input.resDD'",
                         sliderInput("K.V",
                                     "carrying capacity of resource [ind/area]",
                                     min = 0,
                                     max = 10, 
                                     value = 1,
                                     step = 0.1),
                         sliderInput("h",
                                     "predator satiation",
                                     min = 0,
                                     max = 10, 
                                     value = 0,
                                     step = 0.1),
                         sliderInput("alpha.P",
                                     "predator density-dependence",
                                     min = 0,
                                     max = 10, 
                                     value = 0,
                                     step = 0.1)),
        sliderInput("t.max",
                    "Maximum time [time]",
                    min=2,
                    max=100,
                    value=20),
        sliderInput("t.steps",
                    "Number of time steps",
                    min=10,
                    max=500,
                    value=100),
        sliderInput("fSize","Relative font size",
                    min=0.5,max=3.5,value=1,step=0.1),
        textInput('filename', "Filename",value="modelplot"),
        actionButton("printButton","Print")
        ),
    ## Show a plot of the generated distribution
    mainPanel(
        plotOutput("plot")
    )))
