\name{call.cpc}
\alias{call.cpc}
\alias{run.cpc}
\alias{read.cpc}
\title{Run Phillips's CPC program from R}
\description{
  Provides an interface to P. C. Phillips's implementation of Flury's
  algorithm for computing common principal components
}
\usage{
call.cpc(data = NULL, cov1 = NULL, cov2 = NULL, covs = NULL, npts =
c(200, 200),
                     progdir=file.path(.path.package("cpc"),"exec",
                       .Platform$OS.type),
                     progname="phillips-cpc.exe",
                     ansfn=tempfile("cpcans",tmpdir=progdir),
                     datfn=tempfile("cpcdat",tmpdir=progdir),
                     outfn=tempfile("cpcout",tmpdir=progdir),
                     unlink.temp=TRUE,
                     use="complete.obs")
read.cpc(outfn,ngrp,nvar)
run.cpc(covs,npts,                    progdir=file.path(.path.package("cpc"),"exec",
                      .Platform$OS.type),
                    progname="phillips-cpc.exe",
                    ansfn=tempfile("cpcans",tmpdir=progdir),
                    datfn=tempfile("cpcdat",tmpdir=progdir),
                    outfn=tempfile("cpcout",tmpdir=progdir),
                    unlink.temp=TRUE)
}
\arguments{
  \item{data}{a list of similarly shaped numeric matrices representing
    observations of multiple traits (columns) on multiple individuals
    (rows) in multiple groups}
  \item{cov1}{pre-computed covariance matrix of group 1 (for backward
    compatibility)} 
  \item{cov2}{pre-computed covariance matrix of group 2 (for backward
    compatibility)} 
  \item{covs}{list of pre-computed covariance matrices of all groups}
  \item{npts}{numeric vector, number of observations in each group}
  \item{ansfn}{file name for CPC control file}
  \item{datfn}{file name for CPC temporary data file}
  \item{outfn}{file name for CPC output file}
  \item{unlink.temp}{(logical) delete working files when finished?}
  \item{debug}{(logical) print debug messages?}
  \item{progdir}{(character) directory containing Phillips's CPC program}
  \item{progname}{(character) name of Phillips's CPC program}
  \item{ngrp}{(numeric) number of groups}
  \item{nvar}{(numeric) number of variables}
  \item{use}{method for missing observations when computing covariances
    (see \code{\link{cov}} for details)}
}
\details{
  \code{call.cpc()} is a wrapper for \code{run.cpc()}, which writes
  appropriate input files to disk and then calls Phillips's CPC program,
  and \code{read.cpc()}, which reads the resulting output file back into
  R.  At the moment \code{read.cpc()} and \code{call.cpc()} only return
  the CPC eigenvector matrix, although they could be extended.
}
\value{
  \code{run.cpc()} returns nothing (it calls the CPC program which
  creates an output file); \code{read.cpc()} returns a list with (at the
  moment) one element which is the CPC eigenvector matrix returned by
  the CPC program; \code{call.cpc()} returns this matrix alone.
}
\references{Uses CPC V0.96  (c) 1994-1999 Patrick C. Phillips,
  pphillips@uta.edu}
\seealso{\code{\link{pooled.cpc}}}
\author{Ben Bolker}
\examples{
   set.seed(1001)
   X = simdata(npts=1000,vars=c(10,5,2),cors=c(0.8,0.6,0.2))
   eigen(covmat(c(10,5,2),cor=c(0.8,0.6,0.2)))$vectors
   call.cpc(X)
   pooled.cpc(X)
}
\keyword{misc}



