\name{findbars}
\alias{findbars}
\title{Determine random-effects expressions from a formula}
\usage{
  findbars(term)
}
\arguments{
  \item{term}{a mixed-model formula}
}
\value{
  pairs of expressions that were separated by vertical bars
}
\description{
  From the right hand side of a formula for a mixed-effects
  model, determine the pairs of expressions that are
  separated by the vertical bar operator.
}
\section{Note}{
  This function is called recursively on individual terms
  in the model, which is why the argument is called
  \code{term} and not a name like \code{form}, indicating a
  formula.
}
\examples{
findbars(f1 <- Reaction ~ Days + (Days|Subject))
## => list( Days | Subject )
findbars(y ~ Days + (1|Subject) + (0+Days|Subject))
## => list of length 2:  list ( 1 | Subject ,  0+Days|Subject)
\dontshow{
stopifnot(identical(findbars(f1),
                    list(expression(Days | Subject)[[1]])))
}
}
\seealso{
  \code{\link{formula}}, \code{\link{model.frame}},
  \code{\link{model.matrix}}.

  Other utilities: \code{\link{mkRespMod}},
  \code{\link{mkReTrms}}, \code{\link{nlformula}},
  \code{\link{nobars}}, \code{\link{subbars}}
}
\keyword{models}
\keyword{utilities}

