\docType{methods}
\name{profile-methods}
\alias{profile.merMod}
\alias{profile-methods}
\title{Methods for profile() of [ng]lmer fitted models}
\usage{
  \method{profile}{merMod} (fitted, alphamax = 0.01,
    maxpts = 100, delta = cutoff/8, tr = 0, ...)
}
\arguments{
  \item{fitted}{a fitted model, e.g., the result of
  \code{\link{lmer}(..)}.}

  \item{alphamax}{used when \code{delta} is unspecified, as
  probability ... to compute \code{delta} ...}

  \item{maxpts}{...}

  \item{delta}{...}

  \item{tr}{...}

  \item{\dots}{potential further arguments for
  \code{profile} methods.}
}
\description{
  Methods for function \code{\link{profile}} (package
  \pkg{stats}), here for profiling (fitted) mixed effect
  models.
}
\section{Methods}{
  FIXME: These (signatures) will change soon --- document
  \bold{after} change! \describe{ \item{signature(fitted =
  \"merMod\")}{ ...  } }
}
\examples{
fm01ML <- lmer(Yield ~ 1|Batch, Dyestuff, REML = FALSE)
## 0.8s (on a 5600 MIPS 64bit fast(year 2009) desktop "AMD Phenom(tm) II X4 925"):
system.time( tpr <- profile(fm01ML) )
(confint(tpr) -> CIpr)
print(xyplot(tpr))
}
\seealso{
  For (more expensive) alternative confidence intervals:
  \code{\link{bootMer}}.
}
\keyword{methods}

