## simulated data
## ------------------------------------------
set.seed(101)
d <- expand.grid(block=LETTERS[1:26],rep=1:100)
d$x <- runif(nrow(d))
reff_f <- rnorm(length(levels(d$block)),sd=1)
## need intercept large enough to avoid negative values
d$eta0 <- 4+3*d$x  ## version without random effects
d$eta <- d$eta0+reff_f[d$block]
## inverse link
d$mu0 <- 1/d$eta0
d$mu <- 1/d$eta
d$y0 <- rgamma(nrow(d),scale=d$mu0/2,shape=2)
d$y <- rgamma(nrow(d),scale=d$mu/2,shape=2)

g0 <- glm(y0~x,data=d,family="Gamma")
coef(g0)  ## recovers correct values
g1 <- glm(y~x,data=d,family="Gamma")
coef(g1)  ## intercept biased downward? slope upward?
g2 <- glm(y~x+block-1,data=d,family="Gamma")
coef(g2)
summary(coef(g2)[-1])
sd(coef(g2)[-1]) ## low ...

library(lme4Eigen)
g1 <- glmer(y~x+(1|block),data=d,family="Gamma")
print(g1,corr=FALSE)

## real data ...
N <- read.csv("N.csv")  ## from Julieta Aranibar, 10-02-26

m1 <- glmer(amonio~tratamiento+micrositio+(1|repeticion), family=Gamma, data=N)
print(m1,corr=FALSE)
m2 <- glmer(amonio~tratamiento+micrositio+(1|repeticion), family=Gamma(link="log"), data=N)
print(m2,corr=FALSE)


 
