tickdata = read.table("Elston2001_tickdata.txt",header=TRUE,
  colClasses=c("factor","numeric","factor","numeric","factor","factor"))

tickdata <- transform(tickdata,cHEIGHT=scale(HEIGHT,scale=FALSE))
library(lme4)
st1 <- system.time(mod1_glmer <- glmer(TICKS~1+(1|BROOD)+(1|INDEX),
                                       family="poisson",data=tickdata))
st2 <- system.time(mod2_glmer <- update(mod1_glmer,.~.+YEAR))
st3 <- system.time(mod3_glmer <- update(mod1_glmer,.~.+HEIGHT))
st4 <- system.time(mod4_glmer <- update(mod2_glmer,.~.+HEIGHT))
st5 <- system.time(mod5_glmer <- update(mod2_glmer,.~.+(1|LOCATION)))
st6 <- system.time(mod6_glmer <- update(mod5_glmer,.~.+HEIGHT,verbose=TRUE))

st6
print(mod6_glmer,corr=FALSE)

detach("package:lme4",unload=TRUE)
library(lme4a)

sta1 <- system.time(mod1_glmer4a <- glmer(TICKS~1+(1|BROOD)+(1|INDEX),
                                          family="poisson",data=tickdata))
sta2 <- system.time(mod2_glmer4a <- update(mod1_glmer4a,.~.+YEAR))
sta3 <- system.time(mod3_glmer4a <- update(mod1_glmer4a,.~.+HEIGHT))
## Warning, Cholmod not positive definite
sta4 <- system.time(mod4_glmer4a <- update(mod2_glmer4a,.~.+HEIGHT))
## ditto
sta5 <- system.time(mod5_glmer4a <- update(mod2_glmer4a,.~.+(1|LOCATION)))
sta6 <- system.time(mod6_glmer4a <- update(mod5_glmer4a,.~.+HEIGHT,verbose=TRUE))
## ditto

sta6
print(mod6_glmer4a,corr=FALSE)
detach("package:lme4a",unload=TRUE)


