library(lme4Eigen)

fm01ML <- lmer(Yield ~ 1|Batch, Dyestuff, REML = FALSE)

## 0.8s (on a 5600 MIPS 64bit fast(year 2009) desktop "AMD Phenom(tm) II X4 925"):
## 
system.time( tpr <- profile(fm01ML) )

(confint(tpr) -> CIpr)
print(xyplot(tpr))
##  comparing against lme4a reference values -- but lme4Eigen returns sigma
## rather than log(sigma)
stopifnot(dim(CIpr) == c(3,2),
          all.equal(unname(CIpr[".sigma",]),exp(c(3.64362, 4.21446)), tol=1e-6))

## 2D profiles
fm2ML <- lmer(diameter ~ 1 + (1|plate) + (1|sample), Penicillin, REML=0)
pr2 <- profile(fm2ML)
print(xyplot(pr2, absVal=0, aspect=1.3, layout=c(4,1)))
print(splom(pr2))
