## from AllClass.R:

Ptr <<- .Call(merPredDCreate, as(X, "matrix"), Lambdat,
              LamtUt, Lind, RZX, Ut, Utr, V, VtV, Vtr,
              Xwts, Zt, beta0, delb, delu, theta, u0)

## we get Lambdat, Zt from mkReTrms
.Call(merPredDsetTheta, Ptr, theta)
.Call(merPredDupdateXwts, Ptr, Xwts)
   ## -> d_V = W*d_X
.Call(merPredDupdateDecomp, Ptr)

## need to replicate this code:

## from updateDecomp in predModule.cpp:

## what is Ut??
## if (n==N) ?? Ut is just Zt, otherwise it's Zt transformed in some way (AllClass.R:100)
updateL(); ##  -> calls updateLamtUt; it *looks* like LamtUt is just Lamt*Ut
           ##  -> and factorizes LamtUt to get L
d_RZX         = d_LamtUt * d_V;
## so we'd like (ideally) to be able to pause at this point and find out what RZX and L are ...
## condition numbers, ideally try out other solvers and see what's going on and why the solution
## is giving Inf in some places here ... are there Rcpp tools that could help us?
##  Can DB give advice?
if (d_p > 0) {
     d_L.solveInPlace(d_RZX, CHOLMOD_P);   ## solve Px=b (??)
     d_L.solveInPlace(d_RZX, CHOLMOD_L);   ## solve Lx=b (??)
     ##  https://svn.r-project.org/R-packages/trunk/Matrix/src/CHOLMOD/Cholesky/cholmod_solve.c
 }



## so this is approximately (????) trying to solve L_theta R_{ZX} = P Lambda_\theta^T Z^T X
##  brute force ... something like
## except that for GLMMs we do have to worry about weights etc.  (e.g. X is scaled by weights)
RZX <- reTrms$Lambdat %*% reTrms$Zt %*% X
M <- (reTrms$Lambdat %*% reTrms$Zt)
L <- chol(M %*% t(M))


###
## the analogous operations in lme4.0 are on l. 988 of src/lmer.c

## thoughts for fixes:
##  pivoting?
##  modification of theta?
##  drop back to Matrix operations?
