library("testthat")
library("lme4")

context("fitting lmer models")
test_that("lmer", {
    expect_warning(lmer(z~ 1|f, method="abc"),"Use the REML argument")
    expect_warning(lmer(z~ 1|f, method="Laplace"),"Use the REML argument")
    expect_warning(lmer(z~ 1|f, sparseX=TRUE),"has no effect at present")
    expect_that(fm1 <- lmer(Yield ~ 1|Batch, Dyestuff), is_a("lmerMod"))
    expect_that(fm1@resp,                               is_a("lmerResp"))
    expect_that(fm1@pp,                                 is_a("merPredD"))
    expect_that(fe1 <- fixef(fm1),                      is_equivalent_to(1527.5))
    expect_that(VarCorr(fm1)[[1]][1,1],                 equals(1764.07265427677))
    expect_that(isREML(fm1),                            equals(TRUE))
    expect_that(REMLfun <- as.function(fm1),            is_a("function"))
    expect_that(REMLfun(1),                             equals(319.792389042002))
    expect_that(REMLfun(0),                             equals(326.023232155879))
    expect_that(family(fm1),                            equals(gaussian()))
    expect_that(isREML(fm1ML <- refitML(fm1)),          equals(FALSE))
    ## expect_that(is.na(deviance(fm1)),                   equals(TRUE))
    expect_that(deviance(fm1ML),                        equals(327.327059881135))
    expect_that(sigma(fm1),                             equals(49.5100503990048))
    expect_that(sigma(fm1ML),                           equals(49.5100999308089))
    expect_that(extractAIC(fm1),                        equals(c(3, 333.327059881135)))
    expect_that(extractAIC(fm1ML),                      equals(c(3, 333.327059881135)))
    expect_that(vcov(fm1)[1,1],                         equals(375.720278729861))
    expect_that(vcov(fm1ML)[1,1],			equals(313.097218742665,
							       #was 313.097224695739
							       tol = 1e-7))
    expect_that(fm2 <- refit(fm1, Dyestuff2$Yield),     is_a("lmerMod"))
    expect_that(fixef(fm2),                             is_equivalent_to(5.6656))
    expect_that(VarCorr(fm2)[[1]][1,1],                 is_equivalent_to(0))
    expect_that(getME(fm2, "theta"),                    is_equivalent_to(0))
    expect_that(X  <- getME(fm1, "X"),                  is_equivalent_to(array(1, c(1, 30))))
    expect_that(Zt <- getME(fm1, "Zt"),                 is_a("dgCMatrix"))
    expect_that(dim(Zt),                                equals(c(6L, 30L)))
    expect_that(length(Zt@x),                           equals(30L))
    expect_that(Zt@x,                                   equals(rep.int(1, 30L)))
    expect_that(theta <- getME(fm1, "theta"),           is_equivalent_to(0.848330078125))
    expect_that(Lambdat <- getME(fm1, "Lambdat"),       is_a("dgCMatrix"))
    expect_that(as(Lambdat, "matrix"),                  is_equivalent_to(diag(theta, 6L, 6L)))
    expect_that(fm3 <- lmer(Reaction ~ Days + (1|Subject) + (0+Days|Subject), sleepstudy),                                              is_a("lmerMod"))
    expect_that(getME(fm3,"n_rtrms"),                   equals(1L))
})

