\name{confint.merMod}
\alias{confint.merMod}
\title{Compute confidence intervals on the parameters of an lme4 fit}
\usage{
  confint.merMod(object, parm, level = 0.95,
    method = c("profile", "Wald", "boot"), zeta,
    nsim = 500, boot.type = "perc", ...)
}
\arguments{
  \item{object}{a fitted [ng]lmer model}

  \item{parm}{parameters (specified by integer position or
  names)}

  \item{level}{confidence level}

  \item{method}{for computing confidence intervals}

  \item{zeta}{likelihood cutoff (if not specified, computed
  from \code{level}: "profile" only)}

  \item{nsim}{number of simulations for parametric
  bootstrap intervals}

  \item{boot.type}{bootstrap confidence interval type}
}
\value{
  a numeric table of confidence intervals
}
\description{
  Compute confidence intervals on the parameters of an lme4
  fit
}
\details{
  Depending on the method specified, this function will
  compute confidence intervals by ("profile") computing a
  likelihood profile and finding the appropriate cutoffs
  based on the likelihood ratio test; ("Wald") approximate
  the confidence intervals (of fixed-effect parameters
  only) based on the estimated local curvature of the
  likelihood surface; ("boot") compute confidence intervals
}

