#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "local.h"
#include <time.h>
//#include <WaveletLIB.h>

#ifndef DOUBLE_DWT
#define REAL float
#define REALDWT wxfrm_fand
#else
#define REAL double
#define REALDWT wxfrm_dand
#endif

#define DWT_FORWARD  1
#define DWT_BACKWARD  0

#define MEDIAN_WLT
#define BIG2SMALL 1
#define SMALL2BIG 0

#ifndef GRT
#define GRT(A,B) ((A).modx > (B).modx)
#endif

#ifndef LRT
#define LRT(A,B) ((A).modx < (B).modx)
#endif

#ifndef LRET
#define LRET(A,B) ((A).modx <= (B).modx)
#endif

#ifndef ITEM
typedef struct
{
  double modx;
  double f;
  double w;
}
item;
#define ITEM item
#endif

// Function headers;
double median_donoho(double* tab, int length, int N);
void IntQuickSort(ITEM *tab, int left, int right);
void QuickSort(ITEM *tab, int size);
int extract_scale(double *total, double *extracted, int dim, int size, int scale, int dir, int extracted_size, int way);
int extract_array_section(double** big,double** small,int dim,int* big_size,int* small_size,int* starts, int way);
int power(int num,int exp);
int jump(int *tab, int dim);

// Declaration of variables;
static waveletfilter* fltr=NULL;

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int MedianWltFilter_(REAL *DATA, REAL *WORK, REAL *WORK2, int* size,char* Wavelet,int* dim, int* iscoh, int* nelem_2)
{
  
  clock_t time_in,time_trans,time_out;
  register REAL Threshold2, s, mag2;
  REAL logN,stot,Threshold;
  register REAL *ptr;
  register int i,imax;
  int dimensions[3];
  int count=0;
  int n;

  if (fltr==NULL)
    {
      if (Wavelet!=NULL)
	{
	  if (strcmp(Wavelet,"")==0)
	    {
	      fprintf(stderr," Error when Calling MedianWltFilter : no Wavelet parameter defined ");
	      exit(EXIT_FAILURE);
	    }
	  if ((fltr=wfltr_select(Wavelet,&n))==NULL)
	    {
	      fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	      exit(n);
	    }
	}
      else
	if ((fltr=wfltr_select("Coiflet_4",&n))==NULL)
	  {
	    fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	    exit(n);
	  }

      fprintf(stderr,"MedianWltFilter : The selected filter is %s\n",Wavelet);
    }

  time_in = clock();

  dimensions[0]=dimensions[1]=dimensions[2]=*size;
  
  time_trans = clock();
  REALDWT(DATA, dimensions, *dim, DWT_FORWARD, 0, fltr, WORK);
  time_trans = clock() - time_trans;


  for (i=0,imax=1;i<(*dim);i++)
    imax *= dimensions[i];
  
  logN=log(imax);

  extract_scale(WORK,WORK2,*dim,*size,rint(log((double) *size)/log(2))-1,power(2,*dim)-1,(*size)/2,BIG2SMALL);

  Threshold=median_donoho(WORK2,*nelem_2,imax);

  Threshold2=Threshold*Threshold;
  
  if (*iscoh==1)
    for (i=0,s=0,stot=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	stot+=mag2;
	if (mag2<=Threshold2)
	  *ptr=0;
	else
	  {
	    s+=mag2;
	    count++;
	  }
      }
  else
    for (i=0,s=0,stot=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	stot+=mag2;
	if (mag2>Threshold2)
	  {
	    *ptr=0;
	    s+=mag2;
	    count++;
	  }
      } 

  REALDWT(WORK, dimensions, *dim, DWT_BACKWARD, 0, fltr, DATA);
  
  time_out = clock();

  s/=imax;
  stot/=imax;

/*   fprintf(stderr,"Temps pass dans MedianWltFilter pour la transforme directe : %10.8E\n",(double) (time_trans)*1.0/CLOCKS_PER_SEC); */
/*   fprintf(stderr,"Temps pass dans MedianWltFilter : %10.8E\n",(double) (time_out-time_in)*1.0/CLOCKS_PER_SEC); */

  if (*iscoh==1)
    fprintf(stderr,"MedianWltFilter Coh sigma : %12.10E  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",Threshold/sqrt(2*log(imax)),Threshold,sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);
  else
    fprintf(stderr,"MedianWltFilter Incoh sigma: %12.10E  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",Threshold/sqrt(2*log(imax)),Threshold,sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);

  return(EXIT_SUCCESS);

}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

double median_donoho(double* tab, int length, int N)
{
  int i;

  for (i=0;i<length;i++)
    tab[i]=(tab[i]>=0) ? tab[i] : -tab[i];

// There is an inconsistency here - above 'tab' is treated as a double array,
// whereas below it is treated as an pointer to an array of types ITEM
// ITEM and double are inconsistent!!!

  QuickSort(tab,length);


  if ((1 & length)==0)
    return (sqrt(2*log(N)) * (( tab[length/2-1] + tab[length/2] )/2) / 0.6745);
  else
    return(sqrt(2*log(N)) * tab[length/2-1] / 0.6745);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

void IntQuickSort(ITEM *tab, int left, int right)
{
  register ITEM v,t;
  register int i,j;

  if (right>left)
    {
      v=tab[right];
      i=left-1;
      j=right;

      do
        {
          do
            i++;
          while (LRT(tab[i],v));
          do
            j--;
          while (GRT(tab[j],v));

          t=tab[i];
          tab[i]=tab[j];
          tab[j]=t;
        }
      while (j>i);

      tab[j]=tab[i];
      tab[i]=tab[right];
      tab[right]=t;

      IntQuickSort(tab,left,i-1);
      IntQuickSort(tab,i+1,right);
    }

}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


void QuickSort(ITEM *tab, int size)
{
  IntQuickSort(tab,0,size-1);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int extract_scale(double *total, double *extracted, int dim, int size, int scale, int dir, int extracted_size, int way)
{
  double* big;
  double* small;
  int nscale,guessed_size;
  int big_size[32],small_size[32],starts[32];
  register int i,bit;

  if (size==0)
    {
      fprintf(stderr,"Error extracting scale, the size parameter cannot be zero !");
      exit(EXIT_FAILURE);
    }

  if ((nscale= rint(log((double) size)/log(2)) )<=scale)
    {
      fprintf(stderr,"Error extracting scale, the requested scale (%d) is greater than the maxscale (%d) !",scale,nscale-1);
      exit(EXIT_FAILURE);
    }

  if (total==NULL)
    {
      fprintf(stderr,"Error extracting scale, the input is NULL !");
      return(EXIT_FAILURE);
    }

  if (extracted==NULL)
    {
      fprintf(stderr,"Error extracting scale, the output is NULL !");
      exit(EXIT_FAILURE);
    }

  if ((dir<1)||(dir>=power(2,dim)))
    {
      fprintf(stderr,"Error extracting scale, the requested direction (%d) is out of range (1 - %d) !",dir,power(2,dim)-1);
      exit(EXIT_FAILURE);
    }

  /*  if (scale==0)
    {
      return(EXIT_FAILURE);
    }
    else*/
    {
      if (extracted_size!=(guessed_size=power(2,scale)))
	{
	  fprintf(stderr,"The provided array is of incorrect size !");
	  exit(EXIT_FAILURE);
	}

      bit=1;
      for (i=0;i<dim;i++)
	{
	  big_size[i]=size;
	  small_size[i]=guessed_size;
	  starts[i]=((bit & dir)!=0) ? guessed_size  : 0 ;
	  bit <<= 1;
	}

      big=total;
      small=extracted;
      extract_array_section(&big,&small,dim,big_size,small_size,starts,way);

    }
      
  return(EXIT_SUCCESS);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int extract_array_section(double** big,double** small,int dim,int* big_size,int* small_size,int* starts, int way)
{
  int i,jumpskip;
  if (dim>1)
    {
      *big+=starts[dim-1]*(jumpskip=jump(big_size,dim));
      for (i=0;i<small_size[dim-1];i++)
	extract_array_section(big,small,dim-1,big_size,small_size,starts,way);
      *big+=(big_size[dim-1] - small_size[dim-1] - starts[dim-1])*jumpskip;
    }
  else
    {
      *big+=starts[0];

      if (way==BIG2SMALL)
	for (i=0;i<small_size[0];i++,(*big)++,(*small)++)
	  **small=**big;
      else
	for (i=0;i<small_size[0];i++,(*big)++,(*small)++)
	  **big=**small;

      *big+=(big_size[0]-small_size[0]-starts[0]);
    }
  return(EXIT_SUCCESS);
}


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
// The function calculates an integer power of an integer number.
// Parameters:
//  num   - the argument;
//  exp   - the exponent;
/////////////////////////////////////////////////////////////////////////////////////////

int power(int num, int exp)
{
int i, result=1;

  for (i=0;i<exp;i++)
    result*=num;

  return (result);
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int jump(int *tab, int dim)
{
  if (dim==1)
    return(1);
  else
    return(tab[dim-2]*jump(tab, dim-1));
}
