#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "macro_definitions.i"

#ifndef MAX_MOVIES_NUMBER
#define MAX_MOVIES_NUMBER 100
#endif

#define PREC_MOVIE ("d")

#ifndef RECORDER_NAME
#define RECORDER_NAME ("dweezil")
#define RECORDER_COMMAND_LINE ("%s %d %d %s %s M RFlipVert %s > %s.mpg 2> %s.film.diag")
#endif

FILE* Movies[MAX_MOVIES_NUMBER];
int sizes_i[MAX_MOVIES_NUMBER];
int sizes_j[MAX_MOVIES_NUMBER];
int opened_movies=0;


void openmovieout_(int* UNIT, char* name, int* size_i, int* size_j)
{
  static char current_command_line[100];
  char* recorder_name;
  char* recorder_command_line;
  char* EXTRA_OPTION_VORT;
  char* EXTRA_OPTION_PVORT;
  char* EXTRA_OPTION_PRESS;
  char* EXTRA_OPTION_DIV;
  char* EXTRA_OPTION_COUR;
  char* EXTRA_OPTION_U;
  char* EXTRA_OPTION_V;
  char* EXTRA_OPTION_MODV;
  char* EXTRA_OPTION_BERNO;
  char* EXTRA_OPTION_ROSS;
  int i;

  if ((recorder_name=getenv("SW_RECORDER_NAME"))==NULL)
    recorder_name=RECORDER_NAME;
  else
    fprintf(stderr,"\nUsing recoder specified by environment variable SW_RECORDER_NAME : %s\n\n",recorder_name);
  
  if ((recorder_command_line=getenv("SW_RECORDER_CMD"))==NULL)
    recorder_command_line=RECORDER_COMMAND_LINE;
  else
    fprintf(stderr,"\nUsing recoder command line specified by environment variable SW_RECORDER_COMMAND_LINE : %s\n\n",recorder_command_line);

  if ((EXTRA_OPTION_VORT=getenv("EXTRA_OPTION_VORT"))==NULL)
    EXTRA_OPTION_VORT="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_VORT set to : %s\n\n",EXTRA_OPTION_VORT);

  if ((EXTRA_OPTION_PVORT=getenv("EXTRA_OPTION_PVORT"))==NULL)
    EXTRA_OPTION_PVORT="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_PVORT set to : %s\n\n",EXTRA_OPTION_PVORT);

  if ((EXTRA_OPTION_PRESS=getenv("EXTRA_OPTION_PRESS"))==NULL)
    EXTRA_OPTION_PRESS="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_PRESS set to : %s\n\n",EXTRA_OPTION_PRESS);

  if ((EXTRA_OPTION_DIV=getenv("EXTRA_OPTION_DIV"))==NULL)
    EXTRA_OPTION_DIV="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_DIV set to : %s\n\n",EXTRA_OPTION_DIV);

  if ((EXTRA_OPTION_COUR=getenv("EXTRA_OPTION_COUR"))==NULL)
    EXTRA_OPTION_COUR="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_COUR set to : %s\n\n",EXTRA_OPTION_COUR);

  if ((EXTRA_OPTION_U=getenv("EXTRA_OPTION_U"))==NULL)
    EXTRA_OPTION_U="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_U set to : %s\n\n",EXTRA_OPTION_U);

  if ((EXTRA_OPTION_V=getenv("EXTRA_OPTION_V"))==NULL)
    EXTRA_OPTION_V="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_V set to : %s\n\n",EXTRA_OPTION_V);

  if ((EXTRA_OPTION_MODV=getenv("EXTRA_OPTION_MODV"))==NULL)
    EXTRA_OPTION_MODV="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_MODV set to : %s\n\n",EXTRA_OPTION_MODV);

  if ((EXTRA_OPTION_BERNO=getenv("EXTRA_OPTION_BERNO"))==NULL)
    EXTRA_OPTION_BERNO="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_BERNO set to : %s\n\n",EXTRA_OPTION_BERNO);

  if ((EXTRA_OPTION_ROSS=getenv("EXTRA_OPTION_ROSS"))==NULL)
    EXTRA_OPTION_ROSS="";
  else
    fprintf(stderr,"\nUsing EXTRA_OPTION_ROSS set to : %s\n\n",EXTRA_OPTION_ROSS);

  if (opened_movies==0) /* No movie recorder is already started, initialize the Movies tab */
    for (i=0;i<MAX_MOVIES_NUMBER;i++)
      Movies[i]=NULL;
  
  if (opened_movies>=MAX_MOVIES_NUMBER)
    {
      fprintf(stderr,"\nError opening a new movie, the maximum number of movies is reached, %d\n\n",MAX_MOVIES_NUMBER);
      exit(EXIT_FAILURE);
    }

  /* Now, we initialize the command line according to name */

  current_command_line[0]='\0';

  if (strncmp("vort",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"vorticity c",PREC_MOVIE,EXTRA_OPTION_VORT,"vort","vort");

  if (strncmp("vpot",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"PV c",PREC_MOVIE,EXTRA_OPTION_PVORT,"pvort","pvort");

  if (strncmp("pres",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"pressure c",PREC_MOVIE,EXTRA_OPTION_PRESS,"press","press");

  if (strncmp("dive",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"divergence c",PREC_MOVIE,EXTRA_OPTION_DIV,"div","div");

  if (strncmp("cour",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"stream_function c",PREC_MOVIE,EXTRA_OPTION_COUR,"cour","cour");

  if (strncmp("Uvel",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"vorticity c",PREC_MOVIE,EXTRA_OPTION_U,"U","U");

  if (strncmp("Vvel",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"vorticity c",PREC_MOVIE,EXTRA_OPTION_V,"V","V");

  if (strncmp("modv",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"jet",PREC_MOVIE,EXTRA_OPTION_MODV,"modV","modV");

 if (strncmp("bern",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"PV c",PREC_MOVIE,EXTRA_OPTION_BERNO,"berno","berno");

  if (strncmp("ross",name,4)==0)
    sprintf(current_command_line,recorder_command_line,recorder_name,*size_i,*size_j,"vorticity c",PREC_MOVIE,EXTRA_OPTION_ROSS,"ross","ross");

  if (current_command_line[0]=='\0')
    {
      fprintf(stderr,"\nError opening a new movie, the name '%s' does not correspond to any known filed name\n\n",name);
      exit(EXIT_FAILURE);
    }
  
  /* Now, we open the first Movie file and lauch the recorder */
  
  if ((Movies[opened_movies]=popen(current_command_line,"w"))==NULL)
    {
      perror("\nProblem in popen\n\n");
      exit(EXIT_FAILURE);
    }

  sizes_i[opened_movies]=*size_i;
  sizes_j[opened_movies]=*size_j;
  
  *UNIT=opened_movies;
  opened_movies++;

}

void addframetomovie_(int* UNIT,double* datas)
{
  fwrite(datas,SIZE_OF_REAL,sizes_j[*UNIT]*sizes_i[*UNIT],Movies[*UNIT]);
}

void closemovie_(int* UNIT)
{
  pclose(Movies[*UNIT]);
  Movies[*UNIT]=NULL;
  sizes_i[*UNIT]=0;
  sizes_j[*UNIT]=0;
}
