#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "local.h"
#ifndef DOUBLE_DWT
#define REAL float
#define REALDWT wxfrm_fand
#else
#define REAL double
#define REALDWT wxfrm_dand
#endif

#define OUTPUT_FILE   "iters.dat"

#define DWT_FORWARD   1
#define DWT_BACKWARD  0
#include <time.h>

static waveletfilter* fltr=NULL;

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
// The function applies the recursive algorithm to determine the optimal threshold for 
// nonlinear wavelet filtering of the given field.
// Parameters:
// DATA    - input / output data;
// WORK    - scratch array for the wavelet transform;
// size    - integer array with sizes of the data array;
// Wavelet - name of the wavelet filter;
// dim     - dimension of the data array;
// iscoh   - flag determing whether coherent or incoherent part of the data field
//           should be returned;
// vec     - number of fields;
// verbose - verbosity level;
/////////////////////////////////////////////////////////////////////////////////////////

int RecurFilter_(REAL **DATA, REAL **WORK, int* size,char* Wavelet,int* dim, int* iscoh, 
                 int vec, int verbose )
{
  
clock_t time_in, time_trans, time_out;
register double Threshold2, s, mag2;
REAL logN, stot, *modulus2;
register REAL *ptr;
register int i, k, imax, count;
int  n, prevcount, niter;
int  dimensions[3];
FILE *fout;

 if (fltr==NULL)
 {
   if (Wavelet!=NULL)
   {
     if (strcmp(Wavelet,"")==0)
     {
       fprintf(stderr," Error when Calling RecurFilter : no Wavelet parameter defined ");
       exit(EXIT_FAILURE);
     }
     if ((fltr=wfltr_select(Wavelet,&n))==NULL)
     {
       fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
       exit(n);
     }
   }
   else
     if ((fltr=wfltr_select("Coiflet_4",&n))==NULL)
     {
       fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
       exit(n);
     }   
   if ( verbose )
     fprintf(stderr,"  RecurFilter: The selected filter is %s\n",Wavelet);
 }

// Opening file for output;
 if ( (fout = fopen( OUTPUT_FILE, "wt")) == NULL )
 {
   fprintf(stderr,"Cannot open the output file %s \n", OUTPUT_FILE);
   exit(EXIT_FAILURE);
 }
 else if ( verbose )
   fprintf(stderr,"  RecurFilter: Output saved in the file %s \n", OUTPUT_FILE);

 time_in = clock();

 dimensions[0]=dimensions[1]=dimensions[2]=*size;
 for (i=0,imax=1;i<(*dim);i++)
   imax *= dimensions[i];
  
 time_trans = clock();

// Allocating additional memory;
 if ((modulus2 = (REAL*)malloc(imax * sizeof(REAL)))==NULL )
 {
   fprintf(stderr,"Problem allocating memory\n");
   exit(EXIT_FAILURE);
 }

 for(k=0;k<vec;k++)
   REALDWT(DATA[k], dimensions, *dim, DWT_FORWARD, 0, fltr, WORK[k]);

 time_trans = clock() - time_trans;

// Calculating the modulus based on the components;
 for (i=0;i<imax;i++)
 {
   modulus2[i] = 0.0;     
   for (k=0;k<vec;k++)
     modulus2[i] += WORK[k][i] * WORK[k][i];
 }
  
 logN=log(imax);
 Threshold2=1E100;

 for (niter=0,prevcount=-1,count=0 ; prevcount!=count ; niter++)
 {
   prevcount=count;
   for (i=0,s=0,count=0,ptr=modulus2;i<imax;i++,ptr++)
   {
     mag2 = *ptr;
     if (mag2<=Threshold2)
     {
       count++;
       s+= mag2;
     }
   }
   if (niter==0)
     stot = s;   
   if ( verbose == 1 )
     fprintf(stderr,"niter %d count %d\n",niter,count);
   else if (verbose == 2 )
   {
     if (*iscoh==1)
       fprintf(stderr,"Niter: %3d  T: %12.10E  T/sqrt(Z): %4.2E  N: %5d  %%N: %6.2f  %%Z:  %5.2f\n",niter,sqrt(Threshold2),sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);
     else
       fprintf(stderr,"Niter: %3d  T: %12.10E  T/sqrt(Z): %4.2E  N: %5d  %%N: %6.2f  %%Z:  %5.2f\n",niter,sqrt(Threshold2),sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);     
   }

// Saving output to a file;
   if (*iscoh==1)
     fprintf(fout," %3d  %12.10E  %4.2E  %5d  %5.2f  %6.2f\n",niter,sqrt(Threshold2),sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);
   else
     fprintf(fout," %3d  %12.10E  %4.2E  %5d  %5.2f  %6.2f\n",niter,sqrt(Threshold2),sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);     
   
   Threshold2 = 2.0 * s * logN / imax;
//   Threshold2 = 2.0 * s * logN / (imax * vec);
 }
 
 if (*iscoh==1)
 {
   for (i=0;i<imax;i++)
     if ( modulus2[i] <= Threshold2 )
       for(k=0;k<vec;k++)
	 WORK[k][i] = 0.0;
 }
 else
 {
   for (i=0;i<imax;i++)
     if ( modulus2[i] > Threshold2 )
       for(k=0;k<vec;k++)
	 WORK[k][i] = 0.0;
 } 

 for(k=0;k<vec;k++)
   REALDWT(WORK[k], dimensions, *dim, DWT_BACKWARD, 0, fltr, DATA[k]);
  
 time_out = clock();

 fclose(fout);

/*   fprintf(stderr,"Temps pass dans RecurFilter pour la transforme directe : %10.8E\n",(double) (time_trans)*1.0/CLOCKS_PER_SEC); */
/*   fprintf(stderr,"Temps pass dans RecurFilter : %10.8E\n",(double) (time_out-time_in)*1.0/CLOCKS_PER_SEC); */

 if ( verbose == 1 )
 {
   if (*iscoh==1)
     fprintf(stderr,"RecurFilter Niter: %d  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",niter-2,sqrt(Threshold2),sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);
   else
     fprintf(stderr,"RecurFilter Niter: %d  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",niter-2,sqrt(Threshold2),sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);
 }

 return(EXIT_SUCCESS);

}
