#include <rfftw.h>


#ifndef REAL
#define REAL double
#endif


void fftwfax_(int* n, int* ifax, REAL *trigs)
{
  rfftwnd_plan *plans;

  if ((2*sizeof(rfftw_plan))>19*sizeof(int))
    {
      perror("Error when using FFTWFAX, the plans cannot be hold in IFAX array because of architecture dependent reasons.\n");
      exit(EXIT_FAILURE);
    }
 
  plans=(rfftwnd_plan*) ifax;
  
  plans[0] = rfftwnd_create_plan(1, n, FFTW_REAL_TO_COMPLEX, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM );
  plans[1] = rfftwnd_create_plan(1, n, FFTW_COMPLEX_TO_REAL, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM );

}

void rfftwmlt_(REAL *x, REAL *work, REAL *trigs, int *ifax, int *inc1, int *inc2, int *n, int *lot, int *sign)
{
  int i,j,jump,limit;
  REAL *tmp1,*tmp2;
  rfftwnd_plan *plans;
  
  plans=(rfftwnd_plan*) ifax;

  if ((*sign)==-1)  /* real to complex transform */
    {
      /* Fourier transform */
      rfftwnd_real_to_complex(plans[0],*lot,(fftw_real*) x,*inc1,*inc2,(fftw_complex*) work, 1,(*n)/2 + 1);
      
      /* Rearrangement of complex data from work, back to x, and renormalization */
      tmp1=x; /* tmp1 scans the array x */
      tmp2=work; /* tmp2 scans work */
      limit=2*(((*n)/2)+1);
      jump=(*inc2)-(*inc1)*limit; /* this is the jump between the last element of a vector and the first element of the next vector */
      
      for (j=0;j<(*lot);j++)
	{
	  for (i=0;i<limit;i++)
	    {
	      *tmp1=(*tmp2)/(*n);
	      tmp1+=(*inc1);
	      tmp2++;
	    }
	  tmp1+=jump;
	}
    }
  else  /* complex to real transform */
    {
      /* Rearrangement of complex data from x, back to work */
      tmp1=x; /* tmp1 scans the array x */
      tmp2=work; /* tmp2 scans work */
      limit=2*(((*n)/2)+1);
      jump=(*inc2)-(*inc1)*limit; /* this is the jump between the last element of a vector and the first element of the next vector */
     
      for (j=0;j<(*lot);j++)
	{
	  for (i=0;i<limit;i++)
	    {
	      *tmp2=*tmp1;
	      tmp1+=(*inc1);
	      tmp2++;
	    }
	  tmp1+=jump;
	}
      /* Fourier transform */
      rfftwnd_complex_to_real(plans[1],*lot,(fftw_complex*) work,1,(*n)/2+1,(fftw_real*) x, *inc1, *inc2);

    }
}
