#include <rfftw.h>
/////////////////////////////////////////////////////////////////////////
///// Update made by Bartek Protas on the 14th June  2004 ///////////////
#ifdef PARALLEL      
#include <omp.h>
#endif
/////////////////////////////////////////////////////////////////////////


#ifndef REAL
#define REAL double
#endif


void fftwfax_(int* n, int* ifax, REAL *trigs)
{
  rfftwnd_plan *plans;

  if ((2*sizeof(rfftw_plan))>19*sizeof(int))
    {
      perror("Error when using FFTWFAX, the plans cannot be hold in IFAX array because of architecture dependent reasons.\n");
      exit(EXIT_FAILURE);
    }
 
  plans=(rfftwnd_plan*) ifax;
  
/////////////////////////////////////////////////////////////////////////
///// Update made by Bartek Protas on the 14th June  2004 ///////////////
#ifndef PARALLEL      
    plans[0] = rfftwnd_create_plan(1, n, FFTW_REAL_TO_COMPLEX, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM );
    plans[1] = rfftwnd_create_plan(1, n, FFTW_COMPLEX_TO_REAL, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM );
#else
// In the parallel version the switch FFTW_THREADSAFE is added;
    plans[0] = rfftwnd_create_plan(1, n, FFTW_REAL_TO_COMPLEX, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM | FFTW_THREADSAFE );
    plans[1] = rfftwnd_create_plan(1, n, FFTW_COMPLEX_TO_REAL, FFTW_MEASURE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM | FFTW_THREADSAFE );
#endif
/////////////////////////////////////////////////////////////////////////
}

void rfftwmlt_(REAL *x, REAL *work, REAL *trigs, int *ifax, int *inc1, int *inc2, int *n, int *lot, int *sign)
{
  int i,j,jump,limit;
  REAL *tmp1,*tmp2;
  rfftwnd_plan *plans;
  
  plans=(rfftwnd_plan*) ifax;

  if ((*sign)==-1)  /* real to complex transform */
    {
      /* Fourier transform */
/////////////////////////////////////////////////////////////////////////
///// Update made by Bartek Protas on the 14th June  2004 ///////////////
#ifndef PARALLEL      
      rfftwnd_real_to_complex(plans[0],*lot,(fftw_real*) x,*inc1,*inc2,(fftw_complex*) work, 1,(*n)/2 + 1);
#else
#pragma omp parallel for   
      for (j=0;j<(*lot);j++)
	rfftwnd_real_to_complex(plans[0],1, ((fftw_real*) x) + j * (*inc2),*inc1,1,
				((fftw_complex*) work) + j * ((*n)/2 + 1), 1, 1);     
#endif
/////////////////////////////////////////////////////////////////////////
      
      /* Rearrangement of complex data from work, back to x, and renormalization */
      tmp1=x; /* tmp1 scans the array x */
      tmp2=work; /* tmp2 scans work */
      limit=2*(((*n)/2)+1);
      jump=(*inc2)-(*inc1)*limit; /* this is the jump between the last element of a vector and the first element of the next vector */
      
      for (j=0;j<(*lot);j++)
	{
	  for (i=0;i<limit;i++)
	    {
	      *tmp1=(*tmp2)/(*n);
	      tmp1+=(*inc1);
	      tmp2++;
	    }
	  tmp1+=jump;
	}
    }
  else  /* complex to real transform */
    {
      /* Rearrangement of complex data from x, back to work */
      tmp1=x; /* tmp1 scans the array x */
      tmp2=work; /* tmp2 scans work */
      limit=2*(((*n)/2)+1);
      jump=(*inc2)-(*inc1)*limit; /* this is the jump between the last element of a vector and the first element of the next vector */
     
      for (j=0;j<(*lot);j++)
	{
	  for (i=0;i<limit;i++)
	    {
	      *tmp2=*tmp1;
	      tmp1+=(*inc1);
	      tmp2++;
	    }
	  tmp1+=jump;
	}
      /* Fourier transform */
/////////////////////////////////////////////////////////////////////////
///// Update made by Bartek Protas on the 14th June  2004 ///////////////
#ifndef PARALLEL      
      rfftwnd_complex_to_real(plans[1],*lot,(fftw_complex*) work,1,(*n)/2+1,(fftw_real*) x, *inc1, *inc2);
#else   
#pragma omp parallel for   
      for (j=0;j<(*lot);j++)      
	rfftwnd_complex_to_real(plans[1],1,((fftw_complex*) work) + j * ((*n)/2+1),1,1,
				((fftw_real*) x) + j * (*inc2), *inc1, 1);
#endif
/////////////////////////////////////////////////////////////////////////


    }
}
