#include "macro_definitions.i"

!______________________________________________________________________
!______________________________________________________________________
!______________________________________________________________________
!
!              Module DATABASE (Bartek Protas, 15/12/2003)
!
! CONTAINS:
!  - definitions of all the dimensions for the problem
!  - allocation of all the core memory arrays
!______________________________________________________________________

MODULE database

! Definitions of all the dimensions for the problem 
  INTEGER, PARAMETER :: IDIM3I = TURB2D_TAILLE_DU_CHAMP_I
  INTEGER, PARAMETER :: IDIM3J = TURB2D_TAILLE_DU_CHAMP_J
  INTEGER, PARAMETER :: IDIM4I = IDIM3I + 2
  INTEGER, PARAMETER :: IDIM4J = IDIM3J + 2
  INTEGER, PARAMETER :: IDIM33 = IDIM3I*IDIM3I
  INTEGER, PARAMETER :: IDIM44 = IDIM4I*IDIM4I

! FFT-related parameters;
  INTEGER, PARAMETER :: IDIM2I = IDIM3I/2 + 1
  INTEGER, PARAMETER :: IDIM2J = IDIM3J/2 + 1

#if TURB2D_TAILLE_DU_CHAMP_I < TURB2D_TAILLE_DU_CHAMP_J
  INTEGER, PARAMETER :: IDIM3MIN = IDIM3I
  INTEGER, PARAMETER :: IDIM3MAX = IDIM3J
  INTEGER, PARAMETER :: IDIM4MIN = IDIM4I
  INTEGER, PARAMETER :: IDIM4MAX = IDIM4J

! FFT-related parameters;
  INTEGER, PARAMETER :: IDIM1MIN = IDIM3I/2
  INTEGER, PARAMETER :: IDIM1MAX = IDIM3J/2
  INTEGER, PARAMETER :: IDIM2MIN = IDIM2I
  INTEGER, PARAMETER :: IDIM2MAX = IDIM2J
#else
  INTEGER, PARAMETER :: IDIM3MIN = IDIM3J
  INTEGER, PARAMETER :: IDIM3MAX = IDIM3I
  INTEGER, PARAMETER :: IDIM4MIN = IDIM4J
  INTEGER, PARAMETER :: IDIM4MAX = IDIM4I

! FFT-related parameters;
  INTEGER, PARAMETER :: IDIM1MIN = IDIM3J/2
  INTEGER, PARAMETER :: IDIM1MAX = IDIM3I/2
  INTEGER, PARAMETER :: IDIM2MIN = IDIM2J
  INTEGER, PARAMETER :: IDIM2MAX = IDIM2I
#endif

! FFT-related parameters;
  INTEGER, PARAMETER :: ITRIGI = 2*IDIM3I
  INTEGER, PARAMETER :: ITRIGJ = 2*IDIM3J
  INTEGER :: JUMP1, JUMP2, INC1, INC2 
  INTEGER, DIMENSION(19) :: IFAXI, IFAXJ 
  REAL(KIND=SIZE_OF_REAL), DIMENSION(ITRIGI) :: TRIGSI
  REAL(KIND=SIZE_OF_REAL), DIMENSION(ITRIGJ) :: TRIGSJ 

  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: PUA, PVA, PPA, PCA 
  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: PU, PV, PP, PF, PO, PD, PC
  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: PUAA, PVAA, PPAA, PCAA 

  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: MASK 
  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: DISSIP, DISSIP2

  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J,2) :: WORK 

! Penalization-related arrays
  REAL(KIND=SIZE_OF_REAL), DIMENSION(IDIM4I,IDIM4J) :: KSI,SPONGE_MASK, WALL_MASK, GEOP_FORCE, VELO_FORCE
  REAL(KIND=SIZE_OF_REAL), ALLOCATABLE,DIMENSION (:,:) :: DRAG

END MODULE database



!______________________________________________________________________
!______________________________________________________________________
!______________________________________________________________________
!
!              Module PARAMETERS (Bartek Protas, 15/12/2003)
!
! CONTAINS:
!  - definitions of all the perameters: logical, numerical and physical
!______________________________________________________________________

MODULE parameters

! Parameters related to the time step
  INTEGER :: NSTEP, NSTEPA, NINIT
  REAL(KIND=SIZE_OF_REAL) :: TIMEA, TIME, TIME0, MEAN_PRESS
  REAL(KIND=SIZE_OF_REAL) :: DT, DTC, CFL 

! Dissipation-related parameters
  INTEGER :: DISSIPATION_EXPONENT
  REAL(KIND=SIZE_OF_REAL) :: NU, NU_COEFNU

! Penalization-related parameters
  INTEGER :: PENALIZATION, SPONGE, WALLS
  REAL(KIND=SIZE_OF_REAL) :: EPSILON, FX, FY

! Various logical parameters (in the sequence as they are read from 'param.dat')
! (see below for a description)
  INTEGER IINIT, INCOMP, IDALIAS, ISYNC, IHYPER, IVISC, IROT, IFORCE, ISAVE, &
          ISVORT, ISVPOT, ISPRESS, ISDIV, ISSF, ISU, ISV, ISMODV, ISBERN,    &
          ISCUTP, ISCUTV, ISCUTU, NUMCUT, NM, NINV, NSAVE, NSVORT, NSVPOT,   &
          NSPRESS, NSDIV, NSSF, NSU, NSV, NSMODV, NSBERN, NSCUT
  INTEGER :: NMPOINT, FLOW_CASE, VERBOSE
  INTEGER :: FORC_VMEAN
  CHARACTER :: TITLE*6, NAME*25, FNAME*25

! Various numerical parameters
  REAL(KIND=SIZE_OF_REAL) :: KCUTOFFI, KCUTOFFJ, KCUTOFF
  INTEGER :: KEXCIT, KEXCIT2
  REAL(KIND=SIZE_OF_REAL) :: KMAX, ECARLF
  REAL(KIND=SIZE_OF_REAL), SAVE :: PI 

! Various physical parameters
  REAL(KIND=SIZE_OF_REAL) :: ASPECT, ASPECT2
  REAL(KIND=SIZE_OF_REAL) :: KDEF, BURGER, ROSSBY, REYNOLDS
  REAL(KIND=SIZE_OF_REAL) :: FLUCT, FLUCTP, CFLUCTP, FLUCTV, CFLUCTV, P0MAX, V0MAX
  REAL(KIND=SIZE_OF_REAL) :: DX, L0, P0, P02, PM, CORIOL, CORIOL2, RADDEF , P0R, L0R, P0R2, L0R2, DXR
  REAL(KIND=SIZE_OF_REAL) :: CSON, COEF_DIAM_LO, U0, P0FORCE, PMFORCE, DIAMETER

END MODULE parameters


!______________________________________________________________________
!______________________________________________________________________
!______________________________________________________________________
!
!              Module DIAGNOSTICS (Bartek Protas, 15/12/2003)
!
! CONTAINS:
!  - parameters for monitoring invariants
!  - parameters for monitoring extremal values;
!  - I/O unit numbers
!  - flags for video output
!______________________________________________________________________

MODULE diagnostics

! Various forms of energy;
  INTEGER :: NTIME, NDIAG
  REAL(KIND=SIZE_OF_REAL) :: SEPARLF

  REAL(KIND=SIZE_OF_REAL), DIMENSION(NDIAG_MAX,20) :: DDIAG
  REAL(KIND=SIZE_OF_REAL) :: ETOT, EKIN, EPOT, ELIN, ZTOT, ZPOT, ZLIN
  REAL(KIND=SIZE_OF_REAL) :: UMIN, UMAX, VMIN, VMAX, PMIN, PMAX
  REAL(KIND=SIZE_OF_REAL) :: GRAD_VOR_L2, DIV_L1
  REAL(KIND=SIZE_OF_REAL) :: MACH, RO

! I/O units
  INTEGER, PARAMETER :: STDERR  = 0
  INTEGER, PARAMETER :: OUTPUT1 = 6
  INTEGER, PARAMETER :: NVM1    = 10
  INTEGER, PARAMETER :: NFDIAG  = 49
  INTEGER, PARAMETER :: NFPARAM = 5
  INTEGER, PARAMETER :: NFCX    = 52
  INTEGER, PARAMETER :: NFCY    = 53
  INTEGER, PARAMETER :: NFCUTP  = 54
  INTEGER, PARAMETER :: NFCUTV  = 55
  INTEGER, PARAMETER :: NFCUTU  = 56
  INTEGER, PARAMETER :: NFPRESS = 58
  INTEGER, PARAMETER :: NFBERN  = 59
  INTEGER, PARAMETER :: NFVPOT  = 60
  INTEGER, PARAMETER :: NFV     = 61
  INTEGER, PARAMETER :: NFDIV   = 63
  INTEGER, PARAMETER :: NFU     = 64
  INTEGER, PARAMETER :: NFSF    = 66
  INTEGER, PARAMETER :: NFSPEC  = 67
  INTEGER, PARAMETER :: NFVORT  = 68
  INTEGER, PARAMETER :: NFMODV  = 69

! Parameters for graphical (MPG) output;
  INTEGER :: MPGVORT
  INTEGER :: MPGVPOT
  INTEGER :: MPGPRESS
  INTEGER :: MPGDIV
  INTEGER :: MPGSF
  INTEGER :: MPGU
  INTEGER :: MPGV
  INTEGER :: MPGMODV
  INTEGER :: MPGBERN

  INTEGER :: IMPGVORT
  INTEGER :: IMPGVPOT
  INTEGER :: IMPGPRESS
  INTEGER :: IMPGDIV
  INTEGER :: IMPGSF
  INTEGER :: IMPGU
  INTEGER :: IMPGV
  INTEGER :: IMPGMODV
  INTEGER :: IMPGBERN

  INTEGER :: NMPGVORT
  INTEGER :: NMPGVPOT
  INTEGER :: NMPGPRESS
  INTEGER :: NMPGDIV
  INTEGER :: NMPGSF
  INTEGER :: NMPGU
  INTEGER :: NMPGV
  INTEGER :: NMPGMODV
  INTEGER :: NMPGBERN

END MODULE diagnostics

!____________________________________________
!
!     NETOTZPOT       INDICE POUR LE TABLEAU CONTENANT
!                     LES MESURES EN UN POINT A TOUS LES PAS DE TEMPS (POINT PO(10,10)) AINSI
!                     QUE LES VALEURS DE ETOT ET ZPOT REGULIEREMENT ENREGISTREES
!     DRAG            TABLEAU QUI CONTIENDRA LA PORTANCE ET LA TRAINEE
!     NINIT           INDICE DU PAS DE TEMPS DES CHAMPS LUS SUR DISQUE
!     TIME0           TEMPS INITIAL DES CHAMPS LUS SUR LE DISQUE
!     IINIT           IINIT=1   SI INITIALISATION DES CHAMPS
!                     IINIT=0   SI POURSUITE DU CALCUL DES CHAMP
!                     IINIT=2   SI ELIMINATION DE LA PARTIE ONDE DES CHAMPS D'UN RUN PRECEDENT
!     INCOMP          INCOMP>0  SI ECOULEMENT INCOMPRESSIBLE (1 - LEAPFROG, 2 - ADAMS-BASHFORTH)
!     ITRONC          ITRONC=1  SI DESALIASAGE
!     ISYNC           ISYNC=1   SI RESYNCHRONISATION DES QUE LA SEPARATION
!                     LEAPFROG SEPARLF EST SUPERIEURE @ ECARLF %
!     IASS            IASS=1    AVEC FILTRE D'ASSELIN POUR REDUIRE LES
!                     ONDES D'INERTIE-GRAVITE PETITE ECHELLE
!     IHYPER          IHYPER = 1 HYPER DISSIPATION
!     ISAUVE          ISAUVE=1  SI SAUVEGARDE DES CHAMPS SPECTRAUX AU PAS
!     ISVORT          ISVORT=1  SI SAUVEGARDE DES CHAMPS DE VORTICITE
!                     PHYSIQUES TOUS LES NSVORT PAS
!     DE MEME POUR    ISVPOT, ISPRESS, ISDIV, ISSF, ISU, ISV, ISMODV, ISBERN, NSVPOT, NSPRESS,
!                     NSDIV, NSSF, NSU, NSV, NSMODV, NSBERN
!     NM              NOMBRE TOTAL DE PAS DE TEMPS
!     NINV            NOMBRE DE PAS DE TEMPS SEPARANT LES INSTANTS ENTRE  
!                     LESQUELS ON TESTE LA CONSERVATION DE L'ENERGIE
!                     E(N)-E(N-NINV) ET DE L'ENSTROPHIE Z(N)-Z(N-NINV)
!                     VALEUR IMPAIRE POUR TESTER ALTERNATIVEMENT
!                     LES PAS PAIRS ET IMPAIRS
!     NIMP            NOMBRE DE PAS DE TEMPS ENTRE DEUX SORTIES DES
!                     CHAMPS SUR IMPRIMANTE
!     NSAUVE          NOMBRE DE PAS DE TEMPS ENTRE DEUX SORTIES
!                     DES CHAMPS SPECTRAUX SUR LE DISQUE
!     KEXCIT2         CARRE DU NOMBRE D'ONDE LE PLUS EXCITE
!     ISCUTP         ISCUTP=1 CUTE VERTICALE DE PRESSION TOUS LES NSCUT PAS DE TEMPS
!     DE MEME POUR    ISCUTV ET ISCUTU
!     NUMCUT	      PAS D'ESPACE OU ON FAIT LA CUTE
!     NPASA           NINIT + N - 1    
!     METOT           TABLEAU CONTENANT L'ENERGIE TOTALE TOUS LES NINV PAS DE TEMPS
!     MZPOT           TABLEAU CONTENANT L'ENSTROPHIE TOTALE TOUS LES NINV PAS DE TEMPS
