/*
This file is part of a collection of files written by Alexandre
AZZALINI, PhD Student at the French Laboratoire de Meteorologie
Dynamique du CNRS, Ecole Normale Superieure, PARIS, FRANCE.
Copyright Alexandre AZZALINI, CNRS-2001
This is free software. You can redistribute it and/or modify it as
soon as you do not remove this comment.
This piece of program comes without any warranty;without	
even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.	 
 */

#ifndef __IMAGE_H
#define __IMAGE_H
#include <colortype.h>
#include <colormap.h>

typedef struct
{
  int nx;
  int ny;
  int saut;
  color* image;
} image;

static image NULL_image=
{
  0,
  0,
  0,
  NULL,
};

#define ADRESSE(IMAGE,x,y) (IMAGE).image + ((x) + (y) * ((IMAGE).saut))
#define ELEMENT(IMAGE,x,y) (IMAGE).image[(x) + (y) * ((IMAGE).saut)]
#define isnull(IMAGE) ( ( (IMAGE).nx == 0 ) || ( (IMAGE).ny == 0 ) || ( (IMAGE).saut == 0 ) || ( (IMAGE).image == NULL ) )

extern image create_image(int nx,int ny, color bg);
extern image CreatePPMFromFile(FILE *input);
extern image sub_image(image mother,int origin_x, int origin_y,int nx,int ny);
extern int fill_image(image im,color col);
extern int set_pixel(image im,int nx, int ny,color col);
extern int draw_line(image im,int inx, int iny, int fnx, int fny, color col);
extern int MakeColorImage(colormap *cm, image im, int nx, int ny, int fmt_dbl, double *dataD, float *data, double min, double max);
extern int WritePPM(FILE *output, image im);
extern int Add_Amplitude_bar(image im, double gmin, double gmax, double min,double max);
extern int Add_Colorbar(image im, colormap *cm, int vertical);
extern int fill_triangle(image im, int centre_x, int centre_y, int P1x, int P1y, int P2x, int P2y, int P3x, int P3y, color col);
extern int Add_scale_bar(image im,int n,int n_inter,color col);
extern int copy_image(image source, image dest);
extern int turn_image_LR(image source, image dest, int left);
extern int ReadPPM(FILE *input, image im);
extern void SizePPMFile(FILE *input,int *nx, int *ny);
extern color MakeColor(int Red, int Green, int Blue);
extern color SetColorIntensity(color C,float intensity);
#endif
