#include <stdlib.h>
#include <stdio.h>
#include <colortype.h>
#include <mpege.h>

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

static ImVfb* IM0=NULL;
static int inx,iny;
static MPEGe_options options;

void Initialize_MPEGE(FILE *output,int nx,int ny)
{

  if (IM0!=NULL)
    {
      fprintf(stderr,"\nMPEGe Initialisation has already been done !\n");
      exit(EXIT_FAILURE);
    }

  IM0=MPEGe_ImVfbAlloc( nx,ny, IMVFBRGB, TRUE );
  MPEGe_default_options( &options );

  /* start the library with the default options */
  if( MPEGe_open(output, &options )==0 )
    {
      fprintf(stderr,"MPEGe library initialisation failure!:%s\n",options.error);
      exit(EXIT_FAILURE);
    }

  inx=nx;
  iny=ny;

}


int OutPutMPEGFRAME(color *Colors)
{
  color *ptr;
  int i;
  ptr=(color *) ImVfbQPtr(IM0,0,0 );

  for (i=0;i<inx*iny;i++)
    ptr[i]=Colors[i];

  if( !MPEGe_image(IM0, &options) )
    {
      fprintf(stderr,"Oh dear MPEGe_image failure: %s\n",options.error);
      return(EXIT_FAILURE);
    }
  
  return(EXIT_SUCCESS);
  
}


int CLOSE_MPEG()
{
  fprintf(stderr,"\nclosing MPEG\n");
  
  if( !MPEGe_close(&options) ){
    fprintf(stderr,"Had a bit of difficulty closing the file: %s\n",
	    options.error);
    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);

}
