#include <stdlib.h>
#include <stdio.h>
#include <image.h>
#include <mpeg_handle.h>
#include <signal.h>

int errno;

void EMERGENCY_STOP(int argument)
{
  CLOSE_MPEG();
  exit(EXIT_SUCCESS);
}

int clicks=0;

void CLICK(int argument)
{
  clicks++;
  fprintf(stderr,"\nCaught the CLICK, %d CLICKs received \n",clicks);
}

int main(int argc, char** argv)
{
  struct sigaction emergency_stop,click;
  int i;
  int in=0;
  int mpfw=0;
  int rotate=0;
  int obstinate=0;
  FILE* lock;
  FILE* input=stdin;
  image im;
  image rotated;
 
  emergency_stop.sa_handler=EMERGENCY_STOP;
  sigfillset(&(emergency_stop.sa_mask));
  emergency_stop.sa_flags=0; 

  click.sa_handler=CLICK;
  sigfillset(&(click.sa_mask));
  click.sa_flags=0; 
  
  sigaction(SIGINT,&emergency_stop,NULL);
  sigaction(SIGTERM,&emergency_stop,NULL);
  sigaction(SIGQUIT,&emergency_stop,NULL);
 
  sigaction(SIGUSR1,&click,NULL);

  for (i=1;i<argc;i++)
    {
      if (strncmp(argv[i],"-rL",3)==0) /* Rotation de l'image a gauche */
	rotate=1;

      if (strncmp(argv[i],"-rR",3)==0) /* Rotation de l'image a droite */
	rotate=-1;

      if (strncmp(argv[i],"-o",2)==0) /* Lecture repetitive du fichier sans tenir compte du EOF */
	obstinate=1;

      if (strncmp(argv[i],"-l",2)==0)
	if ((i+1<argc)&&(argv[i+1][0]!='-'))
	  {
	    if (NULL==(lock=fopen(argv[i+1],"w")))
	      {
		fprintf(stderr,"\nErreur dans ppm2mpg\n Problme pour ouvrir le lockfile : %s)\n\n",argv[i+1]);
		exit(EXIT_FAILURE);
	      }
	    fprintf(lock,"LOCK\n%d",(int) getpid());
	    fclose(lock);
	  }
	else
	  {
	    fprintf(stderr,"\nErreur dans ppm2mpg\n l'argument de l'option -l est manquant (chemin pour un lockfile)\n\n");
	    exit(EXIT_FAILURE);
	  } 

      if (strncmp(argv[i],"-i",2)==0)
	if ((i+1<argc)&&(argv[i+1][0]!='-'))
	  {
	    in=i;
	  }
	else
	  {
	    fprintf(stderr,"\nErreur dans ppm2mpg\n l'argument de l'option -i est manquant (chemin pour un fichier d'entre)\n\n");
	    exit(EXIT_FAILURE);
	  } 	  	
      
    }
 
  if (obstinate==1)
    {
      fprintf(stderr,"\nWaiting for a first click : kill -USR1 %d\n",getpid());
      fflush(stderr);
      sleep(1);
    }
  
  if (in!=0)
    {
      fprintf(stderr,"\nMy PID is %d\n",getpid());
      fflush(stderr);
      if (NULL==(input=fopen(argv[in+1],"r")))
	{
	  fprintf(stderr,"\nErreur dans ppm2mpg\n Problme pour ouvrir le fichier d'input : %s\n\n",argv[in+1]);
	  exit(EXIT_FAILURE);
	} 
    }
  
 
  im = CreatePPMFromFile(input);

  if (rotate!=0)
    {
      rotated=create_image(im.ny,im.nx,color_BLACK);
      Initialize_MPEGE(stdout,im.ny,im.nx);
    }
  else  
    Initialize_MPEGE(stdout,im.nx,im.ny);
  

  do
    {
      
      do
	{
	  if (feof(input)!=0)
	    {
	      clearerr(input);
	      sleep(1);
	    }
	  else
	    {
	      if (rotate!=0)
		{
		  turn_image_LR(im,rotated,rotate);
		  OutPutMPEGFRAME(rotated.image);
		  mpfw++;
		  fprintf(stderr,"\nNumber of frame written : %d\n",mpfw);
		}
	      else
		{
		  OutPutMPEGFRAME(im.image);
		  mpfw++;
		  fprintf(stderr,"\nNumber of frame written : %d\n",mpfw);
		}
	    }
	}
      while (ReadPPM(input,im)==EXIT_SUCCESS);
      
    }
  while (obstinate==1); 

  CLOSE_MPEG();
  exit(EXIT_SUCCESS);
}
