#include <stdlib.h>
#include <stdio.h>
#include <colormap.h>
#include <math.h>
#include <float.h>
#include <mpeg_handle.h>
#include <image.h>

int errno;

int main(int argc, char **argv)
{
  float *data;
  double *dataD;
  int nx,ny,read,i,j,image_nx,image_ny,bars_nx,bars_debut;
  int centered=0;
  int fmt_dbl=0;
  int m=0,mpg=0,colorbar=0,amplitude_bar=0,Compressed=0,special=0,special_reverse;
  register double min,max,gmin,gmax,vmin,vmax,zero=0,special_start;
  double tmp;
  char char_tab[10][50];
  colormap *cm,*special_cm;
  image Frame, Colors, Amplitude, colorb;
  
  data=NULL;
  dataD=NULL;

  if (argc<4)
    {
      fprintf(stderr,"\nUsage : %s nx ny colormap\n\n Where colormap is one of :\n\n %s \n",argv[0],colormaplist);
      exit(EXIT_FAILURE);
    }

  if (argv[3][0]=='-')
    {
      if ((cm=read_colormap(argv[3]+1))==NULL)
	{
	  fprintf(stderr,"\n\nError, the file specified for the colormap %s cannot be found\nUsage : %s nx ny [-]colormap\n\n Where colormap is one of :\n\n %s \n",argv[3]+1,argv[0],colormaplist);
	  exit(EXIT_FAILURE);
	}
    }
  else
    {
      if ((cm=checkout_colormap(argv[3]))==NULL)
	{
	  fprintf(stderr,"\n\nError, specified colormap %s is not available\nUsage : %s nx ny colormap\n\n Where colormap is one of :\n\n %s \n",argv[3],argv[0],colormaplist);
	  exit(EXIT_FAILURE);
	}
    }

  nx = atoi(argv[1]);
  ny = atoi(argv[2]);

  image_nx=nx;
  image_ny=ny;

  bars_nx= (nx>512) ? 512 : nx;
  bars_debut=0;

  if (argc>=5)
    {
      for (i=4;i<argc;i++)
	{
	  if (argv[i][0]=='c')
	    {
	      centered=1;
	      continue;
	    }
	  if (argv[i][0]=='d')
	    {
	      fprintf(stderr,"\n\n Double precision numbers on input\n\n");
	      fmt_dbl=1;
	      continue;
	    }
	  if (argv[i][0]=='m')
	    {
	      m=0;
	      strncpy(char_tab[0],strtok(argv[i]+1,":"),50);
	      strncpy(char_tab[1],strtok(NULL,":"),50);

	      if (char_tab[1][0]!='=')
		{
		  gmax=atof(char_tab[1]);
		  m=m|2;
		}

	      if (char_tab[0][0]!='=')
		{
		  gmin=atof(char_tab[0]);
		  m=m|1;
		}
	      continue;
	    }
	  if (argv[i][0]=='M')
	    {
	      mpg=1;
	      fprintf(stderr,"\n\n MPEG1 movie on output\n\n");    
	      continue;
	    }
	  if (argv[i][0]=='b')
	    {
	      colorbar=1;
	      fprintf(stderr,"\n\n Colorbar shown \n\n");
	      if (argv[i][1]=='c')
		bars_debut=image_nx/2-bars_nx/2;
	      if (argv[i][1]=='r')
		bars_debut=image_nx-bars_nx;
	      continue;
	    }
	  if (argv[i][0]=='A')
	    {
	      amplitude_bar=1;
	      fprintf(stderr,"\n\n Amplitude bar shown \n\n");    
	      continue;
	    }
	  if (argv[i][0]=='C')
	    {
	      Compressed=1;
	      continue;
	    }
	  if (argv[i][0]=='z')
	    {
	      zero=atof(argv[i]+1);
	      if (zero<0) zero=-zero;
	      fprintf(stderr,"\n\n Amplitude of zero zone set to %f%%\n (Only with 'C' option) \n\n",zero*100);  
	      continue;
	    }
	  if (argv[i][0]=='s')
	    {
	      special = (argv[i][1]=='<') ? -1 : +1;
	    }
	}
    }

  if (colorbar==1)
    {
      image_ny+=16;
    }

  if (amplitude_bar==1)
    {
      if (m==0)
	{
	  fprintf(stderr,"\n\n Error using 'A' option ! It must me used with the 'm' option \n\n");
	  exit(EXIT_FAILURE);
	}
      else
	{
	  image_ny+=16;
	}
      
    }

  if (Compressed==1)
    {
      if (m!=0 || centered!=1)
	fprintf(stderr,"\n\n Colormap compressed using Arctan function\n\n");    
      else
	{
	  fprintf(stderr,"\n\n Colormap compression needs to be used with the 'm' and 'c' options !\n\n");
	  exit(EXIT_FAILURE);
	}
    }
  

  /*  FIN DE L'INITIALISATION. MAINTENANT, ON PASSE AUX CHOSES SERIEUSES !!!! */

  /* ALLOCATION MEMOIRE */
  
  Frame=create_image(image_nx,image_ny,color_BLACK);

  Colors=sub_image(Frame,0,0,nx,ny);

  if (colorbar==1)
    colorb=sub_image(Frame,10+bars_debut,image_ny-(amplitude_bar==1 ? 28 : 8),bars_nx-21,12);

  if (amplitude_bar==1)
    Amplitude=sub_image(Frame,bars_debut,image_ny-12,bars_nx,12);

  if (mpg==1)
    {
      Initialize_MPEGE(stdout,image_nx,image_ny);
    }

  if (fmt_dbl==0)
    {
      if ((data=malloc(nx*ny*sizeof(float)))==NULL)
	{
	  perror("Problem Allocating memory");
	  exit(EXIT_FAILURE);
	}    
    }
  else
    {
      if ((dataD=malloc(nx*ny*sizeof(double)))==NULL)
	{
	  perror("Problem Allocating memory");
	  exit(EXIT_FAILURE);
	}
    }
  
  /* On commence a lire les donnees... */


  for (i=0;;)
    {

      if (fmt_dbl==0)     /* PARTIE DU CODE UTILISEE SI DES FLOATS SONT LUS    */
	{
	  if (((read=fread(data,sizeof(float),nx*ny,stdin))!=nx*ny)&&(i==0))
	    {
	      fprintf(stderr,"\n  Frame %0.6d : problem reading input: the number of actually read datas is less from the expected number\n   actually read : %d\n    expected     : %d \n\n",read,nx*ny);
	      exit(EXIT_FAILURE);
	    }
	  else
	    if (read!=nx*ny)
	      break;

	  min=DBL_MAX;
	  max =-DBL_MAX;
	  
	  for (;read!=0;read--)    /* CALCUL DES EXTREMA */
	    {
	      min = (data[read] < min) ? min=data[read] : min;
	      max = (data[read] > max) ? max=data[read] : max;
	    }
	  
	  if (Compressed==1)
	    for (j=0;j<(nx*ny);j++)
	      {
		data[j]=(float) M_2_PI * atan( .57735 * (double) data[j]/((gmax>gmin) ? gmax : gmin));
	      }
	  fprintf(stderr,"\n Frame %0.6d : Minimum of datas = %.11E  Maximum of datas = %.11E ",i,min,max);
	  
	  switch (m)
	    {
	    case 3 :
	      {
		vmin=gmin;
		vmax=gmax;
		fprintf(stderr,"\n Frame %0.6d : Global Minimum and Maximum for all fields have been given using the 'm' option as  min = %.11E  max = %.11E",i,gmin,gmax);
		break;
	      }
	    case 2 :
	      {
		vmin=min;
		vmax=gmax;
		fprintf(stderr,"\n Frame %0.6d : Global Maximum for all fields have been given using the 'm' option as  max = %.11E The minimum is computed for each field...",i,gmax);
		break;
	      }
	    case 1 :
	      {
		vmin=gmin;
		vmax=max;
		fprintf(stderr,"\n Frame %0.6d : Global Minimum for all fields have been given using the 'm' option as : min =  %.11E The maximum is computed for each field...",i,gmax);
		break;
	      } 
	    case 0 :
	      {
		vmin=min;
		vmax=max;
		fprintf(stderr,"\n Frame %0.6d : No Global Minimum for all field given. The maximum and the minimum are computed from each field...",i);
	      }
	      break;
	    } 
	}
      else         /* PARTIE DU CODE UTILISEE SI DES DOUBLES SONT LUS    */   
	{ 
	  if (((read=fread(dataD,sizeof(double),nx*ny,stdin))!=nx*ny)&&(i==0))
	    {
	      fprintf(stderr,"\n  Frame %0.6d : problem reading input: the number of actually read datas differs from the expected number\n   actually read : %d\n    expected     : %d",read,nx*ny);
	      exit(EXIT_FAILURE);
	    }
	  else
	    if (read!=nx*ny)
	      break;
	  
	  min=DBL_MAX;
	  max =-DBL_MAX;
	  for (;read!=0;read--)    /* CALCUL DES EXTREMA */
	    {
	      min = (dataD[read] < min) ? min=dataD[read] : min;
	      max = (dataD[read] > max) ? max=dataD[read] : max;
	    }
 
	  if (Compressed==1)
	    for (j=0;j<(nx*ny);j++)
	      {
		dataD[j]= M_2_PI * atan(.57735*dataD[j]/((gmax>gmin) ? gmax : gmin));
	      }
	  fprintf(stderr,"\n Frame %0.6d : Minimum of datas = %.11E Maximum of datas = %.11E",i,min,max);

	  switch (m)
	    {
	    case 3 :
	      {
		vmin=gmin;
		vmax=gmax;
		fprintf(stderr,"\n Frame %0.6d : Global Minimum and Maximum for all fields have been given using the 'm' option as  min = %.11E max = %.11E",i,gmin,gmax);
		break;
	      }
	    case 2 :
	      {
		vmin=min;
		vmax=gmax;
		fprintf(stderr,"\n Frame %0.6d : Global Maximum for all fields have been given using the 'm' option as : max = %.11E The minimum is computed for each field...",i,gmax);
		break;
	      }
	    case 1 :
	      {
		vmin=gmin;
		vmax=max;
		fprintf(stderr,"\n Frame %0.6d : Global Minimum for all fields have been given using the 'm' option as : min =  %.11E The maximum is computed for each field...",i,gmax);
		break;
	      } 
	    case 0 :
	      {
		vmin=min;
		vmax=max;
		fprintf(stderr,"\n Frame %0.6d : No Global Minimum for all field given. The maximum and the minimum are computed from each field...",i);
	      }
	      break;
	    } 
	}

      if (Compressed==1)
	{
	  vmin=-0.95;
	  vmax=+0.95;
	  if (fmt_dbl==0)
	    {
	      for (j=0;j<nx*ny;j++)
		if ((data[j]<zero) && (data[j]>-zero)) data[j]=0;
	    }
	  else
	    {
	      for (j=0;j<nx*ny;j++)
		if ((dataD[j]<zero) && (data[j]>-zero)) dataD[j]=0;
	    }
	  
	}
      
      if (centered==1)          /* CENTRAGE DE LA PALETTE SI BESOIN */
	{
	  tmp = (vmin*vmin > vmax*vmax) ? vmin : vmax;
	  vmin = (tmp>0) ? -tmp : tmp;
	  vmax = -vmin;
	  fprintf(stderr,"\n Frame %0.6d : Centered colormap : %.11E %.11E",i,vmin,vmax);
	}

      if (vmin==vmax)
	{
	  fprintf(stderr,"\n Frame %0.6d : The maximum and the minimum for the colormap are the same. The colormap is stretched to [-1 1]",i);
	  vmin=-1,vmax=+1;
	}

	MakeColorImage(cm,Colors,nx,ny,fmt_dbl,dataD,data,vmin,vmax);

      if (amplitude_bar==1)
	{
	  if (Compressed==1)
	    Add_Amplitude_bar(Amplitude,((gmax>gmin) ? gmax : gmin)*tan(vmin*M_PI_2)/.57735,((gmax>gmin) ? gmax : gmin)*tan(vmax*M_PI_2)/.57735,min,max);
	  else
	    Add_Amplitude_bar(Amplitude,vmin,vmax,min,max);
	}
      
      if (colorbar==1)
	{
	  if (Compressed==1)
	    Add_Colorbar(colorb,cm,0);
	  else
	    Add_Colorbar(colorb,cm,0);
	}
      
      if (mpg==1)
	{
	  OutPutMPEGFRAME(Frame.image);
	  fprintf(stderr,"\n MPEG FRAME %0.6d WRITTEN",i);
	}
      else
	WritePPM(stdout,Frame);   /* SORTIE DE L'IMAGE PPM */
      
      i++;
      fprintf(stderr,"\n Total number of colored fields : %d",i);
      
    }
  
  if (mpg==1)
    CLOSE_MPEG();

  exit(EXIT_SUCCESS);
  fprintf(stderr,"\n");

}

