#include <stdlib.h>
#include <stdio.h>

extern int RecurFilter_(float *DATA, float *WORK, int* size,char* Wavelet,int* dim, int* iscoh);

int main(int argc, char **argv)
{
  int n,ndim,size,nelem,coh,readelem;
  float *data,*work;

  if (argc<4)
    {
      fprintf(stderr,"\nUsage : %s ndim size filter\n",argv[0]);
      fprintf(stderr,"\n\nCurrently supported filters :\n\n     AdelsonSimoncelliHingorani\n     AntoniniBarlaudMatheiuDaubechies_4_4\n     BattleLemarie\n     BurtAdelson\n    Coifman_12 (Coifman wavelet with 12 coefficients i.e. 4 vanishing moments) \n     Daubechies_4\n     Daubechies_6\n     Daubechies_8\n     Daubechies_10\n     Daubechies_12\n     Daubechies_20\n     Haar\n     Pseudocoiflet_4_4\n     Spline_2_2\n     Spline_2_4\n     Spline_3_3\n     Spline_3_5\n     Spline_3_7\n\n");
      fflush(stderr);
      exit(EXIT_FAILURE);
    }
  ndim=atoi(argv[1]);
  size=atoi(argv[2]);

  coh=1;
  if (argc>4)
    coh=0;

  if (ndim>3)
    {
      perror("DIM < 4 !\n\n");
      exit(EXIT_FAILURE);
    }
  
  for (nelem=1,n=0;n<ndim;n++)
    nelem *= size;

  data=malloc(nelem*sizeof(float));
  work=malloc(nelem*sizeof(float));

  for (;;)
    {
      if (nelem!=(readelem=fread(data,sizeof(float),nelem,stdin)) && readelem!=0)
	{
	  perror("Error ! input larger or smaller than expected !!!");
	  exit(EXIT_FAILURE);
	}

      if (readelem==0)
	break;
      
      RecurFilter_(data,work, &size,argv[3],&ndim,&coh);
      
      fwrite(data,sizeof(float),nelem,stdout);
    }

  exit(EXIT_SUCCESS);

}



