#include <stdlib.h>
#include <stdio.h>
#include <math.h>

int main(int argc,char** argv)
{
  FILE **files;
  float *modulus2,*ptr;
  float data;
  double s,stot,L,LL;
  double Threshold2,mag2;
  int i,j,nelem,number_of_components;
  int nitermax=0;
  int niter,count,prevcount;
  int coh=1,coeff=1;

  if (argc<4)
    {
      fprintf(stderr,"Incorrect number of arguments\n%s number_of_components npoints file1 (file2...) (nitermax)\n",argv[0]);
      exit(EXIT_FAILURE);
    }

  number_of_components=atoi(argv[1]);
  if (number_of_components<0)
    {
      coh=0;
      number_of_components= -number_of_components;
    }

  if (number_of_components<1)
    {
      fprintf(stderr,"Specified number of components is too small: %d \n%s number_of_components npoints file1 (file2...) (nitermax)",number_of_components,argv[0]);
      exit(EXIT_FAILURE);
    }
  
  if ((nelem=atoi(argv[2]))<0)
    {
      nelem=-nelem;
      coeff=number_of_components;
    }

  if (argc<(number_of_components+3))
    {
      fprintf(stderr,"Specified number of components (%d) does not correspond to the number of specified files (%d) \n%s number_of_components npoints file1 (file2...) (nitermax)",number_of_components,argc-3,argv[0]);
      exit(EXIT_FAILURE);
    }

  if (argc>(number_of_components+3))
    nitermax=atoi(argv[number_of_components+3]);

  if((files=(FILE**)malloc(number_of_components*sizeof(FILE*)))==NULL)
    {
      fprintf(stderr,"Problem allocating memory\n");
      exit(EXIT_FAILURE);
    }

  for (i=0;i<number_of_components;i++)
      files[i]=fopen(argv[3+i],"r");

  if ((modulus2=(float*)malloc(nelem*sizeof(float)))==NULL)
    {
      fprintf(stderr,"Problem allocating memory\n");
      exit(EXIT_FAILURE);
    }
  
  for (i=0;i<nelem;i++)
    {
      modulus2[i]=0;     
      for (j=0;j<number_of_components;j++)
	{
	  fread(&data,sizeof(float),1,files[j]);
	  modulus2[i]+=(data*data);
	}
    }

  Threshold2=1E100;

  L=log(nelem);
  LL=2*L/(nelem*coeff);

  for (niter=0,prevcount=-1,count=0 ; ((niter<nitermax)||(nitermax==0)) && (prevcount!=count) ; niter++)
    {
      prevcount=count;
      for (i=0,s=0,count=0,ptr=modulus2;i<nelem;i++,ptr++)
	{
	  mag2 = *ptr;
	  if (mag2<=Threshold2)
	  {  
	    count++;
	    s+= mag2;
	  }
	}
      Threshold2 = s * LL;
      fprintf(stderr,"niter %d count %d Thresh %11.8E\n",niter,count,sqrt(Threshold2));
      if (niter==0)
	stot = s;
    }

  fprintf(stderr,"Niter: %d  T: %12.10E  T/sqrt(Z): %4.2E  Ncoh: %d Ninc: %d %%Ncoh: %5.2f  %%Ninc : %5.2f  %%Zcoh:  %5.2f  %%Zinc:  %5.2f\n",niter-2,sqrt(Threshold2),sqrt(Threshold2/stot),nelem-count,count,100-(1.e2*count)/nelem,(1.e2*count)/nelem,100-100*s/stot,100*s/stot);

  for (i=0;i<nelem;i++)
    modulus2[i]=(modulus2[i]<=Threshold2) ? 0 : 1;

  for (i=0;i<number_of_components;i++)
    {
      rewind(files[i]);
      for (j=0;j<nelem;j++)
	{
	  fread(&data,sizeof(float),1,files[i]);
	  data=(modulus2[j]==coh)? data : 0;
	  fwrite(&data,sizeof(float),1,stdout); 
	}
    }

  exit(EXIT_SUCCESS);

}
