#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "local.h"
#include <WaveletLIB.h>
#ifndef DOUBLE_DWT
#define REAL float
#define REALDWT wxfrm_fand
#else
#define REAL double
#define REALDWT wxfrm_dand
#endif

#define DWT_FORWARD  1
#define DWT_BACKWARD  0
#include <time.h>

static waveletfilter* fltr=NULL;

int MedianWltFilter_(REAL *DATA, REAL *WORK, REAL *WORK2, int* size,char* Wavelet,int* dim, int* iscoh, int* nelem_2)
{
  
  clock_t time_in,time_trans,time_out;
  register REAL Threshold2, s, mag2;
  REAL logN,stot,Threshold;
  register REAL *ptr;
  register int i,imax;
  int dimensions[3];
  int count=0;
  int n;

  if (fltr==NULL)
    {
      if (Wavelet!=NULL)
	{
	  if (strcmp(Wavelet,"")==0)
	    {
	      fprintf(stderr," Error when Calling MedianWltFilter : no Wavelet parameter defined ");
	      exit(EXIT_FAILURE);
	    }
	  if ((fltr=wfltr_select(Wavelet,&n))==NULL)
	    {
	      fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	      exit(n);
	    }
	}
      else
	if ((fltr=wfltr_select("Coiflet_4",&n))==NULL)
	  {
	    fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	    exit(n);
	  }

      fprintf(stderr,"MedianWltFilter : The selected filter is %s\n",Wavelet);
    }

  time_in = clock();

  dimensions[0]=dimensions[1]=dimensions[2]=*size;
  
  time_trans = clock();
  REALDWT(DATA, dimensions, *dim, DWT_FORWARD, 0, fltr, WORK);
  time_trans = clock() - time_trans;


  for (i=0,imax=1;i<(*dim);i++)
    imax *= dimensions[i];
  
  logN=log(imax);

  extract_scale(WORK,WORK2,*dim,*size,rint(log((double) *size)/log(2))-1,power(2,*dim)-1,(*size)/2,BIG2SMALL);

  Threshold=median_donoho(WORK2,*nelem_2,imax);

  Threshold2=Threshold*Threshold;
  
  if (*iscoh==1)
    for (i=0,s=0,stot=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	stot+=mag2;
	if (mag2<=Threshold2)
	  *ptr=0;
	else
	  {
	    s+=mag2;
	    count++;
	  }
      }
  else
    for (i=0,s=0,stot=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	stot+=mag2;
	if (mag2>Threshold2)
	  {
	    *ptr=0;
	    s+=mag2;
	    count++;
	  }
      } 

  REALDWT(WORK, dimensions, *dim, DWT_BACKWARD, 0, fltr, DATA);
  
  time_out = clock();

  s/=imax;
  stot/=imax;

/*   fprintf(stderr,"Temps pass dans MedianWltFilter pour la transforme directe : %10.8E\n",(double) (time_trans)*1.0/CLOCKS_PER_SEC); */
/*   fprintf(stderr,"Temps pass dans MedianWltFilter : %10.8E\n",(double) (time_out-time_in)*1.0/CLOCKS_PER_SEC); */

  if (*iscoh==1)
    fprintf(stderr,"MedianWltFilter Coh sigma : %12.10E  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",Threshold/sqrt(2*log(imax)),Threshold,sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);
  else
    fprintf(stderr,"MedianWltFilter Incoh sigma: %12.10E  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",Threshold/sqrt(2*log(imax)),Threshold,sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);

  return(EXIT_SUCCESS);

}
