#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "local.h"
#ifndef DOUBLE_DWT
#define REAL float
#define REALDWT wxfrm_fand
#else
#define REAL double
#define REALDWT wxfrm_dand
#endif

#define DWT_FORWARD  1
#define DWT_BACKWARD  0
#include <time.h>

static waveletfilter* fltr=NULL;

int RecurFilter_(REAL *DATA, REAL *WORK, int* size,char* Wavelet,int* dim, int* iscoh)
{
  
  clock_t time_in,time_trans,time_out;
  register double Threshold2, s, mag2;
  REAL logN,stot;
  register REAL *ptr;
  register int i,imax,count;
  int n,prevcount,niter;
  int dimensions[3];

  if (fltr==NULL)
    {
      if (Wavelet!=NULL)
	{
	  if (strcmp(Wavelet,"")==0)
	    {
	      fprintf(stderr," Error when Calling RecurFilter : no Wavelet parameter defined ");
	      exit(EXIT_FAILURE);
	    }
	  if ((fltr=wfltr_select(Wavelet,&n))==NULL)
	    {
	      fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	      exit(n);
	    }
	}
      else
	if ((fltr=wfltr_select("Coiflet_4",&n))==NULL)
	  {
	    fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,Wavelet);
	    exit(n);
	  }

      fprintf(stderr,"RecurFilter : The selected filter is %s\n",Wavelet);
    }

  time_in = clock();

  dimensions[0]=dimensions[1]=dimensions[2]=*size;
  
  time_trans = clock();
  REALDWT(DATA, dimensions, *dim, DWT_FORWARD, 0, fltr, WORK);
  time_trans = clock() - time_trans;


  for (i=0,imax=1;i<(*dim);i++)
    imax *= dimensions[i];
  
  logN=log(imax);

  Threshold2=1E100;

  for (niter=0,prevcount=-1,count=0 ; prevcount!=count ; niter++)
    {
      prevcount=count;
      for (i=0,s=0,count=0,ptr=WORK;i<imax;i++,ptr++)
	{
	  mag2 = (*ptr)*(*ptr);
	  if (mag2<=Threshold2)
	    {
	      count++;
	      s+= mag2;
	    }
	}
      fprintf(stderr,"niter %d count %d\n",niter,count);
      Threshold2 = 2* s * logN / imax;
      if (niter==0)
	stot = s;
    }
  
  if (*iscoh==1)
    for (i=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	if (mag2<=Threshold2)
	  *ptr=0;
      }
  else
    for (i=0,ptr=WORK;i<imax;i++,ptr++)
      {
	mag2 = (*ptr)*(*ptr);
	if (mag2>Threshold2)
	  *ptr=0;
      } 

  REALDWT(WORK, dimensions, *dim, DWT_BACKWARD, 0, fltr, DATA);
  
  time_out = clock();

/*   fprintf(stderr,"Temps pass dans RecurFilter pour la transforme directe : %10.8E\n",(double) (time_trans)*1.0/CLOCKS_PER_SEC); */
/*   fprintf(stderr,"Temps pass dans RecurFilter : %10.8E\n",(double) (time_out-time_in)*1.0/CLOCKS_PER_SEC); */

  if (*iscoh==1)
    fprintf(stderr,"RecurFilter Niter: %d  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",niter-2,sqrt(Threshold2),sqrt(Threshold2/stot),imax-count,100-(1.e2*count)/imax,100-100*s/stot);
  else
    fprintf(stderr,"RecurFilter Niter: %d  T: %12.10E  T/sqrt(Z): %4.2E  N: %d  %%N: %5.2f  %%Z:  %5.2f\n",niter-2,sqrt(Threshold2),sqrt(Threshold2/stot),count,(1.e2*count)/imax,100*s/stot);

  return(EXIT_SUCCESS);

}
