#include <string.h>
#include <stdio.h>
#include "local.h"
#ifndef STDARD
#define STDARD 0
#endif

int power(int a,int b)
{
  if (b<1)
    return(1);
  else
    return(a*power(a,b-1));
}

int main(int argc, char **argv)
{
  int n,ndim,i,shift,nelem,size,dir,dimensions[50],size_of=sizeof(float);
  char *filter;
  char *direction;

  waveletfilter *fltr;

  float *data_in_f;
  float *data_out_f;
  double *data_in_d;
  double *data_out_d;
  

  direction="forward";

  if (argc<4)
    {
      fprintf(stderr,"\nUsage : %s ndim size filter [direction (default forward)] [sizeof (default : sizeof(float), 0 means ASCII) ]\n input and output are done with standard input/output (which allows the use of pipes)\n",argv[0]);
      fprintf(stderr,"\n\nCurrently supported filters :\n\n     AdelsonSimoncelliHingorani\n     AntoniniBarlaudMatheiuDaubechies_4_4\n     BattleLemarie\n     BurtAdelson\n    Coifman_12 (Coifman wavelet with 12 coefficients i.e. 4 vanishing moments) \n     Daubechies_4\n     Daubechies_6\n     Daubechies_8\n     Daubechies_10\n     Daubechies_12\n     Daubechies_20\n     Haar\n     Pseudocoiflet_4_4\n     Spline_2_2\n     Spline_2_4\n     Spline_3_3\n     Spline_3_5\n     Spline_3_7\n\n");
      fflush(stderr);
      exit(EXIT_FAILURE);
    }

  ndim=atoi(argv[1]);
  if (ndim>0)
    {
      size=atoi(argv[2]);
      shift=0;
      for (n=ndim-1;n>=0;n--)
	dimensions[n]=size;
    }
  else /* Dans ce cas, on peut specifier des dimensions differentes*/
    {
      if (ndim==0)
	{
	  perror("Invalid dimension (0)");
	  exit(EXIT_FAILURE);
	}
      ndim=-ndim;
      for (i=0;i<ndim;i++)
	dimensions[ndim-i-1]=atoi(argv[2+i]);
      shift=i-1;
    }

  if (argc>(5+shift))
    size_of=atoi(argv[(5+shift)]);
  
  filter = argv[3+shift];

  if (argc>(4+shift))
    direction = argv[4+shift];

  dir=-1;

   switch (direction[0])
    {
    case ('f') : 
      dir=1;
      direction="forward";
      break;
    case ('F') :
      dir=1;
      direction="forward";
      break;
    case ('b') :
      dir=0;
      direction="backward";
      break;
    case ('B') :
      dir=0;
      direction="backward";
      break;
    }

  if (dir==-1)
  {
    fprintf(stderr,"Invalid direction : direction = %s \n",direction);
    exit(EXIT_FAILURE);
  }

  fprintf(stderr,"The current direction is %s \n",direction);

  if ((fltr=wfltr_select(filter,&n))==NULL)
    {
      fprintf(stderr,"Error in wfltr_select, maybe the filter name is incorrect ? : %d (%s)\n",n,filter);
      exit(n);
    }

  fprintf(stderr,"The selected filter is %s\n",filter);

  for (i=0,nelem=1;i<ndim;i++)
    nelem*=dimensions[i];

  switch (size_of)
    {
    case (0) :
      data_in_d=malloc(nelem*sizeof(double));
      data_out_d=malloc(nelem*sizeof(double));
      n=0;
      while(fscanf(stdin,"%lf",data_in_d+n)!=EOF)
        {
          nelem--;
	  if (nelem<0)
	    {
	      perror("Error ! input larger than expected !!!");
	      exit(EXIT_FAILURE);
	    }	  
        }
      wxfrm_dand(data_in_d, dimensions, ndim, dir, STDARD, fltr, data_out_d);
      
      for (n=0;n<nelem;n++)
	printf("%.9E",data_out_d[n]);
      exit(EXIT_SUCCESS);
    case (4) :
      data_in_f=malloc(nelem*sizeof(float));
      data_out_f=malloc(nelem*sizeof(float));
      
      if (nelem!=fread(data_in_f,sizeof(float),nelem,stdin))
	{
	  perror("Error ! input larger or smaller than expected !!!");
	  exit(EXIT_FAILURE);
	}
      
      wxfrm_fand(data_in_f, dimensions, ndim, dir, STDARD, fltr, data_out_f);
      
      fwrite(data_out_f,sizeof(float),nelem,stdout);
      exit(EXIT_SUCCESS);
    case (8) :
      data_in_d=malloc(nelem*sizeof(double));
      data_out_d=malloc(nelem*sizeof(double));
      
      if (nelem!=fread(data_in_f,sizeof(double),nelem,stdin))
	{
	  perror("Error ! input larger or smaller than expected !!!");
	  exit(EXIT_FAILURE);
	}
      
      wxfrm_dand(data_in_d, dimensions, ndim, dir, STDARD, fltr, data_out_d);
      
      fwrite(data_out_d,sizeof(double),nelem,stdout);
      exit(EXIT_SUCCESS);
    }

exit(EXIT_SUCCESS);
    
 
}
