#include <string.h>
#include <stdio.h>
#include "local.h"


/*  These function have been added by Alexandre Azzalini from Ecole Normale Superieure of Paris in order
    to call an filter constructor from fortran. */


extern waveletfilter *wfltr_select _PROTO((char *wcpat, int *nMatch));

extern void wxfrm_da1d _PROTO((double *a, int nA, bool isFwd,
		waveletfilter *wfltr, double *aXf));
extern void wxfrm_dand _PROTO((double *a, int nA[],
		int nD, bool isFwd, bool isStd, waveletfilter *wfltr, double *aXf));

void fortran_wfltr_select_(waveletfilter **result, char *name)
{
  int n;
  waveletfilter *flt;

  if ((flt=wfltr_select(name,&n))==NULL)
    {
      fprintf(stderr,"Error in fortran_wfltr_select : %d\n",n);
      printf("%d/n",n);
      exit(n);
    }

  *result = flt;

}

void fortran_wxfrm_fand_(float *a, int *nA, int *nD, int *isFwd, int *isStd, waveletfilter **fltr, float *aXf)
{

  if (a!=aXf)
    
    wxfrm_fand(a, nA, *nD, (bool) *isFwd, (bool) *isStd, *fltr, aXf);
  
  else
    {
      perror("Error during the call to fortran_wxfrm_fand, input and output point to the same array in memory !");
      exit(-1);
    }

}

void fortran_wxfrm_dand_(double *a, int *nA, int *nD, int *isFwd, int *isStd, waveletfilter **fltr, double *aXf)
{

  if (a!=aXf)
    
    wxfrm_dand(a, nA, *nD, (bool) *isFwd, (bool) *isStd, *fltr, aXf);
  
  else
    {
      perror("Error during the call to fortran_wxfrm_fand, input and output point to the same array in memory !");
      exit(-1);
    }
}

void fortran_wfltr_name_(waveletfilter **fltr, int *iname, int *length)
{
  char *name;
  name = (char *) iname;
  *length = strlen((**fltr).name);
  strcpy(name,(**fltr).name);
    
}
