/* $Header: /grads2/bobl/src/lib/util/RCS/util.h,v 1.4 1996/04/22 22:25:13 bobl Exp bobl $ */

#ifndef INCLUDED_UTIL
#define INCLUDED_UTIL

#if !defined(FILE) && !defined(INCLUDED_STDIO)
#define INCLUDED_STDIO
#include <stdio.h>
#endif

#if !defined(ARCH_DEC) && !defined(ARCH_DOSTC)
/*
 *	There is a bug in the IRIX (5.3 at least) lint that complains needlessly
 *	about the following functions.  Assuming we use this function very little
 *	and that argument checking will happen at compilation time, we shut lint up
 *	as follows:
 */
#if defined(lint) && defined(ARCH_SGI) && OSREL_MAJOR==5
#define fcabs(arg) fcabsDisabledForLintPurposes(float)
#define readlink(arg1, arg2, arg3) readlinkDisabledForLintPurposes(arg1, arg2, arg3)
#endif
#include <unistd.h>
#endif

#include <values.h>
#ifndef ARCH_LINUX
#include <stdlib.h>
#endif
#include <string.h>

#if defined(NULL) && defined(ARCH_IBM)
#undef NULL
/*
 *	AIX defines NULL as ((void *) 0).  This causes problems with lint.
 */
#define NULL 0
#endif

/*
 *	IBM lint doesn't like mixing old style function declarations with function
 *	prototypes, so we disable prototypes under those circumstances.  This is
 *	okay, since lint will still check function arguments, but of course it
 *	won't check against prototypes.  We should be able to rely on the compiler
 *	for that.
 */
#if defined(__STDC__) \
	|| defined(__cplusplus) \
	|| defined(ARCH_DEC) \
	|| defined(ARCH_DOSTC) \
	|| defined(ARCH_HP) \
	|| defined(ARCH_LINUX) \
	|| defined(ARCH_IBM) \
	|| (defined(ARCH_SUN4) && !defined(lint) && OSREL_MAJOR > 4) \
	|| defined(ARCH_SGI)
# define _PROTO(s) s
# define USE_PROTO
#else
# define _PROTO(s) ()
#endif

/*	@(#)assert.h 1.7 88/02/07 SMI; from UCB 4.2 85/01/21	*/
/* modified to call abort() by bobl 91/11/15 */

#ifdef _assert
#undef _assert
#endif

#ifdef assert
#undef assert
#endif

#ifndef NDEBUG

#if defined(ARCH_SGI) || defined(ARCH_SUN4)
# if defined(ARCH_SGI)
extern void abort _PROTO((void));
# endif
# if defined(__GNUC__) && defined(ARCH_SUN4) && OSREL_MAJOR < 5
extern int fprintf _PROTO((FILE *f, char *s, ...));
# endif
#endif
#define _assert(ex)	\
	{ \
		if (!(ex)) { \
			(void) fprintf(stderr,"Assertion failed: file \"%s\", line %d\n", \
					__FILE__, __LINE__); \
			abort(); \
		} \
	}
#define assert(ex)	_assert(ex)
#else
#define _assert(ex)
#define assert(ex)
#endif

#ifndef DEFINED_BOOL
#define DEFINED_BOOL
typedef int bool;
/*
 *	If TRUE and FALSE are previously defined, they had better be the right
 *	values.  What follows should blow up if that is not the case.
 */
# if !defined(TRUE) || TRUE != 1
#define TRUE 1
# endif
# if !defined(FALSE) || FALSE != 0
#define FALSE 0
# endif
#endif

#ifndef DEFINED_GENERICPTR
#define DEFINED_GENERICPTR
#if defined(ARCH_IBM) \
	|| defined(ARCH_HP) \
	|| defined(ARCH_SGI) \
	|| defined(ARCH_LINUX) \
	|| (defined(ARCH_SUN4) && OSREL_MAJOR >= 5)
typedef void *genericptr;
#else
# ifdef lint /* lint is kinda stupid about void * */
typedef char *genericptr;
# else
typedef void *genericptr;
# endif
#endif
#endif

#define N_ELEM(st) (sizeof(st)/sizeof((st)[0]))

#if defined(lint) || defined(NDEBUG)
#define NOT_REACHED
#else
#define NOT_REACHED \
	{ (void) fprintf(stderr, \
			"Unreachable statement reached at line %d in file \"%s\" -- exiting.\n", \
			__LINE__, __FILE__); \
	exit(1); }
#endif

/*
 *	Returns value of given bit.
 */
#define BIT_AT(val, i) ((((unsigned) (val)) >> (i)) & 0x1)

/*
 *	Useful minimum/maximum macros.
 */
#define MIN(a,b) ( (a) < (b) ? (a) : (b) )
#define MAX(a,b) ( (a) > (b) ? (a) : (b) )

/*
 *	According to K & R, the value of i % j is undefined for negative operands.
 *	It is often the case, however, that we want the result to be cyclical, so
 *	that -1 mod 5 = 4, for example.  The following macro will do this in a
 *	fairly machine-independent manner.  (Notice that we ignore the mathematical
 *	possibility of j <= 0, since in such a case there's probably something
 *	wrong with the code.)
 */
#define MOD(i, j) ( (i) >= 0 ? (i) % (j) : ((j) - ((-(i)) % (j))) % (j) )

#define RATIO(i,j) (((double) (i))/((double) (j)))

/*
 *	This sets the integer "log2val" to the floor of the base-2 log of the
 *	integer "val".
 */
#define SET_FLOOR_LOG2(log2var, val) { \
		for ((log2var) = 0; (1 << (log2var)) <= val; (log2var)++) \
			continue; \
		(log2var)--; \
	}

#define STR_EQ(s1, s2) (strcmp((s1), (s2)) == 0)

#if defined(ARCH_IBM) \
	|| defined(ARCH_SGI) \
	|| (defined(ARCH_SUN4) && OSREL_MAJOR >= 5)
/* sincos() is not available on these systems */
#define SINCOS(a, pS, pC) \
	{ \
		(*pS) = sin(a); \
		(*pC) = cos(a); \
	}
#else
#define SINCOS(a, pS, pC) sincos(a, pS, pC)
#endif

#ifndef M_PI
#define M_PI 3.1415926535897931160
#endif
#define DEG_TO_RAD(d) (M_PI * (d) / 180.0)
#define RAD_TO_DEG(d) (180.0 * (d) / M_PI)

#define MXL_PATH 128

#define SHORT_SWAP(i, j) { _tmpShortSwap = (i); (i) = (j); (j) = _tmpShortSwap; }

/*
 *	A single one of these at the start of each package will embed an RCS
 *	"ident" string into the compiled binary.  The second argument must be the
 *	string that corresponds to { '$', 'H', 'e', 'a', 'd', 'e', 'r', '$', }.
 *
 *	Odd: Only Turbo C complains about
 *
 *		static char rcsid[] = ("string");
 *
 *	so we leave out the parens.
 */
#ifdef lint
#define RCSID(pkg, hdr)
#else
# if defined(ARCH_SUN4) && OSREL_MAJOR < 5
#define RCSID(pkg, hdr) \
	char *_/**/pkg/**/_rcsid() { static char rcsid[] = hdr; return rcsid; }
# else
#define RCSID(pkg, hdr) \
	char *_##pkg##_rcsid(void) { static char rcsid[] = hdr; return rcsid; }
# endif
#endif

#ifdef ARCH_DOSTC
extern int getopt _PROTO((int argc, char **argv, char *optstring));
#endif

/*
 *	GNU CC complains if these aren't declared.
 */
#ifdef __GNUC__

# ifdef ARCH_SGI
#  if OSREL_MAJOR < 5
extern int getopt _PROTO((int argc, char **argv, char *optstring));
#  endif
# endif

# ifdef ARCH_HP
extern int abs _PROTO((int i));
extern void exit _PROTO((int status));
extern int _filbuf _PROTO((FILE *f));
extern int _flsbuf _PROTO((unsigned char c, FILE *f));
extern qsort _PROTO((char *base, int nel, int width, int (*compar)()));
# endif

# ifdef ARCH_SUN4
extern int abs _PROTO((int i));
extern void exit _PROTO((int status));
extern int _filbuf _PROTO((FILE *f));
extern int _flsbuf _PROTO((unsigned char c, FILE *f));
#  if OSREL_MAJOR < 5
extern int fclose _PROTO((FILE *f));
extern int fflush _PROTO((FILE *f));
extern int fgetc _PROTO((FILE *f));
extern int fprintf _PROTO((FILE *f, char *s, ... ));
extern int fread _PROTO((char *p, int s, int n, FILE *f));
extern int fscanf _PROTO((FILE *f, char *s, ...));
extern int fseek _PROTO((FILE *f, long off, int whence));
extern int fwrite _PROTO((char *p, int s, int n, FILE *f));
extern char *mktemp _PROTO((char *));
extern int printf _PROTO((char *s, ... ));
extern puts _PROTO((char *s));
extern long random _PROTO(());
extern int scanf _PROTO((char *s, ...));
extern int srandom _PROTO((int s));
extern long strtol _PROTO((char *s, char **pS, int base));
#  endif
# endif
#endif

/*
 *	The following BEGIN EXTERNS and END EXTERNS are used to strip util library
 *	extern declarations from util.h when it is being exported.  Delete them at
 *	your peril!
 */


#endif
