#include "local.h"

RCSID(wildmat, "$Header: /grads/bobl/src/lib/wvlt/RCS/wildmat.c,v 1.2 1996/06/03 18:47:11 bobl Exp $")

/*
**  Do shell-style pattern matching for ?, \, [], and * characters.
**  Might not be robust in face of malformed patterns; e.g., "foo[a-"
**  could cause a segmentation violation.
**
**  Written by Rich $alz, mirror!rs, Wed Nov 26 19:03:17 EST 1986.
**	Modified for the wvlt library by Bob Lewis.
*/

#define TRUE		1
#define FALSE		0


static int ignoreCase = TRUE;

static int Star
#ifdef USE_PROTO
	(char *s, char *p)
#else
	(s, p)
	char *s;
	char *p;
#endif
{
	while (wildmat(s, p) == FALSE)
		if (*++s == '\0')
			return (FALSE);
	return (TRUE);
}


int wildmat
#ifdef USE_PROTO
	(char *s, char *p)
#else
	(s, p)
	char *s;
	char *p;
#endif
{
	int last, matched, reverse, chS;

#define CH_CMP(c) ( ignoreCase && isascii(c) && isupper(c) ? tolower(c) : (c) )

	for (; *p; s++, p++) {
		chS = CH_CMP(*s);
		switch (*p) {

		case '\\':
			/*
			 * Literal match with following character; fall
			 * through. 
			 */
			p++;
		default:
			if (chS != CH_CMP(*p))
				return (FALSE);
			continue;

		case '?':
			/* Match anything. */
			if (*s == '\0')
				return (FALSE);
			continue;

		case '*':
			/* Trailing star matches everything. */
			return (*++p ? Star(s, p) : TRUE);

		case '[':
			/* [^....] means inverse character class. */
			reverse = (p[1] == '^');
			if (reverse)
				p++;
			for (last = 0400, matched = FALSE; *++p && *p != ']'; last = *p) {
				if (*p == '-') {
					p++;
					if (chS <= CH_CMP(*p) && chS >= last)
						matched = TRUE;
				} else if (chS == CH_CMP(*p))
					matched = TRUE;
			}
			if (matched == reverse)
				return (FALSE);
			continue;
		}
	}

	return (*s == '\0');
}


#ifdef	TEST
#include <stdio.h>

extern char *gets();


main()
{
	char pattern[80];
	char text[80];

	while (TRUE) {
		printf("Enter pattern:  ");
		if (gets(pattern) == NULL)
			break;
		while (TRUE) {
			printf("Enter text:  ");
			if (gets(text) == NULL)
				exit(0);
			if (text[0] == '\0')
				/*
				 * Blank line; go back and get a new
				 * pattern. 
				 */
				break;
			printf("      %d\n", wildmat(text, pattern));
		}
	}
	exit(0);
}

#endif	/* TEST */
