#ifndef _INCLUDED_WVLT
#define _INCLUDED_WVLT

/*
 *	All wavelet basis-specific information is stored in the "waveletfilter"
 *	structure.  The analyzing and reconstruction detail filters (cG and
 *	cGtilde) are constructed from the smoothing filters.
 *
 *	For biorthogonal filters, we require the analysis and reconstruction
 *	smoothing filters (cH and cHtilde, respectively).  In the case of
 *	orthogonal filters, we can set cH = cHtilde (as pointers, even).  The
 *	underlying code thus never knows whether it's dealing with an orthogonal or
 *	a biorthogonal filter.
 *
 *	The somewhat arbitrary constraints for the offsets are determined
 *	empirically:
 *
 *	1) Analysis of a synthesized signal recovers the original signal (within
 *	   roundoff).  (This is the most important constraint.)
 *
 *	2) If the number of coefficients for H or Htilde is odd, the corresponding
 *	   offset is floor(nH / 2) or floor(nHtilde / 2), respectively.  If it is
 *	   even, there is a + or - 1 ambiguity here used to satisfy the other
 *	   constraints.
 *
 *	3) A single-step (factor of 2) refinement of an impulse vector with the
 *	   impulse at position i produces a result with a peak at either 2i
 *	   or 2i+1.
 *
 *	4) A single-step (factor of 1/2) analysis of a vector with an edge at
 *	   either 2i or 2i+1 produces a peak in the wavelet coefficients at i.
 *
 *	The "initial mirror signs" determine whether the signs of G and Gtilde
 *	should be negated.  This avoids the need to do "zero padding" as in
 *	earlier releases.
 */
typedef struct {
	char *name;	/* mainly for selection purposes */
	double *cH;
	int nH;
	double *cHtilde;
	int nHtilde;
	/* offsets of H, G, H~, and G~ */
	int offH, offG, offHtilde, offGtilde;
	/* initial mirror signs of G and G~ (these eliminate the need for filter padding) */
	int imsG, imsGtilde;
} waveletfilter;

/* in "wfltr" */
extern waveletfilter wfltrAdelsonSimoncelliHingorani;
extern waveletfilter wfltrAntoniniBarlaudMatheiuDaubechies_4_4;
extern waveletfilter wfltrBattleLemarie;
extern waveletfilter wfltrBurtAdelson;
/* extern waveletfilter wfltrCoiflet_2; */
/* extern waveletfilter wfltrCoiflet_4; */
/* extern waveletfilter wfltrCoiflet_6; */
extern waveletfilter wfltrCoifman_12;
extern waveletfilter wfltrDaubechies_4;
extern waveletfilter wfltrDaubechies_6;
extern waveletfilter wfltrDaubechies_8;
extern waveletfilter wfltrDaubechies_10;
extern waveletfilter wfltrDaubechies_12;
extern waveletfilter wfltrDaubechies_20;
extern waveletfilter wfltrHaar;
extern waveletfilter wfltrPseudocoiflet_4_4;
extern waveletfilter wfltrSpline_2_2;
extern waveletfilter wfltrSpline_2_4;
extern waveletfilter wfltrSpline_3_3;
extern waveletfilter wfltrSpline_3_5;
extern waveletfilter wfltrSpline_3_7;
extern waveletfilter *wfltrList[];	/* null-terminated array of pointer to the above */
extern void wfltr_exchange _PROTO((waveletfilter *wfltrNorm,
		waveletfilter *wfltrRev));
extern waveletfilter *wfltr_select _PROTO((char *wcpat, int *nMatch));

/* in "wrefine" */
extern void wrefine_da1d _PROTO((double *a, int nA, int nNew,
		waveletfilter *wfltr, double *aRefined));

/* in "wxfrmf" */
extern void wxfrm_fa1d _PROTO((float *a, int nA, bool isFwd,
		waveletfilter *wfltr, float *aXf));
extern void wxfrm_fand _PROTO((float *a, int nAOfIDim[],
		int nD, bool isFwd, bool isStd, waveletfilter *wfltr, float *aXf));

/* in "wxfrmd" */
extern void wxfrm_da1d _PROTO((double *a, int nA, bool isFwd,
		waveletfilter *wfltr, double *aXf));
extern void wxfrm_dand _PROTO((double *a, int nA[],
		int nD, bool isFwd, bool isStd, waveletfilter *wfltr, double *aXf));

#endif /* _INCLUDED_WVLT */
